/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.OutputSnapshotter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.impl.DefaultAfterExecutionState;
import org.gradle.internal.execution.history.impl.OutputSnapshotUtil;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.execution.steps.ChangingOutputsContext;
import org.gradle.internal.execution.steps.InputChangesContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class CaptureStateAfterExecutionStep<C extends InputChangesContext>
extends BuildOperationStep<C, AfterExecutionResult> {
    private final UniqueId buildInvocationScopeId;
    private final OutputSnapshotter outputSnapshotter;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super ChangingOutputsContext, ? extends Result> delegate;

    public CaptureStateAfterExecutionStep(BuildOperationExecutor buildOperationExecutor, UniqueId buildInvocationScopeId, OutputSnapshotter outputSnapshotter, OutputChangeListener outputChangeListener, Step<? super ChangingOutputsContext, ? extends Result> delegate) {
        super(buildOperationExecutor);
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.outputSnapshotter = outputSnapshotter;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public AfterExecutionResult execute(UnitOfWork work, C context) {
        Result result2 = this.executeDelegateBroadcastingChanges(work, context);
        Optional<AfterExecutionState> afterExecutionState = ((BeforeExecutionContext)context).getBeforeExecutionState().map(beforeExecutionState -> this.captureStateAfterExecution(work, (BeforeExecutionContext)context, (BeforeExecutionState)beforeExecutionState, result2.getDuration()));
        return new AfterExecutionResult(result2, afterExecutionState.orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeDelegateBroadcastingChanges(UnitOfWork work, C context) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        work.visitOutputs(((WorkspaceContext)context).getWorkspace(), new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, UnitOfWork.OutputFileValueSupplier value) {
                builder.add((Object)value.getValue().getAbsolutePath());
            }

            @Override
            public void visitLocalState(File localStateRoot) {
                builder.add((Object)localStateRoot.getAbsolutePath());
            }

            @Override
            public void visitDestroyable(File destroyableRoot) {
                builder.add((Object)destroyableRoot.getAbsolutePath());
            }
        });
        ImmutableList outputsToBeChanged = builder.build();
        this.outputChangeListener.invalidateCachesFor((Iterable<String>)outputsToBeChanged);
        try {
            Result result2 = this.delegate.execute(work, new ChangingOutputsContext((InputChangesContext)context));
            return result2;
        }
        finally {
            this.outputChangeListener.invalidateCachesFor((Iterable<String>)outputsToBeChanged);
        }
    }

    private AfterExecutionState captureStateAfterExecution(UnitOfWork work, BeforeExecutionContext context, BeforeExecutionState beforeExecutionState, Duration duration) {
        return this.operation(operationContext -> {
            Timer timer = Time.startTimer();
            ImmutableSortedMap<String, FileSystemSnapshot> outputsProducedByWork = this.captureOutputs(work, context, beforeExecutionState);
            long snapshotOutputDuration = timer.getElapsedMillis();
            Duration originExecutionTime = duration.plus(Duration.ofMillis(snapshotOutputDuration));
            OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), originExecutionTime);
            DefaultAfterExecutionState afterExecutionState = new DefaultAfterExecutionState(beforeExecutionState, outputsProducedByWork, originMetadata, false);
            operationContext.setResult(Operation.Result.INSTANCE);
            return afterExecutionState;
        }, BuildOperationDescriptor.displayName("Snapshot outputs after executing " + work.getDisplayName()).details(Operation.Details.INSTANCE));
    }

    private ImmutableSortedMap<String, FileSystemSnapshot> captureOutputs(UnitOfWork work, BeforeExecutionContext context, BeforeExecutionState beforeExecutionState) {
        ImmutableSortedMap<String, FileSystemSnapshot> unfilteredOutputSnapshotsAfterExecution = this.outputSnapshotter.snapshotOutputs(work, context.getWorkspace());
        if (beforeExecutionState.getDetectedOverlappingOutputs().isPresent()) {
            ImmutableSortedMap previousExecutionOutputSnapshots = context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
            ImmutableSortedMap unfilteredOutputSnapshotsBeforeExecution = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileLocationSnapshots).orElse(ImmutableSortedMap.of());
            return OutputSnapshotUtil.filterOutputsAfterExecution((ImmutableSortedMap<String, FileSystemSnapshot>)previousExecutionOutputSnapshots, (ImmutableSortedMap<String, FileSystemSnapshot>)unfilteredOutputSnapshotsBeforeExecution, unfilteredOutputSnapshotsAfterExecution);
        }
        return unfilteredOutputSnapshotsAfterExecution;
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

