/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkInputListeners;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.InputExecutionState;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.execution.history.PreviousExecutionState;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipEmptyWorkStep
implements Step<PreviousExecutionContext, CachingResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipEmptyWorkStep.class);
    private final OutputChangeListener outputChangeListener;
    private final WorkInputListeners workInputListeners;
    private final Supplier<OutputsCleaner> outputsCleanerSupplier;
    private final Step<? super PreviousExecutionContext, ? extends CachingResult> delegate;

    public SkipEmptyWorkStep(OutputChangeListener outputChangeListener, WorkInputListeners workInputListeners, Supplier<OutputsCleaner> outputsCleanerSupplier, Step<? super PreviousExecutionContext, ? extends CachingResult> delegate) {
        this.outputChangeListener = outputChangeListener;
        this.workInputListeners = workInputListeners;
        this.outputsCleanerSupplier = outputsCleanerSupplier;
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, PreviousExecutionContext context) {
        ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots;
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFileFingerprints = context.getInputFileProperties();
        InputFingerprinter.Result newInputs = this.fingerprintPrimaryInputs(work, context, knownFileFingerprints, knownValueSnapshots = context.getInputProperties());
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties = newInputs.getFileFingerprints();
        if (sourceFileProperties.isEmpty()) {
            return this.executeWithNonEmptySources(work, context);
        }
        if (this.hasEmptySources(sourceFileProperties, newInputs.getPropertiesRequiringIsEmptyCheck(), work)) {
            return this.skipExecutionWithEmptySources(work, context);
        }
        return this.executeWithNonEmptySources(work, context.withInputFiles(newInputs.getAllFileFingerprints()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasEmptySources(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties, ImmutableSet<String> propertiesRequiringIsEmptyCheck, UnitOfWork work) {
        if (propertiesRequiringIsEmptyCheck.isEmpty()) {
            return sourceFileProperties.values().stream().allMatch(CurrentFileCollectionFingerprint::isEmpty);
        }
        if (!this.hasEmptyFingerprints(sourceFileProperties, propertyName -> !propertiesRequiringIsEmptyCheck.contains(propertyName))) return false;
        if (!this.hasEmptyInputFileCollections(work, arg_0 -> propertiesRequiringIsEmptyCheck.contains(arg_0))) return false;
        return true;
    }

    private boolean hasEmptyFingerprints(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> sourceFileProperties, Predicate<String> propertyNameFilter) {
        return sourceFileProperties.entrySet().stream().filter(entry -> propertyNameFilter.test((String)entry.getKey())).map(Map.Entry::getValue).allMatch(CurrentFileCollectionFingerprint::isEmpty);
    }

    private boolean hasEmptyInputFileCollections(UnitOfWork work, Predicate<String> propertyNameFilter) {
        EmptyCheckingVisitor visitor = new EmptyCheckingVisitor(propertyNameFilter);
        work.visitRegularInputs(visitor);
        return visitor.isAllEmpty();
    }

    private InputFingerprinter.Result fingerprintPrimaryInputs(UnitOfWork work, PreviousExecutionContext context, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> knownFileFingerprints, ImmutableSortedMap<String, ValueSnapshot> knownValueSnapshots) {
        return work.getInputFingerprinter().fingerprintInputProperties((ImmutableSortedMap<String, ValueSnapshot>)context.getPreviousExecutionState().map(InputExecutionState::getInputProperties).orElse(ImmutableSortedMap.of()), (ImmutableSortedMap<String, ? extends FileCollectionFingerprint>)context.getPreviousExecutionState().map(PreviousExecutionState::getInputFileProperties).orElse(ImmutableSortedMap.of()), knownValueSnapshots, knownFileFingerprints, visitor -> work.visitRegularInputs(new UnitOfWork.InputVisitor((UnitOfWork.InputVisitor)visitor){
            final /* synthetic */ UnitOfWork.InputVisitor val$visitor;
            {
                this.val$visitor = inputVisitor;
            }

            @Override
            public void visitInputFileProperty(String propertyName, InputBehavior behavior, UnitOfWork.InputFileValueSupplier value) {
                if (behavior.shouldSkipWhenEmpty()) {
                    this.val$visitor.visitInputFileProperty(propertyName, behavior, value);
                }
            }
        }));
    }

    @Nonnull
    private CachingResult skipExecutionWithEmptySources(final UnitOfWork work, final PreviousExecutionContext context) {
        ExecutionEngine.ExecutionOutcome skipOutcome;
        ImmutableSortedMap outputFilesAfterPreviousExecution = context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        Timer timer = Time.startTimer();
        if (outputFilesAfterPreviousExecution.isEmpty()) {
            LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)work.getDisplayName());
            skipOutcome = ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED;
        } else {
            boolean didWork = this.cleanPreviousTaskOutputs((Map<String, FileSystemSnapshot>)outputFilesAfterPreviousExecution);
            if (didWork) {
                LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)work.getDisplayName());
                skipOutcome = ExecutionEngine.ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
            } else {
                skipOutcome = ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED;
            }
        }
        Duration duration = skipOutcome == ExecutionEngine.ExecutionOutcome.SHORT_CIRCUITED ? Duration.ZERO : Duration.ofMillis(timer.getElapsedMillis());
        this.broadcastWorkInputs(work, true);
        Try<ExecutionEngine.Execution> execution = Try.successful(new ExecutionEngine.Execution(){

            @Override
            public ExecutionEngine.ExecutionOutcome getOutcome() {
                return skipOutcome;
            }

            @Override
            public Object getOutput() {
                return work.loadAlreadyProducedOutput(context.getWorkspace());
            }
        });
        return new CachingResult(duration, execution, null, (ImmutableList<String>)ImmutableList.of(), null, CachingState.NOT_DETERMINED);
    }

    private CachingResult executeWithNonEmptySources(UnitOfWork work, PreviousExecutionContext context) {
        this.broadcastWorkInputs(work, false);
        return this.delegate.execute(work, context);
    }

    private void broadcastWorkInputs(UnitOfWork work, boolean onlyPrimaryInputs) {
        this.workInputListeners.broadcastFileSystemInputsOf(work, onlyPrimaryInputs ? EnumSet.of(InputBehavior.PRIMARY) : EnumSet.allOf(InputBehavior.class));
    }

    private boolean cleanPreviousTaskOutputs(Map<String, FileSystemSnapshot> outputFileSnapshots) {
        OutputsCleaner outputsCleaner = this.outputsCleanerSupplier.get();
        for (FileSystemSnapshot outputFileSnapshot : outputFileSnapshots.values()) {
            try {
                this.outputChangeListener.invalidateCachesFor(SnapshotUtil.rootIndex(outputFileSnapshot).keySet());
                outputsCleaner.cleanupOutputs(outputFileSnapshot);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return outputsCleaner.getDidWork();
    }

    private static class EmptyCheckingVisitor
    implements UnitOfWork.InputVisitor {
        private final Predicate<String> propertyNameFilter;
        private boolean allEmpty = true;

        public EmptyCheckingVisitor(Predicate<String> propertyNameFilter) {
            this.propertyNameFilter = propertyNameFilter;
        }

        @Override
        public void visitInputFileProperty(String propertyName, InputBehavior behavior, UnitOfWork.InputFileValueSupplier value) {
            if (this.propertyNameFilter.test(propertyName)) {
                this.allEmpty = this.allEmpty && value.getFiles().isEmpty();
            }
        }

        public boolean isAllEmpty() {
            return this.allEmpty;
        }
    }
}

