/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractDirectorySensitiveFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class RelativePathFingerprintingStrategy
extends AbstractDirectorySensitiveFingerprintingStrategy {
    public static final String IDENTIFIER = "RELATIVE_PATH";
    private final Interner<String> stringInterner;
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public RelativePathFingerprintingStrategy(Interner<String> stringInterner, DirectorySensitivity directorySensitivity, FileSystemLocationSnapshotHasher normalizedContentHasher) {
        super(IDENTIFIER, directorySensitivity, normalizedContentHasher);
        this.stringInterner = stringInterner;
        this.normalizedContentHasher = normalizedContentHasher;
    }

    public RelativePathFingerprintingStrategy(Interner<String> stringInterner, DirectorySensitivity directorySensitivity) {
        this(stringInterner, directorySensitivity, FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet processedEntries = new HashSet();
        roots.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
            FileSystemLocationFingerprint fingerprint;
            String absolutePath = snapshot.getAbsolutePath();
            if (!processedEntries.add(absolutePath) || !this.getDirectorySensitivity().shouldFingerprint(snapshot)) return SnapshotVisitResult.CONTINUE;
            if (relativePath.isRoot()) {
                if (snapshot.getType() != FileType.RegularFile) return SnapshotVisitResult.CONTINUE;
                fingerprint = this.fingerprint(snapshot.getName(), snapshot.getType(), snapshot);
            } else {
                fingerprint = this.fingerprint((String)this.stringInterner.intern((Object)relativePath.toRelativePath()), snapshot.getType(), snapshot);
            }
            if (fingerprint == null) return SnapshotVisitResult.CONTINUE;
            builder.put((Object)absolutePath, (Object)fingerprint);
            return SnapshotVisitResult.CONTINUE;
        });
        return builder.build();
    }

    @Nullable
    FileSystemLocationFingerprint fingerprint(String name, FileType type, FileSystemLocationSnapshot snapshot) {
        HashCode normalizedContentHash = this.getNormalizedContentHash(snapshot, this.normalizedContentHasher);
        return normalizedContentHash == null ? null : new DefaultFileSystemLocationFingerprint(name, type, normalizedContentHash);
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

