/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.source;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.io.LinePerThreadBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.internal.logging.config.LoggingSourceSystem;
import org.gradle.internal.logging.config.LoggingSystem;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.time.Clock;

abstract class PrintStreamLoggingSystem
implements LoggingSourceSystem {
    private final AtomicReference<StandardOutputListener> destination = new AtomicReference();
    private final PrintStream outstr = new LinePerThreadBufferingOutputStream(new TextStream(){

        @Override
        public void text(String output) {
            ((StandardOutputListener)PrintStreamLoggingSystem.this.destination.get()).onOutput(output);
        }

        @Override
        public void endOfStream(@Nullable Throwable failure) {
        }
    });
    private PrintStreamDestination original;
    private boolean enabled;
    private LogLevel logLevel;
    private final StandardOutputListener listener;
    private final OutputEventListener outputEventListener;

    protected PrintStreamLoggingSystem(OutputEventListener listener2, String category, Clock clock) {
        this.outputEventListener = listener2;
        this.listener = new OutputEventDestination(listener2, category, clock);
    }

    protected abstract PrintStream get();

    protected abstract void set(PrintStream var1);

    @Override
    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.enabled, this.logLevel);
    }

    @Override
    public void restore(LoggingSystem.Snapshot state) {
        SnapshotImpl snapshot = (SnapshotImpl)state;
        this.enabled = snapshot.enabled;
        this.logLevel = snapshot.logLevel;
        if (this.enabled) {
            this.install();
        } else {
            this.uninstall();
        }
    }

    @Override
    public LoggingSystem.Snapshot setLevel(LogLevel logLevel) {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (logLevel != this.logLevel) {
            this.logLevel = logLevel;
            if (this.enabled) {
                this.outstr.flush();
                this.outputEventListener.onOutput(new LogLevelChangeEvent(logLevel));
            }
        }
        return snapshot;
    }

    @Override
    public LoggingSystem.Snapshot startCapture() {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (!this.enabled) {
            this.install();
        }
        return snapshot;
    }

    private void uninstall() {
        if (this.original != null) {
            this.outstr.flush();
            this.destination.set(this.original);
            this.set(this.original.originalStream);
            this.original = null;
        }
    }

    private void install() {
        if (this.original == null) {
            PrintStream originalStream = this.get();
            this.original = new PrintStreamDestination(originalStream);
        }
        this.enabled = true;
        this.outstr.flush();
        this.outputEventListener.onOutput(new LogLevelChangeEvent(this.logLevel));
        this.destination.set(this.listener);
        if (this.get() != this.outstr) {
            this.set(this.outstr);
        }
    }

    private static class OutputEventDestination
    implements StandardOutputListener {
        private final OutputEventListener listener;
        private final String category;
        private final Clock clock;

        public OutputEventDestination(OutputEventListener listener2, String category, Clock clock) {
            this.listener = listener2;
            this.category = category;
            this.clock = clock;
        }

        @Override
        public void onOutput(CharSequence output) {
            OperationIdentifier buildOperationId = CurrentBuildOperationRef.instance().getId();
            StyledTextOutputEvent event = new StyledTextOutputEvent(this.clock.getCurrentTime(), this.category, null, buildOperationId, output.toString());
            this.listener.onOutput(event);
        }
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final boolean enabled;
        private final LogLevel logLevel;

        public SnapshotImpl(boolean enabled, LogLevel logLevel) {
            this.enabled = enabled;
            this.logLevel = logLevel;
        }
    }

    private static class PrintStreamDestination
    implements StandardOutputListener {
        private final PrintStream originalStream;

        public PrintStreamDestination(PrintStream originalStream) {
            this.originalStream = originalStream;
        }

        @Override
        public void onOutput(CharSequence output) {
            this.originalStream.print(output);
        }
    }
}

