/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.internal.featurelifecycle.NoOpProblemDiagnosticsFactory;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.problems.ProblemLocationAnalyzer;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;
import org.gradle.problems.buildtree.ProblemStream;

public class DefaultProblemDiagnosticsFactory
implements ProblemDiagnosticsFactory {
    private static final ProblemStream.StackTraceTransformer NO_OP = ImmutableList::copyOf;
    private static final Supplier<Throwable> EXCEPTION_FACTORY = Exception::new;
    private final ProblemLocationAnalyzer locationAnalyzer;
    private final int maxStackTraces;

    @Inject
    public DefaultProblemDiagnosticsFactory(ProblemLocationAnalyzer locationAnalyzer) {
        this(locationAnalyzer, 50);
    }

    @VisibleForTesting
    DefaultProblemDiagnosticsFactory(ProblemLocationAnalyzer locationAnalyzer, int maxStackTraces) {
        this.locationAnalyzer = locationAnalyzer;
        this.maxStackTraces = maxStackTraces;
    }

    @Override
    public ProblemStream newStream() {
        return new DefaultProblemStream();
    }

    @Override
    public ProblemStream newUnlimitedStream() {
        DefaultProblemStream defaultProblemStream = new DefaultProblemStream();
        defaultProblemStream.remainingStackTraces.set(Integer.MAX_VALUE);
        return defaultProblemStream;
    }

    @Override
    public ProblemDiagnostics forException(Throwable exception) {
        return this.locationFromStackTrace(exception, true, true, NO_OP);
    }

    private ProblemDiagnostics locationFromStackTrace(@Nullable Throwable throwable, boolean fromException, boolean keepException, ProblemStream.StackTraceTransformer transformer) {
        if (throwable == null) {
            return NoOpProblemDiagnosticsFactory.EMPTY_DIAGNOSTICS;
        }
        List<StackTraceElement> stackTrace = transformer.transform(throwable.getStackTrace());
        Location location = this.locationAnalyzer.locationForUsage(stackTrace, fromException);
        return new DefaultProblemDiagnostics(keepException ? throwable : null, stackTrace, location);
    }

    private static class DefaultProblemDiagnostics
    implements ProblemDiagnostics {
        private final Throwable exception;
        private final List<StackTraceElement> stackTrace;
        private final Location location;

        public DefaultProblemDiagnostics(@Nullable Throwable exception, List<StackTraceElement> stackTrace, @Nullable Location location) {
            this.exception = exception;
            this.stackTrace = stackTrace;
            this.location = location;
        }

        @Override
        @Nullable
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public List<StackTraceElement> getStack() {
            return this.stackTrace;
        }

        @Override
        @Nullable
        public Location getLocation() {
            return this.location;
        }
    }

    private class DefaultProblemStream
    implements ProblemStream {
        private final AtomicInteger remainingStackTraces = new AtomicInteger();

        public DefaultProblemStream() {
            this.remainingStackTraces.set(DefaultProblemDiagnosticsFactory.this.maxStackTraces);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller(@Nullable Throwable exception) {
            if (exception == null) {
                return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable(EXCEPTION_FACTORY), false, false, NO_OP);
            }
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(exception, true, true, NO_OP);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller() {
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable(EXCEPTION_FACTORY), false, false, NO_OP);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller(Supplier<? extends Throwable> exceptionFactory) {
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable(exceptionFactory), false, true, NO_OP);
        }

        @Override
        public ProblemDiagnostics forCurrentCaller(ProblemStream.StackTraceTransformer transformer) {
            return DefaultProblemDiagnosticsFactory.this.locationFromStackTrace(this.getImplicitThrowable(EXCEPTION_FACTORY), false, false, transformer);
        }

        @Nullable
        private Throwable getImplicitThrowable(Supplier<? extends Throwable> factory) {
            if (this.remainingStackTraces.getAndDecrement() > 0) {
                return factory.get();
            }
            return null;
        }
    }
}

