/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.com.google.common.primitives.Booleans;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.JointCompileTaskConfig;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;

public class BinarySourceTransformations {
    private final TaskContainer tasks;
    private final Iterable<LanguageTransform<?, ?>> prioritizedTransforms;
    private final ServiceRegistry serviceRegistry;

    public BinarySourceTransformations(TaskContainer tasks, LanguageTransformContainer transforms, ServiceRegistry serviceRegistry) {
        this.tasks = tasks;
        this.prioritizedTransforms = this.prioritize(transforms);
        this.serviceRegistry = serviceRegistry;
    }

    public void createTasksFor(BinarySpecInternal binary) {
        Set<LanguageSourceSetInternal> sourceSetsToCompile = this.getSourcesToCompile(binary);
        for (LanguageTransform<?, ?> languageTransform : this.prioritizedTransforms) {
            LanguageSourceSetInternal sourceSetToCompile;
            if (!languageTransform.applyToBinary(binary)) continue;
            while ((sourceSetToCompile = this.findSourceFor(languageTransform, sourceSetsToCompile)) != null) {
                sourceSetsToCompile.remove(sourceSetToCompile);
                SourceTransformTaskConfig taskConfig = languageTransform.getTransformTask();
                String taskName = this.getTransformTaskName(languageTransform, taskConfig, binary, sourceSetToCompile);
                Object task = this.tasks.create(taskName, (Class)taskConfig.getTaskType());
                taskConfig.configureTask((Task)task, binary, sourceSetToCompile, this.serviceRegistry);
                task.dependsOn(sourceSetToCompile);
                binary.getTasks().add(task);
                if (!binary.hasCodependentSources() || !(taskConfig instanceof JointCompileTaskConfig)) continue;
                JointCompileTaskConfig jointCompileTaskConfig = (JointCompileTaskConfig)taskConfig;
                Iterator<LanguageSourceSetInternal> candidateSourceSets = sourceSetsToCompile.iterator();
                while (candidateSourceSets.hasNext()) {
                    LanguageSourceSetInternal candidate = candidateSourceSets.next();
                    if (!jointCompileTaskConfig.canTransform(candidate)) continue;
                    jointCompileTaskConfig.configureAdditionalTransform((Task)task, candidate);
                    candidateSourceSets.remove();
                }
            }
        }
    }

    private Iterable<LanguageTransform<?, ?>> prioritize(LanguageTransformContainer languageTransforms) {
        ArrayList prioritized = Lists.newArrayList((Iterable)languageTransforms);
        Collections.sort(prioritized, new Comparator<LanguageTransform<?, ?>>(){

            @Override
            public int compare(LanguageTransform<?, ?> o1, LanguageTransform<?, ?> o2) {
                boolean joint1 = o1.getTransformTask() instanceof JointCompileTaskConfig;
                boolean joint2 = o2.getTransformTask() instanceof JointCompileTaskConfig;
                return Booleans.trueFirst().compare(joint1, joint2);
            }
        });
        return prioritized;
    }

    private Set<LanguageSourceSetInternal> getSourcesToCompile(BinarySpecInternal binary) {
        LinkedHashSet sourceSets = Sets.newLinkedHashSet();
        for (LanguageSourceSet languageSourceSet : binary.getInputs()) {
            LanguageSourceSetInternal languageSourceSetInternal = (LanguageSourceSetInternal)languageSourceSet;
            if (!languageSourceSetInternal.getMayHaveSources()) continue;
            sourceSets.add(languageSourceSetInternal);
        }
        return sourceSets;
    }

    private String getTransformTaskName(LanguageTransform<?, ?> transform, SourceTransformTaskConfig taskConfig, BinarySpecInternal binary, LanguageSourceSetInternal sourceSetToCompile) {
        if (binary.hasCodependentSources() && taskConfig instanceof JointCompileTaskConfig) {
            return taskConfig.getTaskPrefix() + StringUtils.capitalize((String)binary.getProjectScopedName()) + StringUtils.capitalize((String)transform.getClass().getSimpleName());
        }
        return taskConfig.getTaskPrefix() + StringUtils.capitalize((String)binary.getProjectScopedName()) + StringUtils.capitalize((String)sourceSetToCompile.getProjectScopedName());
    }

    private LanguageSourceSetInternal findSourceFor(LanguageTransform<?, ?> languageTransform, Set<LanguageSourceSetInternal> sourceSetsToCompile) {
        for (LanguageSourceSetInternal candidate : sourceSetsToCompile) {
            if (!languageTransform.getSourceSetType().isInstance(candidate)) continue;
            return candidate;
        }
        return null;
    }
}

