/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimaps;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.util.internal.CollectionUtils;

public class DefaultIncludeDirectives
implements IncludeDirectives {
    private final ImmutableList<Include> allIncludes;
    private final ImmutableListMultimap<String, Macro> macros;
    private final ImmutableListMultimap<String, MacroFunction> macroFunctions;

    public static IncludeDirectives of(ImmutableList<Include> allIncludes, ImmutableList<Macro> macros, ImmutableList<MacroFunction> macroFunctions) {
        if (allIncludes.isEmpty() && macros.isEmpty() && macroFunctions.isEmpty()) {
            return EMPTY;
        }
        return new DefaultIncludeDirectives(allIncludes, (ImmutableListMultimap<String, Macro>)Multimaps.index(macros, (Function)new Function<Macro, String>(){

            @Nullable
            public String apply(@Nullable Macro input) {
                return input.getName();
            }
        }), (ImmutableListMultimap<String, MacroFunction>)Multimaps.index(macroFunctions, (Function)new Function<MacroFunction, String>(){

            @Nullable
            public String apply(@Nullable MacroFunction input) {
                return input.getName();
            }
        }));
    }

    private DefaultIncludeDirectives(ImmutableList<Include> allIncludes, ImmutableListMultimap<String, Macro> macros, ImmutableListMultimap<String, MacroFunction> macroFunctions) {
        this.allIncludes = allIncludes;
        this.macros = macros;
        this.macroFunctions = macroFunctions;
    }

    @Override
    public List<Include> getQuotedIncludes() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.QUOTED;
            }
        });
    }

    @Override
    public List<Include> getSystemIncludes() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.SYSTEM;
            }
        });
    }

    @Override
    public List<Include> getMacroIncludes() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.MACRO;
            }
        });
    }

    @Override
    public List<Include> getAll() {
        return this.allIncludes;
    }

    @Override
    public List<Include> getIncludesOnly() {
        return CollectionUtils.filter(this.allIncludes, new Spec<Include>(){

            @Override
            public boolean isSatisfiedBy(Include element) {
                return !element.isImport();
            }
        });
    }

    @Override
    public Iterable<Macro> getMacros(String name) {
        return this.macros.get((Object)name);
    }

    @Override
    public Collection<Macro> getAllMacros() {
        return this.macros.values();
    }

    @Override
    public Iterable<MacroFunction> getMacroFunctions(String name) {
        return this.macroFunctions.get((Object)name);
    }

    @Override
    public Collection<MacroFunction> getAllMacroFunctions() {
        return this.macroFunctions.values();
    }

    @Override
    public boolean hasMacros() {
        return !this.macros.isEmpty();
    }

    @Override
    public boolean hasMacroFunctions() {
        return !this.macroFunctions.isEmpty();
    }

    @Override
    public IncludeDirectives discardImports() {
        return new DefaultIncludeDirectives((ImmutableList<Include>)ImmutableList.copyOf(this.getIncludesOnly()), this.macros, this.macroFunctions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIncludeDirectives that = (DefaultIncludeDirectives)o;
        return this.allIncludes.equals(that.allIncludes) && this.macros.equals(that.macros) && this.macroFunctions.equals(that.macroFunctions);
    }

    public int hashCode() {
        return this.allIncludes.hashCode() ^ this.macros.hashCode() ^ this.macroFunctions.hashCode();
    }
}

