/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.DefaultBuildRequestContext;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.gradle.launcher.daemon.server.exec.DaemonConnectionBackedEventConsumer;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class ExecuteBuild
extends BuildCommandOnly {
    private static final Logger LOGGER = Logging.getLogger(ExecuteBuild.class);
    private final BuildActionExecuter<BuildActionParameters, BuildRequestContext> actionExecuter;
    private final DaemonRunningStats runningStats;

    public ExecuteBuild(BuildActionExecuter<BuildActionParameters, BuildRequestContext> actionExecuter, DaemonRunningStats runningStats) {
        this.actionExecuter = actionExecuter;
        this.runningStats = runningStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build2) {
        LOGGER.debug("The daemon has started executing the build.");
        LOGGER.debug("Executing build with daemon context: {}", execution.getDaemonContext());
        this.runningStats.buildStarted();
        DaemonConnectionBackedEventConsumer buildEventConsumer = new DaemonConnectionBackedEventConsumer(execution);
        try {
            BuildCancellationToken cancellationToken = execution.getDaemonStateControl().getCancellationToken();
            DefaultBuildRequestContext buildRequestContext = new DefaultBuildRequestContext(build2.getBuildRequestMetaData(), cancellationToken, buildEventConsumer);
            if (!build2.getAction().getStartParameter().isContinuous()) {
                buildRequestContext.getCancellationToken().addCallback(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.info("The daemon has received a build cancellation request.");
                    }
                });
            }
            BuildActionResult result2 = this.actionExecuter.execute(build2.getAction(), build2.getParameters(), buildRequestContext);
            execution.setResult(result2);
        }
        finally {
            buildEventConsumer.waitForFinish();
            this.runningStats.buildFinished();
            LOGGER.debug("The daemon has finished executing the build.");
        }
        execution.proceed();
    }
}

