/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor;

import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;

public class OverrideDependencyDescriptorMediator
implements DependencyDescriptorMediator {
    private String version;
    private String branch;

    public OverrideDependencyDescriptorMediator(String branch, String version) {
        this.branch = branch;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBranch() {
        return this.branch;
    }

    @Override
    public DependencyDescriptor mediate(DependencyDescriptor dd) {
        String branch;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        if ((this.version == null || this.version.equals(mrid.getRevision())) && (this.branch == null || this.branch.equals(mrid.getBranch()))) {
            return dd;
        }
        String version = this.version == null ? mrid.getRevision() : this.version;
        String string = branch = this.branch == null ? mrid.getBranch() : this.branch;
        if (version.equals(dd.getDependencyRevisionId().getRevision()) && branch.equals(dd.getDependencyRevisionId().getBranch())) {
            return dd;
        }
        return dd.clone(ModuleRevisionId.newInstance(mrid.getOrganisation(), mrid.getName(), branch, version, mrid.getQualifiedExtraAttributes()));
    }
}

