/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.settings.MarkdownSettingsUtil;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewLAFThemeStyles;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/BaseStylesExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "priority", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "getPriority", "()Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "styles", "", "", "getStyles", "()Ljava/util/List;", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "showLoadFailedNotification", "tryToLoadCustomStylesheet", "Companion", "Provider", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nBaseStylesExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseStylesExtension.kt\norg/intellij/plugins/markdown/extensions/common/BaseStylesExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class BaseStylesExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final MarkdownBrowserPreviewExtension.Priority priority;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final ResourceProvider resourceProvider;
    @NotNull
    private static final String COLORS_CSS_FILENAME = "baseStyles/colors.css";

    public BaseStylesExtension(@Nullable Project project) {
        this.project = project;
        this.priority = MarkdownBrowserPreviewExtension.Priority.BEFORE_ALL;
        Object[] objectArray = new String[]{"baseStyles/default.css", COLORS_CSS_FILENAME};
        this.styles = CollectionsKt.listOf((Object[])objectArray);
        this.resourceProvider = this;
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return this.priority;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        ResourceProvider.Resource customStylesheet;
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        if (Intrinsics.areEqual((Object)resourceName, (Object)COLORS_CSS_FILENAME)) {
            String string = PreviewLAFThemeStyles.INSTANCE.createStylesheet();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new ResourceProvider.Resource(byArray, null, 2, null);
        }
        Project project = this.project;
        if (project != null) {
            Project p0 = project;
            boolean bl = false;
            v2 = this.tryToLoadCustomStylesheet(p0);
        } else {
            v2 = customStylesheet = null;
        }
        if (customStylesheet != null) {
            return customStylesheet;
        }
        return ResourceProvider.Companion.loadInternalResource$default(ResourceProvider.Companion, Reflection.getOrCreateKotlinClass(BaseStylesExtension.class), resourceName, null, 4, null);
    }

    private final ResourceProvider.Resource tryToLoadCustomStylesheet(Project project) {
        Path path;
        block11: {
            block10: {
                Object object;
                MarkdownSettings settings = MarkdownSettings.Companion.getInstance(project);
                if (!settings.getUseCustomStylesheetPath()) {
                    return null;
                }
                String string = settings.getCustomStylesheetPath();
                if (string == null) {
                    return null;
                }
                String rawPath = string;
                Object object2 = this;
                try {
                    BaseStylesExtension $this$tryToLoadCustomStylesheet_u24lambda_u240 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)Path.of(rawPath, new String[0]));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                Path path2 = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
                if (path2 == null) {
                    return null;
                }
                path = path2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block10;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block11;
            }
            this.showLoadFailedNotification(project);
            return null;
        }
        boolean belongsToTheProject2 = (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(project, path){
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $path;
            {
                this.$project = $project;
                this.$path = $path;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return MarkdownSettingsUtil.INSTANCE.belongsToTheProject$intellij_markdown_core(this.$project, this.$path);
            }
        }));
        if (!belongsToTheProject2) {
            String string = MarkdownBundle.message("markdown.notification.unsafe.stylesheet.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = MarkdownBundle.message("markdown.notification.unsafe.stylesheet.outside.project.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MarkdownNotifications.INSTANCE.showWarning(project, "markdown.custom.stylesheet.unsafe", string, string2);
            return null;
        }
        ResourceProvider.Resource resource = ResourceProvider.Companion.loadExternalResource$default(ResourceProvider.Companion, path, null, 2, null);
        if (resource == null) {
            this.showLoadFailedNotification(project);
        }
        return resource;
    }

    private final void showLoadFailedNotification(Project project) {
        String string = MarkdownBundle.message("markdown.notification.unsafe.stylesheet.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = MarkdownBundle.message("markdown.notification.unsafe.stylesheet.load.error.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MarkdownNotifications.INSTANCE.showWarning(project, "markdown.custom.stylesheet.load.failed", string, string2);
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getStyles().contains(resourceName);
    }

    public void dispose() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/BaseStylesExtension$Companion;", "", "()V", "COLORS_CSS_FILENAME", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/BaseStylesExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown.core"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Override
        @NotNull
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            return new BaseStylesExtension(panel2.getProject());
        }
    }
}

