/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ui.paint.LinePainter2D;
import com.intellij.uiDesigner.DesignSpacer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public final class HSpacer
extends DesignSpacer {
    public HSpacer() {
        this.setSize(50, HSpacer.getHandleHeight());
    }

    protected void paintComponent(Graphics g) {
        int handleHeight = HSpacer.getHandleHeight();
        int handleWidth = HSpacer.getHandleWidth();
        int y = (this.getHeight() - handleHeight) / 2;
        HSpacer.drawHandle(g, 0, y);
        g.setColor(ourColor1);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)handleWidth, (double)(y + handleHeight / 2), (double)(handleWidth + 1), (double)(y + handleHeight / 2));
        int x = this.getWidth() - handleWidth - 1;
        HSpacer.drawHandle(g, x, y);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y + handleHeight / 2), (double)(x - 2), (double)(y + handleHeight / 2));
        g.setColor(ourColor1);
        HSpacer.drawSpring(g, handleWidth + 1, y + handleHeight / 2, this.getWidth() - 2 * handleWidth - 4);
    }

    private static int getHandleWidth() {
        return 5;
    }

    private static int getHandleHeight() {
        return 11;
    }

    private static void drawHandle(Graphics g, int x, int y) {
        g.setColor(ourColor1);
        g.drawRect(x, y, 4, 2);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 2), (double)(y + 3), (double)(x + 2), (double)(y + 3 + 1 - 1));
        g.drawRect(x, y += 4, 4, 2);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 2), (double)(y + 3), (double)(x + 2), (double)(y + 3 + 1 - 1));
        g.drawRect(x, y += 4, 4, 2);
    }

    private static void drawSpring(Graphics g, int x, int y, int width) {
        for (int _x = x; _x < x + width - 1; _x += 4) {
            HSpacer.drawSpringPeriod(g, _x, y);
        }
    }

    private static void drawSpringPeriod(Graphics g, int x, int y) {
        g.setColor(ourColor2);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)(y - 1), (double)x, (double)(y - 2));
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 1), (double)y, (double)(x + 1), (double)y);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 2), (double)(y + 1), (double)(x + 2), (double)(y + 2));
        g.setColor(ourColor3);
        LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(x + 3), (double)y, (double)(x + 3), (double)y);
    }

    public Dimension getMinimumSize() {
        return new Dimension(HSpacer.getHandleWidth() * 2 + 4, HSpacer.getHandleHeight());
    }
}

