/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.coverage;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.JavaCoverageEngine;
import com.intellij.coverage.xml.XMLReportEngine;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.XMLProjectData;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.coverage.CoverageLanguage;
import org.jetbrains.qodana.jvm.coverage.JvmCoverageInspectionKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBase;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageStatistics;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.Xml_mergerKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.stat.CoverageFeatureEventsCollector;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.UastAnonymousClassUtil;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase;", "()V", "languages", "", "", "checker", "", "file", "Lcom/intellij/psi/PsiFile;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "cleanup", "computeXmlCoverageData", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "engineType", "Lkotlin/reflect/KClass;", "Lcom/intellij/coverage/CoverageEngine;", "loadCoverage", "validateFileType", "", "Companion", "JVMDefVisitor", "intellij.qodana.jvm.coverage"})
@SourceDebugExtension(value={"SMAP\nJvmCoverageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1855#2,2:278\n*S KotlinDebug\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection\n*L\n270#1:278,2\n*E\n"})
public final class JvmCoverageInspection
extends CoverageInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> languages;
    @NotNull
    private static final Key<Lazy<ProjectData>> javacov;
    @NotNull
    private static final Key<Lazy<XMLProjectData>> xmlcov;

    public JvmCoverageInspection() {
        Object[] objectArray = new String[]{"Java", "Kotlin"};
        this.languages = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public void loadCoverage(@NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        globalContext.putUserData(javacov, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<ProjectData>(this, globalContext){
            final /* synthetic */ JvmCoverageInspection this$0;
            final /* synthetic */ QodanaGlobalInspectionContext $globalContext;
            {
                this.this$0 = $receiver;
                this.$globalContext = $globalContext;
                super(0);
            }

            @Nullable
            public final ProjectData invoke() {
                return this.this$0.computeCoverageData(this.$globalContext, (KClass<? extends CoverageEngine>)Reflection.getOrCreateKotlinClass(JavaCoverageEngine.class));
            }
        })));
        globalContext.putUserData(xmlcov, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<XMLProjectData>(this, globalContext){
            final /* synthetic */ JvmCoverageInspection this$0;
            final /* synthetic */ QodanaGlobalInspectionContext $globalContext;
            {
                this.this$0 = $receiver;
                this.$globalContext = $globalContext;
                super(0);
            }

            @Nullable
            public final XMLProjectData invoke() {
                XMLProjectData data = JvmCoverageInspection.access$computeXmlCoverageData(this.this$0, this.$globalContext, Reflection.getOrCreateKotlinClass(XMLReportEngine.class));
                if (data != null) {
                    CoverageFeatureEventsCollector.INSPECTION_LOADED_COVERAGE.log(this.$globalContext.getProject(), (Object)((Object)CoverageLanguage.JVM));
                }
                return data;
            }
        })));
    }

    @Override
    public void checker(@NotNull PsiFile file, @NotNull ProblemsHolder problemsHolder, @NotNull QodanaGlobalInspectionContext globalContext) {
        XMLProjectData xmlReport;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(javacov);
        ProjectData report2 = lazy != null ? (ProjectData)lazy.getValue() : null;
        Lazy lazy2 = (Lazy)globalContext.getUserData(xmlcov);
        Object object = xmlReport = lazy2 != null ? (XMLProjectData)lazy2.getValue() : null;
        if (report2 == null && xmlReport == null) {
            return;
        }
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UClass.class, UMethod.class};
        UtilsKt.iterateContents(file, UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new JVMDefVisitor(globalContext, problemsHolder, this.getMethodThreshold(), this.getClassThreshold(), this.getWarnMissingCoverage(), report2, xmlReport, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)new Function1<PsiElement, PsiElement>((Object)this){

            @NotNull
            public final PsiElement invoke(@NotNull PsiElement p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return JvmCoverageInspection.access$highlightedElement((JvmCoverageInspection)((Object)this.receiver), p0);
            }
        })), classArray, true));
    }

    @Override
    public boolean validateFileType(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.languages.contains(file.getLanguage().getDisplayName());
    }

    @Override
    public void cleanup(@NotNull QodanaGlobalInspectionContext globalContext) {
        ProjectData data;
        Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(javacov);
        Object object = data = lazy != null ? (ProjectData)lazy.getValue() : null;
        if (data != null) {
            String string = JavaCoverageEngine.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            this.saveCoverageData(globalContext, string, data);
        }
        globalContext.putUserData(javacov, null);
        globalContext.putUserData(xmlcov, null);
    }

    private final XMLProjectData computeXmlCoverageData(QodanaGlobalInspectionContext globalContext, KClass<? extends CoverageEngine> engineType) {
        List<File> coverageFiles2 = this.provideCoverageFiles(globalContext);
        JvmCoverageInspectionKt.getLogger().info("Coverage for " + JvmClassMappingKt.getJavaClass(engineType).getSimpleName() + " - provided " + coverageFiles2.size() + " files");
        if (coverageFiles2.isEmpty()) {
            return null;
        }
        CoverageEngine engine = (CoverageEngine)CoverageEngine.EP_NAME.findExtensionOrFail(JvmClassMappingKt.getJavaClass(engineType));
        Project project2 = globalContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        List<CoverageSuite> suites = UtilsKt.computeSuites(engine, coverageFiles2, project2);
        if (CollectionsKt.any((Iterable)suites)) {
            CoverageStatistics stat;
            CoverageSuite firstSuite = (CoverageSuite)CollectionsKt.first(suites);
            XMLReportSuite xMLReportSuite = firstSuite instanceof XMLReportSuite ? (XMLReportSuite)firstSuite : null;
            if (xMLReportSuite == null || (xMLReportSuite = xMLReportSuite.getReportData()) == null) {
                throw new QodanaException("JaCoCo suite " + firstSuite.getPresentableName() + " is missing report data");
            }
            XMLReportSuite report2 = xMLReportSuite;
            for (CoverageSuite suite2 : CollectionsKt.drop((Iterable)suites, (int)1)) {
                XMLReportSuite xMLReportSuite2 = suite2 instanceof XMLReportSuite ? (XMLReportSuite)suite2 : null;
                if (xMLReportSuite2 == null || (xMLReportSuite2 = xMLReportSuite2.getReportData()) == null) {
                    throw new QodanaException("JaCoCo suite " + suite2.getPresentableName() + " is missing report data");
                }
                XMLReportSuite add = xMLReportSuite2;
                Xml_mergerKt.merge((XMLProjectData)report2, (XMLProjectData)add);
            }
            Project project3 = globalContext.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            if (UtilsKt.isLocalChanges(project3) && (stat = (CoverageStatistics)globalContext.getUserData(CoverageStatistics.Companion.getStats())) != null) {
                Collection collection = report2.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    XMLProjectData.FileInfo x = (XMLProjectData.FileInfo)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)x);
                    stat.processReportXmlData(x);
                }
            }
            return report2;
        }
        return null;
    }

    public static final /* synthetic */ XMLProjectData access$computeXmlCoverageData(JvmCoverageInspection $this, QodanaGlobalInspectionContext globalContext, KClass engineType) {
        return $this.computeXmlCoverageData(globalContext, (KClass<? extends CoverageEngine>)engineType);
    }

    public static final /* synthetic */ PsiElement access$highlightedElement(JvmCoverageInspection $this, PsiElement element2) {
        return $this.highlightedElement(element2);
    }

    static {
        Key key = Key.create((String)"qodana.javacov.coverage");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        javacov = key;
        Key key2 = Key.create((String)"qodana.xml.coverage");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        xmlcov = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R1\u0010\u0003\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0006 \u0007*\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\t\u001a%\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\n \u0007*\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$Companion;", "", "()V", "javacov", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Lazy;", "Lcom/intellij/rt/coverage/data/ProjectData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "xmlcov", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "intellij.qodana.jvm.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J \u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010*\u001a\u00020\u0015H\u0002J:\u0010+\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010,\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u00100\u001a\u0002012\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u0002042\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u00105\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u00106\u001a\u00020\nH\u0002J\u0018\u00107\u001a\u0002012\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u0011H\u0002J\u0010\u00109\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010:\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\u001a\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010<*\u00020!H\u0002R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$JVMDefVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "methodThreshold", "", "classThreshold", "warnMissingCoverage", "", "report", "Lcom/intellij/rt/coverage/data/ProjectData;", "xmlReport", "Lcom/intellij/rt/coverage/report/XMLProjectData;", "highlightedElement", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;Lcom/intellij/codeInspection/ProblemsHolder;IIZLcom/intellij/rt/coverage/data/ProjectData;Lcom/intellij/rt/coverage/report/XMLProjectData;Lkotlin/jvm/functions/Function1;)V", "anonymousClasses", "", "Lorg/jetbrains/uast/UClass;", "visitedMethods", "Lorg/jetbrains/uast/UMethod;", "xmlFileDataLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "classNameForReports", "", "node", "computeName", "Lorg/jetbrains/uast/UDeclaration;", "type", "file", "Lcom/intellij/psi/PsiFile;", "computeXmlCoverage", "data", "Lcom/intellij/rt/coverage/report/XMLProjectData$FileInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getUClassFqn", "uClass", "issueWithXmlMethodCoverage", "psiFile", "project", "Lcom/intellij/openapi/project/Project;", "threshold", "loadXmlFileData", "", "fileInfo", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "methodNameForReports", "isConstructor", "reportMethodCoverage", "sourcePsi", "visitClass", "visitMethod", "packageAndFileName", "Lkotlin/Pair;", "intellij.qodana.jvm.coverage"})
    @SourceDebugExtension(value={"SMAP\nJvmCoverageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$JVMDefVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n800#2,11:278\n288#2,2:289\n*S KotlinDebug\n*F\n+ 1 JvmCoverageInspection.kt\norg/jetbrains/qodana/jvm/coverage/JvmCoverageInspection$JVMDefVisitor\n*L\n117#1:278,11\n184#1:289,2\n*E\n"})
    private static final class JVMDefVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final QodanaGlobalInspectionContext globalContext;
        @NotNull
        private final ProblemsHolder problemsHolder;
        private final int methodThreshold;
        private final int classThreshold;
        private final boolean warnMissingCoverage;
        @Nullable
        private final ProjectData report;
        @Nullable
        private final XMLProjectData xmlReport;
        @NotNull
        private final Function1<PsiElement, PsiElement> highlightedElement;
        @NotNull
        private final Set<UClass> anonymousClasses;
        @NotNull
        private final Set<UMethod> visitedMethods;
        @NotNull
        private final AtomicBoolean xmlFileDataLoaded;

        public JVMDefVisitor(@NotNull QodanaGlobalInspectionContext globalContext, @NotNull ProblemsHolder problemsHolder, int methodThreshold, int classThreshold, boolean warnMissingCoverage, @Nullable ProjectData report2, @Nullable XMLProjectData xmlReport, @NotNull Function1<? super PsiElement, ? extends PsiElement> highlightedElement) {
            Intrinsics.checkNotNullParameter((Object)((Object)globalContext), (String)"globalContext");
            Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
            Intrinsics.checkNotNullParameter(highlightedElement, (String)"highlightedElement");
            this.globalContext = globalContext;
            this.problemsHolder = problemsHolder;
            this.methodThreshold = methodThreshold;
            this.classThreshold = classThreshold;
            this.warnMissingCoverage = warnMissingCoverage;
            this.report = report2;
            this.xmlReport = xmlReport;
            this.highlightedElement = highlightedElement;
            this.anonymousClasses = new LinkedHashSet();
            this.visitedMethods = new LinkedHashSet();
            this.xmlFileDataLoaded = new AtomicBoolean(false);
        }

        /*
         * WARNING - void declaration
         */
        public boolean visitClass(@NotNull UClass node) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable fileData;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement sourcePsi = psiElement;
            String string = this.getUClassFqn(node);
            if (string == null) {
                return true;
            }
            String fqn = string;
            if (this.report != null) {
                ClassData data = this.report.getClassData(fqn);
                PsiFile file = sourcePsi.getContainingFile();
                if (data != null) {
                    VirtualFile virtualFile2 = file.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                    UtilsKt.loadClassData(data, virtualFile2, this.globalContext);
                }
                Intrinsics.checkNotNull((Object)file);
                TextRange textRange = sourcePsi.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Project project2 = this.problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                if (UtilsKt.issueWithClassCoverage(data, file, textRange, project2, this.classThreshold, this.warnMissingCoverage)) {
                    PsiElement psiElement2 = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                    Object[] objectArray = new Object[]{this.classNameForReports(node), this.classThreshold};
                    String string2 = QodanaBundle.message("class.coverage.below.threshold", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    UtilsKt.reportElement(this.problemsHolder, psiElement2, string2);
                }
            } else if (this.xmlReport != null) {
                XMLProjectData.ClassInfo data;
                String fileName;
                PsiFile psiFile2 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                Pair<String, String> pair = this.packageAndFileName(psiFile2);
                if (pair == null) {
                    return true;
                }
                Pair<String, String> pair2 = pair;
                String packageName2 = (String)pair2.component1();
                fileData = this.xmlReport.getFile(XMLReportSuite.Companion.getPath(packageName2, fileName = (String)pair2.component2()));
                if (fileData != null) {
                    VirtualFile virtualFile3 = sourcePsi.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
                    this.loadXmlFileData((XMLProjectData.FileInfo)fileData, virtualFile3, this.globalContext);
                }
                if ((data = this.xmlReport.getClass(fqn)) == null && this.warnMissingCoverage || data != null && data.coveredLines + data.missedLines != 0 && data.coveredLines * 100 / (data.coveredLines + data.missedLines) < this.classThreshold) {
                    PsiElement psiElement3 = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                    Object[] objectArray = new Object[]{this.classNameForReports(node), this.classThreshold};
                    String string3 = QodanaBundle.message("class.coverage.below.threshold", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    UtilsKt.reportElement(this.problemsHolder, psiElement3, string3);
                }
            }
            Iterable $this$filterIsInstance$iv = node.getUastDeclarations();
            boolean $i$f$filterIsInstance = false;
            fileData = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UMethod)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (UMethod method : (List)destination$iv$iv) {
                if (!method.getJavaPsi().isPhysical() && !method.isConstructor()) continue;
                this.visitMethod(method);
            }
            return true;
        }

        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.visitedMethods.add(node)) {
                return true;
            }
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return true;
            }
            PsiElement sourcePsi = psiElement;
            UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
            if (uClass == null) {
                return true;
            }
            UClass containingClass = uClass;
            String string = this.getUClassFqn(containingClass);
            if (string == null) {
                return true;
            }
            String fqn = string;
            if (this.report != null) {
                ClassData data = this.report.getClassData(fqn);
                if (data == null && !this.warnMissingCoverage) {
                    return true;
                }
                if (containingClass.getSourcePsi() == null && this.anonymousClasses.add(containingClass)) {
                    VirtualFile virtualFile2 = sourcePsi.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                    UtilsKt.loadClassData(data, virtualFile2, this.globalContext);
                }
                PsiFile psiFile2 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                TextRange textRange = sourcePsi.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Project project2 = this.problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                if (UtilsKt.issueWithMethodCoverage(data, psiFile2, textRange, project2, this.methodThreshold, this.warnMissingCoverage, this.globalContext)) {
                    this.reportMethodCoverage(node, sourcePsi);
                }
            } else if (this.xmlReport != null) {
                String fileName;
                PsiFile psiFile3 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"getContainingFile(...)");
                Pair<String, String> pair = this.packageAndFileName(psiFile3);
                if (pair == null) {
                    return true;
                }
                Pair<String, String> pair2 = pair;
                String packageName2 = (String)pair2.component1();
                XMLProjectData.FileInfo data = this.xmlReport.getFile(XMLReportSuite.Companion.getPath(packageName2, fileName = (String)pair2.component2()));
                if (data == null && !this.warnMissingCoverage) {
                    return true;
                }
                if (data != null) {
                    VirtualFile virtualFile3 = sourcePsi.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
                    this.loadXmlFileData(data, virtualFile3, this.globalContext);
                }
                PsiFile psiFile4 = sourcePsi.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"getContainingFile(...)");
                TextRange textRange = sourcePsi.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Project project3 = this.problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                if (this.issueWithXmlMethodCoverage(data, psiFile4, textRange, project3, this.methodThreshold, this.globalContext)) {
                    this.reportMethodCoverage(node, sourcePsi);
                }
            }
            return true;
        }

        private final void loadXmlFileData(XMLProjectData.FileInfo fileInfo, VirtualFile virtualFile2, QodanaGlobalInspectionContext globalContext) {
            if (this.xmlFileDataLoaded.getAndSet(true)) {
                return;
            }
            UtilsKt.loadXmlLineData(fileInfo, virtualFile2, globalContext);
        }

        private final void reportMethodCoverage(UMethod node, PsiElement sourcePsi) {
            boolean isConstructor = node.isConstructor();
            String signature = this.methodNameForReports(node, isConstructor);
            if (isConstructor) {
                PsiElement psiElement = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                Object[] objectArray = new Object[]{signature, this.methodThreshold};
                String string = QodanaBundle.message("constructor.coverage.below.threshold", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                UtilsKt.reportElement(this.problemsHolder, psiElement, string);
            } else {
                PsiElement psiElement = (PsiElement)this.highlightedElement.invoke((Object)sourcePsi);
                Object[] objectArray = new Object[]{signature, this.methodThreshold};
                String string = QodanaBundle.message("method.coverage.below.threshold", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                UtilsKt.reportElement(this.problemsHolder, psiElement, string);
            }
        }

        private final int computeXmlCoverage(XMLProjectData.FileInfo data, Document document2, TextRange textRange) {
            int startOffset = textRange.getStartOffset();
            int endOffset = textRange.getEndOffset();
            int startLineNumber = document2.getLineNumber(startOffset) + 1;
            int endLineNumber = document2.getLineNumber(endOffset) + 1;
            int totalLines = 0;
            int coveredLines = 0;
            int i = startLineNumber;
            if (i <= endLineNumber) {
                while (true) {
                    Object v1;
                    block6: {
                        List list2 = data.lines;
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lines");
                        Iterable $this$firstOrNull$iv = list2;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            XMLProjectData.LineInfo it = (XMLProjectData.LineInfo)element$iv;
                            boolean bl = false;
                            if (!(it.lineNumber == i)) continue;
                            v1 = element$iv;
                            break block6;
                        }
                        v1 = null;
                    }
                    XMLProjectData.LineInfo lineData = v1;
                    if (lineData != null) {
                        ++totalLines;
                        if (lineData.coveredInstructions != 0 || lineData.coveredBranches != 0) {
                            ++coveredLines;
                        }
                    }
                    if (i == endLineNumber) break;
                    ++i;
                }
            }
            if (totalLines == 0) {
                return 100;
            }
            return coveredLines * 100 / totalLines;
        }

        private final Pair<String, String> packageAndFileName(PsiFile $this$packageAndFileName) {
            if (!($this$packageAndFileName instanceof PsiClassOwner)) {
                return null;
            }
            String string = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>($this$packageAndFileName){
                final /* synthetic */ PsiFile $this_packageAndFileName;
                {
                    this.$this_packageAndFileName = $receiver;
                    super(0);
                }

                public final String invoke() {
                    return ((PsiClassOwner)this.$this_packageAndFileName).getPackageName();
                }
            }));
            if (string == null) {
                return null;
            }
            String packageName2 = string;
            String string2 = ((PsiClassOwner)$this$packageAndFileName).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            return TuplesKt.to((Object)packageName2, (Object)string2);
        }

        private final boolean issueWithXmlMethodCoverage(XMLProjectData.FileInfo data, PsiFile psiFile2, TextRange textRange, Project project2, int threshold, QodanaGlobalInspectionContext globalContext) {
            if (data == null) {
                return UtilsKt.failAndLoadMissingCoverageIfNeeded(project2, textRange, psiFile2, this.warnMissingCoverage, globalContext);
            }
            Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
            if (document2 == null) {
                return false;
            }
            Document doc = document2;
            return this.computeXmlCoverage(data, doc, textRange) < threshold;
        }

        private final String getUClassFqn(UClass uClass) {
            if (uClass instanceof UAnonymousClass) {
                PsiClass psiClass = uClass.getJavaPsi();
                Intrinsics.checkNotNull((Object)psiClass, (String)"null cannot be cast to non-null type com.intellij.psi.PsiAnonymousClass");
                String anonymousName = UastAnonymousClassUtil.getName((PsiAnonymousClass)((PsiAnonymousClass)psiClass));
                UClass uClass2 = UastUtils.getContainingUClass((UElement)((UElement)uClass));
                if (uClass2 == null) {
                    return anonymousName;
                }
                UClass containingClass = uClass2;
                String parentName = this.getUClassFqn(containingClass);
                return parentName + anonymousName;
            }
            String name = uClass.getQualifiedName();
            if (name != null && StringsKt.endsWith$default((String)name, (String)".Companion", (boolean)false, (int)2, null)) {
                PsiIdentifier psiIdentifier = uClass.getJavaPsi().getNameIdentifier();
                boolean bl = psiIdentifier != null && (psiIdentifier = psiIdentifier.getTextRange()) != null ? psiIdentifier.isEmpty() : false;
                if (bl) {
                    return StringsKt.removeSuffix((String)name, (CharSequence)".Companion") + "$Companion";
                }
            }
            return name;
        }

        private final String methodNameForReports(UMethod node, boolean isConstructor) {
            UDeclaration uDeclaration = (UDeclaration)node;
            String string = isConstructor ? "constructor" : "function";
            PsiFile psiFile2 = node.getJavaPsi().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            return this.computeName(uDeclaration, string, psiFile2);
        }

        private final String classNameForReports(UClass node) {
            UDeclaration uDeclaration = (UDeclaration)node;
            PsiFile psiFile2 = node.getJavaPsi().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
            return this.computeName(uDeclaration, "class", psiFile2);
        }

        private final String computeName(UDeclaration node, String type, PsiFile file) {
            String psiName;
            PsiElement psiElement = node.getJavaPsi();
            PsiNameIdentifierOwner psiNameIdentifierOwner = psiElement instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiElement : null;
            String string = psiName = psiNameIdentifierOwner != null ? psiNameIdentifierOwner.getName() : null;
            if (psiName != null) {
                return String.valueOf(psiName);
            }
            UClass currentClass = UastUtils.getContainingUClass((UElement)((UElement)node));
            while (currentClass != null) {
                PsiNameIdentifierOwner nameOwner;
                PsiClass psiClass = currentClass.getJavaPsi();
                PsiNameIdentifierOwner psiNameIdentifierOwner2 = nameOwner = psiClass instanceof PsiNameIdentifierOwner ? (PsiNameIdentifierOwner)psiClass : null;
                if ((psiNameIdentifierOwner2 != null ? psiNameIdentifierOwner2.getName() : null) != null) {
                    return "(anonymous " + type + " in " + nameOwner.getName() + ")";
                }
                currentClass = UastUtils.getContainingUClass((UElement)((UElement)currentClass));
            }
            return "(anonymous " + type + " in " + file.getName() + ")";
        }
    }
}

