/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.extensions.VcsIgnoredFilesProvider;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FixesStrategy;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfigKt;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaProfileConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaScriptConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaYamlConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.DefaultSeverityIncludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.ExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.GlobalExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormat;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormatKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b2\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 |2\u00020\u0001:\u0001|B\u00f3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u000e\u0012\u0006\u0010\u0015\u001a\u00020\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u0003\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u001c\u001a\u00020\u000e\u0012\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` \u0012\u0010\u0010!\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` \u0012\b\u0010\"\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010$\u001a\u00020\f\u0012\b\b\u0002\u0010%\u001a\u00020\f\u0012\b\b\u0002\u0010&\u001a\u00020\f\u00a2\u0006\u0002\u0010'J\u000e\u0010Q\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020SJ\t\u0010T\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010U\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010IJ\t\u0010V\u001a\u00020\u0013H\u00c6\u0003J\t\u0010W\u001a\u00020\u000eH\u00c6\u0003J\t\u0010X\u001a\u00020\u0007H\u00c6\u0003J\t\u0010Y\u001a\u00020\u0017H\u00c6\u0003J\t\u0010Z\u001a\u00020\u0019H\u00c6\u0003J\t\u0010[\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\\\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010]\u001a\u00020\u000eH\u00c6\u0003J\u0013\u0010^\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` H\u00c6\u0003J\t\u0010_\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010`\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` H\u00c6\u0003J\u000b\u0010a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0010\u0010b\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010OJ\t\u0010c\u001a\u00020\fH\u00c6\u0003J\t\u0010d\u001a\u00020\fH\u00c6\u0003J\t\u0010e\u001a\u00020\fH\u00c6\u0003J\t\u0010f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010g\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010h\u001a\u00020\tH\u00c6\u0003J\t\u0010i\u001a\u00020\u0007H\u00c6\u0003J\t\u0010j\u001a\u00020\fH\u00c6\u0003J\t\u0010k\u001a\u00020\u000eH\u00c6\u0003J\t\u0010l\u001a\u00020\u0010H\u00c6\u0003J\u00a6\u0002\u0010m\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000e2\b\b\u0002\u0010\u0015\u001a\u00020\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00032\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u000e2\u0012\b\u0002\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` 2\u0012\b\u0002\u0010!\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` 2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010$\u001a\u00020\f2\b\b\u0002\u0010%\u001a\u00020\f2\b\b\u0002\u0010&\u001a\u00020\fH\u00c6\u0001\u00a2\u0006\u0002\u0010nJ\u0013\u0010o\u001a\u00020\u000e2\b\u0010p\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001c\u0010q\u001a\b\u0012\u0004\u0012\u00020r0\u001e2\u0006\u0010s\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020uJ\f\u0010v\u001a\b\u0012\u0004\u0012\u00020r0\u001eJ\t\u0010w\u001a\u00020\fH\u00d6\u0001J\u000e\u0010x\u001a\u00020\u000e2\u0006\u0010y\u001a\u00020\fJ\u0010\u0010z\u001a\u00020\u000e2\u0006\u0010t\u001a\u00020uH\u0002J\t\u0010{\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u001c\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\"\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010)R\u001b\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` \u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010$\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00104R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001b\u0010!\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` \u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00102R\u0011\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010)R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0011\u0010%\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00104R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010.R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010+R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010.R\u0011\u0010&\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u00104R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010.R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010J\u001a\u0004\bH\u0010IR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010+R\u0015\u0010#\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010P\u001a\u0004\bN\u0010O\u00a8\u0006}"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "", "projectPath", "Ljava/nio/file/Path;", "outPath", "resultsStorage", "baseline", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "defaultProfileName", "failThreshold", "", "disableSanityInspections", "", "fixesStrategy", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "runPromoInspections", "script", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "includeAbsent", "outputInspectFormat", "outputFormat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "licenseType", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "coveragePath", "sourceDirectory", "analyzeChanges", "exclude", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScopes;", "include", "bootstrap", "stopThreshold", "fileSuspendThreshold", "moduleSuspendThreshold", "projectSuspendThreshold", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;IZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLjava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicenseType;Ljava/nio/file/Path;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/Integer;III)V", "getAnalyzeChanges", "()Z", "getBaseline", "()Ljava/lang/String;", "getBootstrap", "getCoveragePath", "()Ljava/nio/file/Path;", "getDefaultProfileName", "getDisableSanityInspections", "getExclude", "()Ljava/util/List;", "getFailThreshold", "()I", "getFileSuspendThreshold", "getFixesStrategy", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "getInclude", "getIncludeAbsent", "getLicenseType", "()Lorg/jetbrains/qodana/license/QodanaLicenseType;", "setLicenseType", "(Lorg/jetbrains/qodana/license/QodanaLicenseType;)V", "getModuleSuspendThreshold", "getOutPath", "getOutputFormat", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "getOutputInspectFormat", "getProfile", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "getProjectPath", "getProjectSuspendThreshold", "getResultsStorage", "getRunPromoInspections", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getScript", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "getSourceDirectory", "getStopThreshold", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "checkRunPromo", "inspectionProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component24", "component25", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;IZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLjava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicenseType;Ljava/nio/file/Path;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/Integer;III)Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "equals", "other", "getExcludeModifiers", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaScopeModifier;", "addDefaultExclude", "project", "Lcom/intellij/openapi/project/Project;", "getIncludeModifiers", "hashCode", "isAboveStopThreshold", "count", "supportsGitIgnore", "toString", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1549#2:253\n1620#2,3:254\n*S KotlinDebug\n*F\n+ 1 QodanaConfig.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig\n*L\n216#1:253\n216#1:254,3\n*E\n"})
public final class QodanaConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path projectPath;
    @NotNull
    private final Path outPath;
    @NotNull
    private final Path resultsStorage;
    @Nullable
    private final String baseline;
    @NotNull
    private final QodanaProfileConfig profile;
    @NotNull
    private final String defaultProfileName;
    private final int failThreshold;
    private final boolean disableSanityInspections;
    @NotNull
    private final FixesStrategy fixesStrategy;
    @Nullable
    private final Boolean runPromoInspections;
    @NotNull
    private final QodanaScriptConfig script;
    private final boolean includeAbsent;
    @NotNull
    private final String outputInspectFormat;
    @NotNull
    private final OutputFormat outputFormat;
    @NotNull
    private QodanaLicenseType licenseType;
    @NotNull
    private final Path coveragePath;
    @Nullable
    private final String sourceDirectory;
    private final boolean analyzeChanges;
    @NotNull
    private final List<InspectScope> exclude;
    @NotNull
    private final List<InspectScope> include;
    @Nullable
    private final String bootstrap;
    @Nullable
    private final Integer stopThreshold;
    private final int fileSuspendThreshold;
    private final int moduleSuspendThreshold;
    private final int projectSuspendThreshold;

    public QodanaConfig(@NotNull Path projectPath, @NotNull Path outPath, @NotNull Path resultsStorage, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String defaultProfileName, int failThreshold, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull String outputInspectFormat, @NotNull OutputFormat outputFormat, @NotNull QodanaLicenseType licenseType, @NotNull Path coveragePath, @Nullable String sourceDirectory, boolean analyzeChanges, @NotNull List<InspectScope> exclude2, @NotNull List<InspectScope> include, @Nullable String bootstrap, @Nullable Integer stopThreshold, int fileSuspendThreshold, int moduleSuspendThreshold, int projectSuspendThreshold) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)outputInspectFormat, (String)"outputInspectFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
        Intrinsics.checkNotNullParameter(exclude2, (String)"exclude");
        Intrinsics.checkNotNullParameter(include, (String)"include");
        this.projectPath = projectPath;
        this.outPath = outPath;
        this.resultsStorage = resultsStorage;
        this.baseline = baseline;
        this.profile = profile2;
        this.defaultProfileName = defaultProfileName;
        this.failThreshold = failThreshold;
        this.disableSanityInspections = disableSanityInspections;
        this.fixesStrategy = fixesStrategy;
        this.runPromoInspections = runPromoInspections;
        this.script = script;
        this.includeAbsent = includeAbsent;
        this.outputInspectFormat = outputInspectFormat;
        this.outputFormat = outputFormat;
        this.licenseType = licenseType;
        this.coveragePath = coveragePath;
        this.sourceDirectory = sourceDirectory;
        this.analyzeChanges = analyzeChanges;
        this.exclude = exclude2;
        this.include = include;
        this.bootstrap = bootstrap;
        this.stopThreshold = stopThreshold;
        this.fileSuspendThreshold = fileSuspendThreshold;
        this.moduleSuspendThreshold = moduleSuspendThreshold;
        this.projectSuspendThreshold = projectSuspendThreshold;
        if (!this.projectPath.isAbsolute()) {
            throw new QodanaException("Project path \"" + this.projectPath + "\" must be absolute");
        }
    }

    public /* synthetic */ QodanaConfig(Path path, Path path2, Path path3, String string, QodanaProfileConfig qodanaProfileConfig, String string2, int n, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, String string3, OutputFormat outputFormat, QodanaLicenseType qodanaLicenseType, Path path4, String string4, boolean bl4, List list2, List list3, String string5, Integer n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x200000) != 0) {
            String string6 = System.getProperty("qodana.stop.threshold");
            Integer n7 = n2 = string6 != null ? Integer.valueOf(Integer.parseInt(string6)) : null;
        }
        if ((n6 & 0x400000) != 0) {
            String string7 = System.getProperty("qodana.file.suspend.threshold", "5");
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getProperty(...)");
            n3 = Integer.parseInt(string7);
        }
        if ((n6 & 0x800000) != 0) {
            String string8 = System.getProperty("qodana.module.suspend.threshold", "25");
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getProperty(...)");
            n4 = Integer.parseInt(string8);
        }
        if ((n6 & 0x1000000) != 0) {
            String string9 = System.getProperty("qodana.project.suspend.threshold", "125");
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getProperty(...)");
            n5 = Integer.parseInt(string9);
        }
        this(path, path2, path3, string, qodanaProfileConfig, string2, n, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, string3, outputFormat, qodanaLicenseType, path4, string4, bl4, list2, list3, string5, n2, n3, n4, n5);
    }

    @NotNull
    public final Path getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public final Path getOutPath() {
        return this.outPath;
    }

    @NotNull
    public final Path getResultsStorage() {
        return this.resultsStorage;
    }

    @Nullable
    public final String getBaseline() {
        return this.baseline;
    }

    @NotNull
    public final QodanaProfileConfig getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getDefaultProfileName() {
        return this.defaultProfileName;
    }

    public final int getFailThreshold() {
        return this.failThreshold;
    }

    public final boolean getDisableSanityInspections() {
        return this.disableSanityInspections;
    }

    @NotNull
    public final FixesStrategy getFixesStrategy() {
        return this.fixesStrategy;
    }

    @Nullable
    public final Boolean getRunPromoInspections() {
        return this.runPromoInspections;
    }

    @NotNull
    public final QodanaScriptConfig getScript() {
        return this.script;
    }

    public final boolean getIncludeAbsent() {
        return this.includeAbsent;
    }

    @NotNull
    public final String getOutputInspectFormat() {
        return this.outputInspectFormat;
    }

    @NotNull
    public final OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @NotNull
    public final QodanaLicenseType getLicenseType() {
        return this.licenseType;
    }

    public final void setLicenseType(@NotNull QodanaLicenseType qodanaLicenseType) {
        Intrinsics.checkNotNullParameter((Object)((Object)qodanaLicenseType), (String)"<set-?>");
        this.licenseType = qodanaLicenseType;
    }

    @NotNull
    public final Path getCoveragePath() {
        return this.coveragePath;
    }

    @Nullable
    public final String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public final boolean getAnalyzeChanges() {
        return this.analyzeChanges;
    }

    @NotNull
    public final List<InspectScope> getExclude() {
        return this.exclude;
    }

    @NotNull
    public final List<InspectScope> getInclude() {
        return this.include;
    }

    @Nullable
    public final String getBootstrap() {
        return this.bootstrap;
    }

    @Nullable
    public final Integer getStopThreshold() {
        return this.stopThreshold;
    }

    public final int getFileSuspendThreshold() {
        return this.fileSuspendThreshold;
    }

    public final int getModuleSuspendThreshold() {
        return this.moduleSuspendThreshold;
    }

    public final int getProjectSuspendThreshold() {
        return this.projectSuspendThreshold;
    }

    public final boolean checkRunPromo(@NotNull QodanaInspectionProfile inspectionProfile) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionProfile), (String)"inspectionProfile");
        return Intrinsics.areEqual((Object)this.runPromoInspections, (Object)true) || this.runPromoInspections == null && Intrinsics.areEqual((Object)inspectionProfile.getName(), (Object)this.defaultProfileName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<QodanaScopeModifier> getIncludeModifiers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.include;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            InspectScope inspectScope = (InspectScope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DefaultSeverityIncludeScopeModifier((InspectScope)p0));
        }
        return (List)destination$iv$iv;
    }

    private final boolean supportsGitIgnore(Project project2) {
        List<FilePath> ignored = VcsIgnoredFilesProvider.Companion.getVcsRepositoriesIgnoredFiles(project2);
        return !((Collection)ignored).isEmpty();
    }

    @NotNull
    public final List<QodanaScopeModifier> getExcludeModifiers(boolean addDefaultExclude, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List modifiers = new ArrayList();
        for (InspectScope scope2 : this.exclude) {
            if (Intrinsics.areEqual((Object)scope2.getName(), (Object)"All")) {
                ((Collection)modifiers).add(new GlobalExcludeScopeModifier(scope2));
                continue;
            }
            ((Collection)modifiers).add(new ExcludeScopeModifier(scope2));
        }
        if (addDefaultExclude) {
            ((Collection)modifiers).add(QodanaConfigKt.getDEFAULT_EXCLUDE_SCOPE_MODIFIER());
        }
        if (addDefaultExclude && this.supportsGitIgnore(project2)) {
            ((Collection)modifiers).add(QodanaConfigKt.getGIT_IGNORE_SCOPE_MODIFIER());
        }
        return modifiers;
    }

    public final boolean isAboveStopThreshold(int count) {
        return this.stopThreshold != null && count > this.stopThreshold;
    }

    @NotNull
    public final Path component1() {
        return this.projectPath;
    }

    @NotNull
    public final Path component2() {
        return this.outPath;
    }

    @NotNull
    public final Path component3() {
        return this.resultsStorage;
    }

    @Nullable
    public final String component4() {
        return this.baseline;
    }

    @NotNull
    public final QodanaProfileConfig component5() {
        return this.profile;
    }

    @NotNull
    public final String component6() {
        return this.defaultProfileName;
    }

    public final int component7() {
        return this.failThreshold;
    }

    public final boolean component8() {
        return this.disableSanityInspections;
    }

    @NotNull
    public final FixesStrategy component9() {
        return this.fixesStrategy;
    }

    @Nullable
    public final Boolean component10() {
        return this.runPromoInspections;
    }

    @NotNull
    public final QodanaScriptConfig component11() {
        return this.script;
    }

    public final boolean component12() {
        return this.includeAbsent;
    }

    @NotNull
    public final String component13() {
        return this.outputInspectFormat;
    }

    @NotNull
    public final OutputFormat component14() {
        return this.outputFormat;
    }

    @NotNull
    public final QodanaLicenseType component15() {
        return this.licenseType;
    }

    @NotNull
    public final Path component16() {
        return this.coveragePath;
    }

    @Nullable
    public final String component17() {
        return this.sourceDirectory;
    }

    public final boolean component18() {
        return this.analyzeChanges;
    }

    @NotNull
    public final List<InspectScope> component19() {
        return this.exclude;
    }

    @NotNull
    public final List<InspectScope> component20() {
        return this.include;
    }

    @Nullable
    public final String component21() {
        return this.bootstrap;
    }

    @Nullable
    public final Integer component22() {
        return this.stopThreshold;
    }

    public final int component23() {
        return this.fileSuspendThreshold;
    }

    public final int component24() {
        return this.moduleSuspendThreshold;
    }

    public final int component25() {
        return this.projectSuspendThreshold;
    }

    @NotNull
    public final QodanaConfig copy(@NotNull Path projectPath, @NotNull Path outPath, @NotNull Path resultsStorage, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String defaultProfileName, int failThreshold, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull String outputInspectFormat, @NotNull OutputFormat outputFormat, @NotNull QodanaLicenseType licenseType, @NotNull Path coveragePath, @Nullable String sourceDirectory, boolean analyzeChanges, @NotNull List<InspectScope> exclude2, @NotNull List<InspectScope> include, @Nullable String bootstrap, @Nullable Integer stopThreshold, int fileSuspendThreshold, int moduleSuspendThreshold, int projectSuspendThreshold) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)outputInspectFormat, (String)"outputInspectFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
        Intrinsics.checkNotNullParameter(exclude2, (String)"exclude");
        Intrinsics.checkNotNullParameter(include, (String)"include");
        return new QodanaConfig(projectPath, outPath, resultsStorage, baseline, profile2, defaultProfileName, failThreshold, disableSanityInspections, fixesStrategy, runPromoInspections, script, includeAbsent, outputInspectFormat, outputFormat, licenseType, coveragePath, sourceDirectory, analyzeChanges, exclude2, include, bootstrap, stopThreshold, fileSuspendThreshold, moduleSuspendThreshold, projectSuspendThreshold);
    }

    public static /* synthetic */ QodanaConfig copy$default(QodanaConfig qodanaConfig, Path path, Path path2, Path path3, String string, QodanaProfileConfig qodanaProfileConfig, String string2, int n, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, String string3, OutputFormat outputFormat, QodanaLicenseType qodanaLicenseType, Path path4, String string4, boolean bl4, List list2, List list3, String string5, Integer n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            path = qodanaConfig.projectPath;
        }
        if ((n6 & 2) != 0) {
            path2 = qodanaConfig.outPath;
        }
        if ((n6 & 4) != 0) {
            path3 = qodanaConfig.resultsStorage;
        }
        if ((n6 & 8) != 0) {
            string = qodanaConfig.baseline;
        }
        if ((n6 & 0x10) != 0) {
            qodanaProfileConfig = qodanaConfig.profile;
        }
        if ((n6 & 0x20) != 0) {
            string2 = qodanaConfig.defaultProfileName;
        }
        if ((n6 & 0x40) != 0) {
            n = qodanaConfig.failThreshold;
        }
        if ((n6 & 0x80) != 0) {
            bl = qodanaConfig.disableSanityInspections;
        }
        if ((n6 & 0x100) != 0) {
            fixesStrategy = qodanaConfig.fixesStrategy;
        }
        if ((n6 & 0x200) != 0) {
            bl2 = qodanaConfig.runPromoInspections;
        }
        if ((n6 & 0x400) != 0) {
            qodanaScriptConfig = qodanaConfig.script;
        }
        if ((n6 & 0x800) != 0) {
            bl3 = qodanaConfig.includeAbsent;
        }
        if ((n6 & 0x1000) != 0) {
            string3 = qodanaConfig.outputInspectFormat;
        }
        if ((n6 & 0x2000) != 0) {
            outputFormat = qodanaConfig.outputFormat;
        }
        if ((n6 & 0x4000) != 0) {
            qodanaLicenseType = qodanaConfig.licenseType;
        }
        if ((n6 & 0x8000) != 0) {
            path4 = qodanaConfig.coveragePath;
        }
        if ((n6 & 0x10000) != 0) {
            string4 = qodanaConfig.sourceDirectory;
        }
        if ((n6 & 0x20000) != 0) {
            bl4 = qodanaConfig.analyzeChanges;
        }
        if ((n6 & 0x40000) != 0) {
            list2 = qodanaConfig.exclude;
        }
        if ((n6 & 0x80000) != 0) {
            list3 = qodanaConfig.include;
        }
        if ((n6 & 0x100000) != 0) {
            string5 = qodanaConfig.bootstrap;
        }
        if ((n6 & 0x200000) != 0) {
            n2 = qodanaConfig.stopThreshold;
        }
        if ((n6 & 0x400000) != 0) {
            n3 = qodanaConfig.fileSuspendThreshold;
        }
        if ((n6 & 0x800000) != 0) {
            n4 = qodanaConfig.moduleSuspendThreshold;
        }
        if ((n6 & 0x1000000) != 0) {
            n5 = qodanaConfig.projectSuspendThreshold;
        }
        return qodanaConfig.copy(path, path2, path3, string, qodanaProfileConfig, string2, n, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, string3, outputFormat, qodanaLicenseType, path4, string4, bl4, list2, list3, string5, n2, n3, n4, n5);
    }

    @NotNull
    public String toString() {
        return "QodanaConfig(projectPath=" + this.projectPath + ", outPath=" + this.outPath + ", resultsStorage=" + this.resultsStorage + ", baseline=" + this.baseline + ", profile=" + this.profile + ", defaultProfileName=" + this.defaultProfileName + ", failThreshold=" + this.failThreshold + ", disableSanityInspections=" + this.disableSanityInspections + ", fixesStrategy=" + this.fixesStrategy + ", runPromoInspections=" + this.runPromoInspections + ", script=" + this.script + ", includeAbsent=" + this.includeAbsent + ", outputInspectFormat=" + this.outputInspectFormat + ", outputFormat=" + this.outputFormat + ", licenseType=" + this.licenseType + ", coveragePath=" + this.coveragePath + ", sourceDirectory=" + this.sourceDirectory + ", analyzeChanges=" + this.analyzeChanges + ", exclude=" + this.exclude + ", include=" + this.include + ", bootstrap=" + this.bootstrap + ", stopThreshold=" + this.stopThreshold + ", fileSuspendThreshold=" + this.fileSuspendThreshold + ", moduleSuspendThreshold=" + this.moduleSuspendThreshold + ", projectSuspendThreshold=" + this.projectSuspendThreshold + ")";
    }

    public int hashCode() {
        int result = ((Object)this.projectPath).hashCode();
        result = result * 31 + ((Object)this.outPath).hashCode();
        result = result * 31 + ((Object)this.resultsStorage).hashCode();
        result = result * 31 + (this.baseline == null ? 0 : this.baseline.hashCode());
        result = result * 31 + this.profile.hashCode();
        result = result * 31 + this.defaultProfileName.hashCode();
        result = result * 31 + Integer.hashCode(this.failThreshold);
        int n = this.disableSanityInspections ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.fixesStrategy.hashCode();
        result = result * 31 + (this.runPromoInspections == null ? 0 : ((Object)this.runPromoInspections).hashCode());
        result = result * 31 + this.script.hashCode();
        int n2 = this.includeAbsent ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        result = result * 31 + this.outputInspectFormat.hashCode();
        result = result * 31 + this.outputFormat.hashCode();
        result = result * 31 + this.licenseType.hashCode();
        result = result * 31 + ((Object)this.coveragePath).hashCode();
        result = result * 31 + (this.sourceDirectory == null ? 0 : this.sourceDirectory.hashCode());
        int n3 = this.analyzeChanges ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result = result * 31 + n3;
        result = result * 31 + ((Object)this.exclude).hashCode();
        result = result * 31 + ((Object)this.include).hashCode();
        result = result * 31 + (this.bootstrap == null ? 0 : this.bootstrap.hashCode());
        result = result * 31 + (this.stopThreshold == null ? 0 : ((Object)this.stopThreshold).hashCode());
        result = result * 31 + Integer.hashCode(this.fileSuspendThreshold);
        result = result * 31 + Integer.hashCode(this.moduleSuspendThreshold);
        result = result * 31 + Integer.hashCode(this.projectSuspendThreshold);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QodanaConfig)) {
            return false;
        }
        QodanaConfig qodanaConfig = (QodanaConfig)other;
        if (!Intrinsics.areEqual((Object)this.projectPath, (Object)qodanaConfig.projectPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outPath, (Object)qodanaConfig.outPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resultsStorage, (Object)qodanaConfig.resultsStorage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseline, (Object)qodanaConfig.baseline)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profile, (Object)qodanaConfig.profile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultProfileName, (Object)qodanaConfig.defaultProfileName)) {
            return false;
        }
        if (this.failThreshold != qodanaConfig.failThreshold) {
            return false;
        }
        if (this.disableSanityInspections != qodanaConfig.disableSanityInspections) {
            return false;
        }
        if (this.fixesStrategy != qodanaConfig.fixesStrategy) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.runPromoInspections, (Object)qodanaConfig.runPromoInspections)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.script, (Object)qodanaConfig.script)) {
            return false;
        }
        if (this.includeAbsent != qodanaConfig.includeAbsent) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outputInspectFormat, (Object)qodanaConfig.outputInspectFormat)) {
            return false;
        }
        if (this.outputFormat != qodanaConfig.outputFormat) {
            return false;
        }
        if (this.licenseType != qodanaConfig.licenseType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.coveragePath, (Object)qodanaConfig.coveragePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceDirectory, (Object)qodanaConfig.sourceDirectory)) {
            return false;
        }
        if (this.analyzeChanges != qodanaConfig.analyzeChanges) {
            return false;
        }
        if (!Intrinsics.areEqual(this.exclude, qodanaConfig.exclude)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.include, qodanaConfig.include)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bootstrap, (Object)qodanaConfig.bootstrap)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stopThreshold, (Object)qodanaConfig.stopThreshold)) {
            return false;
        }
        if (this.fileSuspendThreshold != qodanaConfig.fileSuspendThreshold) {
            return false;
        }
        if (this.moduleSuspendThreshold != qodanaConfig.moduleSuspendThreshold) {
            return false;
        }
        return this.projectSuspendThreshold == qodanaConfig.projectSuspendThreshold;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00ff\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010\u001a\u001a\u00020\f2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00062\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010!\u001a\u00020\u00132\u0012\b\u0002\u0010\"\u001a\f\u0012\u0004\u0012\u00020$0#j\u0002`%2\u0012\b\u0002\u0010&\u001a\f\u0012\u0004\u0012\u00020$0#j\u0002`%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig$Companion;", "", "()V", "fromYaml", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "projectPath", "Ljava/nio/file/Path;", "outPath", "yaml", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;", "resultsStorage", "baseline", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "defaultProfileName", "failThreshold", "", "disableSanityInspections", "", "fixesStrategy", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "runPromoInspections", "script", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "includeAbsent", "outputInspectFormat", "outputFormat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "licenseType", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "coveragePath", "sourceDirectory", "analyzeChanges", "exclude", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScopes;", "include", "bootstrap", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;Ljava/nio/file/Path;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;IZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLjava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicenseType;Ljava/nio/file/Path;Ljava/lang/String;ZLjava/util/List;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QodanaConfig fromYaml(@NotNull Path projectPath, @NotNull Path outPath, @NotNull QodanaYamlConfig yaml, @NotNull Path resultsStorage, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String defaultProfileName, int failThreshold, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull String outputInspectFormat, @NotNull OutputFormat outputFormat, @NotNull QodanaLicenseType licenseType, @NotNull Path coveragePath, @Nullable String sourceDirectory, boolean analyzeChanges, @NotNull List<InspectScope> exclude2, @NotNull List<InspectScope> include, @Nullable String bootstrap) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
            Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
            Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
            Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
            Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
            Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)outputInspectFormat, (String)"outputInspectFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
            Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
            Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
            Intrinsics.checkNotNullParameter(exclude2, (String)"exclude");
            Intrinsics.checkNotNullParameter(include, (String)"include");
            if (!Intrinsics.areEqual((Object)yaml.getVersion(), (Object)"1.0")) {
                throw new QodanaException("Property \"version\" in qodana.yaml must be \"1.0\", not \"" + yaml.getVersion() + "\"");
            }
            return new QodanaConfig(projectPath, outPath, resultsStorage, baseline, profile2, defaultProfileName, failThreshold, disableSanityInspections, fixesStrategy, runPromoInspections, script, includeAbsent, outputInspectFormat, outputFormat, licenseType, coveragePath, sourceDirectory, analyzeChanges, exclude2, include, bootstrap, null, 0, 0, 0, 0x1E00000, null);
        }

        public static /* synthetic */ QodanaConfig fromYaml$default(Companion companion, Path path, Path path2, QodanaYamlConfig qodanaYamlConfig, Path path3, String string, QodanaProfileConfig qodanaProfileConfig, String string2, int n, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, String string3, OutputFormat outputFormat, QodanaLicenseType qodanaLicenseType, Path path4, String string4, boolean bl4, List list2, List list3, String string5, int n2, Object object) {
            if ((n2 & 4) != 0) {
                qodanaYamlConfig = QodanaYamlConfig.Companion.getEMPTY_V1();
            }
            if ((n2 & 8) != 0) {
                path3 = QodanaConfigKt.getResultsStorage(path2, OutputFormatKt.getOutputFormat());
            }
            if ((n2 & 0x10) != 0) {
                string = null;
            }
            if ((n2 & 0x20) != 0) {
                qodanaProfileConfig = qodanaYamlConfig.getProfile();
            }
            if ((n2 & 0x40) != 0) {
                string2 = QodanaConfigKt.access$getDefaultProfileName();
            }
            if ((n2 & 0x80) != 0) {
                n = qodanaYamlConfig.getFailThreshold();
            }
            if ((n2 & 0x100) != 0) {
                bl = qodanaYamlConfig.getDisableSanityInspections();
            }
            if ((n2 & 0x200) != 0) {
                fixesStrategy = FixesStrategy.Companion.fromString(qodanaYamlConfig.getFixesStrategy());
            }
            if ((n2 & 0x400) != 0) {
                bl2 = qodanaYamlConfig.getRunPromoInspections();
            }
            if ((n2 & 0x800) != 0) {
                qodanaScriptConfig = qodanaYamlConfig.getScript();
            }
            if ((n2 & 0x1000) != 0) {
                bl3 = qodanaYamlConfig.getIncludeAbsent();
            }
            if ((n2 & 0x2000) != 0) {
                string3 = "json";
            }
            if ((n2 & 0x4000) != 0) {
                outputFormat = OutputFormatKt.getOutputFormat();
            }
            if ((n2 & 0x8000) != 0) {
                qodanaLicenseType = QodanaLicenseType.ULTIMATE_PLUS;
            }
            if ((n2 & 0x10000) != 0) {
                Path path5 = path2.resolve("coverage/");
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
                path4 = path5;
            }
            if ((n2 & 0x20000) != 0) {
                string4 = null;
            }
            if ((n2 & 0x40000) != 0) {
                bl4 = false;
            }
            if ((n2 & 0x80000) != 0) {
                list2 = qodanaYamlConfig.getExclude();
            }
            if ((n2 & 0x100000) != 0) {
                list3 = qodanaYamlConfig.getInclude();
            }
            if ((n2 & 0x200000) != 0) {
                string5 = qodanaYamlConfig.getBootstrap();
            }
            return companion.fromYaml(path, path2, qodanaYamlConfig, path3, string, qodanaProfileConfig, string2, n, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, string3, outputFormat, qodanaLicenseType, path4, string4, bl4, list2, list3, string5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

