/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.InspectionApplicationBase;
import com.intellij.codeInspection.InspectionApplicationException;
import com.intellij.codeInspection.InspectionApplicationFactory;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FixesStrategy;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaYamlComponent;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaYamlConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionApplication;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionApplicationFactory;
import org.jetbrains.qodana.staticAnalysis.script.QodanaApplicationScriptFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\b\u0010\n\u001a\u00020\tH\u0002JD\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplicationFactory;", "Lcom/intellij/codeInspection/InspectionApplicationFactory;", "()V", "options", "Lorg/apache/commons/cli/Options;", "buildApplication", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplication;", "args", "", "", "buildHelpString", "deprecatedLast", "Ljava/util/Comparator;", "Lorg/apache/commons/cli/Option;", "kotlin.jvm.PlatformType", "default", "Lkotlin/Comparator;", "dumpOptions", "", "getApplication", "Lcom/intellij/codeInspection/InspectionApplicationBase;", "id", "parseArgs", "Lorg/apache/commons/cli/CommandLine;", "reportError", "message", "setQodanaOutputLogLevel", "fixesStrategy", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaInspectionApplicationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaInspectionApplicationFactory.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplicationFactory\n+ 2 QodanaYamlComponent.kt\norg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlComponent$Companion\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n83#2:210\n37#3,2:211\n10#4:213\n*S KotlinDebug\n*F\n+ 1 QodanaInspectionApplicationFactory.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplicationFactory\n*L\n89#1:210\n169#1:211,2\n207#1:213\n*E\n"})
public final class QodanaInspectionApplicationFactory
implements InspectionApplicationFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Options options;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public QodanaInspectionApplicationFactory() {
        void $this$options_u24lambda_u240;
        Options options;
        Options options2 = options = new Options();
        QodanaInspectionApplicationFactory qodanaInspectionApplicationFactory = this;
        boolean bl = false;
        $this$options_u24lambda_u240.addOption("b", "baseline", true, QodanaBundle.message("baseline.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "baseline-include-absent", false, QodanaBundle.message("baseline.include.absent.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "fail-threshold", true, QodanaBundle.message("fail.threshold.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "run-promo", true, QodanaBundle.message("run.promo.inspections.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "disable-sanity", false, QodanaBundle.message("disable.sanity.inspections.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "apply-fixes", false, QodanaBundle.message("apply.fixes.inspections.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "cleanup", false, QodanaBundle.message("cleanup.inspections.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "script", true, QodanaBundle.message("script.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("n", "profile-name", true, QodanaBundle.message("profileName.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("p", "profile-path", true, QodanaBundle.message("profilePath.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("c", "changes", false, QodanaBundle.message("changes.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("d", "source-directory", true, QodanaBundle.message("source.directory.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("profileName", null, true, QodanaBundle.message("profileName.deprecated.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("profilePath", null, true, QodanaBundle.message("profilePath.deprecated.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption("changes", null, false, QodanaBundle.message("changes.deprecated.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "fixes-strategy", true, QodanaBundle.message("fixes.strategy.inspections.option.description", new Object[0]));
        $this$options_u24lambda_u240.addOption(null, "stub-profile", true, QodanaBundle.message("stubProfile.option.description", new Object[0]));
        qodanaInspectionApplicationFactory.options = options;
    }

    @NotNull
    public String id() {
        return "qodana";
    }

    @NotNull
    public InspectionApplicationBase getApplication(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (args.size() == 1 && Intrinsics.areEqual((Object)args.get(0), (Object)"--dump-options")) {
            this.dumpOptions();
            System.exit(0);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        try {
            QodanaInspectionApplication qodanaInspectionApplication = this.buildApplication(args);
            if (qodanaInspectionApplication == null) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            return qodanaInspectionApplication;
        }
        catch (QodanaException e) {
            throw new InspectionApplicationException(e.getMessage());
        }
    }

    private final FixesStrategy fixesStrategy(CommandLine $this$fixesStrategy) {
        FixesStrategy fixesStrategy;
        if ($this$fixesStrategy.hasOption("--apply-fixes")) {
            fixesStrategy = FixesStrategy.APPLY;
        } else if ($this$fixesStrategy.hasOption("--cleanup")) {
            fixesStrategy = FixesStrategy.CLEANUP;
        } else if ($this$fixesStrategy.hasOption("--fixes-strategy")) {
            String string = $this$fixesStrategy.getOptionValue("--fixes-strategy");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOptionValue(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            fixesStrategy = FixesStrategy.Companion.fromString(string2);
        } else {
            fixesStrategy = null;
        }
        return fixesStrategy;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final QodanaInspectionApplication buildApplication(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        this.setQodanaOutputLogLevel();
        help = this.buildHelpString();
        commandLine = this.parseArgs(args);
        if (commandLine == null) {
            this.reportError(help);
            return null;
        }
        projectPath = commandLine.getArgs()[0];
        absoluteProjectPath = Paths.get(projectPath, new String[0]).toAbsolutePath();
        outPath = commandLine.getArgs()[1];
        v0 = commandLine.getOptionValue("n");
        if (v0 == null) {
            v0 = profileName = commandLine.getOptionValue("profileName");
        }
        if ((v1 = commandLine.getOptionValue("p")) == null) {
            v1 = commandLine.getOptionValue("profilePath");
        }
        profilePath = v1;
        analyzeChanges = commandLine.hasOption("c") != false || commandLine.hasOption("changes") != false;
        v2 = commandLine.getOptionValue("d");
        if (v2 == null) {
            v2 = commandLine.getOptionValue("source-directory");
        }
        dirToAnalyze = v2;
        var13_11 = QodanaYamlComponent.Companion;
        v3 = Paths.get(projectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"get(...)");
        parentFolder$iv = v3;
        $i$f$load-CmtIpJM = false;
        var12_17 = this_$iv.load-YNEx5aM((Path)parentFolder$iv, Reflection.getOrCreateKotlinClass(QodanaYamlConfig.class));
        if (var12_17 == null) ** GOTO lbl-1000
        parentFolder$iv = var12_17.unbox-impl();
        ResultKt.throwOnFailure((Object)parentFolder$iv);
        this_$iv = (QodanaYamlConfig)parentFolder$iv;
        if (this_$iv != null) {
            v4 = this_$iv;
        } else lbl-1000:
        // 2 sources

        {
            v4 = QodanaYamlConfig.Companion.getEMPTY_V1();
        }
        yamlConfig = v4;
        v5 = commandLine.getOptionValue("run-promo");
        runPromo = v5 != null ? Boolean.parseBoolean(v5) : yamlConfig.getRunPromoInspections();
        disableSanity = commandLine.hasOption("disable-sanity") != false || yamlConfig.getDisableSanityInspections() != false;
        v6 = commandLine.getOptionValue("fail-threshold");
        failThreshold = v6 != null ? Integer.parseInt(v6) : yamlConfig.getFailThreshold();
        v7 = commandLine.getOptionValue("script");
        if (v7 != null) {
            it = v7;
            $i$a$-let-QodanaInspectionApplicationFactory$buildApplication$script$1 = false;
            parsedConfig = QodanaApplicationScriptFactory.parseConfigFromArgument(it);
            if (parsedConfig == null) {
                this.reportError("Can't find script implementation for '" + it + "' value");
                return null;
            }
            v8 = parsedConfig;
        } else {
            v8 = yamlConfig.getScript();
        }
        script = v8;
        includeAbsent = commandLine.hasOption("baseline-include-absent") != false || yamlConfig.getIncludeAbsent() != false;
        Intrinsics.checkNotNull((Object)absoluteProjectPath);
        v9 = Paths.get(outPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"get(...)");
        v10 = commandLine.getOptionValue("baseline");
        v11 = this.fixesStrategy(commandLine);
        if (v11 == null) {
            v12 = yamlConfig.getFixesStrategy().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            v11 = FixesStrategy.Companion.fromString(v12);
        }
        qodanaConfig = QodanaConfig.Companion.fromYaml$default(QodanaConfig.Companion, absoluteProjectPath, v9, yamlConfig, null, v10, null, null, failThreshold, disableSanity, v11, runPromo, script, includeAbsent, null, null, null, null, dirToAnalyze, analyzeChanges, null, null, null, 3793000, null);
        $this$buildApplication_u24lambda_u242 = var18_25 = new QodanaInspectionApplication(help, qodanaConfig);
        $i$a$-apply-QodanaInspectionApplicationFactory$buildApplication$1 = false;
        $this$buildApplication_u24lambda_u242.myProjectPath = absoluteProjectPath.toString();
        $this$buildApplication_u24lambda_u242.myOutPath = outPath;
        $this$buildApplication_u24lambda_u242.myProfileName = profileName;
        $this$buildApplication_u24lambda_u242.myProfilePath = profilePath;
        return var18_25;
    }

    private final String buildHelpString() {
        StringWriter sw = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        Comparator comparator2 = formatter.getOptionComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"getOptionComparator(...)");
        formatter.setOptionComparator(this.deprecatedLast(comparator2));
        formatter.printHelp(new PrintWriter(sw), formatter.getWidth(), QodanaBundle.message("usage.help.description", new Object[0]), "", this.options, formatter.getLeftPadding(), formatter.getDescPadding(), "");
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpOptions() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Qodana linter options:");
        Comparator comparator2 = formatter.getOptionComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"getOptionComparator(...)");
        formatter.setOptionComparator(this.deprecatedLast(comparator2));
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        Closeable closeable = printStream;
        Object object = Charsets.UTF_8;
        closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        object = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            formatter.printHelp(new PrintWriter(writer), formatter.getWidth(), " ", "", this.options, formatter.getLeftPadding(), formatter.getDescPadding(), "");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private final CommandLine parseArgs(List<String> args) {
        try {
            Collection $this$toTypedArray$iv = args;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CommandLine commandLine = new DefaultParser().parse(this.options, thisCollection$iv.toArray(new String[0]), true);
            if (commandLine.getArgList().size() != 2) {
                throw new QodanaException("Arguments should contain only PROJECT_PATH and RESULTS_PATH. Arguments: " + commandLine.getArgList());
            }
            return commandLine;
        }
        catch (ParseException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new QodanaException(string);
        }
    }

    private final void reportError(String message) {
        System.err.println(message);
    }

    private final Comparator<Option> deprecatedLast(Comparator<Option> comparator2) {
        return Comparator.comparing(deprecatedLast.1.INSTANCE).thenComparing(comparator2);
    }

    private final void setQodanaOutputLogLevel() {
        Object object;
        java.util.logging.Logger rootLogger;
        block6: {
            block5: {
                Level level;
                rootLogger = java.util.logging.Logger.getLogger("");
                object = System.getenv("QODANA_OUTPUT_LOG_LEVEL");
                if (object == null) break block5;
                String it = object;
                boolean bl = false;
                try {
                    level = Level.parse(it);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Can't parse log level " + it);
                    level = null;
                }
                Level level2 = level;
                object = level2;
                if (level2 != null) break block6;
            }
            object = Level.SEVERE;
        }
        Object level = object;
        Handler[] handlerArray = rootLogger.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"getHandlers(...)");
        for (Handler h : handlerArray) {
            if (!(h instanceof ConsoleHandler)) continue;
            ((ConsoleHandler)h).setLevel((Level)level);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(QodanaInspectionApplicationFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplicationFactory$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

