/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.ext;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.DefaultTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.FileTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.PropertyTransform;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyUtil {
    public static final Logger LOG = Logger.getInstance(PropertyUtil.class);
    @NonNls
    public static final String FILE_METHOD_NAME = "file";
    @NonNls
    public static final String FILE_CONSTRUCTOR_NAME = "File";
    @NotNull
    public static final PropertyTransform DEFAULT_TRANSFORM = new DefaultTransform();
    @NotNull
    public static final PropertyTransform FILE_TRANSFORM = new FileTransform();

    @NotNull
    public static GradleDslSimpleExpression createOrReplaceBasicExpression(@NotNull GradleDslElement parent, @Nullable GradleDslElement oldElement, @NotNull Object value, @NotNull GradleNameElement name2, @Nullable ModelPropertyDescription propertyDescription) {
        if (parent == null) {
            PropertyUtil.$$$reportNull$$$0(0);
        }
        if (value == null) {
            PropertyUtil.$$$reportNull$$$0(1);
        }
        if (name2 == null) {
            PropertyUtil.$$$reportNull$$$0(2);
        }
        ModelEffectDescription effect = null;
        if (oldElement instanceof GradleDslLiteral) {
            GradleDslSimpleExpression expression = (GradleDslSimpleExpression)oldElement;
            expression.setValue(value);
            GradleDslSimpleExpression gradleDslSimpleExpression = expression;
            if (gradleDslSimpleExpression == null) {
                PropertyUtil.$$$reportNull$$$0(3);
            }
            return gradleDslSimpleExpression;
        }
        if (oldElement != null) {
            name2 = oldElement.getNameElement();
            effect = oldElement.getModelEffect();
        } else if (propertyDescription != null) {
            effect = new ModelEffectDescription(propertyDescription, ModelSemanticsDescription.CREATE_WITH_VALUE);
        }
        GradleDslSimpleExpression expression = PropertyUtil.createBasicExpression(parent, value, name2);
        expression.setModelEffect(effect);
        GradleDslSimpleExpression gradleDslSimpleExpression = expression;
        if (gradleDslSimpleExpression == null) {
            PropertyUtil.$$$reportNull$$$0(4);
        }
        return gradleDslSimpleExpression;
    }

    @NotNull
    public static GradleDslSimpleExpression createBasicExpression(@NotNull GradleDslElement parent, @NotNull Object value, @NotNull GradleNameElement name2) {
        if (parent == null) {
            PropertyUtil.$$$reportNull$$$0(5);
        }
        if (value == null) {
            PropertyUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            PropertyUtil.$$$reportNull$$$0(7);
        }
        GradleDslLiteral newElement = new GradleDslLiteral(parent, name2);
        ((GradleDslSimpleExpression)newElement).setValue(value);
        GradleDslLiteral gradleDslLiteral = newElement;
        if (gradleDslLiteral == null) {
            PropertyUtil.$$$reportNull$$$0(8);
        }
        return gradleDslLiteral;
    }

    public static void replaceElement(@NotNull GradleDslElement holder, @Nullable GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (holder == null) {
            PropertyUtil.$$$reportNull$$$0(9);
        }
        if (newElement == null) {
            PropertyUtil.$$$reportNull$$$0(10);
        }
        if (holder instanceof GradlePropertiesDslElement) {
            if (oldElement != null) {
                ((GradlePropertiesDslElement)holder).replaceElement(oldElement, newElement);
            } else {
                ((GradlePropertiesDslElement)holder).setNewElement(newElement);
            }
        } else if (holder instanceof GradleDslMethodCall) {
            if (!(newElement instanceof GradleDslExpression)) {
                LOG.warn((Throwable)new IllegalArgumentException("not an expression (new): " + newElement));
                return;
            }
            GradleDslMethodCall methodCall = (GradleDslMethodCall)holder;
            if (oldElement != null) {
                if (!(oldElement instanceof GradleDslExpression)) {
                    LOG.warn((Throwable)new IllegalArgumentException("not an expression (old): " + oldElement));
                    return;
                }
                methodCall.replaceArgument((GradleDslExpression)oldElement, (GradleDslExpression)newElement);
            } else {
                methodCall.addNewArgument((GradleDslExpression)newElement);
            }
        } else {
            LOG.warn((Throwable)new IllegalStateException("Property holder has unknown type, " + holder));
        }
    }

    public static void removeElement(@NotNull GradleDslElement element) {
        GradleDslElement holder;
        if (element == null) {
            PropertyUtil.$$$reportNull$$$0(11);
        }
        if ((holder = element.getParent()) == null) {
            return;
        }
        if (holder instanceof GradlePropertiesDslElement) {
            ((GradlePropertiesDslElement)holder).removeProperty(element);
        } else if (holder instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)holder;
            if (element == methodCall.getArgumentsElement()) {
                PropertyUtil.removeElement(methodCall);
            }
            methodCall.remove(element);
        } else {
            LOG.warn((Throwable)new IllegalStateException("Property holder has unknown type, " + holder));
        }
    }

    @NotNull
    public static GradlePropertyModelImpl resolveModel(@NotNull GradlePropertyModelImpl model) {
        if (model == null) {
            PropertyUtil.$$$reportNull$$$0(12);
        }
        HashSet<String> seenModels = new HashSet<String>();
        while (model.getValueType() == GradlePropertyModel.ValueType.REFERENCE && !seenModels.contains(model.getFullyQualifiedName())) {
            if (model.getDependencies().isEmpty()) {
                GradlePropertyModelImpl gradlePropertyModelImpl = model;
                if (gradlePropertyModelImpl == null) {
                    PropertyUtil.$$$reportNull$$$0(13);
                }
                return gradlePropertyModelImpl;
            }
            seenModels.add(model.getFullyQualifiedName());
            model = model.dependencies().get(0);
        }
        GradlePropertyModelImpl gradlePropertyModelImpl = model;
        if (gradlePropertyModelImpl == null) {
            PropertyUtil.$$$reportNull$$$0(14);
        }
        return gradlePropertyModelImpl;
    }

    @NotNull
    public static GradleDslSimpleExpression resolveElement(@NotNull GradleDslSimpleExpression expression) {
        if (expression == null) {
            PropertyUtil.$$$reportNull$$$0(15);
        }
        while (expression instanceof GradleDslLiteral && expression.isReference() && !expression.hasCycle()) {
            GradleReferenceInjection injection = ((GradleDslLiteral)expression).getReferenceInjection();
            if (injection == null) {
                GradleDslSimpleExpression gradleDslSimpleExpression = expression;
                if (gradleDslSimpleExpression == null) {
                    PropertyUtil.$$$reportNull$$$0(16);
                }
                return gradleDslSimpleExpression;
            }
            GradleDslSimpleExpression next = injection.getToBeInjectedExpression();
            if (next == null) {
                GradleDslSimpleExpression gradleDslSimpleExpression = expression;
                if (gradleDslSimpleExpression == null) {
                    PropertyUtil.$$$reportNull$$$0(17);
                }
                return gradleDslSimpleExpression;
            }
            expression = next;
        }
        GradleDslSimpleExpression gradleDslSimpleExpression = expression;
        if (gradleDslSimpleExpression == null) {
            PropertyUtil.$$$reportNull$$$0(18);
        }
        return gradleDslSimpleExpression;
    }

    @Nullable
    public static GradleDslElement followElement(@NotNull GradleDslElement expression) {
        if (expression == null) {
            PropertyUtil.$$$reportNull$$$0(19);
        }
        GradleDslElement element = expression;
        HashSet<GradleDslElement> seen = new HashSet<GradleDslElement>();
        while (element instanceof GradleDslLiteral && ((GradleDslLiteral)element).isReference() && !((GradleDslLiteral)element).hasCycle()) {
            seen.add(element);
            GradleReferenceInjection injection = ((GradleDslLiteral)element).getReferenceInjection();
            if (injection == null) {
                return null;
            }
            GradleDslElement next = injection.getToBeInjected();
            if (next == null || seen.contains(next)) {
                return null;
            }
            element = next;
        }
        return element;
    }

    @Nullable
    public static String getFileValue(@NotNull GradleDslMethodCall methodCall) {
        if (methodCall == null) {
            PropertyUtil.$$$reportNull$$$0(20);
        }
        if (!(methodCall.getMethodName().equals(FILE_METHOD_NAME) && !methodCall.isConstructor() || methodCall.getMethodName().equals(FILE_CONSTRUCTOR_NAME) && methodCall.isConstructor())) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (GradleDslExpression expression : methodCall.getArguments()) {
            String value;
            if (!(expression instanceof GradleDslSimpleExpression) || (value = ((GradleDslSimpleExpression)expression).getValue(String.class)) == null) continue;
            if (builder.length() != 0) {
                builder.append("/");
            }
            builder.append(value);
        }
        String result = builder.toString();
        return result.isEmpty() ? null : result;
    }

    public static boolean isNonExpressionPropertiesElement(@Nullable GradleDslElement e) {
        return e instanceof GradlePropertiesDslElement && !(e instanceof GradleDslExpression);
    }

    public static boolean isPropertiesElementOrMap(@Nullable GradleDslElement e) {
        return e instanceof GradlePropertiesDslElement && !(e instanceof GradleDslExpressionList);
    }

    public static boolean isElementModified(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            PropertyUtil.$$$reportNull$$$0(21);
        }
        if (newElement == null) {
            PropertyUtil.$$$reportNull$$$0(22);
        }
        return PropertyUtil.checkForModifiedValue(oldElement, newElement) || PropertyUtil.checkForModifiedName(oldElement, newElement);
    }

    static boolean isModelElementModified(@NotNull GradleDslElement oldRawElement, @NotNull GradleDslElement newRawElement, @NotNull GradleDslElement oldTransformedElement, @NotNull GradleDslElement newTransformedElement) {
        if (oldRawElement == null) {
            PropertyUtil.$$$reportNull$$$0(23);
        }
        if (newRawElement == null) {
            PropertyUtil.$$$reportNull$$$0(24);
        }
        if (oldTransformedElement == null) {
            PropertyUtil.$$$reportNull$$$0(25);
        }
        if (newTransformedElement == null) {
            PropertyUtil.$$$reportNull$$$0(26);
        }
        return PropertyUtil.checkForModifiedValue(oldTransformedElement, newTransformedElement) || PropertyUtil.checkForModifiedName(oldRawElement, newRawElement);
    }

    @Nullable
    public static GradleDslElement findOriginalElement(@NotNull GradleDslElement parent, @NotNull GradleDslElement element) {
        GradlePropertiesDslElement holder;
        if (parent == null) {
            PropertyUtil.$$$reportNull$$$0(27);
        }
        if (element == null) {
            PropertyUtil.$$$reportNull$$$0(28);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = holder = parent instanceof GradleDslMethodCall ? ((GradleDslMethodCall)parent).getArgumentsElement() : (GradlePropertiesDslElement)parent;
        if (holder instanceof GradleDslExpressionList || holder instanceof GradleDslElementList) {
            List<GradleDslElement> originalElements = holder.getOriginalElements();
            List<GradleDslElement> elements = holder.getAllPropertyElements();
            int index = elements.indexOf(element);
            return originalElements.contains(element) ? element : (index >= 0 && originalElements.size() > index ? originalElements.get(index) : null);
        }
        return holder.getOriginalElementForNameAndType(element.getName(), element.getElementType());
    }

    public static boolean isFakeElementModified(@NotNull FakeElement element) {
        GradleDslElement realExpression;
        GradleDslElement realParent;
        if (element == null) {
            PropertyUtil.$$$reportNull$$$0(29);
        }
        GradleDslElement oldRealExpression = (realParent = (realExpression = element.getRealExpression()).getParent()) == null ? null : PropertyUtil.findOriginalElement(realParent, realExpression);
        return oldRealExpression == null || PropertyUtil.isElementModified(oldRealExpression, realExpression);
    }

    private static boolean checkForModifiedValue(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (oldElement == null) {
            PropertyUtil.$$$reportNull$$$0(30);
        }
        if (newElement == null) {
            PropertyUtil.$$$reportNull$$$0(31);
        }
        if (!oldElement.getClass().equals(newElement.getClass())) {
            return true;
        }
        if (oldElement instanceof GradleDslSettableExpression) {
            GradleDslSettableExpression oExpression = (GradleDslSettableExpression)oldElement;
            GradleDslSettableExpression nExpression = (GradleDslSettableExpression)newElement;
            String newText = null;
            String oldText = null;
            if (nExpression.getUnsavedValue() != null) {
                newText = nExpression.getUnsavedValue().getText();
            } else if (nExpression.getExpression() != null) {
                newText = nExpression.getExpression().getText();
            }
            if (oExpression.getExpression() != null) {
                oldText = oExpression.getExpression().getText();
            } else if (oExpression.getUnsavedValue() != null) {
                oldText = oExpression.getUnsavedValue().getText();
            }
            return (newText != null || oldText != null) && !Objects.equals(newText, oldText);
        }
        if (oldElement instanceof GradlePropertiesDslElement) {
            GradlePropertiesDslElement oListOrMap = (GradlePropertiesDslElement)oldElement;
            GradlePropertiesDslElement nListOrMap = (GradlePropertiesDslElement)newElement;
            List<GradleDslElement> originalElements = oListOrMap.getOriginalElements();
            List<GradleDslElement> newElements = nListOrMap.getCurrentElements();
            if (originalElements.size() != newElements.size()) {
                return true;
            }
            BiFunction<GradleDslElement, GradleDslElement, Boolean> func = oldElement instanceof GradleDslExpressionList ? PropertyUtil::checkForModifiedValue : PropertyUtil::isElementModified;
            for (int i = 0; i < originalElements.size(); ++i) {
                if (!func.apply(originalElements.get(i), newElements.get(i)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (oldElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall oMethodCall = (GradleDslMethodCall)oldElement;
            GradleDslMethodCall nMethodCall = (GradleDslMethodCall)newElement;
            if (!oMethodCall.getMethodName().equals(nMethodCall.getMethodName())) {
                return false;
            }
            return PropertyUtil.checkForModifiedValue(oMethodCall.getArgumentsElement(), nMethodCall.getArgumentsElement());
        }
        PsiElement oldPsi = oldElement.getPsiElement();
        PsiElement newPsi = newElement.getPsiElement();
        return oldPsi == null || newPsi == null || !Objects.equals(oldPsi.getText(), newPsi.getText());
    }

    private static boolean checkForModifiedName(@NotNull GradleDslElement originalElement, @NotNull GradleDslElement newElement) {
        if (originalElement == null) {
            PropertyUtil.$$$reportNull$$$0(32);
        }
        if (newElement == null) {
            PropertyUtil.$$$reportNull$$$0(33);
        }
        ModelEffectDescription oEffect = originalElement.getModelEffect();
        ModelEffectDescription nEffect = newElement.getModelEffect();
        if (oEffect != null && nEffect != null && Objects.equals(oEffect.property, nEffect.property)) {
            return false;
        }
        GradleNameElement oNameElement = originalElement.getNameElement();
        String oldName = oNameElement.getOriginalName();
        if (oldName == null) {
            return false;
        }
        GradleNameElement nNameElement = newElement.getNameElement();
        String newName = nNameElement.getLocalName();
        if (newName == null) {
            return false;
        }
        return !Objects.equals(GradleNameElement.convertNameToKey(newName), GradleNameElement.convertNameToKey(oldName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 13, 14, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ext/PropertyUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 10: 
            case 22: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 11: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRawElement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRawElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldTransformedElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTransformedElement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ext/PropertyUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrReplaceBasicExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createBasicExpression";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModel";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createOrReplaceBasicExpression";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBasicExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "followElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isElementModified";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isModelElementModified";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isFakeElementModified";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkForModifiedValue";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkForModifiedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 13, 14, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

