/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertSchemaPrefixToDefaultIntention
extends PsiElementBaseIntentionAction {
    public ConvertSchemaPrefixToDefaultIntention() {
        this.setText(XmlBundle.message("xml.intention.reset.to.default.namespace.name", new Object[0]));
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlAttribute xmlns;
        if (project2 == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(1);
        }
        if ((xmlns = ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element)) == null) {
            return;
        }
        SchemaPrefixReference prefixRef = null;
        for (PsiReference ref : xmlns.getReferences()) {
            if (!(ref instanceof SchemaPrefixReference)) continue;
            prefixRef = (SchemaPrefixReference)ref;
            break;
        }
        if (prefixRef == null) {
            return;
        }
        final SchemaPrefix prefix = prefixRef.resolve();
        final String ns = prefixRef.getNamespacePrefix();
        final ArrayList tags = new ArrayList();
        final ArrayList attrs = new ArrayList();
        xmlns.getParent().accept(new XmlRecursiveElementVisitor(){

            @Override
            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ns.equals(tag.getNamespacePrefix())) {
                    tags.add(tag);
                }
                super.visitXmlTag(tag);
            }

            @Override
            public void visitXmlAttributeValue(@NotNull XmlAttributeValue value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (value2.getValue().startsWith(ns + ":")) {
                    for (PsiReference ref : value2.getReferences()) {
                        if (!(ref instanceof SchemaPrefixReference) || !ref.isReferenceTo((PsiElement)prefix)) continue;
                        attrs.add((XmlAttribute)value2.getParent());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttributeValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{xmlns.getContainingFile()})) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            ConvertSchemaPrefixToDefaultIntention.convertTagsAndAttributes(ns, tags, attrs, project2);
            ApplicationManager.getApplication().runWriteAction(() -> xmlns.setName("xmlns"));
        }, XmlBundle.message("xml.intention.reset.to.default.namespace.command", new Object[0]), null);
        WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{xmlns.getContainingFile()}).withName(XmlBundle.message("xml.intention.reset.to.default.namespace.command", new Object[0])).run(() -> xmlns.setName("xmlns"));
    }

    private static void convertTagsAndAttributes(String ns, final List<? extends XmlTag> tags, final List<? extends XmlAttribute> attrs, Project project2) {
        final int localNameIndex = ns.length() + 1;
        final int totalCount = tags.size() + attrs.size();
        final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, XmlBundle.message("xml.progress.changing.to.default.namespace", new Object[0]), true);
        progressTask.setTask(new SequentialTask(){
            int tagIndex = 0;
            int attrIndex = 0;

            public boolean isDone() {
                return this.tagIndex + this.attrIndex >= totalCount;
            }

            public boolean iteration() {
                progressTask.getIndicator().setFraction((double)(this.tagIndex + this.attrIndex) / (double)totalCount);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (this.tagIndex < tags.size()) {
                        XmlTag tag;
                        String s;
                        if (!(s = (tag = (XmlTag)tags.get(this.tagIndex++)).getName().substring(localNameIndex)).isEmpty()) {
                            tag.setName(s);
                        }
                    } else if (this.attrIndex < attrs.size()) {
                        XmlAttribute attr = (XmlAttribute)attrs.get(this.attrIndex++);
                        attr.setValue(attr.getValue().substring(localNameIndex));
                    }
                });
                return this.isDone();
            }
        });
        ProgressManager.getInstance().run((Task)progressTask);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(3);
        }
        return ConvertSchemaPrefixToDefaultIntention.getXmlnsDeclaration(element) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = this.getText();
        if (string2 == null) {
            ConvertSchemaPrefixToDefaultIntention.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlElement)) {
            return null;
        }
        for (PsiReference ref : parent.getReferences()) {
            PsiElement tag;
            PsiElement attr;
            PsiElement elem;
            if (!(ref instanceof SchemaPrefixReference) || (elem = ref.resolve()) == null || !((attr = elem.getParent()) instanceof XmlAttribute) || !((tag = attr.getParent()) instanceof XmlTag) || ((XmlTag)tag).getAttribute("xmlns") != null) continue;
            return (XmlAttribute)attr;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/ConvertSchemaPrefixToDefaultIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4 -> new IllegalStateException(string2);
        };
    }
}

