/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.util;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.util.UriUtilKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0013\u0010\u0011\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00122\u0006\u0010\u0005\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/collaboration/util/URIUtil;", "", "()V", "addHttpsSchemaIfMissing", "", "uri", "createUriWithCustomScheme", "Ljava/net/URI;", "scheme", "equalWithoutSchema", "", "first", "second", "isValidHttpUri", "normalizeAndValidateHttpUri", "removeProtocolPrefix", "url", "toStringWithoutScheme", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nURIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URIUtil.kt\ncom/intellij/collaboration/util/URIUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class URIUtil {
    @NotNull
    public static final URIUtil INSTANCE = new URIUtil();

    private URIUtil() {
    }

    @NotNull
    public final String normalizeAndValidateHttpUri(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String normalized = StringsKt.removeSuffix((String)this.addHttpsSchemaIfMissing(uri), (CharSequence)"/");
        if (!StringsKt.startsWith$default((String)normalized, (String)"http", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string2 = CollaborationToolsBundle.message("login.server.invalid", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = string2;
            throw new IllegalArgumentException(string3.toString());
        }
        URI.create(normalized);
        return normalized;
    }

    private final String addHttpsSchemaIfMissing(String uri) {
        if (StringsKt.contains$default((CharSequence)uri, (CharSequence)"://", (boolean)false, (int)2, null)) {
            return uri;
        }
        return "https://" + uri;
    }

    public final boolean isValidHttpUri(@NotNull String uri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (StringsKt.isBlank((CharSequence)uri)) {
            return false;
        }
        try {
            this.normalizeAndValidateHttpUri(uri);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final boolean equalWithoutSchema(@NotNull URI first, @NotNull URI second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String stubScheme = "stub";
        return Intrinsics.areEqual((Object)UriUtilKt.withScheme((URI)first, (String)stubScheme), (Object)UriUtilKt.withScheme((URI)second, (String)stubScheme));
    }

    @NotNull
    public final String toStringWithoutScheme(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String schemeText = uri.getScheme() + "://";
        String string2 = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return StringsKt.removePrefix((String)string2, (CharSequence)schemeText);
    }

    @NotNull
    public final URI createUriWithCustomScheme(@NotNull String uri, @NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        String prefix = scheme + "://";
        if (StringsKt.startsWith$default((String)uri, (String)prefix, (boolean)false, (int)2, null)) {
            return new URI(uri);
        }
        return new URI(prefix + this.removeProtocolPrefix(uri));
    }

    private final String removeProtocolPrefix(String url) {
        String string2;
        int index = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string3 = url.substring(index + 3);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string2 = url;
        }
        return string2;
    }
}

