/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushDialogActionsProvider;
import com.intellij.dvcs.push.PushDialogCustomizer;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.SimplePushAction;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper
implements VcsPushUi,
DataProvider {
    @NonNls
    private static final String DIMENSION_KEY = "Vcs.Push.Dialog.v2";
    @NonNls
    private static final String HELP_ID = "Vcs.Push.Dialog";
    private static final Logger LOG = Logger.getInstance(VcsPushDialog.class);
    private static final ExtensionPointName<PushDialogCustomizer> PUSH_DIALOG_CUSTOMIZER_EP = ExtensionPointName.create((String)"com.intellij.pushDialogCustomizer");
    private static final ExtensionPointName<PushDialogActionsProvider> PUSH_DIALOG_ACTIONS_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.pushDialogActionsProvider");
    private static final int CENTER_PANEL_HEIGHT = 450;
    private static final int CENTER_PANEL_WIDTH = 800;
    protected final Project myProject;
    protected final PushController myController;
    private final Map<PushSupport<?, ?, ?>, VcsPushOptionsPanel> myAdditionalPanels;
    private final PushLog myListPanel;
    private final JComponent myTopPanel;
    private final ComplexPushAction myMainAction;
    @NotNull
    private final List<ActionWrapper> myPushActions;

    public VcsPushDialog(@NotNull Project project2, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project2 == null) {
            VcsPushDialog.$$$reportNull$$$0(0);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(1);
        }
        this(project2, VcsRepositoryManager.getInstance(project2).getRepositories(), selectedRepositories, currentRepo, null);
    }

    public VcsPushDialog(@NotNull Project project2, @NotNull Collection<? extends Repository> allRepos, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo, @Nullable PushSource pushSource) {
        if (project2 == null) {
            VcsPushDialog.$$$reportNull$$$0(2);
        }
        if (allRepos == null) {
            VcsPushDialog.$$$reportNull$$$0(3);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(4);
        }
        super(project2, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myProject = project2;
        this.myController = new PushController(project2, this, allRepos, selectedRepositories, currentRepo, pushSource);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        this.myTopPanel = this.myController.createTopPanel();
        this.myPushActions = this.collectPushActions();
        this.myMainAction = new ComplexPushAction(this.myPushActions.get(0), this.myPushActions.subList(1, this.myPushActions.size()));
        this.myMainAction.putValue("DefaultAction", Boolean.TRUE);
        this.init();
        this.updateOkActions();
        this.setOKButtonText(DvcsBundle.message("action.push", new Object[0]));
        String title2 = allRepos.size() == 1 ? DvcsBundle.message("push.dialog.push.commits.to.title", DvcsUtil.getShortRepositoryName((Repository)ContainerUtil.getFirstItem(allRepos))) : DvcsBundle.message("push.dialog.push.commits.title", new Object[0]);
        this.setTitle(title2);
    }

    @NotNull
    private List<ActionWrapper> collectPushActions() {
        ActionGroup group2 = (ActionGroup)ActionManager.getInstance().getAction("Vcs.Push.Actions");
        ArrayList<PushActionBase> pushActions = new ArrayList<PushActionBase>(ContainerUtil.findAll((Object[])group2.getChildren(null), PushActionBase.class));
        this.customizeDialog((SimplePushAction)((Object)ContainerUtil.findInstance(pushActions, SimplePushAction.class)));
        List actionProviders = PUSH_DIALOG_ACTIONS_PROVIDER_EP.getExtensionList();
        for (PushDialogActionsProvider actionProvider : ContainerUtil.reverse((List)actionProviders)) {
            pushActions.addAll(0, actionProvider.getCustomActionsAboveDefault(this.myProject));
        }
        int firstEnabledActionPosition = ContainerUtil.indexOf(pushActions, it -> it.isEnabled(this));
        if (firstEnabledActionPosition >= 0) {
            PushActionBase firstEnabledAction = (PushActionBase)((Object)pushActions.remove(firstEnabledActionPosition));
            pushActions.add(0, firstEnabledAction);
        }
        List list2 = ContainerUtil.map(pushActions, action2 -> new ActionWrapper(this.myProject, this, (PushActionBase)((Object)action2)));
        if (list2 == null) {
            VcsPushDialog.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void customizeDialog(@NotNull SimplePushAction simplePushAction) {
        List customizers;
        if (simplePushAction == null) {
            VcsPushDialog.$$$reportNull$$$0(6);
        }
        if (!(customizers = PUSH_DIALOG_CUSTOMIZER_EP.getExtensionList()).isEmpty()) {
            if (customizers.size() == 1) {
                PushDialogCustomizer customizer = (PushDialogCustomizer)customizers.get(0);
                this.customizeDialog(customizer, simplePushAction);
            } else {
                LOG.warn("There can be only one push actions customizer, found: " + customizers);
            }
        }
    }

    private void customizeDialog(@NotNull PushDialogCustomizer customizer, @NotNull SimplePushAction simplePushAction) {
        if (customizer == null) {
            VcsPushDialog.$$$reportNull$$$0(7);
        }
        if (simplePushAction == null) {
            VcsPushDialog.$$$reportNull$$$0(8);
        }
        simplePushAction.getTemplatePresentation().setText(customizer.getNameForSimplePushAction(this));
        simplePushAction.setCondition(customizer.getCondition());
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return this.createSouthOptionsPanel();
    }

    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        southPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return southPanel;
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel().addToTop((Component)this.myTopPanel).addToCenter((Component)this.myListPanel).addToBottom((Component)this.createOptionsPanel());
        this.myListPanel.setPreferredSize((Dimension)new JBDimension(800, 450));
        return panel2;
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)2));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            if (panel2.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.DEFAULT) continue;
            ((Container)optionsPanel).add(panel2);
        }
        OptionsPanel optionsPanel2 = optionsPanel;
        if (optionsPanel2 == null) {
            VcsPushDialog.$$$reportNull$$$0(9);
        }
        return optionsPanel2;
    }

    @NotNull
    private JPanel createSouthOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 20 0 0, flowx, gapx 16"));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            if (panel2.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.SOUTH) continue;
            optionsPanel.add(panel2);
        }
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            VcsPushDialog.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions2 = new ArrayList<Action>();
        actions2.add(this.myMainAction);
        actions2.add(this.getCancelAction());
        actions2.add(this.getHelpAction());
        Action[] actionArray = actions2.toArray(new Action[0]);
        if (actionArray == null) {
            VcsPushDialog.$$$reportNull$$$0(11);
        }
        return actionArray;
    }

    @Override
    public boolean canPush() {
        return this.myController.isPushAllowed();
    }

    @Override
    public boolean hasWarnings() {
        return this.myController.hasCommitWarnings();
    }

    @Override
    @NotNull
    public Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> getSelectedPushSpecs() {
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> map2 = this.myController.getSelectedPushSpecs();
        if (map2 == null) {
            VcsPushDialog.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        ComplexPushAction complexPushAction = this.myMainAction;
        if (complexPushAction == null) {
            VcsPushDialog.$$$reportNull$$$0(13);
        }
        return complexPushAction;
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void push(boolean bl) {
        void forcePush;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.executeAfterRunningPrePushHandlers(new Task.Backgroundable(this.myProject, DvcsBundle.message("push.process.pushing", new Object[0]), true, (boolean)forcePush){
            final /* synthetic */ boolean val$forcePush;
            {
                this.val$forcePush = bl;
                super(arg0, arg1, arg2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsPushDialog.this.myController.push(this.val$forcePush);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/ui/VcsPushDialog$1", "run"));
            }
        });
    }

    @Override
    @RequiresEdt
    public void executeAfterRunningPrePushHandlers(@NotNull Task.Backgroundable activity2) {
        if (activity2 == null) {
            VcsPushDialog.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PrePushHandler.Result result2 = this.runPrePushHandlersInModalTask();
        if (result2 == PrePushHandler.Result.OK) {
            activity2.queue();
            this.close(0);
        } else if (result2 == PrePushHandler.Result.ABORT_AND_CLOSE) {
            this.doCancelAction();
        } else if (result2 == PrePushHandler.Result.ABORT) {
            // empty if block
        }
    }

    @RequiresEdt
    public PrePushHandler.Result runPrePushHandlersInModalTask() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result2 = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), DvcsBundle.message("push.process.checking.commits", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                result2.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (error instanceof PushController.HandlerException) {
                    String suggestionMessageProblem;
                    PushController.HandlerException handlerException = (PushController.HandlerException)error;
                    Throwable cause = handlerException.getCause();
                    String failedHandler = handlerException.getFailedHandlerName();
                    List<String> skippedHandlers = handlerException.getSkippedHandlers();
                    if (cause instanceof ProcessCanceledException) {
                        suggestionMessageProblem = DvcsBundle.message("push.dialog.push.cancelled.message", failedHandler);
                    } else {
                        super.onThrowable(cause);
                        suggestionMessageProblem = DvcsBundle.message("push.dialog.push.failed.message", failedHandler);
                    }
                    @Nls String suggestionMessageQuestion = skippedHandlers.isEmpty() ? DvcsBundle.message("push.dialog.push.anyway.confirmation", new Object[0]) : DvcsBundle.message("push.dialog.skip.all.remaining.steps.confirmation", new Object[0]);
                    this.suggestToSkipOrPush(suggestionMessageProblem + "\n" + suggestionMessageQuestion);
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush(DvcsBundle.message("push.dialog.skip.all.steps.confirmation", new Object[0]));
            }

            private void suggestToSkipOrPush(@Nls @NotNull String message2) {
                if (message2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)DvcsBundle.message("action.push", new Object[0]), (String)DvcsBundle.message("action.push.anyway", new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                    result2.set(PrePushHandler.Result.OK);
                } else {
                    result2.set(PrePushHandler.Result.ABORT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestToSkipOrPush";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
        return result2.get();
    }

    public void updateOkActions() {
        this.myMainAction.update();
        for (ActionWrapper wrapper : this.myPushActions) {
            wrapper.update();
        }
    }

    public void enableOkActions(boolean value2) {
        this.myMainAction.setEnabled(value2);
    }

    @Override
    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel2;
        if (support == null) {
            VcsPushDialog.$$$reportNull$$$0(15);
        }
        return (panel2 = this.myAdditionalPanels.get(support)) == null ? null : panel2.getValue();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsPushDialog.$$$reportNull$$$0(16);
        }
        if (VcsPushUi.VCS_PUSH_DIALOG.is(dataId)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepositories";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepos";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simplePushAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPushActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthOptionsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPushSpecs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizeDialog";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeAfterRunningPrePushHandlers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptionValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 9, 10, 11, 12, 13 -> new IllegalStateException(string2);
        };
    }

    private static final class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final ActionWrapper myDefaultAction;
        private final List<? extends ActionWrapper> myOptions;

        private ComplexPushAction(@NotNull ActionWrapper defaultAction, @NotNull List<? extends ActionWrapper> additionalActions) {
            if (defaultAction == null) {
                ComplexPushAction.$$$reportNull$$$0(0);
            }
            if (additionalActions == null) {
                ComplexPushAction.$$$reportNull$$$0(1);
            }
            super(defaultAction.getName());
            this.myDefaultAction = defaultAction;
            this.myOptions = additionalActions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDefaultAction.actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action action2 : this.myOptions) {
                action2.setEnabled(isEnabled);
            }
        }

        public void update() {
            VcsPushUi dialog = this.myDefaultAction.myDialog;
            PushActionBase realAction = this.myDefaultAction.myRealAction;
            this.setEnabled(dialog.canPush());
            this.putValue("Name", realAction.getText(dialog, this.enabled));
            this.putValue("ShortDescription", realAction.getDescription(dialog, this.enabled));
        }

        public Action @NotNull [] getOptions() {
            Action[] actionArray = this.myOptions.toArray(new ActionWrapper[0]);
            if (actionArray == null) {
                ComplexPushAction.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalActions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ActionWrapper
    extends AbstractAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsPushUi myDialog;
        @NotNull
        private final PushActionBase myRealAction;

        ActionWrapper(@NotNull Project project2, @NotNull VcsPushUi dialog, @NotNull PushActionBase realAction) {
            if (project2 == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (dialog == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            if (realAction == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            this.myProject = project2;
            this.myDialog = dialog;
            this.myRealAction = realAction;
            this.putValue("Name", this.myRealAction.getText(this.myDialog, true));
            this.putValue("AnAction", (Object)realAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.actionPerformed(this.myProject, this.myDialog);
        }

        public void update() {
            boolean enabled = this.myRealAction.isEnabled(this.myDialog);
            this.setEnabled(enabled);
            this.putValue("Name", this.myRealAction.getText(this.myDialog, enabled));
            this.putValue("ShortDescription", this.myRealAction.getDescription(this.myDialog, enabled));
        }

        @Nls
        @NotNull
        public String getName() {
            String string2 = Objects.requireNonNull(this.myRealAction.getTemplatePresentation().getTextWithMnemonic());
            if (string2 == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }

    private static class OptionsPanel
    extends JPanel {
        OptionsPanel() {
            super((LayoutManager)new MigLayout("ins 0 0, flowy"));
        }

        @Override
        public Component add(Component comp) {
            BorderLayoutPanel wrapperPanel = new BorderLayoutPanel().addToCenter(comp);
            wrapperPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)15, (int)0, (int)0));
            return super.add((Component)wrapperPanel);
        }
    }
}

