/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.revisions.CurrentRevision;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class Revision {
    @NlsContexts.Label
    @Nullable
    public String getLabel() {
        return null;
    }

    public int getLabelColor() {
        return -1;
    }

    public abstract long getTimestamp();

    @Nullable
    public Long getChangeSetId() {
        return null;
    }

    @NlsContexts.Label
    @Nullable
    public String getChangeSetName() {
        return null;
    }

    public boolean isLabel() {
        return ((List)this.getAffectedFileNames().first).isEmpty();
    }

    public Pair<List<String>, Integer> getAffectedFileNames() {
        return Pair.create(Collections.emptyList(), (Object)0);
    }

    @Nullable
    public abstract Entry findEntry();

    public List<Difference> getDifferencesWith(Revision right) {
        return Entry.getDifferencesBetween(this.findEntry(), right.findEntry(), right instanceof CurrentRevision);
    }

    public abstract RootEntry getRoot();
}

