/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectInitialActivitiesNotifier;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ignoreRefreshQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getIgnoreRefreshQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "awaitRefreshQueue", "", "dispose", "findIgnoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "getDirectoryVcsIgnoredStatus", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "dirPathString", "", "isDirectoryVcsIgnored", "", "dirPath", "isPotentiallyIgnoredFile", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRunConfigurationVcsIgnored", "configurationName", "removeRunConfigurationFromVcsIgnore", "Companion", "intellij.platform.vcs.impl"})
public final class VcsIgnoreManagerImpl
implements VcsIgnoreManager,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MergingUpdateQueue ignoreRefreshQueue;
    @NotNull
    private static final ExtensionPointName<VcsIgnoreChecker> EP_NAME = new ExtensionPointName("com.intellij.vcsIgnoreChecker");

    public VcsIgnoreManagerImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        VcsIgnoreManagerImplKt.access$checkProjectNotDefault(this.project);
        this.ignoreRefreshQueue = new MergingUpdateQueue("VcsIgnoreUpdate", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.ignoreRefreshQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"wait Project opening activities scan", () -> VcsIgnoreManagerImpl._init_$lambda$0(this)));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.project.getMessageBus().connect().subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosing(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    if (project == project2) {
                        try {
                            this.getIgnoreRefreshQueue().waitForAllExecuted(10L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            VcsIgnoreManagerImplKt.access$getLOG$p().warn("Queue '" + this.getIgnoreRefreshQueue() + "' wait for all executed failed with error:", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @NotNull
    public final MergingUpdateQueue getIgnoreRefreshQueue() {
        return this.ignoreRefreshQueue;
    }

    public void dispose() {
    }

    public final void awaitRefreshQueue() {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isReadAccessAllowed();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (this.ignoreRefreshQueue.isEmpty()) {
            return;
        }
        CountDownLatch waiter = new CountDownLatch(1);
        this.ignoreRefreshQueue.queue(Update.create((Object)waiter, () -> VcsIgnoreManagerImpl.awaitRefreshQueue$lambda$1(waiter)));
        ProgressIndicatorUtils.awaitWithCheckCanceled((CountDownLatch)waiter);
    }

    @Nullable
    public final IgnoreFileType findIgnoreFileType(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(ignoredFileContentProvider2.getFileName());
        return fileType instanceof IgnoreFileType ? (IgnoreFileType)fileType : null;
    }

    @Override
    public boolean isDirectoryVcsIgnored(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        try {
            Function0 checkForIgnore2 = (Function0)new Function0<Boolean>(this, dirPath){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $dirPath;
                {
                    this.this$0 = $receiver;
                    this.$dirPath = $dirPath;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return VcsIgnoreManagerImpl.access$getDirectoryVcsIgnoredStatus(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$dirPath) instanceof Ignored;
                }
            };
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsIgnoreManagerImpl.isDirectoryVcsIgnored$lambda$2(checkForIgnore2), VcsBundle.message("checking.vcs.status.progress", new Object[0]), false, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    private final IgnoredCheckResult getDirectoryVcsIgnoredStatus(Project project2, String dirPathString) {
        FilePath filePath = VcsContextFactory.getInstance().createFilePath(dirPathString, true);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePath(...)");
        FilePath dirPath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor(project2, dirPath);
        if (virtualFile == null) {
            return NotIgnored.INSTANCE;
        }
        VirtualFile vcsRoot = virtualFile;
        VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.access$getCheckerForFile(project2, dirPath);
        IgnoredCheckResult ignoredCheckResult = vcsIgnoreChecker != null ? vcsIgnoreChecker.isFilePatternIgnored(vcsRoot, dirPathString) : null;
        if (ignoredCheckResult == null) {
            ignoredCheckResult = NotIgnored.INSTANCE;
        }
        return ignoredCheckResult;
    }

    @Override
    public boolean isRunConfigurationVcsIgnored(@NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        try {
            String configurationFileName = VcsIgnoreManagerImplKt.access$configurationNameToFileName(configurationName);
            Function0 checkForIgnore2 = (Function0)new Function0<Boolean>(this, configurationFileName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationFileName;
                {
                    this.this$0 = $receiver;
                    this.$configurationFileName = $configurationFileName;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return VcsIgnoreManagerImplKt.access$checkConfigurationVcsIgnored(VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationFileName) instanceof Ignored;
                }
            };
            Object[] objectArray = new Object[]{configurationName};
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsIgnoreManagerImpl.isRunConfigurationVcsIgnored$lambda$3(checkForIgnore2), VcsBundle.message("changes.checking.configuration.0.for.ignore", objectArray), false, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    @Override
    public void removeRunConfigurationFromVcsIgnore(@NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        try {
            Function0 removeFromIgnore2 = (Function0)new Function0<Unit>(this, configurationName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationName;
                {
                    this.this$0 = $receiver;
                    this.$configurationName = $configurationName;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IDEA-338210, EA-660187");
                    VcsIgnoreManagerImpl vcsIgnoreManagerImpl = this.this$0;
                    String string2 = this.$configurationName;
                    Throwable throwable = null;
                    try {
                        AccessToken it = (AccessToken)autoCloseable;
                        boolean bl = false;
                        VcsIgnoreManagerImplKt.access$removeConfigurationFromVcsIgnore(VcsIgnoreManagerImpl.access$getProject$p(vcsIgnoreManagerImpl), string2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                }
            };
            Object[] objectArray = new Object[]{configurationName};
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> VcsIgnoreManagerImpl.removeRunConfigurationFromVcsIgnore$lambda$4(removeFromIgnore2), VcsBundle.message("changes.removing.configuration.0.from.ignore", objectArray), false, this.project);
        }
        catch (IOException io) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)io);
        }
    }

    @Override
    public boolean isPotentiallyIgnoredFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = VcsUtil.getFilePath(file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        return this.isPotentiallyIgnoredFile(filePath);
    }

    @Override
    public boolean isPotentiallyIgnoredFile(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this, filePath){
            final /* synthetic */ VcsIgnoreManagerImpl this$0;
            final /* synthetic */ FilePath $filePath;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block4: {
                    void $this$any$iv;
                    if (VcsIgnoreManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        return false;
                    }
                    Iterable iterable = IgnoredFileProvider.IGNORE_FILE.getExtensionList();
                    VcsIgnoreManagerImpl vcsIgnoreManagerImpl = this.this$0;
                    FilePath filePath = this.$filePath;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IgnoredFileProvider it = (IgnoredFileProvider)element$iv;
                            boolean bl2 = false;
                            if (!it.isIgnoredFile(VcsIgnoreManagerImpl.access$getProject$p(vcsIgnoreManagerImpl), filePath)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
        }));
    }

    private static final void _init_$lambda$0(VcsIgnoreManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ VcsIgnoreManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ComponentManager $this$service$iv = (ComponentManager)VcsIgnoreManagerImpl.access$getProject$p(this.this$0);
                        boolean $i$f$service = false;
                        Class<ProjectInitialActivitiesNotifier> serviceClass$iv = ProjectInitialActivitiesNotifier.class;
                        Object object3 = $this$service$iv.getService(serviceClass$iv);
                        if (object3 == null) {
                            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                        }
                        this.label = 1;
                        Object object4 = ((ProjectInitialActivitiesNotifier)object3).awaitInitialVfsRefreshFinished((Continuation)this);
                        if (object4 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final void awaitRefreshQueue$lambda$1(CountDownLatch $waiter) {
        Intrinsics.checkNotNullParameter((Object)$waiter, (String)"$waiter");
        $waiter.countDown();
    }

    private static final Boolean isDirectoryVcsIgnored$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke();
    }

    private static final Boolean isRunConfigurationVcsIgnored$lambda$3(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke();
    }

    private static final Unit removeRunConfigurationFromVcsIgnore$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke();
    }

    @JvmStatic
    @NotNull
    public static final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project2) {
        return Companion.getInstanceImpl(project2);
    }

    public static final /* synthetic */ IgnoredCheckResult access$getDirectoryVcsIgnoredStatus(VcsIgnoreManagerImpl $this, Project project2, String dirPathString) {
        return $this.getDirectoryVcsIgnoredStatus(project2, dirPathString);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            VcsIgnoreManager vcsIgnoreManager = VcsIgnoreManager.getInstance(project2);
            Intrinsics.checkNotNull((Object)vcsIgnoreManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl");
            return (VcsIgnoreManagerImpl)vcsIgnoreManager;
        }

        @NotNull
        public final ExtensionPointName<VcsIgnoreChecker> getEP_NAME() {
            return EP_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

