/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsCommitExternalStatus;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.util.VcsCommitsDataLoader;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails;
import com.intellij.vcs.log.ui.table.CommitSelectionListener;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00043456B'\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0016J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0016\u0010\"\u001a\u00020\u00192\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0014J\b\u0010$\u001a\u00020\u0019H\u0014J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0014J\b\u0010(\u001a\u00020\u0019H\u0014J\b\u0010)\u001a\u00020\u0019H\u0014J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fH\u0014J\u0015\u0010,\u001a\u00020\u00192\u000b\u0010-\u001a\u00070!\u00a2\u0006\u0002\b.H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u00020002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails;", "Lcom/intellij/vcs/log/ui/table/CommitSelectionListener;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Lcom/intellij/openapi/Disposable;", "graphTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "parentDisposable", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;Lcom/intellij/vcs/log/ui/VcsLogColorManager;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;Lcom/intellij/openapi/Disposable;)V", "containingBranchesLoader", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ContainingBranchesAsyncLoader;", "currentSelection", "", "externalStatusesLoader", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader;", "hashesResolver", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$CommitDataLoader;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "Lorg/jetbrains/annotations/NotNull;", "refsLoader", "cancelLoading", "", "dispose", "doResolveHashes", "", "Lcom/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation;", "presentations", "unResolvedHashes", "", "", "onDetailsLoaded", "detailsList", "onEmptySelection", "onError", "error", "", "onLoadingStarted", "onLoadingStopped", "onSelection", "selection", "setEmpty", "text", "Lorg/jetbrains/annotations/Nls;", "sortRefs", "Lcom/intellij/vcs/log/VcsRef;", "refs", "", "CommitDataLoader", "Companion", "ContainingBranchesAsyncLoader", "ExternalStatusesAsyncLoader", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogCommitSelectionListenerForDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,325:1\n1549#2:326\n1620#2,3:327\n1549#2:330\n1620#2,3:331\n766#2:334\n857#2,2:335\n1549#2:337\n1620#2,3:338\n*S KotlinDebug\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails\n*L\n61#1:326\n61#1:327,3\n66#1:330\n66#1:331,3\n124#1:334\n124#1:335,2\n148#1:337\n148#1:338,3\n*E\n"})
public final class VcsLogCommitSelectionListenerForDetails
extends CommitSelectionListener<VcsCommitMetadata>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogColorManager colorManager;
    @NotNull
    private final CommitDetailsListPanel detailsPanel;
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final CommitDataLoader refsLoader;
    @NotNull
    private final CommitDataLoader hashesResolver;
    @NotNull
    private final ContainingBranchesAsyncLoader containingBranchesLoader;
    @NotNull
    private final ExternalStatusesAsyncLoader externalStatusesLoader;
    @NotNull
    private int[] currentSelection;
    private static final int MAX_COMMITS_TO_LOAD = 50;

    private VcsLogCommitSelectionListenerForDetails(VcsLogGraphTable graphTable, VcsLogColorManager colorManager, CommitDetailsListPanel detailsPanel, Disposable parentDisposable) {
        super(graphTable, graphTable.getLogData().getMiniDetailsGetter());
        Object it;
        Object object;
        this.colorManager = colorManager;
        this.detailsPanel = detailsPanel;
        VcsLogData vcsLogData = graphTable.getLogData();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getLogData(...)");
        this.logData = vcsLogData;
        this.refsLoader = new CommitDataLoader();
        this.hashesResolver = new CommitDataLoader();
        ContainingBranchesGetter containingBranchesGetter = this.logData.getContainingBranchesGetter();
        Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"getContainingBranchesGetter(...)");
        ContainingBranchesAsyncLoader containingBranchesAsyncLoader = object = new ContainingBranchesAsyncLoader(containingBranchesGetter, this.detailsPanel);
        VcsLogCommitSelectionListenerForDetails vcsLogCommitSelectionListenerForDetails = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)it);
        vcsLogCommitSelectionListenerForDetails.containingBranchesLoader = object;
        Project project2 = this.logData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        it = object = new ExternalStatusesAsyncLoader(project2, this.detailsPanel);
        vcsLogCommitSelectionListenerForDetails = this;
        boolean bl2 = false;
        Disposer.register((Disposable)this, (Disposable)it);
        vcsLogCommitSelectionListenerForDetails.externalStatusesLoader = object;
        this.currentSelection = new int[0];
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    @NotNull
    protected int[] onSelection(@NotNull int[] selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        this.cancelLoading();
        this.currentSelection = selection;
        int[] nArray = Arrays.copyOf(selection, Math.min(selection.length, 50));
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onDetailsLoaded(@NotNull List<? extends VcsCommitMetadata> detailsList) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(detailsList, (String)"detailsList");
        Iterable $this$map$iv = detailsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CommitId((Hash)it.getId(), it.getRoot()));
        }
        List commitIds = (List)destination$iv$iv;
        this.detailsPanel.rebuildPanel$intellij_platform_vcs_log_impl(commitIds);
        this.detailsPanel.showOverflowLabelIfNeeded(50, this.currentSelection.length);
        Set unResolvedHashes = new LinkedHashSet();
        Iterable $this$map$iv2 = detailsList;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(CommitPresentationUtil.buildPresentation(this.logData.getProject(), (VcsCommitMetadata)it, unResolvedHashes));
        }
        List presentations = (List)destination$iv$iv2;
        this.detailsPanel.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<Integer, CommitDetailsPanel, Unit>((List<? extends CommitPresentationUtil.CommitPresentation>)presentations, (List<CommitId>)commitIds, this){
            final /* synthetic */ List<CommitPresentationUtil.CommitPresentation> $presentations;
            final /* synthetic */ List<CommitId> $commitIds;
            final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;
            {
                this.$presentations = $presentations;
                this.$commitIds = $commitIds;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(int idx, @NotNull CommitDetailsPanel panel2) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                CommitPresentationUtil.CommitPresentation commitPresentation = this.$presentations.get(idx);
                Intrinsics.checkNotNullExpressionValue((Object)commitPresentation, (String)"get(...)");
                CommitPresentationUtil.CommitPresentation presentation2 = commitPresentation;
                panel2.setCommit(presentation2);
                CommitId commit2 = this.$commitIds.get(idx);
                VirtualFile virtualFile = commit2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                VirtualFile root = virtualFile;
                if (VcsLogCommitSelectionListenerForDetails.access$getColorManager$p(this.this$0).hasMultiplePaths()) {
                    Color color = VcsLogCommitSelectionListenerForDetails.access$getColorManager$p(this.this$0).getRootColor(root);
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getRootColor(...)");
                    panel2.setRoot(new CommitDetailsPanel.RootColor(root, color));
                } else {
                    panel2.setRoot(null);
                }
            }
        }));
        this.refsLoader.loadData((Function1)new Function1<ProgressIndicator, List<? extends List<VcsRef>>>(this){
            final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<List<VcsRef>> invoke(@NotNull ProgressIndicator it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int[] nArray = VcsLogCommitSelectionListenerForDetails.access$getCurrentSelection$p(this.this$0);
                GraphTableModel graphTableModel = VcsLogCommitSelectionListenerForDetails.access$getMyGraphTable$p$s-1839395452(this.this$0).getModel();
                Intrinsics.checkNotNullExpressionValue((Object)graphTableModel, (String)"getModel(...)");
                GraphTableModel graphTableModel2 = graphTableModel;
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void p0;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(graphTableModel2.getRefsAtRow((int)p0));
                }
                return (List)destination$iv$iv;
            }
        }, (Function2)new Function2<CommitDetailsPanel, List<VcsRef>, Unit>(this){
            final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull CommitDetailsPanel panel2, @NotNull List<VcsRef> refs) {
                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                Intrinsics.checkNotNullParameter(refs, (String)"refs");
                panel2.setRefs(VcsLogCommitSelectionListenerForDetails.access$sortRefs(this.this$0, refs));
            }
        });
        ContainingBranchesAsyncLoader.requestData$default(this.containingBranchesLoader, commitIds, false, 2, null);
        this.externalStatusesLoader.requestData(commitIds);
        if (!((Collection)unResolvedHashes).isEmpty()) {
            this.hashesResolver.loadData((Function1)new Function1<ProgressIndicator, List<? extends CommitPresentationUtil.CommitPresentation>>(this, (List<? extends CommitPresentationUtil.CommitPresentation>)presentations, (Set<String>)unResolvedHashes){
                final /* synthetic */ VcsLogCommitSelectionListenerForDetails this$0;
                final /* synthetic */ List<CommitPresentationUtil.CommitPresentation> $presentations;
                final /* synthetic */ Set<String> $unResolvedHashes;
                {
                    this.this$0 = $receiver;
                    this.$presentations = $presentations;
                    this.$unResolvedHashes = $unResolvedHashes;
                    super(1);
                }

                @NotNull
                public final List<CommitPresentationUtil.CommitPresentation> invoke(@NotNull ProgressIndicator it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VcsLogCommitSelectionListenerForDetails.access$doResolveHashes(this.this$0, this.$presentations, this.$unResolvedHashes);
                }
            }, onDetailsLoaded.5.INSTANCE);
        }
    }

    private final List<VcsRef> sortRefs(Collection<? extends VcsRef> refs) {
        VcsRef vcsRef = (VcsRef)CollectionsKt.firstOrNull((Iterable)refs);
        if (vcsRef == null || (vcsRef = vcsRef.getRoot()) == null) {
            return CollectionsKt.emptyList();
        }
        VcsRef root = vcsRef;
        Iterable iterable = refs;
        Comparator<VcsRef> comparator2 = this.logData.getLogProvider((VirtualFile)root).getReferenceManager().getLabelsOrderComparator();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"getLabelsOrderComparator(...)");
        return CollectionsKt.sortedWith((Iterable)iterable, comparator2);
    }

    @Override
    protected void onEmptySelection() {
        this.cancelLoading();
        String string2 = VcsLogBundle.message("vcs.log.changes.details.no.commits.selected.status", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.setEmpty(string2);
    }

    @Override
    protected void onLoadingStarted() {
        this.detailsPanel.startLoadingDetails();
    }

    @Override
    protected void onLoadingStopped() {
        this.detailsPanel.stopLoadingDetails();
    }

    @Override
    protected void onError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        String string2 = VcsLogBundle.message("vcs.log.error.loading.details.status", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.setEmpty(string2);
    }

    private final void setEmpty(String text2) {
        this.detailsPanel.setStatusText(text2);
        this.currentSelection = new int[0];
        this.detailsPanel.rebuildPanel$intellij_platform_vcs_log_impl(CollectionsKt.emptyList());
        this.detailsPanel.showOverflowLabelIfNeeded(50, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommitPresentationUtil.CommitPresentation> doResolveHashes(List<? extends CommitPresentationUtil.CommitPresentation> presentations, Set<String> unResolvedHashes) {
        void $this$mapTo$iv$iv;
        Iterable hash2;
        Object it;
        void $this$filterTo$iv$iv;
        MultiMap resolvedHashes = new MultiMap();
        Iterable $this$filter$iv = unResolvedHashes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((String)it).length() == 40)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fullHashes = (List)destination$iv$iv;
        for (String fullHash : fullHashes) {
            Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build(fullHash), (String)"build(...)");
            for (VirtualFile root : this.logData.getRoots()) {
                CommitId id = new CommitId((Hash)((Object)hash2), root);
                if (!this.logData.getStorage().containsCommit(id)) continue;
                resolvedHashes.putValue((Object)fullHash, (Object)id);
            }
            unResolvedHashes.remove(fullHash);
        }
        if (!((Collection)unResolvedHashes).isEmpty()) {
            this.logData.getStorage().iterateCommits(arg_0 -> VcsLogCommitSelectionListenerForDetails.doResolveHashes$lambda$5((Function1)new Function1<CommitId, Boolean>(unResolvedHashes, (MultiMap<String, CommitId>)resolvedHashes){
                final /* synthetic */ Set<String> $unResolvedHashes;
                final /* synthetic */ MultiMap<String, CommitId> $resolvedHashes;
                {
                    this.$unResolvedHashes = $unResolvedHashes;
                    this.$resolvedHashes = $resolvedHashes;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull CommitId commitId2) {
                    Intrinsics.checkNotNullParameter((Object)commitId2, (String)"commitId");
                    for (String hashString : this.$unResolvedHashes) {
                        String string2 = commitId2.getHash().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                        if (!StringsKt.startsWith((String)string2, (String)hashString, (boolean)true)) continue;
                        this.$resolvedHashes.putValue((Object)hashString, (Object)commitId2);
                    }
                    return true;
                }
            }, arg_0));
        }
        Iterable $this$map$iv = presentations;
        boolean $i$f$map = false;
        hash2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommitPresentationUtil.CommitPresentation)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(((CommitPresentationUtil.CommitPresentation)it).resolve((MultiMap<String, CommitId>)resolvedHashes));
        }
        return (List)destination$iv$iv;
    }

    private final void cancelLoading() {
        this.hashesResolver.cancelLoading();
        this.refsLoader.cancelLoading();
        ContainingBranchesAsyncLoader.requestData$default(this.containingBranchesLoader, CollectionsKt.emptyList(), false, 2, null);
        this.externalStatusesLoader.requestData(CollectionsKt.emptyList());
    }

    public void dispose() {
        this.cancelLoading();
    }

    private static final boolean doResolveHashes$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable, @NotNull VcsLogColorManager colorManager) {
        Companion.install(graphTable, detailsPanel, disposable, colorManager);
    }

    @JvmStatic
    @JvmOverloads
    public static final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable) {
        Companion.install(graphTable, detailsPanel, disposable);
    }

    public static final /* synthetic */ VcsLogColorManager access$getColorManager$p(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.colorManager;
    }

    public static final /* synthetic */ int[] access$getCurrentSelection$p(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.currentSelection;
    }

    public static final /* synthetic */ VcsLogGraphTable access$getMyGraphTable$p$s-1839395452(VcsLogCommitSelectionListenerForDetails $this) {
        return $this.myGraphTable;
    }

    public static final /* synthetic */ List access$sortRefs(VcsLogCommitSelectionListenerForDetails $this, Collection refs) {
        return $this.sortRefs(refs);
    }

    public static final /* synthetic */ List access$doResolveHashes(VcsLogCommitSelectionListenerForDetails $this, List presentations, Set unResolvedHashes) {
        return $this.doResolveHashes(presentations, unResolvedHashes);
    }

    public /* synthetic */ VcsLogCommitSelectionListenerForDetails(VcsLogGraphTable graphTable, VcsLogColorManager colorManager, CommitDetailsListPanel detailsPanel, Disposable parentDisposable, DefaultConstructorMarker $constructor_marker) {
        this(graphTable, colorManager, detailsPanel, parentDisposable);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J@\u0010\u0007\u001a\u00020\u0006\"\u0004\b\u0000\u0010\b2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\n0\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00060\fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$CommitDataLoader;", "", "(Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "cancelLoading", "", "loadData", "T", "Lkotlin/Function1;", "", "setData", "Lkotlin/Function2;", "Lcom/intellij/vcs/log/ui/details/commit/CommitDetailsPanel;", "intellij.platform.vcs.log.impl"})
    private final class CommitDataLoader {
        @Nullable
        private ProgressIndicator progressIndicator;

        public final <T> void loadData(@NotNull Function1<? super ProgressIndicator, ? extends List<? extends T>> loadData2, @NotNull Function2<? super CommitDetailsPanel, ? super T, Unit> setData2) {
            Intrinsics.checkNotNullParameter(loadData2, (String)"loadData");
            Intrinsics.checkNotNullParameter(setData2, (String)"setData");
            this.progressIndicator = BackgroundTaskUtil.executeOnPooledThread((Disposable)VcsLogCommitSelectionListenerForDetails.this, () -> CommitDataLoader.loadData$lambda$2(loadData2, this, VcsLogCommitSelectionListenerForDetails.this, setData2));
        }

        public final void cancelLoading() {
            if (this.progressIndicator != null) {
                ProgressIndicator progressIndicator = this.progressIndicator;
                Intrinsics.checkNotNull((Object)progressIndicator);
                progressIndicator.cancel();
                this.progressIndicator = null;
            }
        }

        private static final void loadData$lambda$2$lambda$0(CommitDataLoader this$0, VcsLogCommitSelectionListenerForDetails this$1, Function2 $setData, List $loaded) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)$setData, (String)"$setData");
            Intrinsics.checkNotNullParameter((Object)$loaded, (String)"$loaded");
            this$0.progressIndicator = null;
            this$1.detailsPanel.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<Integer, CommitDetailsPanel, Unit>($setData, $loaded){
                final /* synthetic */ Function2<CommitDetailsPanel, T, Unit> $setData;
                final /* synthetic */ List<T> $loaded;
                {
                    this.$setData = $setData;
                    this.$loaded = $loaded;
                    super(2);
                }

                public final void invoke(int i, @NotNull CommitDetailsPanel panel2) {
                    Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                    this.$setData.invoke((Object)panel2, this.$loaded.get(i));
                }
            }));
        }

        private static final boolean loadData$lambda$2$lambda$1(ProgressIndicator $indicator, Object it) {
            return $indicator.isCanceled();
        }

        private static final void loadData$lambda$2(Function1 $loadData, CommitDataLoader this$0, VcsLogCommitSelectionListenerForDetails this$1, Function2 $setData) {
            Intrinsics.checkNotNullParameter((Object)$loadData, (String)"$loadData");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)$setData, (String)"$setData");
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)indicator);
            List loaded = (List)$loadData.invoke((Object)indicator);
            ApplicationManager.getApplication().invokeLater(() -> CommitDataLoader.loadData$lambda$2$lambda$0(this$0, this$1, $setData, loaded), arg_0 -> CommitDataLoader.loadData$lambda$2$lambda$1(indicator, arg_0));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$Companion;", "", "()V", "MAX_COMMITS_TO_LOAD", "", "install", "", "graphTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "disposable", "Lcom/intellij/openapi/Disposable;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable, @NotNull VcsLogColorManager colorManager) {
            Intrinsics.checkNotNullParameter((Object)((Object)graphTable), (String)"graphTable");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
            VcsLogCommitSelectionListenerForDetails listener2 = new VcsLogCommitSelectionListenerForDetails(graphTable, colorManager, detailsPanel, disposable, null);
            graphTable.getSelectionModel().addListSelectionListener(listener2);
        }

        public static /* synthetic */ void install$default(Companion companion, VcsLogGraphTable vcsLogGraphTable, CommitDetailsListPanel commitDetailsListPanel, Disposable disposable, VcsLogColorManager vcsLogColorManager, int n, Object object) {
            if ((n & 8) != 0) {
                VcsLogColorManager vcsLogColorManager2 = vcsLogGraphTable.getColorManager();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogColorManager2, (String)"getColorManager(...)");
                vcsLogColorManager = vcsLogColorManager2;
            }
            companion.install(vcsLogGraphTable, commitDetailsListPanel, disposable, vcsLogColorManager);
        }

        @JvmStatic
        @JvmOverloads
        public final void install(@NotNull VcsLogGraphTable graphTable, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)((Object)graphTable), (String)"graphTable");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails$Companion.install$default(this, graphTable, detailsPanel, disposable, null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001e\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ContainingBranchesAsyncLoader;", "Lcom/intellij/openapi/Disposable;", "getter", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;)V", "requestedCommits", "", "Lcom/intellij/vcs/log/CommitId;", "branchesChanged", "", "dispose", "requestData", "commits", "fromCache", "", "intellij.platform.vcs.log.impl"})
    private static final class ContainingBranchesAsyncLoader
    implements Disposable {
        @NotNull
        private final ContainingBranchesGetter getter;
        @NotNull
        private final CommitDetailsListPanel detailsPanel;
        @NotNull
        private List<CommitId> requestedCommits;

        public ContainingBranchesAsyncLoader(@NotNull ContainingBranchesGetter getter, @NotNull CommitDetailsListPanel detailsPanel) {
            Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            this.getter = getter;
            this.detailsPanel = detailsPanel;
            this.requestedCommits = CollectionsKt.emptyList();
            Runnable containingBranchesListener = () -> ContainingBranchesAsyncLoader._init_$lambda$0(this);
            this.getter.addTaskCompletedListener(containingBranchesListener);
            Disposer.register((Disposable)this, () -> ContainingBranchesAsyncLoader._init_$lambda$1(this, containingBranchesListener));
        }

        private final void branchesChanged() {
            this.requestData(this.requestedCommits, true);
        }

        public final void requestData(@NotNull List<CommitId> commits2, boolean fromCache) {
            Intrinsics.checkNotNullParameter(commits2, (String)"commits");
            Map result2 = new LinkedHashMap();
            for (CommitId commit2 : commits2) {
                List<String> branches;
                List<String> list2;
                if (fromCache) {
                    VirtualFile virtualFile = commit2.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    Hash hash2 = commit2.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"getHash(...)");
                    list2 = this.getter.getContainingBranchesFromCache(virtualFile, hash2);
                } else {
                    VirtualFile virtualFile = commit2.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    Hash hash3 = commit2.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash3, (String)"getHash(...)");
                    list2 = this.getter.requestContainingBranches(virtualFile, hash3);
                }
                if ((branches = list2) == null) continue;
                result2.put(commit2, branches);
            }
            if (!result2.isEmpty()) {
                this.detailsPanel.forEachPanel((Function2<? super CommitId, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<CommitId, CommitDetailsPanel, Unit>((Map<CommitId, List<String>>)result2){
                    final /* synthetic */ Map<CommitId, List<String>> $result;
                    {
                        this.$result = $result;
                        super(2);
                    }

                    public final void invoke(@NotNull CommitId commit2, @NotNull CommitDetailsPanel panel2) {
                        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
                        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                        panel2.setBranches(this.$result.get(commit2));
                    }
                }));
            }
            this.requestedCommits = commits2;
        }

        public static /* synthetic */ void requestData$default(ContainingBranchesAsyncLoader containingBranchesAsyncLoader, List list2, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            containingBranchesAsyncLoader.requestData(list2, bl);
        }

        public void dispose() {
        }

        private static final void _init_$lambda$0(ContainingBranchesAsyncLoader this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.branchesChanged();
        }

        private static final void _init_$lambda$1(ContainingBranchesAsyncLoader this$0, Runnable $containingBranchesListener) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$containingBranchesListener, (String)"$containingBranchesListener");
            this$0.getter.removeTaskCompletedListener($containingBranchesListener);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J\u0014\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;)V", "loaders", "", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader;", "loadersDisposable", "statuses", "", "Lcom/intellij/vcs/log/CommitId;", "", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "dispose", "", "getLoaders", "requestData", "commits", "ProviderLoader", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogCommitSelectionListenerForDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,325:1\n1855#2,2:326\n1855#2,2:328\n11065#3:330\n11400#3,3:331\n*S KotlinDebug\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader\n*L\n247#1:326,2\n253#1:328,2\n278#1:330\n278#1:331,3\n*E\n"})
    private static final class ExternalStatusesAsyncLoader
    implements Disposable {
        @NotNull
        private final Project project;
        @NotNull
        private final CommitDetailsListPanel detailsPanel;
        @Nullable
        private Disposable loadersDisposable;
        @Nullable
        private List<? extends ProviderLoader<?>> loaders;
        @NotNull
        private Map<CommitId, Map<String, VcsCommitExternalStatusPresentation>> statuses;

        public ExternalStatusesAsyncLoader(@NotNull Project project2, @NotNull CommitDetailsListPanel detailsPanel) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            this.project = project2;
            this.detailsPanel = detailsPanel;
            this.statuses = new LinkedHashMap();
            VcsCommitExternalStatusProvider.Companion.addProviderListChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    Disposable disposable = loadersDisposable;
                    if (disposable != null) {
                        Disposable it = disposable;
                        boolean bl = false;
                        Disposer.dispose((Disposable)it);
                    }
                    loaders = null;
                    this.requestData(CollectionsKt.toList((Iterable)statuses.keySet()));
                }
            }));
        }

        public final void requestData(@NotNull List<CommitId> commits2) {
            Intrinsics.checkNotNullParameter(commits2, (String)"commits");
            this.statuses = new LinkedHashMap();
            if (commits2.isEmpty()) {
                List<? extends ProviderLoader<?>> list2 = this.loaders;
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProviderLoader it = (ProviderLoader)element$iv;
                        boolean bl = false;
                        it.requestData(CollectionsKt.emptyList(), (Function1<Map<CommitId, VcsCommitExternalStatusPresentation>, Unit>)((Function1)requestData.1.1.INSTANCE));
                    }
                }
                return;
            }
            Iterable $this$forEach$iv = this.getLoaders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProviderLoader loader2 = (ProviderLoader)element$iv;
                boolean bl = false;
                loader2.requestData(commits2, (Function1<Map<CommitId, VcsCommitExternalStatusPresentation>, Unit>)((Function1)new Function1<Map<CommitId, ? extends VcsCommitExternalStatusPresentation>, Unit>(this, loader2){
                    final /* synthetic */ ExternalStatusesAsyncLoader this$0;
                    final /* synthetic */ ProviderLoader<?> $loader;
                    {
                        this.this$0 = $receiver;
                        this.$loader = $loader;
                        super(1);
                    }

                    public final void invoke(@NotNull Map<CommitId, ? extends VcsCommitExternalStatusPresentation> result2) {
                        Intrinsics.checkNotNullParameter(result2, (String)"result");
                        for (Map.Entry<CommitId, ? extends VcsCommitExternalStatusPresentation> entry2 : result2.entrySet()) {
                            Object object;
                            CommitId commit2 = entry2.getKey();
                            VcsCommitExternalStatusPresentation statusPresentation = entry2.getValue();
                            Map $this$getOrPut$iv = ExternalStatusesAsyncLoader.access$getStatuses$p(this.this$0);
                            boolean $i$f$getOrPut = false;
                            V value$iv = $this$getOrPut$iv.get(commit2);
                            if (value$iv == null) {
                                boolean bl = false;
                                Map answer$iv = new LinkedHashMap<K, V>();
                                $this$getOrPut$iv.put(commit2, answer$iv);
                                object = answer$iv;
                            } else {
                                object = value$iv;
                            }
                            Map presentations = (Map)object;
                            if (statusPresentation == null) {
                                presentations.remove(this.$loader.getId());
                                continue;
                            }
                            presentations.put(this.$loader.getId(), statusPresentation);
                        }
                        ExternalStatusesAsyncLoader.access$getDetailsPanel$p(this.this$0).forEachPanel((Function2<? super CommitId, ? super CommitDetailsPanel, Unit>)((Function2)new Function2<CommitId, CommitDetailsPanel, Unit>(this.this$0){
                            final /* synthetic */ ExternalStatusesAsyncLoader this$0;
                            {
                                this.this$0 = $receiver;
                                super(2);
                            }

                            public final void invoke(@NotNull CommitId commit2, @NotNull CommitDetailsPanel panel2) {
                                List list2;
                                Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
                                Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
                                Object object = (Map)ExternalStatusesAsyncLoader.access$getStatuses$p(this.this$0).get(commit2);
                                if ((object != null && (object = object.values()) != null ? CollectionsKt.toList((Iterable)((Iterable)object)) : (list2 = null)) == null) {
                                    list2 = CollectionsKt.emptyList();
                                }
                                panel2.setStatuses(list2);
                            }
                        }));
                    }
                }));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<ProviderLoader<?>> getLoaders() {
            if (this.loaders == null && !Disposer.isDisposed((Disposable)this)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Disposable disposable = Disposer.newDisposable((Disposable)this, (String)"Status loaders");
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                Object[] objectArray = VcsCommitExternalStatusProvider.Companion.getEP$intellij_platform_vcs_log_impl().getExtensions();
                ExternalStatusesAsyncLoader externalStatusesAsyncLoader = this;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void provider;
                    ProviderLoader providerLoader;
                    VcsCommitExternalStatusProvider vcsCommitExternalStatusProvider = (VcsCommitExternalStatusProvider)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ProviderLoader it = providerLoader = new ProviderLoader(this.project, provider);
                    boolean bl2 = false;
                    Disposer.register((Disposable)disposable2, (Disposable)it);
                    collection.add(providerLoader);
                }
                externalStatusesAsyncLoader.loaders = (List)destination$iv$iv;
                this.loadersDisposable = disposable2;
            }
            List<ProviderLoader<?>> list2 = this.loaders;
            Intrinsics.checkNotNull(list2);
            return list2;
        }

        public void dispose() {
        }

        public static final /* synthetic */ CommitDetailsListPanel access$getDetailsPanel$p(ExternalStatusesAsyncLoader $this) {
            return $this.detailsPanel;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J6\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132 \u0010\u0015\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017\u0012\u0004\u0012\u00020\u00100\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader;", "T", "Lcom/intellij/vcs/log/data/VcsCommitExternalStatus;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;)V", "id", "", "getId", "()Ljava/lang/String;", "loader", "Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;", "dispose", "", "requestData", "commits", "", "Lcom/intellij/vcs/log/CommitId;", "onChange", "Lkotlin/Function1;", "", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "intellij.platform.vcs.log.impl"})
        private static final class ProviderLoader<T extends VcsCommitExternalStatus>
        implements Disposable {
            @NotNull
            private final Project project;
            @NotNull
            private final VcsCommitExternalStatusProvider<T> provider;
            @NotNull
            private final String id;
            @NotNull
            private final VcsCommitsDataLoader<T> loader;

            /*
             * WARNING - void declaration
             */
            public ProviderLoader(@NotNull Project project2, @NotNull VcsCommitExternalStatusProvider<T> provider) {
                void it;
                VcsCommitsDataLoader<T> vcsCommitsDataLoader;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(provider, (String)"provider");
                this.project = project2;
                this.provider = provider;
                this.id = this.provider.getId();
                VcsCommitsDataLoader<T> vcsCommitsDataLoader2 = vcsCommitsDataLoader = this.provider.createLoader(this.project);
                ProviderLoader providerLoader = this;
                boolean bl = false;
                Disposer.register((Disposable)this, (Disposable)((Disposable)it));
                providerLoader.loader = vcsCommitsDataLoader;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public final void requestData(@NotNull List<CommitId> commits2, @NotNull Function1<? super Map<CommitId, ? extends VcsCommitExternalStatusPresentation>, Unit> onChange) {
                Intrinsics.checkNotNullParameter(commits2, (String)"commits");
                Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
                this.loader.loadData(commits2, (Function1)new Function1<Map<CommitId, ? extends T>, Unit>(onChange, this){
                    final /* synthetic */ Function1<Map<CommitId, ? extends VcsCommitExternalStatusPresentation>, Unit> $onChange;
                    final /* synthetic */ ProviderLoader<T> this$0;
                    {
                        this.$onChange = $onChange;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Map<CommitId, ? extends T> it) {
                        void $this$mapValuesTo$iv$iv;
                        void $this$mapValues$iv;
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        Map<CommitId, ? extends T> map2 = it;
                        ProviderLoader<T> providerLoader = this.this$0;
                        boolean $i$f$mapValues = false;
                        void var6_5 = $this$mapValues$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                        boolean $i$f$mapValuesTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            void it$iv$iv;
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            Map map3 = destination$iv$iv;
                            boolean bl = false;
                            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                            K k = it$iv$iv.getKey();
                            Map map4 = map3;
                            boolean bl2 = false;
                            VcsCommitExternalStatus status = (VcsCommitExternalStatus)entry3.getValue();
                            VcsCommitExternalStatusPresentation vcsCommitExternalStatusPresentation = ProviderLoader.access$getProvider$p(providerLoader).getPresentation(ProviderLoader.access$getProject$p(providerLoader), status);
                            map4.put(k, vcsCommitExternalStatusPresentation);
                        }
                        Map presentations = destination$iv$iv;
                        this.$onChange.invoke((Object)presentations);
                    }
                });
            }

            public void dispose() {
            }

            public static final /* synthetic */ VcsCommitExternalStatusProvider access$getProvider$p(ProviderLoader $this) {
                return $this.provider;
            }

            public static final /* synthetic */ Project access$getProject$p(ProviderLoader $this) {
                return $this.project;
            }
        }
    }
}

