/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.warmup.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.JulLogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RollingFileHandler;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/warmup/util/WarmupLoggerFactory;", "Lcom/intellij/openapi/diagnostic/Logger$Factory;", "()V", "appender", "Lcom/intellij/openapi/diagnostic/RollingFileHandler;", "getLoggerInstance", "Lcom/intellij/openapi/diagnostic/Logger;", "category", "", "Companion", "intellij.platform.warmup"})
final class WarmupLoggerFactory
implements Logger.Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RollingFileHandler appender = new RollingFileHandler(basePath, 20000000L, 50, false, null, 16, null);
    @NotNull
    private static final Path basePath;

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (!Intrinsics.areEqual((Object)category, (Object)"Warmup")) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Logger logger = Logger.getLogger(category);
        logger.addHandler((Handler)this.appender);
        this.appender.setFormatter(new Formatter(){

            @NotNull
            public String format(@NotNull LogRecord record) {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                String string2 = "%1$10tT %2$s%n";
                Object[] objectArray = new Object[]{record.getMillis(), record.getMessage()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                return string3;
            }
        });
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.INFO);
        return (com.intellij.openapi.diagnostic.Logger)new JulLogger(logger);
    }

    static {
        Path path2 = Path.of(PathManager.getLogPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Path path3 = path2;
        Path path4 = path3.resolve("warmup");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
        path3 = path4;
        Path path5 = path3.resolve("warmup.log");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
        basePath = path5;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/warmup/util/WarmupLoggerFactory$Companion;", "", "()V", "basePath", "Ljava/nio/file/Path;", "getBasePath", "()Ljava/nio/file/Path;", "intellij.platform.warmup"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getBasePath() {
            return basePath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

