/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.documentation.impl;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolOrigin;
import com.intellij.webSymbols.WebSymbolsBundle;
import com.intellij.webSymbols.documentation.WebSymbolDocumentation;
import com.intellij.webSymbols.documentation.WebSymbolDocumentationTarget;
import com.intellij.webSymbols.documentation.impl.WebSymbolDocumentationTargetImpl;
import com.intellij.webSymbols.impl.WebSymbolsImplUtilsKt;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl;", "Lcom/intellij/webSymbols/documentation/WebSymbolDocumentationTarget;", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "location", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/webSymbols/WebSymbol;Lcom/intellij/psi/PsiElement;)V", "getLocation", "()Lcom/intellij/psi/PsiElement;", "getSymbol", "()Lcom/intellij/webSymbols/WebSymbol;", "createPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "Companion", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolDocumentationTargetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolDocumentationTargetImpl.kt\ncom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class WebSymbolDocumentationTargetImpl
implements WebSymbolDocumentationTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebSymbol symbol;
    @Nullable
    private final PsiElement location;
    @NotNull
    private static final Regex imgSrcRegex = new Regex("<img [^>]*src\\s*=\\s*['\"]([^'\"]+)['\"]");

    public WebSymbolDocumentationTargetImpl(@NotNull WebSymbol symbol, @Nullable PsiElement location) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.symbol = symbol;
        this.location = location;
    }

    @Override
    @NotNull
    public WebSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    @Nullable
    public PsiElement getLocation() {
        return this.location;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer<? extends WebSymbol> pointer = this.getSymbol().createPointer();
        PsiElement psiElement = this.getLocation();
        SmartPsiElementPointer locationPtr = psiElement != null ? UtilsKt.createSmartPointer((PsiElement)psiElement) : null;
        return () -> WebSymbolDocumentationTargetImpl.createPointer$lambda$1(pointer, locationPtr);
    }

    private static final DocumentationTarget createPointer$lambda$1(Pointer $pointer, SmartPsiElementPointer $locationPtr) {
        WebSymbolDocumentationTargetImpl webSymbolDocumentationTargetImpl;
        Intrinsics.checkNotNullParameter((Object)$pointer, (String)"$pointer");
        WebSymbol webSymbol = (WebSymbol)$pointer.dereference();
        if (webSymbol != null) {
            WebSymbol it = webSymbol;
            boolean bl = false;
            SmartPsiElementPointer smartPsiElementPointer = $locationPtr;
            webSymbolDocumentationTargetImpl = new WebSymbolDocumentationTargetImpl(it, (PsiElement)(smartPsiElementPointer != null ? smartPsiElementPointer.dereference() : null));
        } else {
            webSymbolDocumentationTargetImpl = null;
        }
        return webSymbolDocumentationTargetImpl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010*\u00060\u000fj\u0002`\u00102\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u0014\u001a\u00060\u000fj\u0002`\u0010*\u00060\u000fj\u0002`\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u0015\u001a\u00060\u000fj\u0002`\u0010*\u00060\u000fj\u0002`\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u0016\u001a\u00060\u000fj\u0002`\u0010*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u0019\u001a\u00060\u000fj\u0002`\u0010*\u00060\u000fj\u0002`\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u001a\u001a\u00020\r*\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl$Companion;", "", "()V", "imgSrcRegex", "Lkotlin/text/Regex;", "buildDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "origin", "Lcom/intellij/webSymbols/WebSymbolOrigin;", "doc", "Lcom/intellij/webSymbols/documentation/WebSymbolDocumentation;", "buildSections", "", "", "appendDefinition", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "url2ImageMap", "", "Ljava/awt/Image;", "appendDescription", "appendFootnote", "appendIcon", "icon", "Ljavax/swing/Icon;", "appendSections", "loadLocalImages", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolDocumentationTargetImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolDocumentationTargetImpl.kt\ncom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,187:1\n1#2:188\n1855#3,2:189\n603#4:191\n*S KotlinDebug\n*F\n+ 1 WebSymbolDocumentationTargetImpl.kt\ncom/intellij/webSymbols/documentation/impl/WebSymbolDocumentationTargetImpl$Companion\n*L\n76#1:189,2\n169#1:191\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentationResult buildDocumentation(@NotNull WebSymbolOrigin origin, @NotNull WebSymbolDocumentation doc) {
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
            Map url2ImageMap = new LinkedHashMap();
            String string2 = this.appendFootnote(this.appendSections(this.appendDescription(this.appendDefinition(new StringBuilder(), doc, url2ImageMap), doc), doc), doc).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String contents = this.loadLocalImages(string2, origin, url2ImageMap);
            return (DocumentationResult)DocumentationResult.Companion.documentation(contents).images(url2ImageMap).externalUrl(doc.getDocUrl());
        }

        private final StringBuilder appendDefinition(StringBuilder $this$appendDefinition, WebSymbolDocumentation doc, Map<String, Image> url2ImageMap) {
            StringBuilder stringBuilder;
            StringBuilder it = stringBuilder = $this$appendDefinition.append("<div class='definition'><pre>");
            boolean bl = false;
            Icon icon2 = doc.getIcon();
            if (icon2 != null) {
                Icon it2 = icon2;
                boolean bl2 = false;
                Companion.appendIcon($this$appendDefinition, it2, url2ImageMap).append("&nbsp;&nbsp;");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(doc.getDefinition()).append("</pre></div>").append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            return stringBuilder2;
        }

        private final StringBuilder appendDescription(StringBuilder $this$appendDescription, WebSymbolDocumentation doc) {
            StringBuilder stringBuilder;
            String string2 = doc.getDescription();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                stringBuilder = $this$appendDescription.append("<div class='content'>").append('\n').append(it).append('\n').append("</div>");
            } else {
                stringBuilder = null;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2 == null ? $this$appendDescription : stringBuilder2;
        }

        private final StringBuilder appendSections(StringBuilder $this$appendSections, WebSymbolDocumentation doc) {
            Map<String, String> sections2 = this.buildSections(doc);
            boolean bl = false;
            if (!sections2.isEmpty()) {
                $this$appendSections.append("<table class='sections'>").append('\n');
                Iterable $this$forEach$iv = sections2.entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry2 = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    String name = (String)entry2.getKey();
                    String value2 = (String)entry2.getValue();
                    $this$appendSections.append("<tr><td valign='top' class='section'><p>").append(StringUtil.capitalize((String)name));
                    if (!StringsKt.isBlank((CharSequence)value2)) {
                        if (!StringsKt.endsWith$default((String)name, (String)":", (boolean)false, (int)2, null)) {
                            $this$appendSections.append(':');
                        }
                        if (StringsKt.contains$default((CharSequence)value2, (CharSequence)"<code", (boolean)false, (int)2, null)) {
                            $this$appendSections.append("<code> </code>");
                        }
                        $this$appendSections.append("</td><td valign='top'>").append(value2);
                    }
                    $this$appendSections.append("</td>").append('\n');
                }
                $this$appendSections.append("</table>").append('\n');
            }
            return $this$appendSections;
        }

        private final StringBuilder appendFootnote(StringBuilder $this$appendFootnote, WebSymbolDocumentation doc) {
            StringBuilder stringBuilder;
            String string2 = doc.getFootnote();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                stringBuilder = $this$appendFootnote.append("<div class='content'>").append(it).append("</div>").append('\n');
            } else {
                stringBuilder = null;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2 == null ? $this$appendFootnote : stringBuilder2;
        }

        private final Map<String, String> buildSections(WebSymbolDocumentation doc) {
            LinkedHashMap<String, String> linkedHashMap;
            block18: {
                String it;
                LinkedHashMap<String, String> sections2 = linkedHashMap = new LinkedHashMap<String, String>(doc.getDescriptionSections());
                boolean bl = false;
                if (doc.isRequired()) {
                    ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.isRequired", new Object[0]), "");
                }
                WebSymbolApiStatus webSymbolApiStatus = doc.getApiStatus();
                if (webSymbolApiStatus != null) {
                    WebSymbolApiStatus status = webSymbolApiStatus;
                    boolean bl2 = false;
                    WebSymbolApiStatus webSymbolApiStatus2 = status;
                    if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Deprecated) {
                        Map map2 = sections2;
                        String string2 = WebSymbolsBundle.message("mdn.documentation.section.status.Deprecated", new Object[0]);
                        String string3 = ((WebSymbolApiStatus.Deprecated)status).getMessage();
                        if (string3 == null) {
                            string3 = "";
                        }
                        String string4 = string3;
                        map2.put(string2, string4);
                        String string5 = status.getSince();
                        if (string5 != null) {
                            String it2 = string5;
                            boolean bl3 = false;
                            ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.status.DeprecatedSince", new Object[0]), it2);
                        }
                    } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Obsolete) {
                        Map map3 = sections2;
                        String string6 = WebSymbolsBundle.message("mdn.documentation.section.status.Obsolete", new Object[0]);
                        String string7 = ((WebSymbolApiStatus.Obsolete)status).getMessage();
                        if (string7 == null) {
                            string7 = "";
                        }
                        String it2 = string7;
                        map3.put(string6, it2);
                        String string8 = status.getSince();
                        if (string8 != null) {
                            it2 = string8;
                            boolean bl4 = false;
                            ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.status.ObsoleteSince", new Object[0]), it2);
                        }
                    } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Experimental) {
                        Map map4 = sections2;
                        String string9 = WebSymbolsBundle.message("mdn.documentation.section.status.Experimental", new Object[0]);
                        String string10 = ((WebSymbolApiStatus.Experimental)status).getMessage();
                        if (string10 == null) {
                            string10 = "";
                        }
                        String it3 = string10;
                        map4.put(string9, it3);
                        String string11 = status.getSince();
                        if (string11 != null) {
                            it3 = string11;
                            boolean bl5 = false;
                            ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.status.Since", new Object[0]), it3);
                        }
                    } else if (webSymbolApiStatus2 instanceof WebSymbolApiStatus.Stable) {
                        String string12 = status.getSince();
                        if (string12 != null) {
                            String it4 = string12;
                            boolean bl6 = false;
                            ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.status.Since", new Object[0]), it4);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String string13 = doc.getDefaultValue();
                if (string13 != null) {
                    it = string13;
                    boolean bl7 = false;
                    ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.defaultValue", new Object[0]), "<p><code>" + it + "</code>");
                }
                String string14 = doc.getLibrary();
                if (string14 == null) break block18;
                it = string14;
                boolean bl8 = false;
                ((Map)sections2).put(WebSymbolsBundle.message("mdn.documentation.section.library", new Object[0]), "<p>" + it);
            }
            return linkedHashMap;
        }

        private final StringBuilder appendIcon(StringBuilder $this$appendIcon, Icon icon2, Map<String, Image> url2ImageMap) {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = new BufferedImage(1, 1, 2);
            Graphics2D g = bufferedImage2.createGraphics();
            g.setFont(UIUtil.getToolTipFont());
            int height = (int)(g.getFontMetrics().getStringBounds("a", g).getHeight() / ScaleContext.Companion.create().getScale(ScaleType.USR_SCALE));
            g.dispose();
            try {
                bufferedImage = IconUtil.toBufferedImage$default((Icon)WebSymbolsImplUtilsKt.scaleToHeight(icon2, height), (boolean)false, (int)2, null);
            }
            catch (Exception e) {
                return $this$appendIcon;
            }
            BufferedImage image = bufferedImage;
            String url = "https://img" + url2ImageMap.size();
            url2ImageMap.put(url, image);
            double screenHeight = (double)height * ScaleContext.Companion.create().getScale(ScaleType.SYS_SCALE);
            $this$appendIcon.append("<img src='" + url + "' height=\"" + screenHeight + "\" width=\"" + screenHeight * (double)icon2.getIconWidth() / (double)icon2.getIconHeight() + "\" border=0 />");
            return $this$appendIcon;
        }

        /*
         * WARNING - void declaration
         */
        private final String loadLocalImages(String $this$loadLocalImages, WebSymbolOrigin origin, Map<String, Image> url2ImageMap) {
            void $this$sortedBy$iv;
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)Regex.findAll$default((Regex)imgSrcRegex, (CharSequence)$this$loadLocalImages, (int)0, (int)2, null), (Function1)loadLocalImages.replaces.1.INSTANCE), (Function1)loadLocalImages.replaces.2.INSTANCE), (Function1)((Function1)new Function1<MatchGroup, Pair<? extends IntRange, ? extends String>>(origin, url2ImageMap){
                final /* synthetic */ WebSymbolOrigin $origin;
                final /* synthetic */ Map<String, Image> $url2ImageMap;
                {
                    this.$origin = $origin;
                    this.$url2ImageMap = $url2ImageMap;
                    super(1);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Pair<IntRange, String> invoke(@NotNull MatchGroup group2) {
                    Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
                    Icon icon2 = this.$origin.loadIcon(group2.getValue());
                    if (icon2 == null) return null;
                    Icon it = icon2;
                    boolean bl = false;
                    BufferedImage bufferedImage = IconUtil.toBufferedImage((Icon)it, (boolean)true);
                    if (bufferedImage == null) return null;
                    BufferedImage bufferedImage2 = bufferedImage;
                    Map<String, Image> map2 = this.$url2ImageMap;
                    BufferedImage it2 = bufferedImage2;
                    boolean bl2 = false;
                    String url = "https://img" + map2.size();
                    map2.put(url, it2);
                    Pair pair = new Pair((Object)group2.getRange(), (Object)url);
                    return pair;
                }
            }));
            boolean $i$f$sortedBy = false;
            List replaces2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((IntRange)it.getFirst()).getFirst());
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((IntRange)it.getFirst()).getFirst()));
                }
            }));
            if (replaces2.isEmpty()) {
                return $this$loadLocalImages;
            }
            StringBuilder result2 = new StringBuilder();
            int lastIndex = 0;
            for (Pair replace : replaces2) {
                Intrinsics.checkNotNullExpressionValue((Object)result2.append($this$loadLocalImages, lastIndex, ((IntRange)replace.getFirst()).getFirst()), (String)"this.append(value, startIndex, endIndex)");
                result2.append((String)replace.getSecond());
                lastIndex = ((IntRange)replace.getFirst()).getLast() + 1;
            }
            if (lastIndex < $this$loadLocalImages.length()) {
                Intrinsics.checkNotNullExpressionValue((Object)result2.append($this$loadLocalImages, lastIndex, $this$loadLocalImages.length()), (String)"this.append(value, startIndex, endIndex)");
            }
            String string2 = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

