/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.XmlTypedHandlersAdditionalSupport;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThreeState;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlCustomElementDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class HtmlUtil {
    private static final Logger LOG = Logger.getInstance(HtmlUtil.class);
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    public static final String HTML5_DATA_ATTR_PREFIX = "data-";
    @NlsSafe
    public static final String SCRIPT_TAG_NAME = "script";
    @NlsSafe
    public static final String STYLE_TAG_NAME = "style";
    @NlsSafe
    public static final String TEMPLATE_TAG_NAME = "template";
    @NlsSafe
    public static final String TEXTAREA_TAG_NAME = "textarea";
    @NlsSafe
    public static final String TITLE_TAG_NAME = "title";
    @NlsSafe
    public static final String STYLE_ATTRIBUTE_NAME = "style";
    @NlsSafe
    public static final String SRC_ATTRIBUTE_NAME = "src";
    @NlsSafe
    public static final String ID_ATTRIBUTE_NAME = "id";
    @NlsSafe
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    @NlsSafe
    public static final String TYPE_ATTRIBUTE_NAME = "type";
    @NlsSafe
    public static final String LANGUAGE_ATTRIBUTE_NAME = "language";
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    public static final String[] RFC2616_HEADERS = new String[]{"Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language", "Accept-Ranges", "Age", "Allow", "Authorization", "Cache-Control", "Connection", "Content-Encoding", "Content-Language", "Content-Length", "Content-Location", "Content-MD5", "Content-Range", "Content-Type", "Date", "ETag", "Expect", "Expires", "From", "Host", "If-Match", "If-Modified-Since", "If-None-Match", "If-Range", "If-Unmodified-Since", "Last-Modified", "Location", "Max-Forwards", "Pragma", "Proxy-Authenticate", "Proxy-Authorization", "Range", "Referer", "Refresh", "Retry-After", "Server", "TE", "Trailer", "Transfer-Encoding", "Upgrade", "User-Agent", "Vary", "Via", "Warning", "WWW-Authenticate"};
    private static final String HTML_TAG_REGEXP = "\\s*</?\\w+\\s*(\\w+\\s*=.*)?>.*";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("\\s*</?\\w+\\s*(\\w+\\s*=.*)?>.*");
    private static final Set<String> EMPTY_TAGS_MAP = Set.of("area", "base", "basefont", "br", "col", "embed", "frame", "hr", "meta", "img", "input", "isindex", "link", "param", "source", "track", "wbr");
    private static final Set<String> OPTIONAL_END_TAGS_MAP = Set.of("head", "caption", "colgroup", "dd", "dt", "embed", "li", "noembed", "optgroup", "option", "p", "rt", "rp", "tbody", "td", "tfoot", "th", "thead", "tr");
    private static final Set<String> BLOCK_TAGS_MAP = Set.of("p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment");
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = Set.of("a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var");
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = Set.of("p", "h1", "h2", "h3", "h4", "h5", "h6", "pre");
    private static final Set<String> HTML5_TAGS_SET = Set.of("article", "aside", "audio", "canvas", "command", "datalist", "details", "embed", "figcaption", "figure", "footer", "header", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "video", "wbr", "main");
    private static final Set<String> P_AUTO_CLOSE_CLOSING_TAGS = Set.of("abbr", "acronym", "address", "applet", "area", "article", "aside", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "data", "datalist", "dd", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "head", "header", "hgroup", "h1", "hr", "html", "i", "iframe", "img", "input", "kbd", "keygen", "label", "legend", "li", "link", "main", "mark", "menu", "menuitem", "meta", "meter", "nav", "noframes", "object", "ol", "optgroup", "option", "output", "p", "param", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "svg", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "wbr");
    private static final Map<String, Set<String>> AUTO_CLOSE_BY_OPENING_TAG = new HashMap<String, Set<String>>();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(@NotNull XmlTag tag, boolean toLowerCase) {
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(0);
        }
        String name = tag.getName();
        boolean result2 = EMPTY_TAGS_MAP.contains(!toLowerCase || tag.isCaseSensitive() ? name : StringUtil.toLowerCase((String)name));
        return result2 && !XmlCustomElementDescriptor.isCustomElement(tag);
    }

    public static boolean isSingleHtmlTag(String tagName, boolean caseSensitive) {
        return EMPTY_TAGS_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    @Deprecated(forRemoval=true)
    public static boolean isSingleHtmlTag(String tagName) {
        return HtmlUtil.isSingleHtmlTag(tagName, false);
    }

    public static boolean isTagWithOptionalEnd(@NotNull String tagName, boolean caseSensitive) {
        if (tagName == null) {
            HtmlUtil.$$$reportNull$$$0(1);
        }
        return OPTIONAL_END_TAGS_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    @NotNull
    public static ThreeState canOpeningTagAutoClose(@NotNull String tagToClose, @NotNull String openingTag, boolean caseSensitive) {
        String normalizedOpeningTag;
        if (tagToClose == null) {
            HtmlUtil.$$$reportNull$$$0(2);
        }
        if (openingTag == null) {
            HtmlUtil.$$$reportNull$$$0(3);
        }
        String normalizedTagToClose = caseSensitive ? tagToClose : StringUtil.toLowerCase((String)tagToClose);
        String string2 = normalizedOpeningTag = caseSensitive ? openingTag : StringUtil.toLowerCase((String)openingTag);
        if (!HtmlUtil.isTagWithOptionalEnd(normalizedTagToClose, true)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                HtmlUtil.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        Set<String> closingTags = AUTO_CLOSE_BY_OPENING_TAG.get(normalizedTagToClose);
        if (closingTags != null && closingTags.contains(normalizedOpeningTag)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                HtmlUtil.$$$reportNull$$$0(5);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            HtmlUtil.$$$reportNull$$$0(6);
        }
        return threeState;
    }

    public static boolean canClosingTagAutoClose(@NotNull String tagToClose, @NotNull String closingTag, boolean caseSensitive) {
        String normalizedClosingTag;
        if (tagToClose == null) {
            HtmlUtil.$$$reportNull$$$0(7);
        }
        if (closingTag == null) {
            HtmlUtil.$$$reportNull$$$0(8);
        }
        String normalizedTagToClose = caseSensitive ? tagToClose : StringUtil.toLowerCase((String)tagToClose);
        String string2 = normalizedClosingTag = caseSensitive ? closingTag : StringUtil.toLowerCase((String)closingTag);
        if (!HtmlUtil.isTagWithOptionalEnd(normalizedTagToClose, true)) {
            return false;
        }
        if (normalizedTagToClose.equals("p")) {
            return P_AUTO_CLOSE_CLOSING_TAGS.contains(normalizedClosingTag);
        }
        return true;
    }

    public static boolean isHtmlBlockTag(String tagName, boolean caseSensitive) {
        return BLOCK_TAGS_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    @Deprecated(forRemoval=true)
    public static boolean isHtmlBlockTag(String tagName) {
        return HtmlUtil.isHtmlBlockTag(tagName, false);
    }

    public static boolean isPossiblyInlineTag(@NotNull String tagName) {
        if (tagName == null) {
            HtmlUtil.$$$reportNull$$$0(9);
        }
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName);
    }

    public static boolean isInlineTagContainer(String tagName, boolean caseSensitive) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(caseSensitive ? tagName : StringUtil.toLowerCase((String)tagName));
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor, XmlTag element, List<? super XmlElementDescriptor> variants) {
        block5: {
            XmlNSDescriptor nsDescriptor;
            PsiElement parent;
            block6: {
                String name = descriptor.getName(element);
                if (name == null || !HtmlUtil.isTagWithOptionalEnd(name, false)) break block5;
                parent = element.getParent();
                if (parent instanceof XmlTag && XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parent.getNode()) != null) {
                    return;
                }
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof HtmlTag)) break block6;
                XmlElementDescriptor parentDescriptor = ((HtmlTag)parent).getDescriptor();
                if (parentDescriptor == descriptor || parentDescriptor == null) break block5;
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName(), false)) continue;
                    variants.add(elementsDescriptor);
                }
                break block5;
            }
            if (parent instanceof HtmlDocumentImpl && (nsDescriptor = descriptor.getNSDescriptor()) != null) {
                for (XmlElementDescriptor elementDescriptor : nsDescriptor.getRootElementsDescriptors((XmlDocument)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementDescriptor.getName(), false) || variants.contains(elementDescriptor)) continue;
                    variants.add(elementDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        return HtmlPsiUtil.getRealXmlDocument(doc);
    }

    public static boolean isShortNotationOfBooleanAttributePreferred() {
        return Registry.is((String)"html.prefer.short.notation.of.boolean.attributes", (boolean)true);
    }

    @TestOnly
    public static void setShortNotationOfBooleanAttributeIsPreferred(boolean value2, Disposable parent) {
        final boolean oldValue = HtmlUtil.isShortNotationOfBooleanAttributePreferred();
        final RegistryValue registryValue = Registry.get((String)"html.prefer.short.notation.of.boolean.attributes");
        registryValue.setValue(value2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                registryValue.setValue(oldValue);
            }
        });
    }

    public static boolean isBooleanAttribute(@NotNull XmlAttributeDescriptor descriptor, @Nullable PsiElement context) {
        if (descriptor == null) {
            HtmlUtil.$$$reportNull$$$0(10);
        }
        if (descriptor.isEnumerated()) {
            String[] values2 = descriptor.getEnumeratedValues();
            if (values2 == null) {
                return false;
            }
            if (values2.length == 2) {
                return values2[0].isEmpty() && values2[1].equals(descriptor.getName()) || values2[1].isEmpty() && values2[0].equals(descriptor.getName());
            }
            if (values2.length == 1) {
                return descriptor.getName().equals(values2[0]);
            }
        }
        return context != null && HtmlUtil.isCustomBooleanAttribute(descriptor.getName(), context);
    }

    public static boolean isCustomBooleanAttribute(@NotNull String attributeName, @NotNull PsiElement context) {
        String entitiesString;
        if (attributeName == null) {
            HtmlUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            HtmlUtil.$$$reportNull$$$0(12);
        }
        if ((entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownBooleanAttribute")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().equalsIgnoreCase(attributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(PsiElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownAttribute");
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.isEmpty()) continue;
            descriptors[index++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(@Nullable PsiElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownTag");
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            String tagName = tokenizer.nextToken();
            if (tagName.isEmpty()) continue;
            descriptors[index++] = new CustomXmlTagDescriptor(tagName);
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(@Nullable PsiElement context, @NotNull String inspectionName) {
        if (inspectionName == null) {
            HtmlUtil.$$$reportNull$$$0(13);
        }
        if (context == null) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        XmlEntitiesInspection inspection = (XmlEntitiesInspection)profile.getUnwrappedTool(inspectionName, (PsiElement)containingFile);
        if (inspection != null) {
            return inspection.getAdditionalEntries();
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttribute context) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors(context));
            return descriptors;
        }
        boolean isJsfHtmlNamespace = false;
        for (String jsfHtmlUri : XmlUtil.JSF_HTML_URIS) {
            if (declarationTag.getPrefixByNamespace(jsfHtmlUri) == null) continue;
            isJsfHtmlNamespace = true;
            break;
        }
        if (isJsfHtmlNamespace && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            }, XmlAttributeDescriptor.class);
        }
        return descriptors;
    }

    public static boolean isHtml5Document(XmlDocument doc) {
        VirtualFile vFile;
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        PsiFile htmlFile = doc.getContainingFile();
        String htmlFileFullName = htmlFile != null ? ((vFile = htmlFile.getVirtualFile()) == null ? htmlFile.getName() : vFile.getPath()) : "unknown";
        if (doctype == null) {
            LOG.debug("DOCTYPE for " + htmlFileFullName + " is null");
            return HtmlUtil.isHtmlTagContainingFile(doc) && Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(doc.getProject()));
        }
        boolean html5Doctype = HtmlUtil.isHtml5Doctype(doctype);
        String doctypeDescription = "text: " + doctype.getText() + ", dtdUri: " + doctype.getDtdUri() + ", publicId: " + doctype.getPublicId() + ", markupDecl: " + doctype.getMarkupDecl();
        LOG.debug("DOCTYPE for " + htmlFileFullName + "; " + doctypeDescription + "; HTML5: " + html5Doctype);
        return html5Doctype;
    }

    public static boolean isHtml5Doctype(XmlDoctype doctype) {
        return doctype.getDtdUri() == null && doctype.getPublicId() == null && doctype.getMarkupDecl() == null;
    }

    public static boolean isHtml5Context(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        if (doc == null && context != null) {
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(context.getProject()));
        }
        return HtmlUtil.isHtml5Document(doc);
    }

    public static boolean isHtmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(14);
        }
        if (!tag.getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE)) {
            return false;
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlDocument.class);
        String doctype = null;
        if (doc != null) {
            doctype = XmlUtil.getDtdUri(doc);
        }
        doctype = doctype == null ? ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(tag.getProject()) : doctype;
        return XmlUtil.XHTML4_SCHEMA_LOCATION.equals(doctype) || !StringUtil.containsIgnoreCase((String)doctype, (String)"xhtml");
    }

    public static boolean hasNonHtml5Doctype(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        return doctype != null && !HtmlUtil.isHtml5Doctype(doctype);
    }

    public static boolean isHtml5Tag(@NotNull String tagName) {
        if (tagName == null) {
            HtmlUtil.$$$reportNull$$$0(15);
        }
        return HTML5_TAGS_SET.contains(tagName);
    }

    public static boolean isCustomHtml5Attribute(String attributeName) {
        return attributeName.startsWith(HTML5_DATA_ATTR_PREFIX);
    }

    @Nullable
    public static String getHrefBase(XmlFile file) {
        XmlTag root = file.getRootTag();
        XmlTag head = root != null ? root.findFirstSubTag("head") : null;
        XmlTag base = head != null ? head.findFirstSubTag("base") : null;
        return base != null ? base.getAttributeValue("href") : null;
    }

    public static boolean isOwnHtmlAttribute(XmlAttributeDescriptor descriptor) {
        PsiElement declaration = descriptor.getDeclaration();
        PsiFile file = declaration != null ? declaration.getContainingFile() : null;
        String name = file != null ? file.getName() : null;
        return "meta.rnc".equals(name) || "web-forms.rnc".equals(name) || "embed.rnc".equals(name) || "tables.rnc".equals(name) || "media.rnc".equals(name);
    }

    public static boolean tagHasHtml5Schema(@NotNull XmlTag context) {
        XmlElementDescriptor descriptor;
        if (context == null) {
            HtmlUtil.$$$reportNull$$$0(16);
        }
        XmlNSDescriptor nsDescriptor = (descriptor = context.getDescriptor()) != null ? descriptor.getNSDescriptor() : null;
        return HtmlUtil.isHtml5Schema(nsDescriptor);
    }

    public static boolean isHtml5Schema(@Nullable XmlNSDescriptor nsDescriptor) {
        XmlFile descriptorFile = nsDescriptor != null ? nsDescriptor.getDescriptorFile() : null;
        String descriptorPath = descriptorFile != null ? descriptorFile.getVirtualFile().getPath() : null;
        return Objects.equals(Html5SchemaProvider.getHtml5SchemaLocation(), descriptorPath) || Objects.equals(Html5SchemaProvider.getXhtml5SchemaLocation(), descriptorPath);
    }

    public static String getStartTag(@NotNull String line) {
        int tagStart;
        if (line == null) {
            HtmlUtil.$$$reportNull$$$0(17);
        }
        if (HtmlUtil.startsWithTag(line) && (tagStart = line.indexOf("<")) >= 0) {
            for (int i = ++tagStart; i < line.length(); ++i) {
                char ch = line.charAt(i);
                if (Character.isAlphabetic(ch) || i > tagStart && (Character.isDigit(ch) || ch == '-')) continue;
                return line.substring(tagStart, i);
            }
        }
        return null;
    }

    public static boolean startsWithTag(@NotNull String line) {
        if (line == null) {
            HtmlUtil.$$$reportNull$$$0(18);
        }
        if (line.trim().startsWith("<")) {
            return HTML_TAG_PATTERN.matcher(line).matches();
        }
        return false;
    }

    public static Charset detectCharsetFromMetaTag(@NotNull CharSequence content) {
        String name;
        if (content == null) {
            HtmlUtil.$$$reportNull$$$0(19);
        }
        int charPrefix = StringUtil.indexOf((CharSequence)content, (CharSequence)CHARSET);
        while (true) {
            int charsetPrefixEnd;
            if (charPrefix == -1) {
                return null;
            }
            for (charsetPrefixEnd = charPrefix + CHARSET.length(); charsetPrefixEnd < content.length() && Character.isWhitespace(content.charAt(charsetPrefixEnd)); ++charsetPrefixEnd) {
            }
            if (charsetPrefixEnd < content.length() && content.charAt(charsetPrefixEnd) == '=') break;
            charPrefix = StringUtil.indexOf((CharSequence)content, (CharSequence)CHARSET, (int)charsetPrefixEnd);
        }
        if (content.length() > charPrefix + 200 && (name = HtmlUtil.tryFetchCharsetFromFileContent(content.subSequence(0, charPrefix + 200))) != null) {
            return CharsetToolkit.forName((String)name);
        }
        String name2 = HtmlUtil.tryFetchCharsetFromFileContent(content);
        return CharsetToolkit.forName((String)name2);
    }

    private static String tryFetchCharsetFromFileContent(@NotNull CharSequence content) {
        if (content == null) {
            HtmlUtil.$$$reportNull$$$0(20);
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content).build(new XmlBuilder(){
                @NonNls
                final Set<String> inTag = new HashSet<String>();
                boolean metHttpEquiv;
                boolean metHtml5Charset;
                private String contentAttributeValue;

                @Override
                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
                }

                @Override
                public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startOffset, int endOffset, int headerEndOffset) {
                    @NonNls String name = StringUtil.toLowerCase((String)localName.toString());
                    this.inTag.add(name);
                    if (!this.inTag.contains("head") && !"html".equals(name)) {
                        4.terminate();
                    }
                    return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                }

                private static void terminate() {
                    throw TerminateException.INSTANCE;
                }

                @Override
                public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                    @NonNls String name = StringUtil.toLowerCase((String)localName.toString());
                    if ("meta".equals(name) && (this.metHttpEquiv || this.metHtml5Charset) && this.contentAttributeValue != null) {
                        String charsetName;
                        if (this.metHttpEquiv) {
                            int start2 = this.contentAttributeValue.indexOf(HtmlUtil.CHARSET_PREFIX);
                            if (start2 == -1) {
                                return;
                            }
                            int end = this.contentAttributeValue.indexOf(59, start2 += HtmlUtil.CHARSET_PREFIX.length());
                            if (end == -1) {
                                end = this.contentAttributeValue.length();
                            }
                            charsetName = this.contentAttributeValue.substring(start2, end);
                        } else {
                            charsetName = StringUtil.unquoteString((String)this.contentAttributeValue);
                        }
                        charsetNameRef.set((Object)charsetName);
                        4.terminate();
                    }
                    if ("head".equals(name)) {
                        4.terminate();
                    }
                    this.inTag.remove(name);
                    this.metHttpEquiv = false;
                    this.metHtml5Charset = false;
                    this.contentAttributeValue = null;
                }

                @Override
                public void attribute(CharSequence localName, CharSequence v, int startoffset, int endoffset) {
                    @NonNls String name = StringUtil.toLowerCase((String)localName.toString());
                    if (this.inTag.contains("meta")) {
                        @NonNls String value2 = StringUtil.toLowerCase((String)v.toString());
                        if (name.equals("http-equiv")) {
                            this.metHttpEquiv |= value2.equals("content-type");
                        } else if (name.equals(HtmlUtil.CHARSET)) {
                            this.metHtml5Charset = true;
                            this.contentAttributeValue = value2;
                        }
                        if (name.equals("content")) {
                            this.contentAttributeValue = value2;
                        }
                    }
                }

                @Override
                public void textElement(CharSequence display2, CharSequence physical, int startoffset, int endoffset) {
                }

                @Override
                public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                }

                @Override
                public void error(@NotNull String message2, int startOffset, int endOffset) {
                    if (message2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/xml/util/HtmlUtil$4", "error"));
                }
            });
        }
        catch (TerminateException terminateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String)charsetNameRef.get();
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName) {
        return "br".equalsIgnoreCase(tagName);
    }

    public static boolean hasHtml(@NotNull PsiFile file) {
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(21);
        }
        return HtmlUtil.isHtmlFile((PsiElement)file) || file.getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }

    public static boolean supportsXmlTypedHandlers(@NotNull PsiFile file) {
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(22);
        }
        return XmlTypedHandlersAdditionalSupport.supportsTypedHandlers(file);
    }

    public static boolean hasHtmlPrefix(@NotNull String url) {
        if (url == null) {
            HtmlUtil.$$$reportNull$$$0(23);
        }
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//") || url.startsWith("ftp://");
    }

    public static boolean isHtmlFile(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            HtmlUtil.$$$reportNull$$$0(24);
        }
        return (language = element.getLanguage()).isKindOf((Language)HTMLLanguage.INSTANCE) || language.isKindOf((Language)XHTMLLanguage.INSTANCE);
    }

    public static boolean isHtmlFile(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(25);
        }
        return (fileType = file.getFileType()) == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            if (containingFile instanceof HtmlCompatibleFile) {
                return true;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                return true;
            }
            XmlDocument document2 = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
            if (document2 instanceof HtmlDocumentImpl) {
                return true;
            }
            FileViewProvider provider = containingFile.getViewProvider();
            Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
            return language == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isScriptTag(@Nullable XmlTag tag) {
        return tag != null && tag.getLocalName().equalsIgnoreCase(SCRIPT_TAG_NAME);
    }

    @NotNull
    public static Iterable<String> splitClassNames(@Nullable String classAttributeValue) {
        Iterable<String> iterable = classAttributeValue != null ? StringUtil.tokenize((String)classAttributeValue, (String)" \t,") : Collections.emptyList();
        if (iterable == null) {
            HtmlUtil.$$$reportNull$$$0(26);
        }
        return iterable;
    }

    @Contract(value="!null -> !null")
    @NlsSafe
    public static String getTagPresentation(@Nullable XmlTag tag) {
        String classValue;
        if (tag == null) {
            return null;
        }
        StringBuilder builder2 = new StringBuilder(tag.getLocalName());
        String idValue = HtmlUtil.getAttributeValue(tag, ID_ATTRIBUTE_NAME);
        if (idValue != null) {
            builder2.append('#').append(idValue);
        }
        if ((classValue = HtmlUtil.getAttributeValue(tag, CLASS_ATTRIBUTE_NAME)) != null) {
            for (String className : HtmlUtil.splitClassNames(classValue)) {
                builder2.append('.').append(className);
            }
        }
        return builder2.toString();
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlTag tag, @NotNull String attrName) {
        String value2;
        XmlAttribute classAttribute;
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(27);
        }
        if (attrName == null) {
            HtmlUtil.$$$reportNull$$$0(28);
        }
        if ((classAttribute = HtmlUtil.getAttributeByName(tag, attrName)) != null && !HtmlUtil.containsOuterLanguageElements(classAttribute) && !StringUtil.isEmptyOrSpaces((String)(value2 = classAttribute.getValue()))) {
            return value2;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute getAttributeByName(@NotNull XmlTag tag, @NotNull String name) {
        if (tag == null) {
            HtmlUtil.$$$reportNull$$$0(29);
        }
        if (name == null) {
            HtmlUtil.$$$reportNull$$$0(30);
        }
        for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement nameElement;
            if (!(child instanceof XmlAttribute) || (nameElement = child.getFirstChild()) == null || nameElement.getNode().getElementType() != XmlTokenType.XML_NAME || !name.equalsIgnoreCase(nameElement.getText())) continue;
            return (XmlAttribute)child;
        }
        return null;
    }

    private static boolean containsOuterLanguageElements(@NotNull PsiElement element) {
        if (element == null) {
            HtmlUtil.$$$reportNull$$$0(31);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CompositeElement) {
                return HtmlUtil.containsOuterLanguageElements(child);
            }
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    public static List<XmlAttributeValue> getIncludedPathsElements(@NotNull XmlFile file) {
        if (file == null) {
            HtmlUtil.$$$reportNull$$$0(32);
        }
        final ArrayList result2 = new ArrayList();
        file.acceptChildren(new XmlRecursiveElementWalkingVisitor(){

            @Override
            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    5.$$$reportNull$$$0(0);
                }
                XmlAttribute attribute = null;
                if ("link".equalsIgnoreCase(tag.getName())) {
                    attribute = tag.getAttribute("href");
                } else if (HtmlUtil.SCRIPT_TAG_NAME.equalsIgnoreCase(tag.getName()) || "img".equalsIgnoreCase(tag.getName())) {
                    attribute = tag.getAttribute(HtmlUtil.SRC_ATTRIBUTE_NAME);
                }
                if (attribute != null) {
                    result2.add(attribute.getValueElement());
                }
                super.visitXmlTag(tag);
            }

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (element.getLanguage() instanceof XMLLanguage) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/util/HtmlUtil$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    static {
        AUTO_CLOSE_BY_OPENING_TAG.put("colgroup", Set.of("colgroup", "tbody", "tfoot", "thead"));
        AUTO_CLOSE_BY_OPENING_TAG.put("dd", Set.of("dd", "dt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("dt", Set.of("dd", "dt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("head", Set.of("body"));
        AUTO_CLOSE_BY_OPENING_TAG.put("li", Set.of("li"));
        AUTO_CLOSE_BY_OPENING_TAG.put("optgroup", Set.of("optgroup"));
        AUTO_CLOSE_BY_OPENING_TAG.put("option", Set.of("optgroup", "option"));
        AUTO_CLOSE_BY_OPENING_TAG.put("p", Set.of("address", "article", "aside", "blockquote", "center", "details", "div", "dl", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "main", "menu", "nav", "ol", "p", "pre", "section", "table", "ul"));
        AUTO_CLOSE_BY_OPENING_TAG.put("rp", Set.of("rp", "rt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("rt", Set.of("rp", "rt"));
        AUTO_CLOSE_BY_OPENING_TAG.put("tbody", Set.of("tbody", "tfoot"));
        AUTO_CLOSE_BY_OPENING_TAG.put("td", Set.of("td", "th"));
        AUTO_CLOSE_BY_OPENING_TAG.put("th", Set.of("td", "th"));
        AUTO_CLOSE_BY_OPENING_TAG.put("thead", Set.of("tbody", "tfoot"));
        AUTO_CLOSE_BY_OPENING_TAG.put("tr", Set.of("tr"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagToClose";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTag";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/HtmlUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingTag";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionName";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/HtmlUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "canOpeningTagAutoClose";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "splitClassNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSingleHtmlTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTagWithOptionalEnd";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canOpeningTagAutoClose";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 26: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canClosingTagAutoClose";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyInlineTag";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanAttribute";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCustomBooleanAttribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEntitiesString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlTag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isHtml5Tag";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tagHasHtml5Schema";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStartTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startsWithTag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "detectCharsetFromMetaTag";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryFetchCharsetFromFileContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasHtml";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "supportsXmlTypedHandlers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasHtmlPrefix";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlFile";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeByName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "containsOuterLanguageElements";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedPathsElements";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 5, 6, 26 -> new IllegalStateException(string2);
        };
    }

    public static class CustomXmlTagDescriptor
    extends XmlElementDescriptorImpl {
        private final String myTagName;

        CustomXmlTagDescriptor(String tagName) {
            super(null);
            this.myTagName = tagName;
        }

        @Override
        public String getName(PsiElement context) {
            return this.myTagName;
        }

        @Override
        public String getDefaultName() {
            return this.myTagName;
        }

        @Override
        public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
            return true;
        }
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

