/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.rngom.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private final Class cls;
    private ResourceBundle bundle;
    private final Localizer parent;

    public Localizer(Class cls) {
        this(null, cls);
    }

    public Localizer(Localizer parent, Class cls) {
        this.parent = parent;
        this.cls = cls;
    }

    private String getString(String key2) {
        try {
            return this.getBundle().getString(key2);
        }
        catch (MissingResourceException e) {
            if (this.parent != null) {
                return this.parent.getString(key2);
            }
            throw e;
        }
    }

    public String message(String key2) {
        return MessageFormat.format(this.getString(key2), new Object[0]);
    }

    public String message(String key2, Object arg) {
        return MessageFormat.format(this.getString(key2), arg);
    }

    public String message(String key2, Object arg1, Object arg2) {
        return MessageFormat.format(this.getString(key2), arg1, arg2);
    }

    public String message(String key2, Object[] args) {
        return MessageFormat.format(this.getString(key2), args);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            String s = this.cls.getName();
            int i = s.lastIndexOf(46);
            s = i > 0 ? s.substring(0, i + 1) : "";
            this.bundle = ResourceBundle.getBundle(s + "Messages");
        }
        return this.bundle;
    }
}

