/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import com.intellij.licensecommon.util.InvalidLicenseKeyException;
import java.math.BigInteger;

public class GroupUtil {
    public static String encodeGroups(BigInteger value) {
        BigInteger MOD = BigInteger.valueOf(60466176L);
        StringBuffer buffer = new StringBuffer();
        int groupCount = 0;
        while (value.compareTo(BigInteger.ZERO) != 0) {
            int d = value.mod(MOD).intValue();
            String group = GroupUtil.encodeGroup(d);
            if (groupCount > 0) {
                buffer.append("-");
            }
            buffer.append(group);
            value = value.divide(MOD);
            ++groupCount;
        }
        String key = buffer.toString();
        return key;
    }

    public static String encodeGroup(int value) {
        StringBuffer buffer = new StringBuffer();
        int MOD = 36;
        for (int i = 0; i < 5; ++i) {
            int d = value % 36;
            char c = d < 10 ? (char)(48 + d) : (char)(65 + d - 10);
            buffer.append(c);
            value /= 36;
        }
        return buffer.toString();
    }

    public static BigInteger decodeGroups(String key) throws InvalidLicenseKeyException {
        BigInteger value = BigInteger.ZERO;
        int index = key.length();
        BigInteger MOD = BigInteger.valueOf(60466176L);
        while (index >= 0) {
            int index1 = key.lastIndexOf(45, index - 1) + 1;
            String group = key.substring(index1, index);
            int d = GroupUtil.decodeGroup(group);
            value = value.multiply(MOD);
            value = value.add(BigInteger.valueOf(d));
            index = index1 - 1;
        }
        return value;
    }

    public static int decodeGroup(String group) throws InvalidLicenseKeyException {
        if (group.length() != 5) {
            throw new InvalidLicenseKeyException();
        }
        int MOD = 36;
        int value = 0;
        for (int i = group.length() - 1; i >= 0; --i) {
            int d;
            char c = group.charAt(i);
            if ('0' <= c && c <= '9') {
                d = c - 48;
            } else if ('A' <= c && c <= 'Z') {
                d = c - 65 + 10;
            } else {
                throw new InvalidLicenseKeyException();
            }
            value *= 36;
            value += d;
        }
        return value;
    }
}

