/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GrCreateFieldForParameterIntention
extends CreateFieldFromParameterActionBase {
    protected boolean isAvailable(@NotNull PsiParameter parameter) {
        PsiElement scope;
        if (parameter == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(0);
        }
        if (!((scope = parameter.getDeclarationScope()) instanceof GrMethod)) {
            return false;
        }
        if (((GrMethod)scope).getContainingClass() == null) {
            return false;
        }
        return !GrCreateFieldForParameterIntention.checkAssignmentToFieldExists(parameter);
    }

    protected PsiType getSubstitutedType(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(1);
        }
        return GroovyRefactoringUtil.getSubstitutedType((GrParameter)parameter);
    }

    private static boolean checkAssignmentToFieldExists(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter).findAll()) {
            GrExpression value2;
            PsiElement psiElement;
            PsiElement element = reference.getElement();
            if (!(element instanceof GrReferenceExpression) || !((psiElement = element.getParent()) instanceof GrAssignmentExpression)) continue;
            GrAssignmentExpression parent2 = (GrAssignmentExpression)psiElement;
            if (((GrAssignmentExpression)element.getParent()).getRValue() != element || !((value2 = parent2.getLValue()) instanceof GrReferenceExpression) || !(((GrReferenceExpression)value2).resolve() instanceof PsiField)) continue;
            return true;
        }
        return false;
    }

    protected PsiVariable createField(@NotNull Project project, @NotNull PsiClass targetClass, @NotNull PsiMethod method, @NotNull PsiParameter myParameter, PsiType type2, @NotNull String fieldName, boolean methodStatic, boolean isFinal) {
        GrOpenBlock block;
        if (project == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(3);
        }
        if (method == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(4);
        }
        if (myParameter == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            GrCreateFieldForParameterIntention.$$$reportNull$$$0(6);
        }
        if ((block = ((GrMethod)method).getBlock()) == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrAssignmentExpression assignment = GrCreateFieldForParameterIntention.createAssignment(targetClass, myParameter, fieldName, methodStatic, factory);
        GrStatement anchor = GrCreateFieldForParameterIntention.getAnchor(block);
        GrStatement statement = block.addStatementBefore(assignment, anchor);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)statement);
        if (targetClass.findFieldByName(fieldName, false) == null) {
            String[] modifiers = GrCreateFieldForParameterIntention.getModifiers(methodStatic, isFinal);
            GrVariableDeclaration fieldDeclaration = factory.createFieldDeclaration(modifiers, fieldName, null, type2);
            GrVariableDeclaration inserted = (GrVariableDeclaration)targetClass.add((PsiElement)fieldDeclaration);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
            return inserted.getVariables()[0];
        }
        return null;
    }

    private static GrAssignmentExpression createAssignment(PsiClass targetClass, PsiParameter myParameter, String fieldName, boolean methodStatic, GroovyPsiElementFactory factory) {
        StringBuilder builder = new StringBuilder();
        if (methodStatic) {
            builder.append(targetClass.getQualifiedName());
            builder.append('.');
        } else {
            builder.append("this.");
        }
        builder.append(fieldName);
        builder.append("=").append(myParameter.getName());
        return (GrAssignmentExpression)factory.createStatementFromText(builder.toString());
    }

    @Nullable
    private static GrStatement getAnchor(GrOpenBlock block) {
        Object[] statements2 = block.getStatements();
        GrStatement fist = (GrStatement)ArrayUtil.getFirstElement((Object[])statements2);
        if (fist instanceof GrConstructorInvocation) {
            return statements2.length > 1 ? statements2[1] : null;
        }
        return fist;
    }

    private static String[] getModifiers(boolean aStatic, boolean aFinal) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("private");
        if (aStatic) {
            list.add("static");
        }
        if (aFinal) {
            list.add("final");
        }
        return ArrayUtilRt.toStringArray(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myParameter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/declaration/GrCreateFieldForParameterIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSubstitutedType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

