/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GrBlockLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionList;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrInExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaBody;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GrTryResourceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrYieldStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSwitchExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AfterCallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.GotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.InstanceOfInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.PositiveGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalBlockBeginInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.FunctionalBlockEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrResolverPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.LoopIteratorVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeYieldInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ThrowingInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class ControlFlowBuilder
extends GroovyRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance(ControlFlowBuilder.class);
    private final List<InstructionImpl> myInstructions = new ArrayList<InstructionImpl>();
    private final Deque<InstructionImpl> myProcessingStack = new ArrayDeque<InstructionImpl>();
    private GroovyPsiElement myScope;
    private final Deque<GrFunctionalExpression> myFunctionalScopeStack = new ArrayDeque<GrFunctionalExpression>();
    private final boolean isFlatFlow;
    private final Deque<ExceptionInfo> myCaughtExceptionInfos = new ArrayDeque<ExceptionInfo>();
    private FList<ConditionInstruction> myConditions = FList.emptyList();
    private int myFinallyCount;
    private InstructionImpl myHead;
    private List<Pair<InstructionImpl, GroovyPsiElement>> myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
    private final Map<VariableDescriptor, Integer> myVariableMapping;
    private int myInstructionNumber;
    private final GrControlFlowPolicy myPolicy;

    private ControlFlowBuilder(GrControlFlowPolicy policy, boolean isFlatFlow) {
        this.myPolicy = policy;
        this.isFlatFlow = isFlatFlow;
        this.myVariableMapping = new HashMap<VariableDescriptor, Integer>();
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        GrStatement[] statements2;
        if (block == null) {
            ControlFlowBuilder.$$$reportNull$$$0(0);
        }
        PsiElement parent2 = block.getParent();
        PsiElement lbrace = block.getLBrace();
        if (lbrace != null && parent2 instanceof GrMethod) {
            for (GrParameter parameter : ((GrMethod)parent2).getParameters()) {
                if (!this.myPolicy.isVariableInitialized(parameter)) continue;
                this.addNode(new ReadWriteVariableInstruction(this.getDescriptorId(VariableDescriptorFactory.createDescriptor(parameter)), parameter, -1));
            }
        }
        super.visitOpenBlock(block);
        if (!(block.getParent() instanceof GrBlockStatement && block.getParent().getParent() instanceof GrLoopStatement || (statements2 = block.getStatements()).length <= 0)) {
            this.handlePossibleYield(statements2[statements2.length - 1]);
            this.handlePossibleReturn(statements2[statements2.length - 1]);
        }
    }

    @Override
    public void visitExpressionLambdaBody(@NotNull GrExpressionLambdaBody body) {
        if (body == null) {
            ControlFlowBuilder.$$$reportNull$$$0(1);
        }
        this.addFunctionalExpressionParameters(body.getLambdaExpression());
        body.getExpression().accept(this);
    }

    @Override
    public void visitBlockLambdaBody(@NotNull GrBlockLambdaBody body) {
        if (body == null) {
            ControlFlowBuilder.$$$reportNull$$$0(2);
        }
        this.addFunctionalExpressionParameters(body.getLambdaExpression());
        this.addControlFlowInstructions(body);
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            ControlFlowBuilder.$$$reportNull$$$0(3);
        }
        super.visitFile(file);
        GrStatement[] statements2 = file.getStatements();
        if (statements2.length > 0) {
            this.handlePossibleReturn(statements2[statements2.length - 1]);
        }
    }

    @Nullable
    private InstructionImpl handlePossibleReturn(@NotNull GrStatement possibleReturn) {
        if (possibleReturn == null) {
            ControlFlowBuilder.$$$reportNull$$$0(4);
        }
        if (possibleReturn instanceof GrExpression && ControlFlowBuilderUtil.isCertainlyReturnStatement(possibleReturn)) {
            return this.addNodeAndCheckPending(new MaybeReturnInstruction((GrExpression)possibleReturn));
        }
        return null;
    }

    @NotNull
    public static GroovyControlFlow buildControlFlow(@NotNull GroovyPsiElement scope) {
        if (scope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(5);
        }
        return ControlFlowBuilder.buildControlFlow(scope, GrResolverPolicy.getInstance());
    }

    @ApiStatus.Experimental
    @NotNull
    public static GroovyControlFlow buildFlatControlFlow(@NotNull GroovyPsiElement scope) {
        if (scope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(6);
        }
        GroovyControlFlow groovyControlFlow = new ControlFlowBuilder(GrResolverPolicy.getInstance(), true).doBuildFlatControlFlow(scope);
        if (groovyControlFlow == null) {
            ControlFlowBuilder.$$$reportNull$$$0(7);
        }
        return groovyControlFlow;
    }

    @NotNull
    public static GroovyControlFlow buildControlFlow(@NotNull GroovyPsiElement scope, @NotNull GrControlFlowPolicy policy) {
        if (scope == null) {
            ControlFlowBuilder.$$$reportNull$$$0(8);
        }
        if (policy == null) {
            ControlFlowBuilder.$$$reportNull$$$0(9);
        }
        GroovyControlFlow groovyControlFlow = new ControlFlowBuilder(policy, false).doBuildControlFlow(scope);
        if (groovyControlFlow == null) {
            ControlFlowBuilder.$$$reportNull$$$0(10);
        }
        return groovyControlFlow;
    }

    private GroovyControlFlow doBuildFlatControlFlow(GroovyPsiElement scope) {
        GrControlFlowOwner topOwner = ControlFlowUtils.getTopmostOwner(scope);
        if (topOwner == null) {
            return new GroovyControlFlow(Instruction.EMPTY_ARRAY, this.getDescriptorMapping());
        }
        this.myFinallyCount = 0;
        this.myInstructionNumber = 0;
        this.myScope = scope;
        this.startNode(null);
        topOwner.accept(this);
        InstructionImpl end = this.startNode(null);
        this.checkPending(end);
        return new GroovyControlFlow(this.myInstructions.toArray(Instruction.EMPTY_ARRAY), this.getDescriptorMapping());
    }

    private int getDescriptorId(VariableDescriptor actualDescriptor) {
        this.myVariableMapping.putIfAbsent(actualDescriptor, this.myVariableMapping.size() + 1);
        return this.myVariableMapping.get(actualDescriptor);
    }

    private VariableDescriptor[] getDescriptorMapping() {
        VariableDescriptor[] array = new VariableDescriptor[this.myVariableMapping.size() + 1];
        for (Map.Entry<VariableDescriptor, Integer> entry : this.myVariableMapping.entrySet()) {
            array[entry.getValue().intValue()] = entry.getKey();
        }
        return array;
    }

    private GroovyControlFlow doBuildControlFlow(GroovyPsiElement scope) {
        if (scope instanceof GrLambdaExpression) {
            GrLambdaBody body = ((GrLambdaExpression)scope).getBody();
            Instruction[] flow = body != null ? body.getControlFlow() : Instruction.EMPTY_ARRAY;
            return new GroovyControlFlow(flow, this.getDescriptorMapping());
        }
        this.myFinallyCount = 0;
        this.myInstructionNumber = 0;
        this.myScope = scope;
        this.startNode(null);
        if (scope instanceof GrClosableBlock) {
            this.addFunctionalExpressionParameters((GrFunctionalExpression)scope);
            this.addControlFlowInstructions((GrStatementOwner)scope);
        } else {
            scope.accept(this);
        }
        InstructionImpl end = this.startNode(null);
        this.checkPending(end);
        return new GroovyControlFlow(this.myInstructions.toArray(Instruction.EMPTY_ARRAY), this.getDescriptorMapping());
    }

    private void addControlFlowInstructions(GrStatementOwner owner) {
        for (PsiElement child = owner.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(this);
        }
        GrStatement[] statements2 = owner.getStatements();
        if (statements2.length > 0) {
            this.handlePossibleReturn(statements2[statements2.length - 1]);
        }
    }

    private void addFunctionalExpressionParameters(GrFunctionalExpression expression) {
        for (GrParameter parameter : expression.getAllParameters()) {
            if (!this.myPolicy.isVariableInitialized(parameter)) continue;
            this.addNode(new ReadWriteVariableInstruction(this.getDescriptorId(VariableDescriptorFactory.createDescriptor(parameter)), parameter, -1));
        }
    }

    private <T extends InstructionImpl> T addNode(T instruction) {
        instruction.setNumber(this.myInstructionNumber++);
        this.myInstructions.add(instruction);
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, instruction);
        }
        this.myHead = instruction;
        return instruction;
    }

    private <T extends InstructionImpl> T addNodeAndCheckPending(T i2) {
        this.addNode(i2);
        this.checkPending(i2);
        return i2;
    }

    private static void addEdge(InstructionImpl begin, InstructionImpl end) {
        begin.addSuccessor(end);
        end.addPredecessor(begin);
        if (!(begin instanceof MixinTypeInstruction)) {
            end.addNegationsFrom(begin);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull GrLambdaExpression expression) {
        GrLambdaBody body;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(11);
        }
        if ((body = expression.getBody()) == null) {
            return;
        }
        if (this.isFlatFlow) {
            FunctionalBlockBeginInstruction startClosure = new FunctionalBlockBeginInstruction(expression);
            this.myFunctionalScopeStack.addLast(expression);
            this.addNode(startClosure);
            this.addPendingEdge(expression, startClosure);
            this.addFunctionalExpressionParameters(expression);
            if (body instanceof GrBlockLambdaBody) {
                this.addControlFlowInstructions((GrStatementOwner)((Object)body));
            } else {
                super.visitLambdaBody(body);
            }
            FunctionalBlockEndInstruction endClosure = new FunctionalBlockEndInstruction(startClosure);
            this.addNode(endClosure);
            this.checkPending(expression.getParent(), endClosure);
            this.myFunctionalScopeStack.removeLast();
        } else {
            List<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>> reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(ControlFlowUtils.getGroovyControlFlow(body), false);
            this.addReadFromNestedControlFlow(expression, reads);
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            ControlFlowBuilder.$$$reportNull$$$0(12);
        }
        if (this.isFlatFlow) {
            FunctionalBlockBeginInstruction startClosure = new FunctionalBlockBeginInstruction(closure);
            this.myFunctionalScopeStack.addLast(closure);
            this.addNodeAndCheckPending(startClosure);
            this.addPendingEdge(closure, startClosure);
            this.addFunctionalExpressionParameters(closure);
            this.addControlFlowInstructions(closure);
            FunctionalBlockEndInstruction endClosure = new FunctionalBlockEndInstruction(startClosure);
            this.addNode(endClosure);
            this.checkPending(closure.getParent(), endClosure);
            this.myFunctionalScopeStack.removeLast();
        } else {
            if (closure.getParent() instanceof GrStringInjection) {
                this.addFunctionalExpressionParameters(closure);
                super.visitClosure(closure);
                return;
            }
            List<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>> reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(ControlFlowUtils.getGroovyControlFlow(closure), false);
            this.addReadFromNestedControlFlow(closure, reads);
        }
    }

    private void addReadFromNestedControlFlow(@NotNull PsiElement anchor, List<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>> reads) {
        if (anchor == null) {
            ControlFlowBuilder.$$$reportNull$$$0(13);
        }
        for (kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor> read : reads) {
            PsiElement element = ((ReadWriteVariableInstruction)read.getFirst()).getElement();
            if (element instanceof GrReferenceExpression && !this.myPolicy.isReferenceAccepted((GrReferenceExpression)element)) continue;
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(this.getDescriptorId((VariableDescriptor)read.getSecond()), anchor, 1));
        }
        this.addNodeAndCheckPending(new InstructionImpl(anchor));
    }

    @Override
    public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
        if (breakStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(14);
        }
        super.visitBreakStatement(breakStatement);
        GrStatement target = breakStatement.resolveLabel();
        if (target == null) {
            target = breakStatement.findTargetStatement();
        }
        if (target != null) {
            if (this.myHead != null) {
                this.addPendingEdge(target, this.myHead);
            }
            this.readdPendingEdge(target);
        }
        this.interruptFlow();
    }

    @Override
    public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
        if (continueStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(15);
        }
        super.visitContinueStatement(continueStatement);
        GrStatement target = continueStatement.resolveLabel();
        if (target == null) {
            target = continueStatement.findTargetStatement();
        }
        if (target != null) {
            InstructionImpl instruction = this.findInstruction(target);
            if (instruction != null) {
                if (this.myHead != null) {
                    ControlFlowBuilder.addEdge(this.myHead, instruction);
                }
                this.checkPending(continueStatement, instruction);
            }
            this.interruptFlow();
        }
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        GrReturnStatement scopeElement;
        if (returnStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(16);
        }
        boolean isNodeNeeded = this.myHead == null || this.myHead.getElement() != returnStatement;
        GrExpression value2 = returnStatement.getReturnValue();
        if (value2 != null) {
            value2.accept(this);
        }
        GrReturnStatement grReturnStatement = scopeElement = this.myFunctionalScopeStack.isEmpty() ? null : returnStatement;
        if (isNodeNeeded) {
            InstructionImpl returnInstruction = this.startNode(returnStatement);
            this.addPendingEdge(scopeElement, this.myHead);
            this.finishNode(returnInstruction);
        } else {
            this.addPendingEdge(scopeElement, this.myHead);
        }
        this.interruptFlow();
    }

    @Override
    public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
        if (assertStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(17);
        }
        InstructionImpl assertInstruction = this.startNode(assertStatement);
        GrExpression assertion = assertStatement.getAssertion();
        if (assertion != null) {
            GrExpression errorMessage;
            assertion.accept(this);
            InstructionImpl positiveHead = this.myHead;
            List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(assertStatement);
            if (!negations.isEmpty()) {
                this.interruptFlow();
                this.reduceAllNegationsIntoInstruction(assertStatement, negations);
            }
            if ((errorMessage = assertStatement.getErrorMessage()) != null) {
                errorMessage.accept(this);
            }
            this.addNode(new ThrowingInstruction(assertStatement));
            PsiClassType type2 = TypesUtil.createTypeByFQClassName("java.lang.AssertionError", assertStatement);
            ExceptionInfo info = this.findCatch((PsiType)type2);
            if (info != null) {
                info.myThrowers.add(this.myHead);
            } else {
                this.addPendingEdge(null, this.myHead);
            }
            this.myHead = positiveHead;
        }
        this.finishNode(assertInstruction);
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        GrThrowStatement scopeElement;
        GrExpression exception;
        if (throwStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(18);
        }
        if ((exception = throwStatement.getException()) == null) {
            return;
        }
        exception.accept(this);
        ThrowingInstruction throwInstruction = new ThrowingInstruction(throwStatement);
        this.addNodeAndCheckPending(throwInstruction);
        this.interruptFlow();
        PsiType type2 = ControlFlowBuilder.getNominalTypeNoRecursion(exception);
        GrThrowStatement grThrowStatement = scopeElement = this.myFunctionalScopeStack.isEmpty() ? null : throwStatement;
        if (type2 != null) {
            ExceptionInfo info = this.findCatch(type2);
            if (info != null) {
                info.myThrowers.add(throwInstruction);
            } else {
                this.addPendingEdge(scopeElement, throwInstruction);
            }
        } else {
            this.addPendingEdge(scopeElement, throwInstruction);
        }
    }

    @Nullable
    private static PsiType getNominalTypeNoRecursion(@NotNull GrExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(19);
        }
        if (expression instanceof GrNewExpression) {
            return expression.getType();
        }
        if (expression instanceof GrReferenceExpression && ((GrReferenceExpression)expression).getQualifier() == null) {
            return ControlFlowBuilder.getTypeByRef((GrReferenceExpression)expression);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeByRef(@NotNull GrReferenceExpression invoked) {
        PsiElement resolved;
        if (invoked == null) {
            ControlFlowBuilder.$$$reportNull$$$0(20);
        }
        return (resolved = invoked.getStaticReference().resolve()) instanceof PsiVariable ? ((PsiVariable)resolved).getType() : null;
    }

    private void interruptFlow() {
        this.myHead = null;
    }

    @Nullable
    private ExceptionInfo findCatch(PsiType thrownType) {
        Iterator<ExceptionInfo> iterator2 = this.myCaughtExceptionInfos.descendingIterator();
        while (iterator2.hasNext()) {
            PsiType type2;
            ExceptionInfo info = iterator2.next();
            GrCatchClause clause = info.myClause;
            GrParameter parameter = clause.getParameter();
            if (parameter == null || !(type2 = parameter.getType()).isAssignableFrom(thrownType)) continue;
            return info;
        }
        return null;
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(21);
        }
        InstructionImpl instruction = this.startNode(labeledStatement);
        super.visitLabeledStatement(labeledStatement);
        this.finishNode(instruction);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        GrExpression rValue;
        VariableDescriptor descriptor2;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(22);
        }
        GrExpression lValue = expression.getLValue();
        if ((expression.isOperatorAssignment() || expression.getOperationTokenType() == GroovyElementTypes.T_ELVIS_ASSIGN) && lValue instanceof GrReferenceExpression && this.myPolicy.isReferenceAccepted((GrReferenceExpression)lValue) && (descriptor2 = VariableDescriptorFactory.createDescriptor((GrReferenceExpression)lValue)) != null) {
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(this.getDescriptorId(descriptor2), lValue, 1));
        }
        if ((rValue = expression.getRValue()) != null) {
            rValue.accept(this);
        }
        lValue.accept(this);
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        GrExpression rValue;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(23);
        }
        if ((rValue = expression.getRValue()) != null) {
            rValue.accept(this);
        }
        expression.getLValue().accept(this);
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        GrExpression operand;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(24);
        }
        if ((operand = expression.getOperand()) != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
        GrExpression operand;
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(25);
        }
        if ((operand = expression.getOperand()) == null) {
            return;
        }
        if (expression.getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            operand.accept(this);
            this.visitCall(expression);
            return;
        }
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        ConditionInstruction cond = this.registerCondition(expression, false);
        this.addNodeAndCheckPending(cond);
        operand.accept(this);
        this.visitCall(expression);
        this.myConditions = conditionsBefore;
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        InstructionImpl head = this.myHead;
        this.addNodeAndCheckPending(new PositiveGotoInstruction(expression, cond));
        this.handlePossibleReturn(expression);
        this.addPendingEdge(expression, this.myHead);
        this.myHead = negations.isEmpty() ? head : this.reduceAllNegationsIntoInstruction(expression, negations);
    }

    @Nullable
    private InstructionImpl reduceAllNegationsIntoInstruction(GroovyPsiElement currentScope, List<? extends GotoInstruction> negations) {
        if (negations.size() > 1) {
            InstructionImpl instruction = this.addNode(new InstructionImpl(currentScope));
            for (GotoInstruction gotoInstruction : negations) {
                ControlFlowBuilder.addEdge(gotoInstruction, instruction);
            }
            return instruction;
        }
        if (negations.size() == 1) {
            GotoInstruction instruction = negations.get(0);
            this.myHead = instruction;
            return instruction;
        }
        return null;
    }

    private List<GotoInstruction> collectAndRemoveAllPendingNegations(GroovyPsiElement currentScope) {
        ArrayList<GotoInstruction> negations = new ArrayList<GotoInstruction>();
        Iterator<Pair<InstructionImpl, GroovyPsiElement>> iterator2 = this.myPending.iterator();
        while (iterator2.hasNext()) {
            Pair<InstructionImpl, GroovyPsiElement> pair = iterator2.next();
            InstructionImpl instruction = (InstructionImpl)pair.first;
            GroovyPsiElement scope = (GroovyPsiElement)pair.second;
            if (PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)currentScope, (boolean)true) || !(instruction instanceof GotoInstruction)) continue;
            negations.add((GotoInstruction)instruction);
            iterator2.remove();
        }
        return negations;
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(26);
        }
        expression.getOperand().accept(this);
        this.processInstanceOf(expression, GrInstanceOfExpression.isNegated(expression));
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
        if (refExpr == null) {
            ControlFlowBuilder.$$$reportNull$$$0(27);
        }
        super.visitReferenceExpression(refExpr);
        if (this.myPolicy.isReferenceAccepted(refExpr)) {
            VariableDescriptor descriptor2 = VariableDescriptorFactory.createDescriptor(refExpr);
            if (descriptor2 == null) {
                return;
            }
            if (ControlFlowUtils.isIncOrDecOperand(refExpr)) {
                ReadWriteVariableInstruction i2 = new ReadWriteVariableInstruction(this.getDescriptorId(descriptor2), refExpr, 1);
                this.addNodeAndCheckPending(i2);
                this.addNode(new ReadWriteVariableInstruction(this.getDescriptorId(descriptor2), refExpr, -1));
            } else {
                int type2 = PsiUtil.isLValue(refExpr) ? -1 : 1;
                this.addNodeAndCheckPending(new ReadWriteVariableInstruction(this.getDescriptorId(descriptor2), refExpr, type2));
            }
        }
        if (refExpr.isQualified() && !(refExpr.getParent() instanceof GrCall)) {
            this.visitCall(refExpr);
        }
    }

    @Override
    public void visitMethodCall(@NotNull GrMethodCall call) {
        if (call == null) {
            ControlFlowBuilder.$$$reportNull$$$0(28);
        }
        super.visitMethodCall(call);
        this.addNodeAndCheckPending(new ArgumentsInstruction(call, this.myVariableMapping));
        this.visitCall(call);
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (invocation == null) {
            ControlFlowBuilder.$$$reportNull$$$0(29);
        }
        super.visitConstructorInvocation(invocation);
        this.addNodeAndCheckPending(new ArgumentsInstruction(invocation, this.myVariableMapping));
        this.visitCall(invocation);
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        if (newExpression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(30);
        }
        super.visitNewExpression(newExpression);
        this.addNodeAndCheckPending(new ArgumentsInstruction(newExpression, this.myVariableMapping));
        this.visitCall(newExpression);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(31);
        }
        GrExpression left = expression.getLeftOperand();
        GrExpression right = expression.getRightOperand();
        IElementType opType = expression.getOperationTokenType();
        if (ControlFlowBuilderUtil.isInstanceOfBinary(expression)) {
            expression.getLeftOperand().accept(this);
            this.processInstanceOf(expression, GrInExpression.isNegated((GrInExpression)expression));
            return;
        }
        if (opType == GroovyElementTypes.T_EQ || opType == GroovyElementTypes.T_NEQ) {
            if (PsiUtilKt.isNullLiteral(right)) {
                left.accept(this);
                this.processInstanceOf(expression, opType == GroovyElementTypes.T_NEQ);
                return;
            }
            if (right != null && PsiUtilKt.isNullLiteral(left)) {
                right.accept(this);
                this.processInstanceOf(expression, opType == GroovyElementTypes.T_NEQ);
                return;
            }
        }
        if (opType != GroovyTokenTypes.mLOR && opType != GroovyTokenTypes.mLAND && opType != GroovyElementTypes.KW_IN && opType != GroovyElementTypes.T_NOT_IN) {
            left.accept(this);
            if (right != null) {
                right.accept(this);
            }
            this.visitCall(expression);
            return;
        }
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        ConditionInstruction condition = this.registerCondition(expression, false);
        this.addNodeAndCheckPending(condition);
        left.accept(this);
        if (right == null) {
            return;
        }
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        this.visitCall(expression);
        if (opType == GroovyTokenTypes.mLAND) {
            InstructionImpl head = this.myHead;
            if (negations.isEmpty()) {
                this.addNode(new NegatingGotoInstruction(expression, condition));
                this.handlePossibleReturn(expression);
                this.addPendingEdge(expression, this.myHead);
            } else {
                for (GotoInstruction negation : negations) {
                    this.myHead = negation;
                    this.handlePossibleReturn(expression);
                    this.addPendingEdge(expression, this.myHead);
                }
            }
            this.myHead = head;
        } else {
            InstructionImpl instruction = this.addNodeAndCheckPending(new InstructionImpl(expression));
            this.handlePossibleReturn(expression);
            this.addPendingEdge(expression, this.myHead);
            this.myHead = instruction;
            InstructionImpl head = this.reduceAllNegationsIntoInstruction(expression, negations);
            if (head != null) {
                this.myHead = head;
            }
        }
        this.myConditions = conditionsBefore;
        right.accept(this);
    }

    private void processInstanceOf(GrExpression expression, boolean negated) {
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        ConditionInstruction cond = this.registerCondition(expression, negated);
        this.addNodeAndCheckPending(cond);
        this.addNode(new InstanceOfInstruction(expression, cond, this.myVariableMapping));
        NegatingGotoInstruction negation = new NegatingGotoInstruction(expression, cond);
        this.addNode(negation);
        InstructionImpl possibleReturn = this.handlePossibleReturn(expression);
        this.addPendingEdge(expression, possibleReturn != null ? possibleReturn : negation);
        this.myHead = cond;
        this.addNode(new InstanceOfInstruction(expression, cond, this.myVariableMapping));
        this.myConditions = conditionsBefore;
    }

    private void visitCall(GroovyPsiElement call) {
        if (this.myCaughtExceptionInfos.size() <= 0 && this.myFinallyCount <= 0) {
            return;
        }
        ThrowingInstruction instruction = new ThrowingInstruction(call);
        this.addNodeAndCheckPending(instruction);
        for (ExceptionInfo info : this.myCaughtExceptionInfos) {
            info.myThrowers.add(instruction);
        }
        if (this.myFinallyCount > 0) {
            this.addPendingEdge(null, instruction);
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(32);
        }
        InstructionImpl ifInstruction = this.startNode(ifStatement);
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        GrExpression condition = ifStatement.getCondition();
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        InstructionImpl conditionEnd = null;
        InstructionImpl thenEnd = null;
        InstructionImpl elseEnd = null;
        if (condition != null) {
            condition.accept(this);
            conditionEnd = this.myHead;
        }
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(ifStatement);
        if (thenBranch != null) {
            thenBranch.accept(this);
            this.handlePossibleReturn(thenBranch);
            thenEnd = this.myHead;
            this.interruptFlow();
            this.readdPendingEdge(ifStatement);
        }
        this.myHead = this.reduceAllNegationsIntoInstruction(ifStatement, negations);
        if (this.myHead == null && conditionEnd != null) {
            this.myHead = conditionEnd;
        }
        if (elseBranch != null) {
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
            elseEnd = this.myHead;
            this.interruptFlow();
        }
        if (!(thenBranch == null && elseBranch == null || thenEnd == null && elseEnd == null && elseBranch != null)) {
            IfEndInstruction end = new IfEndInstruction(ifStatement);
            this.addNode(end);
            if (thenEnd != null) {
                ControlFlowBuilder.addEdge(thenEnd, end);
            }
            if (elseEnd != null) {
                ControlFlowBuilder.addEdge(elseEnd, end);
            } else if (elseBranch == null) {
                // empty if block
            }
        }
        this.myConditions = conditionsBefore;
        this.finishNode(ifInstruction);
    }

    @NotNull
    private ConditionInstruction registerCondition(@NotNull PsiElement element, boolean negated) {
        if (element == null) {
            ControlFlowBuilder.$$$reportNull$$$0(33);
        }
        ConditionInstruction condition = new ConditionInstruction(element, negated, (Collection<ConditionInstruction>)this.myConditions);
        this.myConditions = this.myConditions.prepend((Object)condition);
        ConditionInstruction conditionInstruction = condition;
        if (conditionInstruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(34);
        }
        return conditionInstruction;
    }

    private void acceptNullable(@Nullable GroovyPsiElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (forStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(35);
        }
        GrForClause clause = forStatement.getClause();
        this.processForLoopInitializer(clause);
        InstructionImpl start = this.startNode(forStatement);
        this.addForLoopBreakingEdge(forStatement, clause);
        this.flushForeachLoopVariable(clause);
        GrStatement body = forStatement.getBody();
        if (body != null) {
            InstructionImpl bodyInstruction = this.startNode(body);
            body.accept(this);
            this.finishNode(bodyInstruction);
        }
        this.checkPending(start);
        if (clause instanceof GrTraditionalForClause) {
            this.acceptNullable(((GrTraditionalForClause)clause).getUpdate());
        }
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, start);
        }
        this.interruptFlow();
        this.finishNode(start);
    }

    private void processForLoopInitializer(@Nullable GrForClause clause) {
        if (clause instanceof GrTraditionalForClause) {
            this.acceptNullable(((GrTraditionalForClause)clause).getInitialization());
        } else if (clause instanceof GrForInClause) {
            GrForInClause forInClause = (GrForInClause)clause;
            this.acceptNullable(forInClause.getIteratedExpression());
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(this.getDescriptorId(new LoopIteratorVariableDescriptor(forInClause)), forInClause, -1));
        }
    }

    private void addForLoopBreakingEdge(GrForStatement forStatement, @Nullable GrForClause clause) {
        GrForStatement target;
        GroovyPsiElement groovyPsiElement = target = forStatement.getParent() instanceof GrLabeledStatement ? (GroovyPsiElement)forStatement.getParent() : forStatement;
        if (clause instanceof GrTraditionalForClause) {
            GrExpression condition = ((GrTraditionalForClause)clause).getCondition();
            if (condition != null) {
                condition.accept(this);
                if (!ControlFlowBuilder.alwaysTrue(condition)) {
                    this.addPendingEdge(target, this.myHead);
                }
            }
        } else {
            this.addPendingEdge(target, this.myHead);
        }
    }

    private void flushForeachLoopVariable(@Nullable GrForClause clause) {
        GrVariable variable;
        if (clause instanceof GrForInClause && (variable = ((GrForInClause)clause).getDeclaredVariable()) != null && this.myPolicy.isVariableInitialized(variable)) {
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(this.getDescriptorId(new LoopIteratorVariableDescriptor((GrForInClause)clause)), variable, 1));
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(this.getDescriptorId(VariableDescriptorFactory.createDescriptor(variable)), variable, -1));
        }
    }

    @NotNull
    private List<Pair<InstructionImpl, GroovyPsiElement>> collectCorrespondingPendingEdges(@Nullable PsiElement currentScope) {
        if (currentScope == null) {
            List<Pair<InstructionImpl, GroovyPsiElement>> result2 = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            List<Pair<InstructionImpl, GroovyPsiElement>> list = result2;
            if (list == null) {
                ControlFlowBuilder.$$$reportNull$$$0(36);
            }
            return list;
        }
        ArrayList<Pair<InstructionImpl, GroovyPsiElement>> targets = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        for (int i2 = this.myPending.size() - 1; i2 >= 0; --i2) {
            Pair<InstructionImpl, GroovyPsiElement> pair = this.myPending.get(i2);
            PsiElement scopeWhenToAdd = (PsiElement)pair.getSecond();
            if (scopeWhenToAdd == null) continue;
            if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)currentScope, (boolean)false)) break;
            targets.add(pair);
            this.myPending.remove(i2);
        }
        ArrayList<Pair<InstructionImpl, GroovyPsiElement>> arrayList = targets;
        if (arrayList == null) {
            ControlFlowBuilder.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    private void checkPending(@NotNull InstructionImpl instruction) {
        if (instruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(38);
        }
        PsiElement element = instruction.getElement();
        this.checkPending(element, instruction);
    }

    private void checkPending(@Nullable PsiElement currentScope, @NotNull InstructionImpl targetInstruction) {
        if (targetInstruction == null) {
            ControlFlowBuilder.$$$reportNull$$$0(39);
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> pendingEdges = this.collectCorrespondingPendingEdges(currentScope);
        for (Pair<InstructionImpl, GroovyPsiElement> pair : pendingEdges) {
            ControlFlowBuilder.addEdge((InstructionImpl)pair.getFirst(), targetInstruction);
        }
    }

    private void readdPendingEdge(@Nullable GroovyPsiElement newScope) {
        List<Pair<InstructionImpl, GroovyPsiElement>> targets = this.collectCorrespondingPendingEdges(newScope);
        for (Pair<InstructionImpl, GroovyPsiElement> target : targets) {
            this.addPendingEdge(newScope, (InstructionImpl)target.getFirst());
        }
    }

    private void addPendingEdge(@Nullable GroovyPsiElement scopeWhenAdded, InstructionImpl instruction) {
        int i2;
        if (instruction == null) {
            return;
        }
        if (scopeWhenAdded != null) {
            Pair<InstructionImpl, GroovyPsiElement> pair;
            GroovyPsiElement currScope;
            for (i2 = 0; i2 < this.myPending.size() && ((currScope = (GroovyPsiElement)(pair = this.myPending.get(i2)).getSecond()) == null || PsiTreeUtil.isAncestor((PsiElement)currScope, (PsiElement)scopeWhenAdded, (boolean)true)); ++i2) {
            }
        }
        this.myPending.add(i2, (Pair<InstructionImpl, GroovyPsiElement>)Pair.create((Object)instruction, (Object)scopeWhenAdded));
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
        GrStatement body;
        if (whileStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(40);
        }
        InstructionImpl instruction = this.startNode(whileStatement);
        GrExpression condition = whileStatement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if (!ControlFlowBuilder.alwaysTrue(condition)) {
            this.addPendingEdge(whileStatement, this.myHead);
        }
        if ((body = whileStatement.getBody()) != null) {
            body.accept(this);
        }
        this.checkPending(instruction);
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, instruction);
        }
        this.interruptFlow();
        this.finishNode(instruction);
    }

    private static boolean alwaysTrue(GroovyPsiElement condition) {
        if (condition instanceof GrExpression) {
            return Boolean.TRUE.equals(GroovyConstantExpressionEvaluator.evaluateNoResolve((GrExpression)condition));
        }
        return false;
    }

    private void visitSwitchElement(@NotNull GrSwitchElement switchElement) {
        GrExpression condition;
        if (switchElement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(41);
        }
        if ((condition = switchElement.getCondition()) != null) {
            condition.accept(this);
        }
        InstructionImpl instruction = this.startNode(switchElement);
        GrCaseSection[] sections = switchElement.getCaseSections();
        if (!ControlFlowBuilder.containsAllCases(switchElement)) {
            this.addPendingEdge(switchElement, instruction);
        }
        FList<ConditionInstruction> conditionsBefore = this.myConditions;
        for (GrCaseSection section : sections) {
            Object expressionPattern;
            this.myConditions = conditionsBefore;
            this.myHead = instruction;
            Object[] expressionPatterns = section.getExpressions();
            if (!section.isDefault() && expressionPatterns.length > 0 && ContainerUtil.and((Object[])expressionPatterns, expr -> expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).getStaticReference().resolve() instanceof PsiClass) && (expressionPattern = expressionPatterns[0]) != null && expressionPattern.getParent() instanceof GrExpressionList) {
                ConditionInstruction cond = this.registerCondition(section, false);
                this.addNodeAndCheckPending(cond);
                this.addNode(new InstanceOfInstruction((GroovyPsiElement)expressionPattern.getParent(), cond, this.myVariableMapping));
            }
            section.accept(this);
        }
        this.myConditions = conditionsBefore;
        this.finishNode(instruction);
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(42);
        }
        this.visitSwitchElement(switchStatement);
    }

    @Override
    public void visitSwitchExpression(@NotNull GrSwitchExpression switchExpression) {
        if (switchExpression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(43);
        }
        this.visitSwitchElement(switchExpression);
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(44);
        }
        GrExpression condition = expression.getCondition();
        GrExpression thenBranch = expression.getThenBranch();
        GrExpression elseBranch = expression.getElseBranch();
        condition.accept(this);
        InstructionImpl conditionEnd = this.myHead;
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        if (thenBranch != null) {
            thenBranch.accept(this);
            this.handlePossibleReturn(thenBranch);
            this.addPendingEdge(expression, this.myHead);
        }
        if (elseBranch != null) {
            InstructionImpl head = this.reduceAllNegationsIntoInstruction(expression, negations);
            this.myHead = head != null ? head : conditionEnd;
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
        }
    }

    @Override
    public void visitElvisExpression(@NotNull GrElvisExpression expression) {
        if (expression == null) {
            ControlFlowBuilder.$$$reportNull$$$0(45);
        }
        GrExpression condition = expression.getCondition();
        GrExpression elseBranch = expression.getElseBranch();
        condition.accept(this);
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        InstructionImpl head = this.myHead;
        this.handlePossibleReturn(condition);
        this.addPendingEdge(expression, this.myHead);
        this.myHead = head;
        if (elseBranch != null) {
            head = this.reduceAllNegationsIntoInstruction(expression, negations);
            if (head != null) {
                this.myHead = head;
            }
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
        }
    }

    private static boolean containsAllCases(GrSwitchElement statement) {
        PsiClass resolved;
        GrCaseSection[] sections;
        for (GrCaseSection section : sections = statement.getCaseSections()) {
            if (!section.isDefault()) continue;
            return true;
        }
        GrExpression condition = statement.getCondition();
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        PsiType type2 = TypesUtil.unboxPrimitiveTypeWrapper(ControlFlowBuilder.getNominalTypeNoRecursion(condition));
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiPrimitiveType) {
            if (PsiTypes.booleanType().equals((Object)type2)) {
                return sections.length == 2;
            }
            if (PsiTypes.byteType().equals((Object)type2) || PsiTypes.charType().equals((Object)type2)) {
                return sections.length == 128;
            }
            return false;
        }
        if (type2 instanceof PsiClassType && (resolved = ((PsiClassType)type2).resolve()) != null && resolved.isEnum()) {
            PsiField[] fields;
            int enumConstantCount = 0;
            for (PsiField field : fields = resolved.getFields()) {
                if (!(field instanceof PsiEnumConstant)) continue;
                ++enumConstantCount;
            }
            if (sections.length == enumConstantCount) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        int i2;
        if (caseSection == null) {
            ControlFlowBuilder.$$$reportNull$$$0(46);
        }
        for (GrExpression value2 : caseSection.getExpressions()) {
            if (value2 == null) continue;
            value2.accept(this);
        }
        GrStatement[] statements2 = caseSection.getStatements();
        for (i2 = statements2.length - 1; i2 >= 0 && statements2[i2] instanceof GrBreakStatement; --i2) {
        }
        for (int j = 0; j < statements2.length; ++j) {
            GrStatement statement = statements2[j];
            statement.accept(this);
            if (j != i2) continue;
            this.handlePossibleReturn(statement);
        }
        if (statements2.length > 0) {
            this.handlePossibleYield(statements2[statements2.length - 1]);
        }
        if (this.myHead != null) {
            this.addPendingEdge(caseSection, this.myHead);
        }
        if (caseSection.getArrow() != null) {
            PsiElement parent2 = caseSection.getParent();
            if (parent2 instanceof GrSwitchElement) {
                this.readdPendingEdge((GroovyPsiElement)parent2);
            }
            this.interruptFlow();
        }
    }

    private void handlePossibleYield(GrStatement statement) {
        if (statement instanceof GrExpression && ControlFlowBuilderUtil.isCertainlyYieldStatement(statement)) {
            this.addNodeAndCheckPending(new MaybeYieldInstruction((GrExpression)statement));
        }
    }

    @Override
    public void visitYieldStatement(@NotNull GrYieldStatement yieldStatement) {
        GrExpression value2;
        if (yieldStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(47);
        }
        if ((value2 = yieldStatement.getYieldedValue()) != null) {
            value2.accept(this);
        }
        if (this.myHead != null) {
            GrSwitchElement correspondingSwitch = (GrSwitchElement)PsiTreeUtil.getParentOfType((PsiElement)yieldStatement, GrSwitchElement.class);
            this.addNode(new InstructionImpl(yieldStatement));
            this.addPendingEdge(correspondingSwitch, this.myHead);
        }
        this.interruptFlow();
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement tryCatchStatement) {
        GrTryResourceList resourceList;
        if (tryCatchStatement == null) {
            ControlFlowBuilder.$$$reportNull$$$0(48);
        }
        GrOpenBlock tryBlock = tryCatchStatement.getTryBlock();
        GrCatchClause[] catchClauses = tryCatchStatement.getCatchClauses();
        GrFinallyClause finallyClause = tryCatchStatement.getFinallyClause();
        for (int i2 = catchClauses.length - 1; i2 >= 0; --i2) {
            this.myCaughtExceptionInfos.push(new ExceptionInfo(catchClauses[i2]));
        }
        if (finallyClause != null) {
            ++this.myFinallyCount;
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> oldPending = null;
        if (finallyClause != null) {
            oldPending = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        }
        if ((resourceList = tryCatchStatement.getResourceList()) != null) {
            resourceList.accept(this);
        }
        InstructionImpl tryBegin = this.startNode(tryBlock);
        if (tryBlock != null) {
            tryBlock.accept(this);
        }
        InstructionImpl tryEnd = this.myHead;
        this.finishNode(tryBegin);
        LinkedHashSet<Pair<InstructionImpl, GroovyPsiElement>> pendingAfterTry = new LinkedHashSet<Pair<InstructionImpl, GroovyPsiElement>>(this.myPending);
        List[] throwers = new List[catchClauses.length];
        for (int i3 = 0; i3 < catchClauses.length; ++i3) {
            throwers[i3] = this.myCaughtExceptionInfos.pop().myThrowers;
        }
        InstructionImpl[] catches = new InstructionImpl[catchClauses.length];
        for (int i4 = 0; i4 < catchClauses.length; ++i4) {
            this.interruptFlow();
            InstructionImpl catchBeg = this.startNode(catchClauses[i4]);
            for (InstructionImpl[] thrower : throwers[i4]) {
                ControlFlowBuilder.addEdge((InstructionImpl)thrower, catchBeg);
            }
            GrParameter parameter = catchClauses[i4].getParameter();
            if (parameter != null && this.myPolicy.isVariableInitialized(parameter)) {
                this.addNode(new ReadWriteVariableInstruction(this.getDescriptorId(VariableDescriptorFactory.createDescriptor(parameter)), parameter, -1));
            }
            catchClauses[i4].accept(this);
            catches[i4] = this.myHead;
            this.finishNode(catchBeg);
        }
        pendingAfterTry.addAll(this.myPending);
        this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>(pendingAfterTry);
        if (finallyClause != null) {
            --this.myFinallyCount;
            this.interruptFlow();
            InstructionImpl finallyInstruction = this.startNode(finallyClause, false);
            LinkedHashSet<AfterCallInstruction> postCalls = new LinkedHashSet<AfterCallInstruction>();
            List<Pair<InstructionImpl, GroovyPsiElement>> copy = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            for (Pair pair : copy) {
                postCalls.add(this.addCallNode(finallyInstruction, (GroovyPsiElement)pair.getSecond(), (InstructionImpl)pair.getFirst()));
            }
            if (tryEnd != null) {
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, tryEnd));
            }
            for (InstructionImpl catchEnd : catches) {
                if (catchEnd == null) continue;
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, catchEnd));
            }
            List<Pair<InstructionImpl, GroovyPsiElement>> pendingPostCalls = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            this.myHead = finallyInstruction;
            finallyClause.accept(this);
            ReturnInstruction returnInstruction = new ReturnInstruction(finallyClause);
            for (AfterCallInstruction postCall : postCalls) {
                postCall.setReturnInstruction(returnInstruction);
                ControlFlowBuilder.addEdge(returnInstruction, postCall);
            }
            this.addNodeAndCheckPending(returnInstruction);
            this.interruptFlow();
            this.finishNode(finallyInstruction);
            if (oldPending == null) {
                this.error();
            }
            oldPending.addAll(pendingPostCalls);
            this.myPending = oldPending;
        } else {
            if (tryEnd != null) {
                this.addPendingEdge(tryCatchStatement, tryEnd);
            }
            for (InstructionImpl catchEnd : catches) {
                this.addPendingEdge(tryBlock, catchEnd);
            }
        }
    }

    private void error() {
        this.error("broken control flow for a scope");
    }

    private void error(@NonNls @NotNull String descr) {
        PsiFile file;
        if (descr == null) {
            ControlFlowBuilder.$$$reportNull$$$0(49);
        }
        String fileText = (file = this.myScope.getContainingFile()) != null ? file.getText() : null;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        String path = virtualFile == null ? null : virtualFile.getPresentableUrl();
        LOG.error(descr + this.myScope.getText(), new Attachment[]{new Attachment(String.valueOf(path), String.valueOf(fileText))});
    }

    private AfterCallInstruction addCallNode(InstructionImpl finallyInstruction, GroovyPsiElement scopeWhenAdded, InstructionImpl src) {
        this.interruptFlow();
        CallInstruction call = new CallInstruction(finallyInstruction);
        this.addNode(call);
        ControlFlowBuilder.addEdge(src, call);
        ControlFlowBuilder.addEdge(call, finallyInstruction);
        AfterCallInstruction afterCall = new AfterCallInstruction(call);
        this.addNode(afterCall);
        this.addPendingEdge(scopeWhenAdded, afterCall);
        return afterCall;
    }

    private InstructionImpl startNode(@Nullable GroovyPsiElement element) {
        return this.startNode(element, true);
    }

    private InstructionImpl startNode(@Nullable GroovyPsiElement element, boolean checkPending) {
        InstructionImpl instruction = new InstructionImpl(element);
        this.addNode(instruction);
        if (checkPending) {
            this.checkPending(instruction);
        }
        this.myProcessingStack.push(instruction);
        return instruction;
    }

    private void finishNode(InstructionImpl instruction) {
        InstructionImpl popped = this.myProcessingStack.pop();
        if (!instruction.equals(popped)) {
            String description = "popped  : " + popped.toString() + " : " + popped.hashCode() + ", " + popped.getClass() + "\nexpected: " + instruction.toString() + " : " + instruction.hashCode() + ", " + instruction.getClass() + "\nsame objects: " + (popped == instruction) + "\n";
            this.error(description);
        }
    }

    @Override
    public void visitField(@NotNull GrField field) {
        if (field == null) {
            ControlFlowBuilder.$$$reportNull$$$0(50);
        }
    }

    @Override
    public void visitParameter(@NotNull GrParameter parameter) {
        if (parameter == null) {
            ControlFlowBuilder.$$$reportNull$$$0(51);
        }
        if (parameter.getParent() instanceof GrForClause) {
            this.visitVariable(parameter);
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            ControlFlowBuilder.$$$reportNull$$$0(52);
        }
    }

    @Override
    public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
        if (initializer == null) {
            ControlFlowBuilder.$$$reportNull$$$0(53);
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            ControlFlowBuilder.$$$reportNull$$$0(54);
        }
        if (!(typeDefinition instanceof GrAnonymousClassDefinition)) {
            return;
        }
        GrArgumentList argumentList = ((GrAnonymousClassDefinition)typeDefinition).getArgumentListGroovy();
        if (argumentList != null) {
            argumentList.accept(this);
        }
        List<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>> vars = ControlFlowBuilder.collectUsedVariableWithoutInitialization(typeDefinition);
        this.addReadFromNestedControlFlow(typeDefinition, vars);
    }

    private static List<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>> collectUsedVariableWithoutInitialization(GrTypeDefinition typeDefinition) {
        final LinkedHashSet vars = new LinkedHashSet();
        typeDefinition.acceptChildren(new GroovyRecursiveElementVisitor(){

            private void collectVars(GroovyControlFlow flow) {
                List<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>> reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(flow, false);
                vars.addAll(reads);
            }

            @Override
            public void visitField(@NotNull GrField field) {
                GrExpression initializer;
                if (field == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((initializer = field.getInitializerGroovy()) != null) {
                    GroovyControlFlow flow = ControlFlowBuilder.buildControlFlow(initializer);
                    this.collectVars(flow);
                }
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                GrOpenBlock block;
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((block = method.getBlock()) != null) {
                    this.collectVars(ControlFlowUtils.getGroovyControlFlow(block));
                }
            }

            @Override
            public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                if (initializer == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.collectVars(ControlFlowUtils.getGroovyControlFlow(initializer.getBlock()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "field";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return new ArrayList<kotlin.Pair<ReadWriteVariableInstruction, VariableDescriptor>>(vars);
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            ControlFlowBuilder.$$$reportNull$$$0(55);
        }
        super.visitVariable(variable);
        if (this.myPolicy.isVariableInitialized(variable)) {
            ReadWriteVariableInstruction writeInst = new ReadWriteVariableInstruction(this.getDescriptorId(VariableDescriptorFactory.createDescriptor(variable)), variable, -1);
            this.addNodeAndCheckPending(writeInst);
        }
    }

    @Nullable
    private InstructionImpl findInstruction(PsiElement element) {
        for (InstructionImpl instruction : this.myInstructions) {
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            ControlFlowBuilder.$$$reportNull$$$0(56);
        }
        ProgressManager.checkCanceled();
        super.visitElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 34, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleReturn";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 10: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 11: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continueStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertStatement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 33: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInstruction";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchElement";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSection";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yieldStatement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryCatchStatement";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descr";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFlatControlFlow";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildControlFlow";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "registerCondition";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCorrespondingPendingEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitOpenBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionLambdaBody";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockLambdaBody";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handlePossibleReturn";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildControlFlow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildFlatControlFlow";
                break;
            }
            case 7: 
            case 10: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitClosure";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addReadFromNestedControlFlow";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitAssertStatement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNominalTypeNoRecursion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByRef";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitTupleAssignmentExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitUnaryExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitInstanceofExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodCall";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitConstructorInvocation";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitNewExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerCondition";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkPending";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchElement";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitElvisExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitCaseSection";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitYieldStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitParameter";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeDefinition";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitVariable";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 34, 36, 37 -> new IllegalStateException(string);
        };
    }

    private static final class ExceptionInfo {
        final GrCatchClause myClause;
        final List<InstructionImpl> myThrowers = new ArrayList<InstructionImpl>();

        private ExceptionInfo(GrCatchClause clause) {
            this.myClause = clause;
        }
    }
}

