/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codehaus.groovy.syntax.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\nH\u0002\u001a\f\u0010\r\u001a\u00020\f*\u0004\u0018\u00010\u000e\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"zeros", "", "", "getLiteralType", "Lcom/intellij/psi/PsiType;", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "parseInteger", "", "literalText", "", "hasIntegerSuffix", "", "isZero", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "intellij.groovy.psi"})
public final class LiteralUtilKt {
    @NotNull
    private static final Set<Object> zeros;

    @Nullable
    public static final Number parseInteger(@NotNull String literalText) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)literalText, (String)"literalText");
        try {
            number = Numbers.parseInteger((String)literalText);
        }
        catch (NumberFormatException e) {
            number = null;
        }
        return number;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final PsiType getLiteralType(@NotNull GrLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        elemType = GrLiteralImpl.getLiteralType(literal);
        if (elemType == GroovyElementTypes.KW_NULL) {
            return PsiTypes.nullType();
        }
        if (!Intrinsics.areEqual((Object)elemType, (Object)GroovyElementTypes.NUM_INT)) ** GOTO lbl-1000
        text = literal.getText();
        $i$a$-let-LiteralUtilKt$getLiteralType$integerLiteralWithoutSuffix$1 = false;
        Intrinsics.checkNotNull((Object)text);
        if (LiteralUtilKt.hasIntegerSuffix(text) == false) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = integerLiteralWithoutSuffix = false;
        }
        if (!integerLiteralWithoutSuffix) ** GOTO lbl25
        var4_2 = literal.getValue();
        if (var4_2 instanceof Integer) {
            v1 = "java.lang.Integer";
        } else if (var4_2 instanceof Long) {
            v1 = "java.lang.Long";
        } else if (var4_2 instanceof BigInteger) {
            v1 = "java.math.BigInteger";
        } else {
            return null;
lbl25:
            // 1 sources

            v1 = TypesUtil.getBoxedTypeName(elemType);
            if (v1 == null) {
                return null;
            }
        }
        fqn = v1;
        return (PsiType)TypesUtil.createTypeByFQClassName(fqn, literal);
    }

    private static final boolean hasIntegerSuffix(String $this$hasIntegerSuffix) {
        return StringsKt.endsWith$default((CharSequence)$this$hasIntegerSuffix, (char)'i', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)$this$hasIntegerSuffix, (char)'I', (boolean)false, (int)2, null);
    }

    public static final boolean isZero(@Nullable GrExpression $this$isZero) {
        if (!($this$isZero instanceof GrLiteral)) {
            return false;
        }
        Object value2 = ((GrLiteral)$this$isZero).getValue();
        return CollectionsKt.contains((Iterable)zeros, (Object)value2) || value2 instanceof BigDecimal && ((BigDecimal)value2).compareTo(BigDecimal.ZERO) == 0;
    }

    static {
        Object[] objectArray = new Object[5];
        objectArray[0] = 0;
        objectArray[1] = 0L;
        objectArray[2] = Float.valueOf(0.0f);
        objectArray[3] = 0.0;
        Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(0L), (String)"valueOf(this.toLong())");
        zeros = SetsKt.setOf((Object[])objectArray);
    }
}

