/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.TailType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;

public class FieldInitializerTailTypes
extends TailType {
    public static final TailType EQ_CLOSURE = new FieldInitializerTailTypes("{}", 1);
    public static final TailType EQ_ARRAY = new FieldInitializerTailTypes("[]", 1);
    public static final TailType EQ_STRING_ARRAY = new FieldInitializerTailTypes("['']", 2);
    public static final TailType EQ_STRING = new FieldInitializerTailTypes("\"\"", 1);
    private final String myText;
    private final int myPosition;

    public FieldInitializerTailTypes(String text, int position) {
        this.myText = text;
        this.myPosition = position;
    }

    public int processTail(Editor editor, int tailOffset) {
        CommonCodeStyleSettings styleSettings = CodeStyle.getLocalLanguageSettings((Editor)editor, (int)tailOffset);
        Document document = editor.getDocument();
        CharSequence chars2 = document.getCharsSequence();
        int textLength = chars2.length();
        if (tailOffset < textLength - 1 && chars2.charAt(tailOffset) == ' ' && chars2.charAt(tailOffset + 1) == '=') {
            return FieldInitializerTailTypes.moveCaret((Editor)editor, (int)tailOffset, (int)2);
        }
        if (tailOffset < textLength && chars2.charAt(tailOffset) == '=') {
            return FieldInitializerTailTypes.moveCaret((Editor)editor, (int)tailOffset, (int)1);
        }
        if (styleSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS) {
            document.insertString(tailOffset, (CharSequence)" =");
            tailOffset = FieldInitializerTailTypes.moveCaret((Editor)editor, (int)tailOffset, (int)2);
        } else {
            document.insertString(tailOffset, (CharSequence)"=");
            tailOffset = FieldInitializerTailTypes.moveCaret((Editor)editor, (int)tailOffset, (int)1);
        }
        if (styleSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS) {
            tailOffset = FieldInitializerTailTypes.insertChar((Editor)editor, (int)tailOffset, (char)' ');
        }
        document.insertString(tailOffset, (CharSequence)this.myText);
        return FieldInitializerTailTypes.moveCaret((Editor)editor, (int)tailOffset, (int)this.myPosition);
    }
}

