/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cache.client;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.cache.JpsCachesLoaderUtil;
import org.jetbrains.jps.cache.client.JpsNettyClient;
import org.jetbrains.jps.cache.client.JpsServerAuthUtil;
import org.jetbrains.jps.cache.client.JpsServerConnectionUtil;
import org.jetbrains.jps.cache.model.DownloadableFileUrl;
import org.jetbrains.jps.cache.model.JpsLoaderContext;

final class JpsCachesDownloader {
    private static final Logger LOG = Logger.getInstance(JpsCachesDownloader.class);
    private static final byte MAX_RETRY_COUNT = 3;
    private static final String CDN_CACHE_HEADER = "X-Cache";
    private int hitsCount;
    private final List<DownloadableFileUrl> myFilesDescriptions;
    private final JpsNettyClient myNettyClient;
    private final JpsLoaderContext myContext;

    JpsCachesDownloader(@NotNull List<DownloadableFileUrl> filesDescriptions, @NotNull JpsNettyClient nettyClient, @Nullable JpsLoaderContext context) {
        if (filesDescriptions == null) {
            JpsCachesDownloader.$$$reportNull$$$0(0);
        }
        if (nettyClient == null) {
            JpsCachesDownloader.$$$reportNull$$$0(1);
        }
        this.hitsCount = 0;
        this.myFilesDescriptions = filesDescriptions;
        this.myNettyClient = nettyClient;
        this.myContext = context;
    }

    @NotNull
    List<Pair<File, DownloadableFileUrl>> download(@NotNull File targetDir) throws IOException {
        ArrayList<Pair<File, DownloadableFileUrl>> arrayList;
        if (targetDir == null) {
            JpsCachesDownloader.$$$reportNull$$$0(2);
        }
        CopyOnWriteArrayList<Pair<File, DownloadableFileUrl>> downloadedFiles = new CopyOnWriteArrayList<Pair<File, DownloadableFileUrl>>();
        CopyOnWriteArrayList existingFiles = new CopyOnWriteArrayList();
        try {
            int expectedDownloads = this.myContext != null ? this.myContext.getTotalExpectedDownloads() : 0;
            this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.downloading.0.files.text", this.myFilesDescriptions.size()));
            long start = System.currentTimeMillis();
            ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
            AtomicLong totalSize = new AtomicLong();
            for (DownloadableFileUrl downloadableFileUrl : this.myFilesDescriptions) {
                results.add(JpsCachesLoaderUtil.EXECUTOR_SERVICE.submit(() -> {
                    if (this.myContext != null) {
                        this.myContext.checkCanceled();
                    }
                    File existing = new File(targetDir, description.getDefaultFileName());
                    byte attempt = 0;
                    File downloaded = null;
                    while (downloaded == null) {
                        attempt = (byte)(attempt + 1);
                        try {
                            downloaded = this.downloadFile(description, existing, expectedDownloads);
                        }
                        catch (IOException e) {
                            if (attempt != 3) {
                                LOG.info("Failed to download " + description.getDownloadUrl() + " Root cause: " + e + ". Attempt " + attempt + " to download file again");
                                Thread.sleep(250L);
                                continue;
                            }
                            throw new IOException(JpsBuildBundle.message("error.file.download.failed", description.getDownloadUrl(), e.getMessage()), e);
                        }
                    }
                    assert (downloaded != null) : "Download result shouldn't be NULL";
                    if (FileUtil.filesEqual(downloaded, (File)existing)) {
                        existingFiles.add(Pair.create((Object)existing, (Object)description));
                    } else {
                        totalSize.addAndGet(downloaded.length());
                        downloadedFiles.add(Pair.create((Object)downloaded, (Object)description));
                    }
                    return null;
                }));
            }
            for (Future future : results) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    if (e.getCause() instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)e.getCause();
                    }
                    LOG.error((Throwable)e);
                }
            }
            long duration = System.currentTimeMillis() - start;
            LOG.info("Downloaded " + StringUtil.formatFileSize((long)totalSize.get()) + " in " + StringUtil.formatDuration((long)duration) + "(" + duration + "ms). Percentage of CDN cache hits: " + this.hitsCount * 100 / this.myFilesDescriptions.size() + "%");
            ArrayList<Pair<File, DownloadableFileUrl>> localFiles = new ArrayList<Pair<File, DownloadableFileUrl>>();
            localFiles.addAll(JpsCachesDownloader.moveToDir(downloadedFiles, targetDir));
            localFiles.addAll(existingFiles);
            arrayList = localFiles;
        }
        catch (ProcessCanceledException | IOException e) {
            for (Pair pair : downloadedFiles) {
                FileUtil.delete((File)((File)pair.getFirst()));
            }
            throw e;
        }
        if (arrayList == null) {
            JpsCachesDownloader.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private File downloadFile(@NotNull DownloadableFileUrl description, @NotNull File existingFile, int expectedDownloads) throws IOException {
        if (description == null) {
            JpsCachesDownloader.$$$reportNull$$$0(4);
        }
        if (existingFile == null) {
            JpsCachesDownloader.$$$reportNull$$$0(5);
        }
        String presentableUrl = description.getPresentableDownloadUrl();
        Map<String, String> headers = JpsServerAuthUtil.getRequestHeaders();
        try (CloseableHttpClient client = HttpClientBuilder.create().disableAutomaticRetries().build();){
            HttpGet httpRequest = new HttpGet(description.getDownloadUrl());
            headers.forEach((k, v) -> httpRequest.setHeader(k, v));
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpRequest);
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == 200) {
                long size = responseEntity.getContentLength();
                if (existingFile.exists() && size == existingFile.length()) {
                    File file = existingFile;
                    File file2 = file;
                    if (file2 == null) {
                        JpsCachesDownloader.$$$reportNull$$$0(6);
                    }
                    return file2;
                }
                Header header = response.getFirstHeader(CDN_CACHE_HEADER);
                if (header != null && header.getValue().startsWith("Hit")) {
                    ++this.hitsCount;
                }
                this.myNettyClient.sendDescriptionStatusMessage(JpsBuildBundle.message("progress.download.file.text", description.getPresentableFileName(), presentableUrl), expectedDownloads);
                File file = JpsServerConnectionUtil.saveToFile(FileUtil.createTempFile((String)"download.", (String)".tmp").toPath(), responseEntity, this.myContext).toFile();
                File file3 = file;
                if (file3 == null) {
                    JpsCachesDownloader.$$$reportNull$$$0(7);
                }
                return file3;
            }
            String errorText = StreamUtil.readText((Reader)new InputStreamReader(responseEntity.getContent(), StandardCharsets.UTF_8));
            throw new IOException("Request: " + description.getDownloadUrl() + " Error: " + response.getStatusLine().getStatusCode() + " body: " + errorText);
        }
    }

    private static List<Pair<File, DownloadableFileUrl>> moveToDir(List<Pair<File, DownloadableFileUrl>> downloadedFiles, File targetDir) throws IOException {
        FileUtil.createDirectory((File)targetDir);
        ArrayList<Pair<File, DownloadableFileUrl>> result = new ArrayList<Pair<File, DownloadableFileUrl>>();
        for (Pair<File, DownloadableFileUrl> pair : downloadedFiles) {
            DownloadableFileUrl description = (DownloadableFileUrl)pair.getSecond();
            String fileName = description.generateFileName((Condition<? super String>)((Condition)s -> !new File(targetDir, (String)s).exists()));
            File toFile = new File(targetDir, fileName);
            FileUtil.rename((File)((File)pair.getFirst()), (File)toFile);
            result.add((Pair<File, DownloadableFileUrl>)Pair.create((Object)toFile, (Object)description));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesDescriptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nettyClient";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cache/client/JpsCachesDownloader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cache/client/JpsCachesDownloader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

