/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.intellij.openapi.util.io.FileUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.dependency.MapletFactory;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.SerializableGraphElement;
import org.jetbrains.jps.dependency.impl.MemorySetMultiMaplet;
import org.jetbrains.jps.dependency.impl.PersistentSetMultiMaplet;

public final class Containers {
    public static final MapletFactory MEMORY_CONTAINER_FACTORY = new MapletFactory(){

        @Override
        public <K extends SerializableGraphElement, V extends SerializableGraphElement> MultiMaplet<K, V> createSetMultiMaplet(String storageName) {
            return new MemorySetMultiMaplet();
        }
    };

    public static MapletFactory createPersistentContainerFactory(String rootDirPath) {
        return new PersistentMapletFactory(rootDirPath);
    }

    public static <K, V> Map<K, V> createCustomPolicyMap(BiFunction<? super K, ? super K, Boolean> keyEqualsImpl, Function<? super K, Integer> keyHashCodeImpl) {
        return new Object2ObjectOpenCustomHashMap(Containers.asStrategy(keyEqualsImpl, keyHashCodeImpl));
    }

    public static <T> Set<T> createCustomPolicySet(BiFunction<? super T, ? super T, Boolean> equalsImpl, Function<? super T, Integer> hashCodeImpl) {
        return new ObjectOpenCustomHashSet(Containers.asStrategy(equalsImpl, hashCodeImpl));
    }

    public static <T> Set<T> createCustomPolicySet(Collection<? extends T> col, BiFunction<? super T, ? super T, Boolean> equalsImpl, Function<? super T, Integer> hashCodeImpl) {
        return new ObjectOpenCustomHashSet(col, Containers.asStrategy(equalsImpl, hashCodeImpl));
    }

    @NotNull
    private static <T> Hash.Strategy<T> asStrategy(final BiFunction<? super T, ? super T, Boolean> equalsImpl, final Function<? super T, Integer> hashCodeImpl) {
        return new Hash.Strategy<T>(){

            public int hashCode(@Nullable T o) {
                return (Integer)hashCodeImpl.apply(o);
            }

            public boolean equals(@Nullable T a, @Nullable T b) {
                return (Boolean)equalsImpl.apply(a, b);
            }
        };
    }

    private static class PersistentMapletFactory
    implements MapletFactory,
    Closeable {
        private final String myRootDirPath;
        private final List<PersistentSetMultiMaplet<?, ?>> myContainers = new ArrayList();

        PersistentMapletFactory(String rootDirPath) {
            this.myRootDirPath = rootDirPath;
        }

        @Override
        public <K extends SerializableGraphElement, V extends SerializableGraphElement> MultiMaplet<K, V> createSetMultiMaplet(String storageName) {
            PersistentSetMultiMaplet container = new PersistentSetMultiMaplet(this.getMapFile(storageName));
            this.myContainers.add(container);
            return container;
        }

        @Override
        public void close() {
            Throwable ex = null;
            for (PersistentSetMultiMaplet<?, ?> container : this.myContainers) {
                try {
                    container.close();
                }
                catch (Throwable e) {
                    if (ex != null) continue;
                    ex = e;
                }
            }
            this.myContainers.clear();
            if (ex instanceof IOException) {
                throw new BuildDataCorruptedException((IOException)ex);
            }
            if (ex != null) {
                throw new RuntimeException(ex);
            }
        }

        private Path getMapFile(String name) {
            File file = new File(this.myRootDirPath, name);
            FileUtil.createIfDoesntExist((File)file);
            return file.toPath();
        }
    }
}

