/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.javac.Iterators;

public final class MemorySetMultiMaplet<K, V>
implements MultiMaplet<K, V> {
    private final Map<K, Set<V>> myMap = new HashMap<K, Set<V>>();

    @Override
    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    @Override
    @Nullable
    public Iterable<V> get(K key) {
        return this.myMap.get(key);
    }

    @Override
    public void put(K key, Iterable<? extends V> values) {
        this.myMap.put(key, (Set)Iterators.collect(values, new HashSet()));
    }

    @Override
    public void remove(K key) {
        this.myMap.remove(key);
    }

    @Override
    public void appendValue(K key, V value) {
        Set<V> values = this.myMap.get(key);
        if (values == null) {
            values = new HashSet<V>();
            this.myMap.put(key, values);
        }
        values.add(value);
    }

    @Override
    public void removeValue(K key, V value) {
        Set<V> values = this.myMap.get(key);
        if (values != null) {
            values.remove(value);
        }
    }

    @Override
    public Iterable<K> getKeys() {
        return this.myMap.keySet();
    }
}

