/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.dependency.SerializableGraphElement;
import org.jetbrains.jps.dependency.impl.NodeKeyDescriptor;
import org.jetbrains.jps.dependency.impl.NodeKeyDescriptorImpl;
import org.jetbrains.jps.javac.Iterators;

public final class PersistentSetMultiMaplet<K extends SerializableGraphElement, V extends SerializableGraphElement>
implements MultiMaplet<K, V> {
    private static final Collection<?> NULL_COLLECTION = Collections.emptyList();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<K, Collection<V>> map;
    private final LoadingCache<K, Collection<V>> cache;

    public PersistentSetMultiMaplet(Path mapFile) {
        try {
            Supplier<Collection> fileCollectionFactory = NodeKeyDescriptor::createNodeSet;
            NodeKeyDescriptorImpl keyDescriptor = NodeKeyDescriptorImpl.getInstance();
            CollectionDataExternalizer valueExternalizer = new CollectionDataExternalizer(NodeKeyDescriptorImpl.getInstance(), fileCollectionFactory);
            this.map = new PersistentHashMap(mapFile, keyDescriptor, valueExternalizer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cache = Caffeine.newBuilder().maximumSize(128L).build(key -> {
            try {
                Collection collection = (Collection)this.map.get(key);
                return collection == null ? NULL_COLLECTION : collection;
            }
            catch (IOException e) {
                throw new BuildDataCorruptedException(e);
            }
        });
    }

    @Override
    public boolean containsKey(K key) {
        try {
            return this.map.containsMapping(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    @Nullable
    public Iterable<V> get(K key) {
        Collection collection = (Collection)this.cache.get(key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void put(K key, Iterable<? extends V> values) {
        try {
            this.cache.invalidate(key);
            this.map.put(key, (Object)Iterators.collect(values, new HashSet()));
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.cache.invalidate(key);
            this.map.remove(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void appendValue(K key, V value) {
        try {
            this.map.appendData(key, new AppendablePersistentMap.ValueDataAppender(){
                final /* synthetic */ SerializableGraphElement val$value;
                {
                    this.val$value = serializableGraphElement;
                }

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NodeKeyDescriptorImpl.getInstance().save(out, this.val$value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/dependency/impl/PersistentSetMultiMaplet$1", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeValue(K key, V value) {
        try {
            Collection collection = (Collection)this.cache.get(key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.cache.invalidate(key);
                if (collection.isEmpty()) {
                    this.map.remove(key);
                } else {
                    this.map.put(key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public Iterable<K> getKeys() {
        try {
            return this.map.getAllKeysWithExistingMapping();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.cache.invalidateAll();
            this.map.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static final class CollectionDataExternalizer<V extends SerializableGraphElement>
    implements DataExternalizer<Collection<V>> {
        private final DataExternalizer<V> myElementExternalizer;
        private final Supplier<? extends Collection<V>> myCollectionFactory;

        CollectionDataExternalizer(DataExternalizer<V> elementExternalizer, Supplier<? extends Collection<V>> collectionFactory) {
            this.myElementExternalizer = elementExternalizer;
            this.myCollectionFactory = collectionFactory;
        }

        public void save(@NotNull DataOutput out, Collection<V> value) throws IOException {
            if (out == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(0);
            }
            for (SerializableGraphElement x : value) {
                this.myElementExternalizer.save(out, (Object)x);
            }
        }

        public Collection<V> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(1);
            }
            Collection<V> result = this.myCollectionFactory.get();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add((SerializableGraphElement)this.myElementExternalizer.read(in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/dependency/impl/PersistentSetMultiMaplet$CollectionDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

