/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.injection.MarkdownCodeFenceUtils;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0003\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "isValidHost", "", "updateText", "text", "", "CodeFenceLiteralTextEscaper", "Companion", "Manipulator", "intellij.markdown.core"})
public final class MarkdownCodeFence
extends MarkdownCodeFenceImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MarkdownCodeFence(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2 instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor2).visitCodeFence(this);
        } else {
            super.accept(visitor2);
        }
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(this){
            final /* synthetic */ MarkdownCodeFence this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public String getPresentableText() {
                return !this.this$0.isValid() ? null : "Code Fence";
            }

            @Nullable
            public String getLocationString() {
                if (!this.this$0.isValid()) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                List<PsiElement> list2 = MarkdownCodeFence.Companion.obtainFenceContent(this.this$0, false);
                if (list2 == null) {
                    return "";
                }
                List<PsiElement> elements2 = list2;
                for (PsiElement element2 : elements2) {
                    if (((CharSequence)sb).length() > 0) {
                        sb.append("\\n");
                    }
                    sb.append(element2.getText());
                    if (sb.length() < 50) continue;
                    break;
                }
                return sb.toString();
            }
        };
    }

    public boolean isValidHost() {
        return MarkdownCodeFenceUtils.isAbleToAcceptInjections(this);
    }

    @Nullable
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)((PsiElement)this), (String)text2);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new CodeFenceLiteralTextEscaper(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$CodeFenceLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "host", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;)V", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "getRelevantTextRange", "isOneLine", "intellij.markdown.core"})
    private static final class CodeFenceLiteralTextEscaper
    extends LiteralTextEscaper<PsiLanguageInjectionHost> {
        public CodeFenceLiteralTextEscaper(@NotNull MarkdownCodeFence host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            super((PsiLanguageInjectionHost)host);
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            List<PsiElement> list2 = Companion.obtainFenceContent((MarkdownCodeFence)psiLanguageInjectionHost, false);
            if (list2 == null) {
                return true;
            }
            List<PsiElement> elements2 = list2;
            for (PsiElement element2 : elements2) {
                TextRange intersected;
                if (rangeInsideHost.intersection(element2.getTextRangeInParent()) == null) continue;
                outChars.append(intersected.substring(((MarkdownCodeFence)this.myHost).getText()));
            }
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            List<PsiElement> list2 = Companion.obtainFenceContent((MarkdownCodeFence)psiLanguageInjectionHost, false);
            if (list2 == null) {
                return -1;
            }
            List<PsiElement> elements2 = list2;
            int cur = 0;
            for (PsiElement element2 : elements2) {
                TextRange intersected = rangeInsideHost.intersection(element2.getTextRangeInParent());
                if (intersected == null || intersected.isEmpty()) continue;
                if (cur + intersected.getLength() == offsetInDecoded) {
                    return intersected.getStartOffset() + intersected.getLength();
                }
                if (cur == offsetInDecoded) {
                    return intersected.getStartOffset();
                }
                if (cur < offsetInDecoded && cur + intersected.getLength() > offsetInDecoded) {
                    return intersected.getStartOffset() + (offsetInDecoded - cur);
                }
                cur += intersected.getLength();
            }
            PsiElement last = elements2.get(elements2.size() - 1);
            TextRange intersected = rangeInsideHost.intersection(last.getTextRangeInParent());
            if (intersected == null || intersected.isEmpty()) {
                return -1;
            }
            int result2 = intersected.getStartOffset() + (offsetInDecoded - (cur - intersected.getLength()));
            return rangeInsideHost.getStartOffset() <= result2 && result2 <= rangeInsideHost.getEndOffset() ? result2 : -1;
        }

        @NotNull
        public TextRange getRelevantTextRange() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            Intrinsics.checkNotNull((Object)psiLanguageInjectionHost, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            return Companion.obtainRelevantTextRange((MarkdownCodeFence)psiLanguageInjectionHost);
        }

        public boolean isOneLine() {
            return false;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$Companion;", "", "()V", "obtainFenceContent", "", "Lcom/intellij/psi/PsiElement;", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "withWhitespaces", "", "obtainRelevantTextRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final TextRange obtainRelevantTextRange(MarkdownCodeFence element2) {
            List<PsiElement> list2 = this.obtainFenceContent(element2, true);
            if (list2 == null) {
                return MarkdownCodeFenceUtils.INSTANCE.getEmptyRange(element2);
            }
            List<PsiElement> elements2 = list2;
            PsiElement first = (PsiElement)CollectionsKt.first(elements2);
            PsiElement last = (PsiElement)CollectionsKt.last(elements2);
            TextRange textRange = TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
            return textRange;
        }

        @ApiStatus.Experimental
        @Nullable
        public final List<PsiElement> obtainFenceContent(@NotNull MarkdownCodeFence element2, boolean withWhitespaces) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return withWhitespaces ? (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element2), () -> Companion.obtainFenceContent$lambda$0(element2)) : (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element2), () -> Companion.obtainFenceContent$lambda$1(element2));
        }

        private static final CachedValueProvider.Result obtainFenceContent$lambda$0(MarkdownCodeFence $element) {
            Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
            Object[] objectArray = new Object[]{$element};
            return CachedValueProvider.Result.create(MarkdownCodeFenceUtils.getContent($element, true), (Object[])objectArray);
        }

        private static final CachedValueProvider.Result obtainFenceContent$lambda$1(MarkdownCodeFence $element) {
            Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
            Object[] objectArray = new Object[]{$element};
            return CachedValueProvider.Result.create(MarkdownCodeFenceUtils.getContent($element, false), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0002H\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$Manipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence;", "()V", "appendIndent", "", "content", "indent", "collectText", "element", "createShiftedChangeRange", "Lcom/intellij/openapi/util/TextRange;", "range", "relevantRange", "textLength", "", "handleContentChange", "replaceWithIndent", "text", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nMarkdownCodeFence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCodeFence.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFence$Manipulator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
    public static final class Manipulator
    extends AbstractElementManipulator<MarkdownCodeFence> {
        @Nullable
        public MarkdownCodeFence handleContentChange(@NotNull MarkdownCodeFence element2, @NotNull TextRange range, @NotNull String content2) throws IncorrectOperationException {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            if (StringsKt.contains$default((CharSequence)content2, (CharSequence)"```", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)content2, (CharSequence)"~~~", (boolean)false, (int)2, null)) {
                MarkdownCodeFence markdownCodeFence;
                MarkdownPsiElement markdownPsiElement = MarkdownPsiElementFactory.createTextElement(element2.getProject(), content2);
                Intrinsics.checkNotNullExpressionValue((Object)markdownPsiElement, (String)"createTextElement(...)");
                MarkdownPsiElement textElement = markdownPsiElement;
                if (textElement instanceof MarkdownCodeFence) {
                    PsiElement psiElement = element2.replace((PsiElement)textElement);
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
                    markdownCodeFence = (MarkdownCodeFence)psiElement;
                } else {
                    markdownCodeFence = null;
                }
                return markdownCodeFence;
            }
            TextRange relevantRange = Companion.obtainRelevantTextRange(element2);
            String string = MarkdownCodeFenceUtils.getIndent(element2);
            if (string == null) {
                string = "";
            }
            String indent = string;
            String text2 = this.collectText(element2);
            CharSequence charSequence = text2;
            String updatedText = charSequence == null || charSequence.length() == 0 || range.getStartOffset() < relevantRange.getStartOffset() ? this.appendIndent(content2, indent) : this.replaceWithIndent(text2, content2, this.createShiftedChangeRange(range, relevantRange, text2.length()), indent);
            MarkdownCodeFence markdownCodeFence = MarkdownPsiElementFactory.createCodeFence(element2.getProject(), element2.getFenceLanguage(), updatedText, indent);
            Intrinsics.checkNotNullExpressionValue((Object)markdownCodeFence, (String)"createCodeFence(...)");
            MarkdownCodeFence fenceElement = markdownCodeFence;
            PsiElement psiElement = element2.replace((PsiElement)fenceElement);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence");
            return (MarkdownCodeFence)psiElement;
        }

        private final TextRange createShiftedChangeRange(TextRange range, TextRange relevantRange, int textLength) {
            int delta = relevantRange.getStartOffset();
            return new TextRange(RangesKt.coerceIn((int)(range.getStartOffset() - delta), (int)0, (int)textLength), RangesKt.coerceIn((int)(range.getEndOffset() - delta), (int)0, (int)textLength));
        }

        private final String replaceWithIndent(String text2, String content2, TextRange range, String indent) {
            boolean bl;
            StringBuilder stringBuilder;
            if (((CharSequence)content2).length() == 0) {
                return text2;
            }
            String string = text2.substring(0, range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String prefix = string;
            String string2 = text2.substring(range.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String suffix = string2;
            String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)content2);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLinesKeepSeparators(...)");
            Sequence lines2 = ArraysKt.asSequence((Object[])stringArray);
            StringBuilder $this$replaceWithIndent_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$replaceWithIndent_u24lambda_u240.append(prefix);
            Character c = StringsKt.lastOrNull((CharSequence)prefix);
            if (c != null) {
                char p0 = c.charValue();
                boolean bl3 = false;
                bl = StringUtil.isLineBreak((char)p0);
            } else {
                bl = false;
            }
            if (bl) {
                $this$replaceWithIndent_u24lambda_u240.append(indent);
            }
            $this$replaceWithIndent_u24lambda_u240.append((String)SequencesKt.first((Sequence)lines2));
            for (String line : SequencesKt.drop((Sequence)lines2, (int)1)) {
                $this$replaceWithIndent_u24lambda_u240.append(indent);
                $this$replaceWithIndent_u24lambda_u240.append(line);
            }
            $this$replaceWithIndent_u24lambda_u240.append(suffix);
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            return string3;
        }

        private final String appendIndent(String content2, String indent) {
            if (((CharSequence)indent).length() == 0) {
                return content2;
            }
            String[] stringArray = StringUtil.splitByLinesKeepSeparators((String)content2);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLinesKeepSeparators(...)");
            String result2 = ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(indent){
                final /* synthetic */ String $indent;
                {
                    this.$indent = $indent;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(String it) {
                    return this.$indent + it;
                }
            }), (int)30, null);
            return StringUtil.endsWithLineBreak((CharSequence)content2) ? result2 + indent : result2;
        }

        private final String collectText(MarkdownCodeFence element2) {
            StringBuilder stringBuilder;
            List<PsiElement> list2 = Companion.obtainFenceContent(element2, true);
            if (list2 == null) {
                return null;
            }
            List<PsiElement> elements2 = list2;
            StringBuilder $this$collectText_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (PsiElement child2 : elements2) {
                $this$collectText_u24lambda_u241.append(child2.getText());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }
    }
}

