/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.Iteration;
import org.jetbrains.jetCheck.PropertyChecker;
import org.jetbrains.jetCheck.PropertyFailure;
import org.jetbrains.jetCheck.Scenario;
import org.jetbrains.jetCheck.StructureNode;

class StatusNotifier {
    private final PropertyChecker.Parameters parameters;
    private int currentIteration;
    private long lastPrinted = System.currentTimeMillis();
    private int lastReportedStage = -1;
    private String lastReportedTrace = null;

    StatusNotifier(PropertyChecker.Parameters parameters) {
        this.parameters = parameters;
    }

    void iterationStarted(int iteration) {
        this.currentIteration = iteration;
        if (this.shouldPrint()) {
            System.out.println(StatusNotifier.formatCurrentTime() + ": iteration " + this.currentIteration + " of " + this.parameters.getIterationCount() + "...");
        }
    }

    void counterExampleFound(Iteration<?> iteration) {
        if (this.parameters.silent) {
            return;
        }
        this.lastPrinted = System.currentTimeMillis();
        System.err.println(StatusNotifier.formatCurrentTime() + ": failed on iteration " + this.currentIteration + " (" + iteration.printSeeds() + "), shrinking...");
    }

    private boolean shouldPrint() {
        if (this.parameters.silent) {
            return false;
        }
        if (System.currentTimeMillis() - this.lastPrinted > 5000L) {
            this.lastPrinted = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    <T> void shrinkAttempt(PropertyFailure<T> failure, Iteration<T> iteration, StructureNode data) {
        if (this.shouldPrint()) {
            int stage = failure.getShrinkingStageCount();
            System.out.println(StatusNotifier.formatCurrentTime() + ": still shrinking (" + iteration.printSeeds() + "). Examples tried: " + failure.getTotalShrinkingExampleCount() + ", successful minimizations: " + stage);
            if (this.lastReportedStage != stage) {
                String trace;
                this.lastReportedStage = stage;
                System.err.println(" Current minimal example: " + failure.getMinimalCounterexample().getExampleValue());
                Throwable exceptionCause = failure.getMinimalCounterexample().getExceptionCause();
                if (exceptionCause != null && !(trace = StatusNotifier.shortenStackTrace(exceptionCause)).equals(this.lastReportedTrace)) {
                    this.lastReportedTrace = trace;
                    System.err.println(" Reason: " + trace);
                }
                System.err.println();
            }
        }
        if (this.parameters.printData) {
            System.out.println("Generating from shrunk raw data: " + data);
        }
    }

    void eofException() {
        if (this.parameters.silent) {
            return;
        }
        System.out.println("Generator tried to read past the end of serialized data, so it seems the failure isn't reproducible anymore");
    }

    void logEntryReceived(String entry) {
        if (this.parameters.printValues) {
            System.out.println(entry);
        }
    }

    <T> void beforePropertyCheck(T value) {
        if (this.parameters.printValues && !this.isAlreadyPrinted(value)) {
            System.out.println("Checking " + value);
        }
    }

    private boolean isAlreadyPrinted(Object value) {
        return value instanceof Scenario && !((Scenario)value).hasEmptyLog();
    }

    void propertyCheckFailed(@Nullable Throwable exception) {
        if (this.parameters.printValues) {
            System.out.println("  failure" + (exception == null ? "" : ": " + exception.getClass().getName()));
        }
    }

    private static String shortenStackTrace(Throwable e) {
        String trace = StatusNotifier.printStackTrace(e);
        return trace.length() > 1000 ? trace.substring(0, 1000) + "..." : trace;
    }

    @NotNull
    private static String formatCurrentTime() {
        return LocalTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(Locale.getDefault()));
    }

    static String printStackTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        return stringWriter.getBuffer().toString();
    }

    void beforeReproducing(StructureNode data) {
        if (this.parameters.printData) {
            System.out.println("Reproducing from raw data " + data);
        }
    }

    void replayFailed(@NotNull Throwable e) {
        if (this.parameters.printData) {
            System.out.println("  failed: " + e.getClass().getName());
        }
    }
}

