/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.local;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.intellij.indexing.shared.local.SharedIndexLocalFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/indexing/shared/local/PredefinedJsonSharedIndexLocalFinder;", "Lcom/intellij/indexing/shared/local/SharedIndexLocalFinder;", "()V", "findSharedIndexChunks", "", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nPredefinedJsonSharedIndexLocalFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PredefinedJsonSharedIndexLocalFinder.kt\ncom/intellij/indexing/shared/local/PredefinedJsonSharedIndexLocalFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n1549#2:35\n1620#2,3:36\n10#3:39\n*S KotlinDebug\n*F\n+ 1 PredefinedJsonSharedIndexLocalFinder.kt\ncom/intellij/indexing/shared/local/PredefinedJsonSharedIndexLocalFinder\n*L\n27#1:35\n27#1:36,3\n14#1:39\n*E\n"})
public final class PredefinedJsonSharedIndexLocalFinder
implements SharedIndexLocalFinder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;
    @Nullable
    private static final String projectRelativeIndexJsonLocation;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Path> findSharedIndexChunks(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String basePath = string;
        String string2 = projectRelativeIndexJsonLocation;
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String relativeJsonLocation = string2;
        Path path = Path.of(basePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = path.resolve(relativeJsonLocation);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
        Path jsonFileLocation = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(jsonFileLocation, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            JsonNode node = new ObjectMapper().readTree(jsonFileLocation.toFile());
            JsonNode jsonNode = node.get("shared-indexes");
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ArrayNode");
            ArrayNode sharedIndexList = (ArrayNode)jsonNode;
            Iterable $this$map$iv = (Iterable)sharedIndexList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Path.of(it.asText(), new String[0]));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            log.warn("Can't read " + ((Object)jsonFileLocation).toString(), (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PredefinedJsonSharedIndexLocalFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        projectRelativeIndexJsonLocation = System.getProperty("local.project.shared.index.json.path");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/local/PredefinedJsonSharedIndexLocalFinder$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "projectRelativeIndexJsonLocation", "", "getProjectRelativeIndexJsonLocation", "()Ljava/lang/String;", "intellij.indexing.shared"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @Nullable
        public final String getProjectRelativeIndexJsonLocation() {
            return projectRelativeIndexJsonLocation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

