/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.platform.api.MutableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.ReplaceableSharedIndexStorage;
import com.intellij.indexing.shared.platform.api.SharedIndexStats;
import com.intellij.indexing.shared.platform.api.SharedIndexStorage;
import com.intellij.indexing.shared.platform.impl.BundledSharedIndexesResolver;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexMainZipStorage;
import com.intellij.indexing.shared.platform.impl.SharedIndexStorageHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u001d\u0010\u0017\u001a\u00020\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u0019H\u0082\bJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u001f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder;", "Ljava/io/Closeable;", "mutableStorage", "Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;", "providedStorages", "", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStorage;", "replaceableChunkStorages", "", "Lcom/intellij/indexing/shared/platform/api/ReplaceableSharedIndexStorage;", "(Lcom/intellij/indexing/shared/platform/api/MutableSharedIndexStorage;Ljava/util/List;Ljava/util/List;)V", "storageId", "", "getStorageId", "()Ljava/lang/String;", "addChunk", "", "chunkSourcePath", "Ljava/nio/file/Path;", "chunkId", "option", "Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "close", "foreachStorage", "action", "Lkotlin/Function1;", "getChunkRoot", "getSharedIndexStats", "Lcom/intellij/indexing/shared/platform/api/SharedIndexStats;", "isCompatibleChunk", "", "toString", "Companion", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexStorageHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexStorageHolder.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,144:1\n97#1,2:145\n99#1,2:149\n97#1,2:155\n99#1,2:159\n97#1,2:164\n99#1,2:168\n97#1,2:170\n99#1,2:174\n1855#2,2:147\n1855#2,2:151\n1855#2,2:153\n1855#2,2:157\n1789#2,3:161\n1855#2,2:166\n1855#2,2:172\n10#3:176\n*S KotlinDebug\n*F\n+ 1 SharedIndexStorageHolder.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder\n*L\n92#1:145,2\n92#1:149,2\n103#1:155,2\n103#1:159,2\n128#1:164,2\n128#1:168,2\n135#1:170,2\n135#1:174,2\n92#1:147,2\n98#1:151,2\n99#1:153,2\n103#1:157,2\n124#1:161,3\n128#1:166,2\n135#1:172,2\n26#1:176\n*E\n"})
public final class SharedIndexStorageHolder
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedIndexStorage mutableStorage;
    @NotNull
    private final List<SharedIndexStorage> providedStorages;
    @NotNull
    private final List<ReplaceableSharedIndexStorage> replaceableChunkStorages;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String MAIN_STORAGE_OLD_NAME = "chunks.zip";
    @NotNull
    public static final String MAIN_STORAGE_NAME = "shared-index.chunks";

    public SharedIndexStorageHolder(@NotNull MutableSharedIndexStorage mutableStorage, @NotNull List<? extends SharedIndexStorage> providedStorages, @NotNull List<ReplaceableSharedIndexStorage> replaceableChunkStorages) {
        Intrinsics.checkNotNullParameter((Object)mutableStorage, (String)"mutableStorage");
        Intrinsics.checkNotNullParameter(providedStorages, (String)"providedStorages");
        Intrinsics.checkNotNullParameter(replaceableChunkStorages, (String)"replaceableChunkStorages");
        this.mutableStorage = mutableStorage;
        this.providedStorages = providedStorages;
        this.replaceableChunkStorages = replaceableChunkStorages;
    }

    @NotNull
    public String toString() {
        SharedIndexStorage it$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append("CompositeStorage{");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl2 = false;
        $this$toString_u24lambda_u241.append(it.toString()).append(", ");
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl2 = false;
            $this$toString_u24lambda_u241.append(it.toString()).append(", ");
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl4 = false;
            it = it$iv;
            bl2 = false;
            $this$toString_u24lambda_u241.append(it.toString()).append(", ");
        }
        $this$toString_u24lambda_u241.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void foreachStorage(Function1<? super SharedIndexStorage, Unit> action) {
        SharedIndexStorage it;
        boolean $i$f$foreachStorage = false;
        action.invoke((Object)this.mutableStorage);
        Iterable $this$forEach$iv = this.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SharedIndexStorage)element$iv;
            boolean bl = false;
            action.invoke((Object)it);
        }
        $this$forEach$iv = this.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ReplaceableSharedIndexStorage)element$iv;
            boolean bl = false;
            action.invoke((Object)it);
        }
    }

    @Nullable
    public final Path getChunkRoot(@NotNull String chunkId) {
        SharedIndexStorage it$iv;
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        Path chunkRoot = it.getChunkRoot(chunkId);
        if (chunkRoot != null) {
            return chunkRoot;
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            chunkRoot = it.getChunkRoot(chunkId);
            if (chunkRoot == null) continue;
            return chunkRoot;
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            chunkRoot = it.getChunkRoot(chunkId);
            if (chunkRoot == null) continue;
            return chunkRoot;
        }
        return null;
    }

    public final void addChunk(@NotNull Path chunkSourcePath, @NotNull String chunkId, @NotNull ChunkStorageOption option) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chunkSourcePath, (String)"chunkSourcePath");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        switch (WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
            case 1: {
                this.mutableStorage.appendChunk(chunkSourcePath, chunkId);
                break;
            }
            case 2: {
                String string = "Not supported yet";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final String getStorageId() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.union((Iterable)this.providedStorages, (Iterable)CollectionsKt.listOf((Object)this.mutableStorage)), (CharSequence)", ", null, null, (int)0, null, (Function1)storageId.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SharedIndexStats getSharedIndexStats() {
        void $this$fold$iv;
        Iterable iterable = this.providedStorages;
        SharedIndexStats initial$iv = this.mutableStorage.getSharedIndexStats();
        boolean $i$f$fold = false;
        SharedIndexStats accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            SharedIndexStorage sharedIndexStorage = (SharedIndexStorage)element$iv;
            SharedIndexStats acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(it.getSharedIndexStats());
        }
        return accumulator$iv;
    }

    public final boolean isCompatibleChunk(@NotNull String chunkId) {
        SharedIndexStorage it$iv;
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        if (it.containsChunk(chunkId) && it.isCompatibleChunk(chunkId)) {
            return true;
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            if (!it.containsChunk(chunkId) || !it.isCompatibleChunk(chunkId)) continue;
            return true;
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            if (!it.containsChunk(chunkId) || !it.isCompatibleChunk(chunkId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        SharedIndexStorage it$iv;
        SharedIndexStorageHolder this_$iv = this;
        boolean $i$f$foreachStorage = false;
        SharedIndexStorage it = this_$iv.mutableStorage;
        boolean bl = false;
        try {
            it.close();
        }
        catch (Throwable t) {
            LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
        }
        Iterable $this$forEach$iv$iv = this_$iv.providedStorages;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (SharedIndexStorage)element$iv$iv;
            boolean bl2 = false;
            it = it$iv;
            bl = false;
            try {
                it.close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
            }
        }
        $this$forEach$iv$iv = this_$iv.replaceableChunkStorages;
        $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            it$iv = (ReplaceableSharedIndexStorage)element$iv$iv;
            boolean bl3 = false;
            it = it$iv;
            bl = false;
            try {
                it.close();
            }
            catch (Throwable t) {
                LOG.warn("Failed to close " + it + ". " + t.getMessage(), t);
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final SharedIndexStorageHolder openStoragesOrReset(@NotNull Runnable corruptionHandler) throws IOException {
        return Companion.openStoragesOrReset(corruptionHandler);
    }

    @JvmStatic
    public static final void deleteMutableStorage() {
        Companion.deleteMutableStorage();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexStorageHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAIN_STORAGE_NAME", "", "MAIN_STORAGE_OLD_NAME", "deleteMutableStorage", "", "openStoragesOrReset", "Lcom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder;", "corruptionHandler", "Ljava/lang/Runnable;", "tryOpenStorages", "tryOpenStorages$intellij_indexing_shared", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndexStorageHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexStorageHolder.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,144:1\n43#2,3:145\n43#2,3:148\n*S KotlinDebug\n*F\n+ 1 SharedIndexStorageHolder.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexStorageHolder$Companion\n*L\n64#1:145,3\n76#1:148,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SharedIndexStorageHolder openStoragesOrReset(@NotNull Runnable corruptionHandler) throws IOException {
            Intrinsics.checkNotNullParameter((Object)corruptionHandler, (String)"corruptionHandler");
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            SharedIndexMainZipStorage mutableStorage = (SharedIndexMainZipStorage)IOUtil.openCleanOrResetBroken(() -> Companion.openStoragesOrReset$lambda$0(oldStoragePath, newStoragePath), () -> Companion.openStoragesOrReset$lambda$1(corruptionHandler, oldStoragePath, newStoragePath));
            boolean $i$f$service = false;
            Class<BundledSharedIndexesResolver> serviceClass$iv = BundledSharedIndexesResolver.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            List<SharedIndexStorage> bundledIndexes = ((BundledSharedIndexesResolver)object).openBundledStorages();
            Intrinsics.checkNotNull((Object)mutableStorage);
            return new SharedIndexStorageHolder(mutableStorage, bundledIndexes, new ArrayList());
        }

        @Nullable
        public final SharedIndexStorageHolder tryOpenStorages$intellij_indexing_shared() {
            Object $this$tryOpenStorages_u24lambda_u242;
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            Object object = this;
            try {
                $this$tryOpenStorages_u24lambda_u242 = object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)oldStoragePath);
                Intrinsics.checkNotNull((Object)newStoragePath);
                $this$tryOpenStorages_u24lambda_u242 = Result.constructor-impl((Object)new SharedIndexMainZipStorage(oldStoragePath, newStoragePath, "shared index central storage"));
            }
            catch (Throwable throwable) {
                $this$tryOpenStorages_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = $this$tryOpenStorages_u24lambda_u242;
            SharedIndexMainZipStorage sharedIndexMainZipStorage = (SharedIndexMainZipStorage)(Result.isFailure-impl((Object)object) ? null : object);
            if (sharedIndexMainZipStorage == null) {
                return null;
            }
            SharedIndexMainZipStorage mutableStorage = sharedIndexMainZipStorage;
            boolean $i$f$service = false;
            Class<BundledSharedIndexesResolver> serviceClass$iv = BundledSharedIndexesResolver.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            List<SharedIndexStorage> bundledIndexes = ((BundledSharedIndexesResolver)object2).openBundledStorages();
            return new SharedIndexStorageHolder(mutableStorage, bundledIndexes, new ArrayList());
        }

        @JvmStatic
        public final void deleteMutableStorage() {
            Path oldStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_OLD_NAME);
            Path newStoragePath = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve(SharedIndexStorageHolder.MAIN_STORAGE_NAME);
            FileUtil.deleteWithRenaming((File)oldStoragePath.toFile());
            FileUtil.deleteWithRenaming((File)newStoragePath.toFile());
        }

        private static final SharedIndexMainZipStorage openStoragesOrReset$lambda$0(Path $oldStoragePath, Path $newStoragePath) {
            Intrinsics.checkNotNull((Object)$oldStoragePath);
            Intrinsics.checkNotNull((Object)$newStoragePath);
            return new SharedIndexMainZipStorage($oldStoragePath, $newStoragePath, "shared index central storage");
        }

        private static final void openStoragesOrReset$lambda$1(Runnable $corruptionHandler, Path $oldStoragePath, Path $newStoragePath) {
            Intrinsics.checkNotNullParameter((Object)$corruptionHandler, (String)"$corruptionHandler");
            $corruptionHandler.run();
            if (Files.exists($oldStoragePath, new LinkOption[0])) {
                FileUtil.delete((Path)$oldStoragePath);
            }
            if (Files.exists($newStoragePath, new LinkOption[0])) {
                FileUtil.delete((Path)$newStoragePath);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChunkStorageOption.values().length];
            try {
                nArray[ChunkStorageOption.APPENDABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkStorageOption.REPLACEABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

