/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExport;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrFileMetadata;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExport;", "name", "", "file", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/library/SerializedIrFile;)V", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "decl", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "exportingName", "containingFile", "packageFqName", "declaration", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "containingPackageFqName", "getContainingPackageFqName", "()Ljava/lang/String;", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getExportingName", "fqName", "getFqName", "render", "Companion", "ir.serialization.js"})
@SourceDebugExtension(value={"SMAP\nJsKlibExportingDeclaration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsKlibExportingDeclaration.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class JsKlibExportingDeclaration
extends JsKlibExport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String exportingName;
    @Nullable
    private final IrDeclaration declaration;
    @NotNull
    private final String containingPackageFqName;
    @NotNull
    private final String fqName;

    public JsKlibExportingDeclaration(@NotNull String exportingName, @NotNull String containingFile, @NotNull String packageFqName, @Nullable IrDeclaration declaration) {
        String it;
        String string;
        Intrinsics.checkNotNullParameter((Object)exportingName, (String)"exportingName");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        super(containingFile);
        this.exportingName = exportingName;
        this.declaration = declaration;
        String string2 = string = packageFqName;
        JsKlibExportingDeclaration jsKlibExportingDeclaration = this;
        boolean bl = false;
        boolean bl2 = !Intrinsics.areEqual((Object)it, (Object)"<root>");
        String string3 = bl2 ? string : null;
        if (string3 == null) {
            string3 = "";
        }
        jsKlibExportingDeclaration.containingPackageFqName = string3;
        it = string = ".";
        StringBuilder stringBuilder = new StringBuilder().append(this.containingPackageFqName);
        jsKlibExportingDeclaration = this;
        boolean bl3 = false;
        boolean bl4 = ((CharSequence)this.containingPackageFqName).length() > 0;
        String string4 = bl4 ? string : null;
        if (string4 == null) {
            string4 = "";
        }
        jsKlibExportingDeclaration.fqName = stringBuilder.append(string4).append(this.exportingName).toString();
    }

    @NotNull
    public final String getExportingName() {
        return this.exportingName;
    }

    @Nullable
    public final IrDeclaration getDeclaration() {
        return this.declaration;
    }

    public JsKlibExportingDeclaration(@NotNull String name, @NotNull SerializedIrFile file) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(name, file.getPath(), file.getFqName(), null);
    }

    public JsKlibExportingDeclaration(@NotNull String name, @NotNull IrFile file, @NotNull IrDeclaration decl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)decl, (String)"decl");
        String string = file.getFileEntry().getName();
        String string2 = file.getPackageFqName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this(name, string, string2, decl);
    }

    @NotNull
    public final String getContainingPackageFqName() {
        return this.containingPackageFqName;
    }

    @Override
    @NotNull
    public String getFqName() {
        return this.fqName;
    }

    @Override
    @NotNull
    public String render() {
        return "exporting name '" + this.exportingName + "' from file '" + this.getContainingFile() + '\'';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration$Companion;", "", "()V", "collectDeclarations", "", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "cleanFiles", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "dirtyFiles", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "exportedNames", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "ir.serialization.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<JsKlibExportingDeclaration> collectDeclarations(@NotNull List<SerializedIrFile> cleanFiles, @NotNull List<? extends IrFile> dirtyFiles, @NotNull Map<IrFile, ? extends Map<IrDeclarationWithName, String>> exportedNames) {
            List list;
            Intrinsics.checkNotNullParameter(cleanFiles, (String)"cleanFiles");
            Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
            Intrinsics.checkNotNullParameter(exportedNames, (String)"exportedNames");
            List $this$collectDeclarations_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (SerializedIrFile serializedIrFile : cleanFiles) {
                JsIrFileMetadata fileMetadata = JsIrFileMetadata.Companion.fromByteArray(KlibKt.getFileMetadata(serializedIrFile));
                for (String string : fileMetadata.getExportedNames()) {
                    $this$collectDeclarations_u24lambda_u240.add(new JsKlibExportingDeclaration(string, serializedIrFile));
                }
            }
            for (IrFile irFile : dirtyFiles) {
                Map<IrDeclarationWithName, String> exportedDeclarations2;
                if (exportedNames.get(irFile) == null) continue;
                for (Map.Entry entry : exportedDeclarations2.entrySet()) {
                    IrDeclarationWithName declaration = (IrDeclarationWithName)entry.getKey();
                    String exportedName = (String)entry.getValue();
                    $this$collectDeclarations_u24lambda_u240.add(new JsKlibExportingDeclaration(exportedName, irFile, declaration));
                }
            }
            return CollectionsKt.build((List)list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

