/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.services;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.ml.embeddings.search.indices.IndexableEntity;
import com.intellij.platform.ml.embeddings.search.services.DiskSynchronizedEmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.FileContentBasedEmbeddingsStorage;
import com.intellij.platform.ml.embeddings.search.services.SemanticSearchFileContentChangeListener;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ%\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0084@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/FileContentBasedEmbeddingsStorage;", "T", "Lcom/intellij/platform/ml/embeddings/search/indices/IndexableEntity;", "Lcom/intellij/platform/ml/embeddings/search/services/DiskSynchronizedEmbeddingsStorage;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "collectEntities", "", "fileChangeListener", "Lcom/intellij/platform/ml/embeddings/search/services/SemanticSearchFileContentChangeListener;", "(Lcom/intellij/platform/ml/embeddings/search/services/SemanticSearchFileContentChangeListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "", "traversePsiFile", "file", "Lcom/intellij/psi/PsiFile;", "intellij.platform.ml.embeddings"})
public abstract class FileContentBasedEmbeddingsStorage<T extends IndexableEntity>
extends DiskSynchronizedEmbeddingsStorage<T>
implements Disposable {
    public FileContentBasedEmbeddingsStorage(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project, cs);
    }

    @NotNull
    public abstract List<T> traversePsiFile(@NotNull PsiFile var1);

    @Nullable
    protected final Object collectEntities(@NotNull SemanticSearchFileContentChangeListener<T> fileChangeListener, @NotNull Continuation<? super List<? extends T>> $completion) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        return CoroutinesKt.readAction((Function0)new Function0<List<? extends T>>(this, psiManager2, fileChangeListener){
            final /* synthetic */ FileContentBasedEmbeddingsStorage<T> this$0;
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ SemanticSearchFileContentChangeListener<T> $fileChangeListener;
            {
                this.this$0 = $receiver;
                this.$psiManager = $psiManager;
                this.$fileChangeListener = $fileChangeListener;
                super(0);
            }

            @NotNull
            public final List<T> invoke() {
                List list;
                FileContentBasedEmbeddingsStorage<T> fileContentBasedEmbeddingsStorage = this.this$0;
                PsiManager psiManager = this.$psiManager;
                SemanticSearchFileContentChangeListener<T> semanticSearchFileContentChangeListener = this.$fileChangeListener;
                List $this$invoke_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)fileContentBasedEmbeddingsStorage.getProject()).getContentSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentSourceRoots(...)");
                Object[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VirtualFile root = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, null, arg_0 -> collectEntities.2.invoke$lambda$3$lambda$2$lambda$1(psiManager, fileContentBasedEmbeddingsStorage, semanticSearchFileContentChangeListener, $this$invoke_u24lambda_u243, arg_0));
                }
                return CollectionsKt.build((List)list);
            }

            private static final boolean invoke$lambda$3$lambda$2$lambda$1(PsiManager $psiManager, FileContentBasedEmbeddingsStorage this$0, SemanticSearchFileContentChangeListener $fileChangeListener, List $this_buildList, VirtualFile virtualFile) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)$psiManager, (String)"$psiManager");
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$fileChangeListener, (String)"$fileChangeListener");
                    Intrinsics.checkNotNullParameter((Object)$this_buildList, (String)"$this_buildList");
                    Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                    ProgressManager.checkCanceled();
                    if (virtualFile.getCanonicalFile() == null || !VirtualFileUtil.isFile((VirtualFile)virtualFile)) break block1;
                    PsiFile psiFile = $psiManager.findFile(virtualFile);
                    if (psiFile != null) {
                        PsiFile psiFile2;
                        PsiFile file = psiFile2 = psiFile;
                        boolean bl = false;
                        List<T> classes = this$0.traversePsiFile(file);
                        $fileChangeListener.addEntityCountsForFile(virtualFile, classes);
                        $this_buildList.addAll((Collection)classes);
                    }
                }
                return true;
            }
        }, $completion);
    }

    public void dispose() {
    }
}

