/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.codereview.CodeReviewProgressTreeModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestChangedFileKt;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestFileViewedState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRViewedStateDataProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00022\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRProgressTreeModel;", "Lcom/intellij/collaboration/ui/codereview/CodeReviewProgressTreeModel;", "Lcom/intellij/openapi/vcs/changes/Change;", "Lcom/intellij/openapi/Disposable;", "repository", "Lgit4idea/repo/GitRepository;", "reviewData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "viewedStateData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRViewedStateDataProvider;", "canShowRead", "Lkotlin/Function0;", "", "(Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRViewedStateDataProvider;Lkotlin/jvm/functions/Function0;)V", "filesViewedState", "", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestFileViewedState;", "unresolvedThreadsCount", "", "asLeaf", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "dispose", "", "getUnresolvedDiscussionsCount", "leafValue", "isRead", "loadThreads", "loadViewedState", "intellij.vcs.github"})
public final class GHPRProgressTreeModel
extends CodeReviewProgressTreeModel<Change>
implements Disposable {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GHPRReviewDataProvider reviewData;
    @NotNull
    private final GHPRViewedStateDataProvider viewedStateData;
    @NotNull
    private final Function0<Boolean> canShowRead;
    @NotNull
    private Map<String, Integer> unresolvedThreadsCount;
    @NotNull
    private Map<String, ? extends GHPullRequestFileViewedState> filesViewedState;

    public GHPRProgressTreeModel(@NotNull GitRepository repository, @NotNull GHPRReviewDataProvider reviewData, @NotNull GHPRViewedStateDataProvider viewedStateData, @NotNull Function0<Boolean> canShowRead) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)reviewData, (String)"reviewData");
        Intrinsics.checkNotNullParameter((Object)viewedStateData, (String)"viewedStateData");
        Intrinsics.checkNotNullParameter(canShowRead, (String)"canShowRead");
        this.repository = repository;
        this.reviewData = reviewData;
        this.viewedStateData = viewedStateData;
        this.canShowRead = canShowRead;
        this.unresolvedThreadsCount = MapsKt.emptyMap();
        this.filesViewedState = MapsKt.emptyMap();
        this.loadThreads();
        this.reviewData.addReviewThreadsListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.loadThreads();
            }
        }));
        this.loadViewedState();
        this.viewedStateData.addViewedStateListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.loadViewedState();
            }
        }));
    }

    private final void loadThreads() {
        CompletableFutureUtil.INSTANCE.handleOnEdt(this.reviewData.loadReviewThreads(), (Disposable)this, (Function2)new Function2<List<? extends GHPullRequestReviewThread>, Throwable, Unit>(this){
            final /* synthetic */ GHPRProgressTreeModel this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable List<GHPullRequestReviewThread> threads, @Nullable Throwable throwable) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                if (threads == null) {
                    return;
                }
                Iterable iterable = threads;
                GHPRProgressTreeModel gHPRProgressTreeModel = this.this$0;
                boolean $i$f$filter = false;
                void var5_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    GHPullRequestReviewThread it = (GHPullRequestReviewThread)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isResolved())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$groupingBy$iv = (List)destination$iv$iv;
                boolean $i$f$groupingBy = false;
                GHPRProgressTreeModel.access$setUnresolvedThreadsCount$p(gHPRProgressTreeModel, GroupingKt.eachCount((Grouping)((Grouping)new Grouping<GHPullRequestReviewThread, String>($this$groupingBy$iv){
                    final /* synthetic */ Iterable $this_groupingBy;
                    {
                        this.$this_groupingBy = $receiver;
                    }

                    @NotNull
                    public Iterator<GHPullRequestReviewThread> sourceIterator() {
                        return this.$this_groupingBy.iterator();
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object keyOf(Object element) {
                        GHPullRequestReviewThread it = (GHPullRequestReviewThread)element;
                        boolean bl = false;
                        return it.getPath();
                    }
                })));
                GHPRProgressTreeModel.access$fireModelChanged(this.this$0);
            }
        });
    }

    private final void loadViewedState() {
        CompletableFutureUtil.INSTANCE.handleOnEdt(this.viewedStateData.loadViewedState(), (Disposable)this, (Function2)new Function2<Map<String, ? extends GHPullRequestFileViewedState>, Throwable, Unit>(this){
            final /* synthetic */ GHPRProgressTreeModel this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable Map<String, ? extends GHPullRequestFileViewedState> viewedState2, @Nullable Throwable throwable) {
                if (viewedState2 == null) {
                    return;
                }
                GHPRProgressTreeModel.access$setFilesViewedState$p(this.this$0, viewedState2);
                GHPRProgressTreeModel.access$fireModelChanged(this.this$0);
            }
        });
    }

    public void dispose() {
    }

    @Nullable
    public Change asLeaf(@NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object object = node.getUserObject();
        return object instanceof Change ? (Change)object : null;
    }

    public boolean isRead(@NotNull Change leafValue) {
        Intrinsics.checkNotNullParameter((Object)leafValue, (String)"leafValue");
        if (!((Boolean)this.canShowRead.invoke()).booleanValue()) {
            return true;
        }
        String repositoryRelativePath = VcsFileUtil.relativePath((VirtualFile)this.repository.getRoot(), (FilePath)ChangesUtil.getFilePath((Change)leafValue));
        GHPullRequestFileViewedState gHPullRequestFileViewedState = this.filesViewedState.get(repositoryRelativePath);
        if (gHPullRequestFileViewedState == null) {
            return true;
        }
        GHPullRequestFileViewedState viewedState2 = gHPullRequestFileViewedState;
        return GHPullRequestChangedFileKt.isViewed(viewedState2);
    }

    public int getUnresolvedDiscussionsCount(@NotNull Change leafValue) {
        Intrinsics.checkNotNullParameter((Object)leafValue, (String)"leafValue");
        String repositoryRelativePath = VcsFileUtil.relativePath((VirtualFile)this.repository.getRoot(), (FilePath)ChangesUtil.getFilePath((Change)leafValue));
        Integer n = this.unresolvedThreadsCount.get(repositoryRelativePath);
        return n != null ? n : 0;
    }

    public static final /* synthetic */ void access$setUnresolvedThreadsCount$p(GHPRProgressTreeModel $this, Map map2) {
        $this.unresolvedThreadsCount = map2;
    }

    public static final /* synthetic */ void access$fireModelChanged(GHPRProgressTreeModel $this) {
        $this.fireModelChanged();
    }

    public static final /* synthetic */ void access$setFilesViewedState$p(GHPRProgressTreeModel $this, Map map2) {
        $this.filesViewedState = map2;
    }
}

