/*
 * Decompiled with CFR 0.152.
 */
package circlet.calendar;

import circlet.calendar.DateCalendarItem;
import circlet.calendar.DateCalendarPage;
import circlet.calendar.DateCalendarStyle;
import circlet.calendar.DateCalendarVmInputs;
import circlet.calendar.DateCalendarVmOutputs;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.utils.InfiniteRange;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0016\u0018\u0000 O*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002OPBK\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\u0012\b\u0002\u0010\t\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J$\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u0000022\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J^\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0010\u00105\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0$2\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00028\u00000\u00122\n\u00106\u001a\u00060\u0007j\u0002`\b2\u0006\u00107\u001a\u0002082\u0010\u00109\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\nH\u0002J \u0010:\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0$2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\u001e\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u001e\u0010=\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J(\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0010\u0010?\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0$2\u0006\u0010@\u001a\u00020AH\u0002J\u001e\u0010B\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0$2\n\u0010C\u001a\u00060\u0007j\u0002`\bH\u0002J \u0010D\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0$2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002J\b\u0010E\u001a\u000200H\u0002J,\u0010E\u001a\u0002002\u0012\b\u0002\u0010F\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n2\u0010\b\u0002\u0010G\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bJ\u0012\u0010H\u001a\u0002002\n\u0010C\u001a\u00060\u0007j\u0002`\bJ \u0010I\u001a\u0002002\u000e\u0010G\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\b\b\u0002\u0010J\u001a\u00020AJ\b\u0010K\u001a\u000200H\u0016J\u0016\u0010L\u001a\u0002002\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\b\u0010M\u001a\u000200H\u0016J\b\u0010N\u001a\u000200H\u0002RD\u0010\u0013\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00028\u00000\u00122\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0004\u0012\u00028\u00000\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\t\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00060\u0007j\u0002`\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001b\u0010#\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R$\u0010'\u001a\u0018\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R \u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001c\u00a8\u0006Q"}, d2={"Lcirclet/calendar/DateCalendarVM;", "ItemContent", "Lcirclet/calendar/DateCalendarVmInputs;", "Lcirclet/calendar/DateCalendarVmOutputs;", "delegate", "Lcirclet/calendar/DateCalendarVM$Delegate;", "selectedDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "datesDisplayRange", "Lruntime/utils/InfiniteRange;", "firstDayOfWeek", "Lkotlin/Function0;", "Lcirclet/platform/api/Weekday;", "style", "Lcirclet/calendar/DateCalendarStyle;", "(Lcirclet/calendar/DateCalendarVM$Delegate;Lcirclet/platform/api/KotlinXDate;Lruntime/utils/InfiniteRange;Lkotlin/jvm/functions/Function0;Lcirclet/calendar/DateCalendarStyle;)V", "value", "", "contentItems", "getContentItems", "()Ljava/util/Map;", "setContentItems", "(Ljava/util/Map;)V", "currentPage", "Lruntime/reactive/MutableProperty;", "Lcirclet/calendar/DateCalendarPage;", "getCurrentPage", "()Lruntime/reactive/MutableProperty;", "fullRange", "getFullRange", "()Lruntime/utils/InfiniteRange;", "initialDate", "getInitialDate", "()Lcirclet/platform/api/KotlinXDate;", "initialRange", "Lkotlin/ranges/ClosedRange;", "getInitialRange", "()Lkotlin/ranges/ClosedRange;", "pagesCache", "", "getStyle", "()Lcirclet/calendar/DateCalendarStyle;", "weekdayLabels", "", "", "getWeekdayLabels", "didTapItem", "", "item", "Lcirclet/calendar/DateCalendarItem;", "onPage", "makePageForRange", "pageRange", "today", "itemsCount", "", "calendarRange", "nextPageRange", "page", "pageAfter", "pageBefore", "pageForRange", "range", "useCache", "", "pageRangeWithBaseDate", "date", "previousPageRange", "reloadData", "newDisplayRange", "newSelectedDate", "scrollToDate", "setSelectedDate", "focusSelectedRange", "showNextPage", "showPage", "showPreviousPage", "updateWeekdaysIfNeeded", "Companion", "Delegate", "app-state"})
@SourceDebugExtension(value={"SMAP\nDateCalendarVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateCalendarVM.kt\ncirclet/calendar/DateCalendarVM\n+ 2 ClosedRange.kt\nruntime/utils/ClosedRangeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n77#2:252\n1549#3:253\n1620#3,3:254\n*S KotlinDebug\n*F\n+ 1 DateCalendarVM.kt\ncirclet/calendar/DateCalendarVM\n*L\n194#1:252\n194#1:253\n194#1:254,3\n*E\n"})
public class DateCalendarVM<ItemContent>
implements DateCalendarVmInputs<ItemContent>,
DateCalendarVmOutputs<ItemContent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Delegate delegate;
    @Nullable
    private KotlinXDate selectedDate;
    @NotNull
    private InfiniteRange<KotlinXDate> datesDisplayRange;
    @NotNull
    private final Function0<Weekday> firstDayOfWeek;
    @NotNull
    private final DateCalendarStyle style;
    @NotNull
    private final Map<KotlinXDate, DateCalendarPage<ItemContent>> pagesCache;
    @NotNull
    private Map<KotlinXDate, ? extends ItemContent> contentItems;
    @NotNull
    private final ClosedRange<KotlinXDate> initialRange;
    @NotNull
    private final MutableProperty<DateCalendarPage<ItemContent>> currentPage;
    @NotNull
    private final MutableProperty<List<String>> weekdayLabels;
    public static final int numberOfLinesForMonth = 6;

    public DateCalendarVM(@Nullable Delegate delegate2, @Nullable KotlinXDate selectedDate, @NotNull InfiniteRange<KotlinXDate> datesDisplayRange, @NotNull Function0<? extends Weekday> firstDayOfWeek, @NotNull DateCalendarStyle style) {
        Intrinsics.checkNotNullParameter(datesDisplayRange, (String)"datesDisplayRange");
        Intrinsics.checkNotNullParameter(firstDayOfWeek, (String)"firstDayOfWeek");
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        this.delegate = delegate2;
        this.selectedDate = selectedDate;
        this.datesDisplayRange = datesDisplayRange;
        this.firstDayOfWeek = firstDayOfWeek;
        this.style = style;
        this.pagesCache = new LinkedHashMap();
        this.contentItems = MapsKt.emptyMap();
        this.initialRange = this.pageRangeWithBaseDate(this.getInitialDate());
        this.currentPage = PropertyKt.mutableProperty(this.pageForRange(this.initialRange, true));
        this.weekdayLabels = PropertyKt.mutableProperty(CollectionsKt.emptyList());
        this.updateWeekdaysIfNeeded();
    }

    public /* synthetic */ DateCalendarVM(Delegate delegate2, KotlinXDate kotlinXDate, InfiniteRange infiniteRange, Function0 function0, DateCalendarStyle dateCalendarStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kotlinXDate = null;
        }
        if ((n & 4) != 0) {
            infiniteRange = new InfiniteRange(null, null, 3, null);
        }
        this(delegate2, kotlinXDate, infiniteRange, (Function0<? extends Weekday>)function0, dateCalendarStyle);
    }

    @Override
    @NotNull
    public DateCalendarStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final InfiniteRange<KotlinXDate> getFullRange() {
        return this.datesDisplayRange;
    }

    @NotNull
    public final Map<KotlinXDate, ItemContent> getContentItems() {
        return this.contentItems;
    }

    public final void setContentItems(@NotNull Map<KotlinXDate, ? extends ItemContent> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.contentItems = value2;
        this.reloadData();
    }

    @NotNull
    public final ClosedRange<KotlinXDate> getInitialRange() {
        return this.initialRange;
    }

    @Override
    @NotNull
    public MutableProperty<DateCalendarPage<ItemContent>> getCurrentPage() {
        return this.currentPage;
    }

    @NotNull
    public MutableProperty<List<String>> getWeekdayLabels() {
        return this.weekdayLabels;
    }

    public final void setSelectedDate(@Nullable KotlinXDate newSelectedDate, boolean focusSelectedRange) {
        ClosedRange<KotlinXDate> range3 = ((DateCalendarPage)this.getCurrentPage().getValue()).getRange();
        if (!Intrinsics.areEqual((Object)this.selectedDate, (Object)newSelectedDate)) {
            this.pagesCache.clear();
            this.selectedDate = newSelectedDate;
        }
        if (focusSelectedRange && newSelectedDate != null) {
            range3 = this.pageRangeWithBaseDate(newSelectedDate);
        }
        this.getCurrentPage().setValue(this.pageForRange(range3, true));
    }

    public static /* synthetic */ void setSelectedDate$default(DateCalendarVM dateCalendarVM, KotlinXDate kotlinXDate, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setSelectedDate");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        dateCalendarVM.setSelectedDate(kotlinXDate, bl);
    }

    public final void scrollToDate(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        if (!this.datesDisplayRange.contains((KotlinXDate)((Comparable)date2))) {
            return;
        }
        ClosedRange<KotlinXDate> range3 = this.pageRangeWithBaseDate(date2);
        if (!Intrinsics.areEqual(range3, ((DateCalendarPage)this.getCurrentPage().getValue()).getRange())) {
            this.getCurrentPage().setValue(this.pageForRange(range3, true));
        }
    }

    public final void reloadData(@NotNull InfiniteRange<KotlinXDate> newDisplayRange, @Nullable KotlinXDate newSelectedDate) {
        ClosedRange<KotlinXDate> closedRange;
        Intrinsics.checkNotNullParameter(newDisplayRange, (String)"newDisplayRange");
        this.pagesCache.clear();
        if (!Intrinsics.areEqual((Object)newSelectedDate, (Object)this.selectedDate)) {
            KotlinXDate kotlinXDate = newSelectedDate;
            if (kotlinXDate == null) {
                kotlinXDate = ADateJvmKt.getToday();
            }
            closedRange = this.pageRangeWithBaseDate(kotlinXDate);
        } else if (newDisplayRange.intersects(((DateCalendarPage)this.getCurrentPage().getValue()).getRange())) {
            closedRange = ((DateCalendarPage)this.getCurrentPage().getValue()).getRange();
        } else {
            KotlinXDate kotlinXDate = newSelectedDate;
            if (kotlinXDate == null) {
                kotlinXDate = ADateJvmKt.getToday();
            }
            closedRange = this.pageRangeWithBaseDate(kotlinXDate);
        }
        ClosedRange<KotlinXDate> range3 = closedRange;
        this.selectedDate = newSelectedDate;
        this.datesDisplayRange = newDisplayRange;
        DateCalendarPage<ItemContent> page = this.pageForRange(range3, true);
        if (!Intrinsics.areEqual(this.getCurrentPage().getValue(), page)) {
            this.getCurrentPage().setValue(page);
        } else {
            this.getCurrentPage().forceNotify();
        }
    }

    public static /* synthetic */ void reloadData$default(DateCalendarVM dateCalendarVM, InfiniteRange infiniteRange, KotlinXDate kotlinXDate, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadData");
        }
        if ((n & 1) != 0) {
            infiniteRange = dateCalendarVM.datesDisplayRange;
        }
        if ((n & 2) != 0) {
            kotlinXDate = dateCalendarVM.selectedDate;
        }
        dateCalendarVM.reloadData(infiniteRange, kotlinXDate);
    }

    @Override
    public void showNextPage() {
        block0: {
            DateCalendarPage<ItemContent> dateCalendarPage = this.pageAfter((DateCalendarPage)this.getCurrentPage().getValue());
            if (dateCalendarPage == null) break block0;
            DateCalendarPage<ItemContent> it = dateCalendarPage;
            boolean bl = false;
            this.getCurrentPage().setValue(it);
        }
    }

    @Override
    public void showPreviousPage() {
        block0: {
            DateCalendarPage<ItemContent> dateCalendarPage = this.pageBefore((DateCalendarPage)this.getCurrentPage().getValue());
            if (dateCalendarPage == null) break block0;
            DateCalendarPage<ItemContent> it = dateCalendarPage;
            boolean bl = false;
            this.getCurrentPage().setValue(it);
        }
    }

    @Override
    public void didTapItem(@NotNull DateCalendarItem<ItemContent> item2, @NotNull DateCalendarPage<ItemContent> onPage) {
        block0: {
            Intrinsics.checkNotNullParameter(item2, (String)"item");
            Intrinsics.checkNotNullParameter(onPage, (String)"onPage");
            Delegate delegate2 = this.delegate;
            if (delegate2 == null) break block0;
            delegate2.calendarVMDidSelectDate(item2.getDate());
        }
    }

    @Override
    public void showPage(@NotNull DateCalendarPage<ItemContent> page) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        this.getCurrentPage().setValue(page);
    }

    @Override
    @Nullable
    public DateCalendarPage<ItemContent> pageAfter(@NotNull DateCalendarPage<ItemContent> page) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        ClosedRange<KotlinXDate> nextPage = this.nextPageRange(page);
        return this.datesDisplayRange.intersects(nextPage) ? this.pageForRange(nextPage, true) : null;
    }

    @Override
    @Nullable
    public DateCalendarPage<ItemContent> pageBefore(@NotNull DateCalendarPage<ItemContent> page) {
        Intrinsics.checkNotNullParameter(page, (String)"page");
        ClosedRange<KotlinXDate> previousPage = this.previousPageRange(page);
        return this.datesDisplayRange.intersects(previousPage) ? this.pageForRange(previousPage, true) : null;
    }

    private final KotlinXDate getInitialDate() {
        KotlinXDate kotlinXDate;
        if (this.selectedDate != null) {
            KotlinXDate kotlinXDate2 = this.selectedDate;
            kotlinXDate = kotlinXDate2;
            Intrinsics.checkNotNull((Object)kotlinXDate2);
        } else if (this.datesDisplayRange.contains((KotlinXDate)((Comparable)ADateJvmKt.getToday()))) {
            kotlinXDate = ADateJvmKt.getToday();
        } else if (this.datesDisplayRange.getStart() != null) {
            KotlinXDate kotlinXDate3 = this.datesDisplayRange.getStart();
            Intrinsics.checkNotNull((Object)kotlinXDate3);
            kotlinXDate = kotlinXDate3;
        } else {
            kotlinXDate = ADateJvmKt.getToday();
        }
        return kotlinXDate;
    }

    private final void reloadData() {
        this.pagesCache.clear();
        this.getCurrentPage().setValue(this.pageForRange(((DateCalendarPage)this.getCurrentPage().getValue()).getRange(), false));
    }

    private final ClosedRange<KotlinXDate> pageRangeWithBaseDate(KotlinXDate date2) {
        ClosedRange closedRange;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStyle().ordinal()]) {
            case 1: {
                closedRange = RangesKt.rangeTo((Comparable)ADateKt.startOfWeek(date2, (Weekday)((Object)this.firstDayOfWeek.invoke())), (Comparable)ADateKt.endOfWeek(date2, (Weekday)((Object)this.firstDayOfWeek.invoke())));
                break;
            }
            case 2: {
                closedRange = RangesKt.rangeTo((Comparable)ADateKt.getStartOfMonth(date2), (Comparable)ADateKt.getEndOfMonth(date2));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return closedRange;
    }

    private final ClosedRange<KotlinXDate> nextPageRange(DateCalendarPage<ItemContent> page) {
        ClosedRange<KotlinXDate> closedRange;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStyle().ordinal()]) {
            case 1: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.plusDays((KotlinXDate)page.getRange().getStart(), EntriesMappings.entries$0.size()));
                break;
            }
            case 2: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.plusMonths((KotlinXDate)page.getRange().getStart(), 1));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return closedRange;
    }

    private final ClosedRange<KotlinXDate> previousPageRange(DateCalendarPage<ItemContent> page) {
        ClosedRange<KotlinXDate> closedRange;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStyle().ordinal()]) {
            case 1: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.minusDays((KotlinXDate)page.getRange().getStart(), EntriesMappings.entries$0.size()));
                break;
            }
            case 2: {
                closedRange = this.pageRangeWithBaseDate(ADateJvmKt.minusMonths((KotlinXDate)page.getRange().getStart(), 1));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return closedRange;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateWeekdaysIfNeeded() {
        void $this$mapTo$iv$iv$iv;
        void $this$map$iv;
        ClosedRange closedRange = (ClosedRange)CollectionsKt.getIndices((Collection)((Collection)EntriesMappings.entries$0));
        Property property2 = this.getWeekdayLabels();
        boolean $i$f$map = false;
        Iterable $this$map$iv$iv = (Iterable)new IntRange(((Number)((Object)$this$map$iv.getStart())).intValue(), ((Number)((Object)$this$map$iv.getEndInclusive())).intValue());
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv$iv;
            int n = item$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            collection.add(WorkingDaysKt.weekdayToICal(WorkingDaysKt.weekday((int)((it + ((Weekday)((Object)this.firstDayOfWeek.invoke())).ordinal()) % EntriesMappings.entries$0.size()))));
        }
        property2.setValue((List)destination$iv$iv$iv);
    }

    private final DateCalendarPage<ItemContent> pageForRange(ClosedRange<KotlinXDate> range3, boolean useCache) {
        int n;
        DateCalendarPage<ItemContent> cachedPage;
        if (useCache && (cachedPage = this.pagesCache.get(range3.getStart())) != null) {
            return cachedPage;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getStyle().ordinal()]) {
            case 1: {
                n = EntriesMappings.entries$0.size();
                break;
            }
            case 2: {
                n = EntriesMappings.entries$0.size() * 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int size2 = n;
        DateCalendarPage<? extends ItemContent> page = this.makePageForRange(range3, this.contentItems, ADateJvmKt.getToday(), size2, this.datesDisplayRange);
        this.pagesCache.put((KotlinXDate)range3.getStart(), page);
        return page;
    }

    private final DateCalendarPage<ItemContent> makePageForRange(ClosedRange<KotlinXDate> pageRange, Map<KotlinXDate, ? extends ItemContent> contentItems, KotlinXDate today, int itemsCount, InfiniteRange<KotlinXDate> calendarRange) {
        KotlinXDate currentDate = null;
        currentDate = ADateKt.startOfWeek((KotlinXDate)pageRange.getStart(), (Weekday)((Object)this.firstDayOfWeek.invoke()));
        ArrayList<DateCalendarItem<ItemContent>> items2 = new ArrayList<DateCalendarItem<ItemContent>>(EntriesMappings.entries$0.size());
        int dayNumber = 0;
        dayNumber = ADateJvmKt.getDayOfMonth(currentDate);
        int totalDaysCount = 0;
        totalDaysCount = ADateKt.getNumberOfDaysInMonth(currentDate);
        for (int i = 0; i < itemsCount; ++i) {
            int it = i;
            boolean bl = false;
            items2.add(new DateCalendarItem<ItemContent>(currentDate, String.valueOf(dayNumber), Intrinsics.areEqual((Object)currentDate, (Object)today), Intrinsics.areEqual((Object)currentDate, (Object)this.selectedDate), !calendarRange.contains((KotlinXDate)((Comparable)currentDate)) || !pageRange.contains((Comparable)currentDate), contentItems.get(currentDate)));
            currentDate = ADateJvmKt.plusDays(currentDate, 1);
            if (dayNumber < totalDaysCount) {
                ++dayNumber;
                continue;
            }
            dayNumber = 1;
            totalDaysCount = ADateKt.getNumberOfDaysInMonth(currentDate);
        }
        return new DateCalendarPage(pageRange, (List)items2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcirclet/calendar/DateCalendarVM$Companion;", "", "()V", "numberOfLinesForMonth", "", "app-state"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H&\u00a8\u0006\u0007"}, d2={"Lcirclet/calendar/DateCalendarVM$Delegate;", "", "calendarVMDidSelectDate", "", "date", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "app-state"})
    public static interface Delegate {
        public void calendarVMDidSelectDate(@NotNull KotlinXDate var1);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Weekday> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])Weekday.values());
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DateCalendarStyle.values().length];
            try {
                nArray[DateCalendarStyle.WeekHorizontal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateCalendarStyle.MonthHorizontal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

