/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.DocumentFolder;
import circlet.client.api.DraftsKt;
import circlet.client.api.RefResolverExtKt;
import circlet.common.documents.FolderPermissionChecker;
import circlet.common.permissions.CreateDocuments;
import circlet.common.permissions.DocumentFolderRight;
import circlet.common.permissions.ViewFoldersMetadata;
import circlet.platform.api.Ref;
import circlet.platform.api.RefResolver;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcirclet/client/api/FolderRecordPermissionsChecker;", "Lcirclet/common/documents/FolderPermissionChecker;", "folder", "Lcirclet/client/api/DocumentFolder;", "refResolver", "Lcirclet/platform/api/RefResolver;", "grantedRights", "", "", "(Lcirclet/client/api/DocumentFolder;Lcirclet/platform/api/RefResolver;Ljava/util/List;)V", "getParentFolderChecker", "hasPermission", "", "right", "Lcirclet/common/permissions/DocumentFolderRight;", "hasPermissionInParentContext", "isArchived", "isContainerAccessible", "client-api"})
@SourceDebugExtension(value={"SMAP\nDrafts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Drafts.kt\ncirclet/client/api/FolderRecordPermissionsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1727:1\n1747#2,3:1728\n1747#2,3:1732\n1747#2,3:1735\n1#3:1731\n*S KotlinDebug\n*F\n+ 1 Drafts.kt\ncirclet/client/api/FolderRecordPermissionsChecker\n*L\n1606#1:1728,3\n1610#1:1732,3\n1611#1:1735,3\n*E\n"})
public final class FolderRecordPermissionsChecker
implements FolderPermissionChecker {
    @NotNull
    private final DocumentFolder folder;
    @NotNull
    private final RefResolver refResolver;
    @NotNull
    private final List<String> grantedRights;

    public FolderRecordPermissionsChecker(@NotNull DocumentFolder folder, @NotNull RefResolver refResolver, @NotNull List<String> grantedRights) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)refResolver, (String)"refResolver");
        Intrinsics.checkNotNullParameter(grantedRights, (String)"grantedRights");
        this.folder = folder;
        this.refResolver = refResolver;
        this.grantedRights = grantedRights;
    }

    public /* synthetic */ FolderRecordPermissionsChecker(DocumentFolder documentFolder, RefResolver refResolver, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = documentFolder.getGrantedRights();
        }
        this(documentFolder, refResolver, list2);
    }

    @Override
    public boolean hasPermission(@NotNull DocumentFolderRight right) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Iterable $this$any$iv = this.grantedRights;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)right.getUniqueCode-lTrUgfw())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean hasPermissionInParentContext(@NotNull DocumentFolderRight right) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Ref<DocumentFolder> ref2 = this.folder.getParent();
            if (ref2 != null) {
                Ref<DocumentFolder> it = ref2;
                boolean bl2 = false;
                Iterable $this$any$iv = RefResolverExtKt.resolveWith(it, this.refResolver).getGrantedRights();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it2 = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it2, (Object)right.getUniqueCode-lTrUgfw())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            } else {
                Object object = this.folder.getContainerInfo();
                if (object != null && (object = object.getGrantedRights()) != null) {
                    Iterable $this$any$iv = (Iterable)object;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)right.getUniqueCode-lTrUgfw())) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isArchived() {
        return this.folder.getArchived();
    }

    @Override
    @Nullable
    public FolderPermissionChecker getParentFolderChecker() {
        FolderRecordPermissionsChecker folderRecordPermissionsChecker;
        Ref<DocumentFolder> ref2 = this.folder.getParent();
        if (ref2 != null) {
            Ref<DocumentFolder> it = ref2;
            boolean bl = false;
            folderRecordPermissionsChecker = new FolderRecordPermissionsChecker(RefResolverExtKt.resolveWith(it, this.refResolver), this.refResolver, null, 4, null);
        } else {
            folderRecordPermissionsChecker = null;
        }
        return folderRecordPermissionsChecker;
    }

    @Override
    public boolean isContainerAccessible() {
        boolean bl;
        List<String> list2 = DraftsKt.getContainerInfo(this.folder).getGrantedRights();
        if (list2 != null) {
            List<String> it = list2;
            boolean bl2 = false;
            bl = it.contains(ViewFoldersMetadata.INSTANCE.getUniqueCode-lTrUgfw()) || it.contains(CreateDocuments.INSTANCE.getUniqueCode-lTrUgfw());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean canRestore() {
        return FolderPermissionChecker.DefaultImpls.canRestore(this);
    }
}

