/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.CalendarEventSpec;
import circlet.common.calendar.ClosedTimeInterval;
import circlet.common.calendar.DatesInterval;
import circlet.common.calendar.EventCountersKt;
import circlet.common.calendar.RecurrenceRuleEnds;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.SpecInstancesKt;
import circlet.common.calendar.TimeIntervalDTO;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.ADateKt;
import circlet.platform.api.ATimeZone;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.Math;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u001aH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\n\u0010\u000b\u001a\u00060\tj\u0002`\n2\n\u0010\f\u001a\u00060\tj\u0002`\n2\n\u0010\r\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0010\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\u0011\u001a\u00020\u0012\u001a*\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\f\u001a\u00060\tj\u0002`\n\u001a\"\u0010\u001a\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001d\u001a\"\u0010\u001a\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u001e\u001a\u001a\u0010\u001f\u001a\u00020 *\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000f\u001a\"\u0010$\u001a\u00020\u0005*\u00020\u00122\n\u0010%\u001a\u00060\tj\u0002`\n2\n\u0010&\u001a\u00060\tj\u0002`\n\u001a\u0012\u0010'\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u0015\u001a\u001a\u0010(\u001a\u00060\tj\u0002`\n*\u00020\u00122\n\u0010)\u001a\u00060\u0014j\u0002`\u0015\u001a\u0016\u0010*\u001a\u00020+*\u00020\u00122\n\u0010)\u001a\u00060\u0014j\u0002`\u0015\u001a*\u0010,\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u00152\u0006\u0010)\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007\u001a\"\u0010/\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u00152\u0006\u0010)\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007\u001a*\u00100\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u00152\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007\u001a\u0012\u00103\u001a\u00060\u0014j\u0002`\u0015*\u00060\u0014j\u0002`\u0015\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u00064"}, d2={"log", "Llibraries/klogging/KLogger;", "getLog", "()Llibraries/klogging/KLogger;", "doesMonthlyOnDateIntersect", "", "freqInterval", "", "meetingStart", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "meetingEnd", "start", "end", "zone", "Lcirclet/platform/api/ATimeZone;", "lastOccurrenceStart", "event", "Lcirclet/common/calendar/CalendarEventSpec;", "lastOccurrenceStartLocalDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "ends", "Lcirclet/common/calendar/RecurrenceRuleEnds;", "freq", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "startThisMonth", "year", "month", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnFirstWeekday;", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnLastWeekday;", "calcDatesInterval", "Lcirclet/common/calendar/DatesInterval;", "timeInterval", "Lcirclet/common/calendar/TimeIntervalDTO;", "targetTimezone", "intersects", "_start", "_end", "monthStart", "startTimeAtDay", "day", "timeIntervalAtDay", "Lcirclet/common/calendar/ClosedTimeInterval;", "toLastDateWithMonthDay", "interval", "repetitions", "toNextDateWithMonthDay", "toNextYearWithYearDay", "dayInMonth", "monthInYear", "yearStart", "common"})
@SourceDebugExtension(value={"SMAP\nSpecIntersects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecIntersects.kt\ncirclet/common/calendar/SpecIntersectsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ControlFlow.kt\nlibraries/basics/ControlFlowKt\n+ 5 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,468:1\n1855#2:469\n1855#2,2:470\n1856#2:472\n1855#2,2:473\n1855#2,2:475\n1855#2,2:477\n766#2:484\n857#2,2:485\n1#3:479\n4#4,4:480\n13#5:487\n*S KotlinDebug\n*F\n+ 1 SpecIntersects.kt\ncirclet/common/calendar/SpecIntersectsKt\n*L\n87#1:469\n88#1:470,2\n87#1:472\n144#1:473,2\n170#1:475,2\n205#1:477,2\n328#1:484\n328#1:485,2\n267#1:480,4\n240#1:487\n*E\n"})
public final class SpecIntersectsKt {
    @NotNull
    private static final KLogger log;

    public static final boolean intersects(@NotNull CalendarEventSpec $this$intersects, @NotNull KotlinXDateTime _start, @NotNull KotlinXDateTime _end) {
        RecurrenceRuleFreq recurrenceRuleFreq;
        Comparable<KotlinXDateTime> newEnd;
        RecurrenceRuleFreq freq;
        Intrinsics.checkNotNullParameter((Object)$this$intersects, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)_start, (String)"_start");
        Intrinsics.checkNotNullParameter((Object)_end, (String)"_end");
        ATimeZone zone = $this$intersects.getTimezone();
        KotlinXDateTime start2 = ADateJvmKt.withZone(_start, zone);
        Comparable<KotlinXDateTime> end = null;
        end = ADateJvmKt.withZone(_end, zone);
        KotlinXDateTime meetingStart = ADateJvmKt.withZone($this$intersects.getStart(), zone);
        KotlinXDateTime meetingEnd = ADateJvmKt.withZone($this$intersects.getEnd(), zone);
        if (meetingStart.compareTo(end) >= 0) {
            return false;
        }
        if ($this$intersects.getRecurrenceRule() == null) {
            return meetingEnd.compareTo(start2) > 0;
        }
        RecurrenceRuleEnds ends = $this$intersects.getRecurrenceRule().getEnds();
        Comparable<KotlinXDate> comparable = SpecIntersectsKt.lastOccurrenceStartLocalDate(ends, freq = $this$intersects.getAllDay() ? $this$intersects.getRecurrenceRule().getFreq() : EventCountersKt.fix($this$intersects.getRecurrenceRule().getFreq(), $this$intersects.getStart(), $this$intersects.getTimezone()), meetingStart);
        Comparable<KotlinXDateTime> comparable2 = comparable != null && (comparable = ADateJvmKt.toDateTimeAtStartOfDay(comparable, zone)) != null ? ADateJvmKt.withTime((KotlinXDateTime)comparable, 23, 59, 59, 0) : (newEnd = null);
        if (newEnd != null) {
            if (newEnd.compareTo((KotlinXDateTime)end) < 0) {
                end = newEnd;
            }
            if (end.compareTo(start2) < 0) {
                return false;
            }
        }
        if ((recurrenceRuleFreq = freq) instanceof RecurrenceRuleFreq.Daily) {
            if (meetingEnd.compareTo(start2) > 0) {
                return true;
            }
            int intervals = java.lang.Math.max(0, ADateJvmKt.daysBetween(meetingEnd, start2) - 1) / ((RecurrenceRuleFreq.Daily)freq).getInterval() + 1;
            KotlinXDateTime nextMeetingStat = ADateJvmKt.plusDays(meetingStart, intervals * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            KotlinXDateTime nextMeetingEnd = ADateJvmKt.plusDays(meetingEnd, intervals * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            if (nextMeetingStat.compareTo(end) >= 0) {
                return false;
            }
            if (nextMeetingEnd.compareTo(start2) > 0) {
                return true;
            }
            KotlinXDateTime nextMeetingStat2 = ADateJvmKt.plusDays(meetingStart, (intervals + 1) * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            KotlinXDateTime nextMeetingEnd2 = ADateJvmKt.plusDays(meetingEnd, (intervals + 1) * ((RecurrenceRuleFreq.Daily)freq).getInterval());
            if (nextMeetingStat2.compareTo(end) >= 0) {
                return false;
            }
            return nextMeetingEnd2.compareTo(start2) > 0;
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            int intervals = java.lang.Math.max(0, ADateJvmKt.daysBetween(meetingEnd, start2) - 1) / (7 * ((RecurrenceRuleFreq.Weekly)freq).getInterval());
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator nextMeetingStat2 = $this$forEach$iv.iterator();
            while (nextMeetingStat2.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)nextMeetingStat2).nextInt();
                boolean bl = false;
                Iterable $this$forEach$iv2 = (Iterable)new IntRange(0, 6);
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    int element$iv2;
                    int dow = element$iv2 = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    KotlinXDateTime nextMeetingStart = ADateJvmKt.plusDays(meetingStart, (intervals + shift) * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + dow);
                    KotlinXDateTime nextMeetingEnd = ADateJvmKt.plusDays(meetingEnd, (intervals + shift) * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + dow);
                    if (!((RecurrenceRuleFreq.Weekly)freq).getWeekdays().contains((Object)ADateJvmKt.getWeekday(nextMeetingStart))) continue;
                    if (nextMeetingStart.compareTo(end) >= 0) {
                        return false;
                    }
                    if (nextMeetingEnd.compareTo(start2) <= 0) continue;
                    return true;
                }
            }
            return false;
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            if (meetingEnd.compareTo(start2) > 0) {
                return true;
            }
            int intervals = java.lang.Math.max(0, ADateJvmKt.yearsBetween(meetingEnd, start2) - 1) / ((RecurrenceRuleFreq.Yearly)freq).getInterval() + 1;
            KotlinXDateTime nextMeetingStat = ADateJvmKt.plusYears(meetingStart, intervals * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            KotlinXDateTime nextMeetingEnd = ADateJvmKt.plusYears(meetingEnd, intervals * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            if (nextMeetingStat.compareTo(end) >= 0) {
                return false;
            }
            if (nextMeetingEnd.compareTo(start2) > 0) {
                return true;
            }
            KotlinXDateTime nextMeetingStat2 = ADateJvmKt.plusYears(meetingStart, (intervals + 1) * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            KotlinXDateTime nextMeetingEnd2 = ADateJvmKt.plusYears(meetingEnd, (intervals + 1) * ((RecurrenceRuleFreq.Yearly)freq).getInterval());
            if (nextMeetingStat2.compareTo(end) >= 0) {
                return false;
            }
            return nextMeetingEnd2.compareTo(start2) > 0;
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            return SpecIntersectsKt.doesMonthlyOnDateIntersect(((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval(), meetingStart, meetingEnd, start2, end, zone);
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            return SpecIntersectsKt.doesMonthlyOnDateIntersect(((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval(), meetingStart, meetingEnd, start2, end, zone);
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            int intervals = java.lang.Math.max(0, ADateJvmKt.monthsBetween(meetingEnd, start2) - 1) / ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval();
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)iterator3).nextInt();
                boolean bl = false;
                KotlinXDate startDate = ADateJvmKt.toDate(meetingStart);
                KotlinXDate nextMeetingStatMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(startDate, 1), (intervals + shift) * ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval());
                KotlinXDate nextMeetingStatDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMeetingStatMonth), ADateJvmKt.getMonth(nextMeetingStatMonth), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
                int days = ADateJvmKt.daysBetween(startDate, nextMeetingStatDate);
                KotlinXDateTime nextMeetingStat = ADateJvmKt.plusDays(meetingStart, days);
                KotlinXDateTime nextMeetingEnd = ADateJvmKt.plusDays(meetingEnd, days);
                if (nextMeetingStat.compareTo(end) >= 0) {
                    return false;
                }
                if (nextMeetingEnd.compareTo(start2) <= 0) continue;
                return true;
            }
            return false;
        }
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            int intervals = java.lang.Math.max(0, ADateJvmKt.monthsBetween(meetingEnd, start2) - 1) / ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval();
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator iterator4 = $this$forEach$iv.iterator();
            while (iterator4.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)iterator4).nextInt();
                boolean bl = false;
                KotlinXDate startDate = ADateJvmKt.toDate(meetingStart);
                KotlinXDate nextMeetingStatMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(startDate, 1), (intervals + shift) * ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval());
                KotlinXDate nextMeetingStatDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMeetingStatMonth), ADateJvmKt.getMonth(nextMeetingStatMonth), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
                int days = ADateJvmKt.daysBetween(startDate, nextMeetingStatDate);
                KotlinXDateTime nextMeetingStat = ADateJvmKt.plusDays(meetingStart, days);
                KotlinXDateTime nextMeetingEnd = ADateJvmKt.plusDays(meetingEnd, days);
                if (nextMeetingStat.compareTo(end) >= 0) {
                    return false;
                }
                if (nextMeetingEnd.compareTo(start2) <= 0) continue;
                return true;
            }
            return false;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final boolean doesMonthlyOnDateIntersect(int freqInterval, KotlinXDateTime meetingStart, KotlinXDateTime meetingEnd, KotlinXDateTime start2, KotlinXDateTime end, ATimeZone zone) {
        boolean possibleEveryMonth;
        boolean bl = possibleEveryMonth = ADateJvmKt.getDayOfMonth(meetingStart) < 29;
        if (possibleEveryMonth) {
            int intervals = java.lang.Math.max(0, ADateJvmKt.monthsBetween(meetingEnd, start2) - 1) / freqInterval;
            Iterable $this$forEach$iv = (Iterable)new IntRange(0, 2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int shift = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl2 = false;
                KotlinXDateTime nextMeetingStat = ADateJvmKt.plusMonths(meetingStart, (intervals + shift) * freqInterval);
                KotlinXDateTime nextMeetingEnd = ADateJvmKt.plusMonths(meetingEnd, (intervals + shift) * freqInterval);
                if (nextMeetingStat.compareTo(end) >= 0) {
                    return false;
                }
                if (nextMeetingEnd.compareTo(start2) <= 0) continue;
                return true;
            }
            return false;
        }
        KotlinXDateTime nextStart = meetingStart;
        int duration = ADateKt.minutesDifference(meetingStart, meetingEnd);
        while (nextStart.compareTo(end) < 0) {
            KotlinXDateTime nextEnd = ADateJvmKt.plusMinutes(nextStart, duration);
            if (nextEnd.compareTo(start2) > 0) {
                return true;
            }
            nextStart = ADateJvmKt.plusMinutes(ADateJvmKt.toDateTimeAtStartOfDay(SpecIntersectsKt.toNextDateWithMonthDay(ADateJvmKt.toDate(ADateJvmKt.withZone(nextStart, zone)), ADateJvmKt.getDayOfMonth(meetingStart), freqInterval), zone), ADateJvmKt.getMinuteOfDay(meetingStart));
        }
        return false;
    }

    @NotNull
    public static final KotlinXDateTime startTimeAtDay(@NotNull CalendarEventSpec $this$startTimeAtDay, @NotNull KotlinXDate day) {
        Intrinsics.checkNotNullParameter((Object)$this$startTimeAtDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        return SpecInstancesKt.shiftedSpec($this$startTimeAtDay, day, $this$startTimeAtDay.getTimezone()).getStart();
    }

    @NotNull
    public static final KLogger getLog() {
        return log;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final DatesInterval calcDatesInterval(@NotNull CalendarEventSpec $this$calcDatesInterval, @NotNull TimeIntervalDTO timeInterval, @NotNull ATimeZone targetTimezone) {
        Intrinsics.checkNotNullParameter((Object)$this$calcDatesInterval, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeInterval, (String)"timeInterval");
        Intrinsics.checkNotNullParameter((Object)targetTimezone, (String)"targetTimezone");
        intervalStart = timeInterval.getStart();
        startDateInEventZone = ADateJvmKt.toDate(ADateJvmKt.withZone(intervalStart, $this$calcDatesInterval.getTimezone()));
        intervalEnd = timeInterval.getEnd();
        v0 = intervalEnd;
        endDateInEventZone = v0 != null && (v0 = ADateJvmKt.withZone(v0, $this$calcDatesInterval.getTimezone())) != null ? ADateJvmKt.toDate(v0) : null;
        it = var9_7 = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, startDateInEventZone);
        $i$a$-takeIf-SpecIntersectsKt$calcDatesInterval$firstOccurrenceOnInterval$1 = false;
        v1 = it.compareTo(intervalStart) >= 0 != false ? var9_7 : null;
        if (v1 == null) {
            it = it = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, ADateJvmKt.plusDays(startDateInEventZone, 1));
            $i$a$-takeIf-SpecIntersectsKt$calcDatesInterval$firstOccurrenceOnInterval$2 = false;
            v1 = (intervalEnd == null || it.compareTo(intervalEnd) < 0) != false ? it : null;
            if (v1 == null) {
                v1 = intervalStart;
            }
        }
        firstOccurrenceOnInterval = v1;
        v2 = endDateInEventZone;
        if (v2 != null) {
            date = v2;
            $i$a$-let-SpecIntersectsKt$calcDatesInterval$lastOccurrenceOnInterval$1 = false;
            var12_13 = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, date);
            startTime = var12_13;
            $i$a$-takeIf-SpecIntersectsKt$calcDatesInterval$lastOccurrenceOnInterval$1$1 = false;
            v3 /* !! */  = startTime.compareTo(intervalEnd) < 0 != false ? var12_13 : null;
            if (v3 /* !! */  == null) {
                it = startTime = SpecIntersectsKt.startTimeAtDay($this$calcDatesInterval, ADateJvmKt.plusDays(date, -1));
                $i$a$-takeIf-SpecIntersectsKt$calcDatesInterval$lastOccurrenceOnInterval$1$2 = false;
                v3 /* !! */  = it.compareTo(intervalStart) >= 0 != false ? startTime : null;
                if (v3 /* !! */  == null) {
                    v3 /* !! */  = intervalEnd;
                }
            }
        } else {
            v3 /* !! */  = null;
        }
        lastOccurrenceOnInterval = v3 /* !! */ ;
        inclusiveStartDate = ADateJvmKt.toDate(ADateJvmKt.withZone(firstOccurrenceOnInterval, targetTimezone));
        v4 = lastOccurrenceOnInterval;
        endDate = v4 != null && (v4 = ADateJvmKt.withZone(v4, targetTimezone)) != null ? ADateJvmKt.toDate(v4) : null;
        v5 = endDate;
        if (v5 == null) ** GOTO lbl-1000
        startTime = v5;
        condition$iv = endDate.compareTo(inclusiveStartDate) < 0;
        $i$f$chainIf = false;
        if (condition$iv) {
            $this$calcDatesInterval_u24lambda_u2410 = $this$chainIf$iv;
            $i$a$-chainIf-SpecIntersectsKt$calcDatesInterval$exclusiveEndDate$1 = false;
            v6 = inclusiveStartDate;
        } else {
            v6 = $this$chainIf$iv;
        }
        v5 = v6;
        if (v6 != null) {
            v7 = ADateJvmKt.plusDays(v5, 1);
        } else lbl-1000:
        // 2 sources

        {
            v7 = null;
        }
        exclusiveEndDate = v7;
        return new DatesInterval(inclusiveStartDate, exclusiveEndDate);
    }

    @NotNull
    public static final ClosedTimeInterval timeIntervalAtDay(@NotNull CalendarEventSpec $this$timeIntervalAtDay, @NotNull KotlinXDate day) {
        Intrinsics.checkNotNullParameter((Object)$this$timeIntervalAtDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        KotlinXDateTime start2 = SpecIntersectsKt.startTimeAtDay($this$timeIntervalAtDay, day);
        KotlinXDateTime end = ADateJvmKt.plusMinutes(start2, EventCountersKt.durationInMinutes($this$timeIntervalAtDay));
        return new ClosedTimeInterval(start2, end);
    }

    @Nullable
    public static final KotlinXDateTime lastOccurrenceStart(@NotNull CalendarEventSpec event2) {
        KotlinXDateTime kotlinXDateTime;
        int n;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        KotlinXDateTime startInZone = ADateJvmKt.withZone(event2.getStart(), event2.getTimezone());
        if (event2.getRecurrenceRule() == null) {
            return startInZone;
        }
        RecurrenceRuleEnds ends = event2.getRecurrenceRule().getEnds();
        RecurrenceRuleFreq freq = event2.getRecurrenceRule().getFreq();
        KotlinXDate kotlinXDate = SpecIntersectsKt.lastOccurrenceStartLocalDate(ends, freq, startInZone);
        if (kotlinXDate == null) {
            return null;
        }
        KotlinXDate lastDateInZone = kotlinXDate;
        KotlinXDateTime startTimeAtDay = SpecIntersectsKt.startTimeAtDay(event2, lastDateInZone);
        KotlinXDate nextOccurrence = EventCountersKt.nextOccurrence(event2, startTimeAtDay, true);
        if (nextOccurrence != null) {
            return startTimeAtDay;
        }
        RecurrenceRuleFreq recurrenceRuleFreq = freq;
        if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
            n = 1 * ((RecurrenceRuleFreq.Daily)freq).getInterval();
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
            n = 7 * ((RecurrenceRuleFreq.Weekly)freq).getInterval();
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval();
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval();
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval();
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            n = 31 * ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval();
        } else if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
            n = 365 * ((RecurrenceRuleFreq.Yearly)freq).getInterval();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int periodInDays = n;
        KotlinXDate kotlinXDate2 = EventCountersKt.nextOccurrence(event2, ADateJvmKt.plusDays(startTimeAtDay, -periodInDays), true);
        if (kotlinXDate2 != null) {
            KotlinXDate it = kotlinXDate2;
            boolean bl = false;
            kotlinXDateTime = SpecIntersectsKt.startTimeAtDay(event2, it);
        } else {
            kotlinXDateTime = null;
        }
        return kotlinXDateTime;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinXDate lastOccurrenceStartLocalDate(@NotNull RecurrenceRuleEnds ends, @NotNull RecurrenceRuleFreq freq, @NotNull KotlinXDateTime start2) {
        Intrinsics.checkNotNullParameter((Object)ends, (String)"ends");
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        RecurrenceRuleEnds recurrenceRuleEnds = ends;
        if (recurrenceRuleEnds instanceof RecurrenceRuleEnds.OnDate) {
            return ((RecurrenceRuleEnds.OnDate)ends).getDate();
        }
        if (recurrenceRuleEnds instanceof RecurrenceRuleEnds.TotalCount) {
            int reps = ((RecurrenceRuleEnds.TotalCount)ends).getCount();
            RecurrenceRuleFreq recurrenceRuleFreq = freq;
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Daily) {
                return ADateJvmKt.toDate(ADateJvmKt.plusDays(start2, (reps - 1) * ((RecurrenceRuleFreq.Daily)freq).getInterval()));
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Weekly) {
                void $this$filterTo$iv$iv;
                int perWeek = ((Collection)((RecurrenceRuleFreq.Weekly)freq).getWeekdays()).size();
                if (perWeek == 0) {
                    return null;
                }
                int intervals = (reps - 1) / perWeek;
                int wkDayCnt = (reps - 1) % perWeek;
                Iterable $this$filter$iv = (Iterable)new IntRange(0, 6);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int shift = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!((RecurrenceRuleFreq.Weekly)freq).getWeekdays().contains((Object)ADateJvmKt.getWeekday(ADateJvmKt.plusDays(start2, intervals * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + shift)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                int shift = ((Number)((List)destination$iv$iv).get(wkDayCnt)).intValue();
                return ADateJvmKt.toDate(ADateJvmKt.plusDays(start2, intervals * ((RecurrenceRuleFreq.Weekly)freq).getInterval() * 7 + shift));
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.Yearly) {
                boolean leapYearEvent = ADateJvmKt.getMonth(start2) == 2 && ADateJvmKt.getDayOfMonth(start2) == 29;
                int yearsBetweenEvents = leapYearEvent ? Math.INSTANCE.lcd(((RecurrenceRuleFreq.Yearly)freq).getInterval(), 4) : ((RecurrenceRuleFreq.Yearly)freq).getInterval();
                return ADateJvmKt.toDate(ADateJvmKt.plusYears(start2, (reps - 1) * yearsBetweenEvents));
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
                KotlinXDate firstStartDate = ADateJvmKt.getDayOfMonth(start2) == ((RecurrenceRuleFreq.MonthlyOnDate)freq).getDay() ? ADateJvmKt.toDate(start2) : SpecIntersectsKt.toNextDateWithMonthDay(ADateJvmKt.toDate(start2), ((RecurrenceRuleFreq.MonthlyOnDate)freq).getDay(), 1);
                return ADateJvmKt.getDayOfMonth(firstStartDate) < 29 ? ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval()) : SpecIntersectsKt.toLastDateWithMonthDay(firstStartDate, ADateJvmKt.getDayOfMonth(firstStartDate), ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval(), reps);
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
                KotlinXDate firstStartDate = ADateJvmKt.toDate(start2);
                return ADateJvmKt.getDayOfMonth(firstStartDate) < 29 ? ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval()) : SpecIntersectsKt.toLastDateWithMonthDay(firstStartDate, ADateJvmKt.getDayOfMonth(firstStartDate), ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval(), reps);
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
                KotlinXDate kotlinXDate;
                KotlinXDate startThisMonth = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(start2), ADateJvmKt.getMonth(start2), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
                if (startThisMonth.compareTo(ADateJvmKt.toDate(start2)) >= 0) {
                    kotlinXDate = startThisMonth;
                } else {
                    KotlinXDate nextMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(ADateJvmKt.toDate(start2), 1), 1);
                    kotlinXDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMonth), ADateJvmKt.getMonth(nextMonth), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
                }
                KotlinXDate firstStartDate = kotlinXDate;
                KotlinXDate lastMonth = ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval());
                return SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(lastMonth), ADateJvmKt.getMonth(lastMonth), (RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq);
            }
            if (recurrenceRuleFreq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
                KotlinXDate kotlinXDate;
                KotlinXDate startThisMonth = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(start2), ADateJvmKt.getMonth(start2), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
                if (startThisMonth.compareTo(ADateJvmKt.toDate(start2)) >= 0) {
                    kotlinXDate = startThisMonth;
                } else {
                    KotlinXDate nextMonth = ADateJvmKt.plusMonths(ADateJvmKt.withDay(ADateJvmKt.toDate(start2), 1), 1);
                    kotlinXDate = SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(nextMonth), ADateJvmKt.getMonth(nextMonth), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
                }
                KotlinXDate firstStartDate = kotlinXDate;
                KotlinXDate lastMonth = ADateJvmKt.plusMonths(firstStartDate, (reps - 1) * ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval());
                return SpecIntersectsKt.startThisMonth(ADateJvmKt.getYear(lastMonth), ADateJvmKt.getMonth(lastMonth), (RecurrenceRuleFreq.MonthlyOnLastWeekday)freq);
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    @NotNull
    public static final KotlinXDate toLastDateWithMonthDay(@NotNull KotlinXDate $this$toLastDateWithMonthDay, int day, int interval2, int repetitions) {
        Intrinsics.checkNotNullParameter((Object)$this$toLastDateWithMonthDay, (String)"<this>");
        KotlinXDate nextDay = null;
        nextDay = $this$toLastDateWithMonthDay;
        int n = repetitions - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            nextDay = SpecIntersectsKt.toNextDateWithMonthDay(nextDay, day, interval2);
        }
        return nextDay;
    }

    @NotNull
    public static final KotlinXDate toNextDateWithMonthDay(@NotNull KotlinXDate $this$toNextDateWithMonthDay, int day, int interval2) {
        Intrinsics.checkNotNullParameter((Object)$this$toNextDateWithMonthDay, (String)"<this>");
        KotlinXDate nextDate = null;
        KotlinXDate nextMonth = SpecIntersectsKt.monthStart($this$toNextDateWithMonthDay);
        do {
            nextDate = ADateKt.withDayIfExist(nextMonth, day);
            nextMonth = ADateJvmKt.plusMonths(nextMonth, interval2);
        } while (nextDate == null || nextDate.compareTo($this$toNextDateWithMonthDay) <= 0);
        return nextDate;
    }

    @NotNull
    public static final KotlinXDate toNextYearWithYearDay(@NotNull KotlinXDate $this$toNextYearWithYearDay, int dayInMonth, int monthInYear, int interval2) {
        Intrinsics.checkNotNullParameter((Object)$this$toNextYearWithYearDay, (String)"<this>");
        KotlinXDate nextDate = null;
        KotlinXDate nextYear = SpecIntersectsKt.yearStart($this$toNextYearWithYearDay);
        do {
            nextDate = ADateKt.withDayIfExist(ADateJvmKt.plusMonths(nextYear, monthInYear - 1), dayInMonth);
            nextYear = ADateJvmKt.plusYears(nextYear, interval2);
        } while (nextDate == null || nextDate.compareTo($this$toNextYearWithYearDay) <= 0);
        return nextDate;
    }

    @NotNull
    public static final KotlinXDate monthStart(@NotNull KotlinXDate $this$monthStart) {
        Intrinsics.checkNotNullParameter((Object)$this$monthStart, (String)"<this>");
        return ADateJvmKt.withDay($this$monthStart, 1);
    }

    @NotNull
    public static final KotlinXDate yearStart(@NotNull KotlinXDate $this$yearStart) {
        Intrinsics.checkNotNullParameter((Object)$this$yearStart, (String)"<this>");
        return ADateJvmKt.aDate(ADateJvmKt.getYear($this$yearStart), 1, 1);
    }

    @NotNull
    public static final KotlinXDate startThisMonth(int year, int month, @NotNull RecurrenceRuleFreq.MonthlyOnFirstWeekday freq) {
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        KotlinXDate start2 = ADateJvmKt.plusDays(ADateJvmKt.aDate(year, month, 1), freq.getShift() * 7);
        for (int i = 0; i < 7; ++i) {
            KotlinXDate ret = ADateJvmKt.plusDays(start2, i);
            if (ADateJvmKt.getWeekday(ret) != freq.getWeekday()) continue;
            return ret;
        }
        return start2;
    }

    @NotNull
    public static final KotlinXDate startThisMonth(int year, int month, @NotNull RecurrenceRuleFreq.MonthlyOnLastWeekday freq) {
        Intrinsics.checkNotNullParameter((Object)freq, (String)"freq");
        KotlinXDate lastDay = ADateJvmKt.plusDays(ADateJvmKt.plusMonths(ADateJvmKt.aDate(year, month, 1), 1), -1);
        for (int i = 0; i < 7; ++i) {
            KotlinXDate ret = ADateJvmKt.plusDays(lastDay, -i);
            if (ADateJvmKt.getWeekday(ret) != freq.getWeekday()) continue;
            return ret;
        }
        return lastDay;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$logger$iv;
        KLoggers kLoggers = KLoggers.INSTANCE;
        String fallbackName$iv = "Spec";
        boolean $i$f$logger = false;
        log = $this$logger$iv.logger((Function0<String>)((Function0)new Function0<String>(fallbackName$iv){
            final /* synthetic */ String $fallbackName;
            {
                this.$fallbackName = $fallbackName;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$fallbackName;
            }
        }));
    }
}

