/*
 * Decompiled with CFR 0.152.
 */
package circlet.packages.maven;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcirclet/packages/maven/NexusService;", "", "()V", "Companion", "packages-maven-api"})
public final class NexusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SNAPSHOTS_PATH = "content/repositories/snapshots";
    @NotNull
    public static final String STAGING_DEPLOY_PATH = "service/local/staging/deploy/maven2";
    @NotNull
    private static final Regex OSSRH_URL_PATTERN = new Regex("https:\\/\\/([a-z0-9]+\\.)?oss\\.sonatype\\.org(\\/.*)?");

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcirclet/packages/maven/NexusService$Companion;", "", "()V", "OSSRH_URL_PATTERN", "Lkotlin/text/Regex;", "SNAPSHOTS_PATH", "", "STAGING_DEPLOY_PATH", "getRuleSetsPath", "getStagingDeployByIdPath", "repositoryId", "getStagingProfilesDropPath", "profileId", "getStagingProfilesFinishPath", "getStagingProfilesPath", "getStagingProfilesPromotePath", "getStagingProfilesStartPath", "getStagingRepositoryActivityPath", "getStagingRepositoryPath", "isOssrhReleaseRepositoryUrl", "", "url", "isOssrhSnapshotRepositoryUrl", "isOssrhUrl", "packages-maven-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRuleSetsPath() {
            return "service/local/staging/rule_sets";
        }

        @NotNull
        public final String getStagingProfilesPath() {
            return "service/local/staging/profiles";
        }

        @NotNull
        public final String getStagingProfilesDropPath(@NotNull String profileId) {
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            return "service/local/staging/profiles/" + profileId + "/drop";
        }

        @NotNull
        public final String getStagingProfilesFinishPath(@NotNull String profileId) {
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            return "service/local/staging/profiles/" + profileId + "/finish";
        }

        @NotNull
        public final String getStagingProfilesPromotePath(@NotNull String profileId) {
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            return "service/local/staging/profiles/" + profileId + "/promote";
        }

        @NotNull
        public final String getStagingProfilesStartPath(@NotNull String profileId) {
            Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
            return "service/local/staging/profiles/" + profileId + "/start";
        }

        @NotNull
        public final String getStagingDeployByIdPath(@NotNull String repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            return "service/local/staging/deployByRepositoryId/" + repositoryId;
        }

        @NotNull
        public final String getStagingRepositoryPath(@NotNull String repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            return "service/local/staging/repository/" + repositoryId;
        }

        @NotNull
        public final String getStagingRepositoryActivityPath(@NotNull String repositoryId) {
            Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
            return "service/local/staging/repository/" + repositoryId + "/activity";
        }

        public final boolean isOssrhUrl(@NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            return OSSRH_URL_PATTERN.matches((CharSequence)url2);
        }

        public final boolean isOssrhReleaseRepositoryUrl(@NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            return this.isOssrhUrl(url2) && StringsKt.contains$default((CharSequence)url2, (CharSequence)NexusService.STAGING_DEPLOY_PATH, (boolean)false, (int)2, null);
        }

        public final boolean isOssrhSnapshotRepositoryUrl(@NotNull String url2) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            return this.isOssrhUrl(url2) && StringsKt.contains$default((CharSequence)url2, (CharSequence)NexusService.SNAPSHOTS_PATH, (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

