/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.ARecord;
import circlet.platform.api.Arena;
import circlet.platform.api.ArenaTypesRegistry;
import circlet.platform.api.ArenasKt;
import circlet.platform.api.CallContext;
import circlet.platform.api.ExtArena;
import circlet.platform.api.ExtRecord;
import circlet.platform.api.Ref;
import circlet.platform.api.RefSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import libraries.basics.Sync;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\tJ\"\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ,\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0016\u0010\u0019\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u001f0\u0012H\u0016J#\u0010 \u001a\u00020\u001b\"\n\b\u0000\u0010!\u0018\u0001*\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H!0\u0007H\u0086\bJ,\u0010 \u001a\u00020\u001b\"\b\b\u0000\u0010!*\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H!0\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H!0\u0012J_\u0010\"\u001a\u00020\u001b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00072K\u0010#\u001aG\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\bJ#\u0010$\u001a\u00020\u001b\"\n\b\u0000\u0010!\u0018\u0001*\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H!0\u0007H\u0086\bJ,\u0010$\u001a\u00020\u001b\"\b\b\u0000\u0010!*\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H!0\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H!0\u0007J+\u0010%\u001a\u0002H!\"\b\b\u0000\u0010!*\u00020\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H!0'2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u00132\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rc\u0010\u0005\u001aW\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012I\u0012G\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\u0012\u0004\u0012\u00020\u00130\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0014\u001a \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00150\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcirclet/platform/api/ClientArenaRegistry;", "Lcirclet/platform/api/ArenaTypesRegistry;", "()V", "arenaPrefixMaxLength", "", "arenaTSRegistry", "", "Lcirclet/platform/api/Arena;", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "arenaId", "id", "Lcirclet/platform/api/CallContext;", "context", "Lcirclet/platform/api/ARecord;", "arenaTSSelectors", "Lkotlin/reflect/KClass;", "Lcirclet/platform/api/RefSelector;", "arenaTypes", "", "arenas", "arena", "", "type", "cleanupTombstoneRegistry", "", "extArena", "Lcirclet/platform/api/ExtArena;", "parentArenaId", "Lcirclet/platform/api/ExtRecord;", "registerArena", "T", "registerTombstone", "ts", "registerTombstoneSelector", "tombstone", "ref", "Lcirclet/platform/api/Ref;", "(Lcirclet/platform/api/Ref;Lcirclet/platform/api/CallContext;)Lcirclet/platform/api/ARecord;", "tombstoneSelector", "platform-api"})
@SourceDebugExtension(value={"SMAP\nClientArenaRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientArenaRegistry.kt\ncirclet/platform/api/ClientArenaRegistry\n+ 2 Sync.kt\nlibraries/basics/Sync\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n4#2:102\n4#2:110\n4#2:111\n4#2:112\n4#2:113\n4#2:114\n4#2:117\n4#2:118\n4#2:119\n372#3,7:103\n1054#4:115\n1#5:116\n*S KotlinDebug\n*F\n+ 1 ClientArenaRegistry.kt\ncirclet/platform/api/ClientArenaRegistry\n*L\n14#1:102\n29#1:110\n41#1:111\n44#1:112\n63#1:113\n70#1:114\n82#1:117\n88#1:118\n95#1:119\n22#1:103,7\n72#1:115\n*E\n"})
public final class ClientArenaRegistry
implements ArenaTypesRegistry {
    @NotNull
    private final Map<Integer, Arena<?>> arenas = new LinkedHashMap();
    @NotNull
    private final Map<KClass<? extends ARecord>, List<Arena<?>>> arenaTypes = new LinkedHashMap();
    private int arenaPrefixMaxLength;
    @NotNull
    private final Map<Arena<?>, Function3<String, String, CallContext, ARecord>> arenaTSRegistry = new LinkedHashMap();
    @NotNull
    private final Map<KClass<? extends ARecord>, RefSelector> arenaTSSelectors = new LinkedHashMap();

    public final /* synthetic */ <T extends ARecord> void registerArena(Arena<T> arena2) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        boolean $i$f$registerArena = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.registerArena(arena2, Reflection.getOrCreateKotlinClass(ARecord.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ARecord> void registerArena(@NotNull Arena<T> arena2, @NotNull KClass<T> type2) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        Map<Integer, Arena<?>> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            int prefixHash = arena2.getPrefix().hashCode();
            Arena<?> registered = this.arenas.get(prefixHash);
            if (!(registered == null || Intrinsics.areEqual(registered, arena2))) {
                boolean $i$a$-require-ClientArenaRegistry$registerArena$1$22 = false;
                String $i$a$-require-ClientArenaRegistry$registerArena$1$22 = "Arena's hash collision '" + prefixHash + "': trying to add " + arena2 + ", in cache " + registered;
                throw new IllegalArgumentException($i$a$-require-ClientArenaRegistry$registerArena$1$22.toString());
            }
            if (registered == null) {
                List list2;
                Integer $i$a$-require-ClientArenaRegistry$registerArena$1$22 = prefixHash;
                this.arenas.put($i$a$-require-ClientArenaRegistry$registerArena$1$22, arena2);
                Map<KClass<ARecord>, List<Arena<?>>> $this$getOrPut$iv = this.arenaTypes;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(type2);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(type2, answer$iv);
                    list2 = answer$iv;
                } else {
                    list2 = value$iv;
                }
                list2.add(arena2);
                this.arenaPrefixMaxLength = Math.max(this.arenaPrefixMaxLength, arena2.getPrefix().length());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final Arena<?> arena(@NotNull String arenaId) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        Map<Integer, Arena<?>> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            int end = Math.min(this.arenaPrefixMaxLength, arenaId.length());
            while (true) {
                if (0 >= end) {
                    Unit unit = Unit.INSTANCE;
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                    return null;
                }
                CharSequence prefix = arenaId.subSequence(0, end);
                Arena<?> arena2 = this.arenas.get(prefix.hashCode());
                if (arena2 != null && Intrinsics.areEqual((Object)arena2.getPrefix(), (Object)prefix)) {
                    return arena2;
                }
                --end;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<Arena<?>> arenas(@NotNull KClass<? extends ARecord> type2) {
        List<Arena<?>> list2;
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        Map<Integer, Arena<?>> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            List<Arena<?>> list3 = this.arenaTypes.get(type2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
            list2 = list3;
        }
        if (list2 == null) {
            throw new IllegalStateException(("Arena record type " + type2.getSimpleName() + " is not registered").toString());
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ExtArena<?> extArena(@NotNull String parentArenaId, @NotNull KClass<? extends ExtRecord<? extends ARecord>> type2) {
        Intrinsics.checkNotNullParameter((Object)parentArenaId, (String)"parentArenaId");
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<Integer, Arena<?>> lock$iv = this.arenas;
        boolean $i$f$exec = false;
        Map<Integer, Arena<?>> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            Arena<?> arena2 = this.arena(parentArenaId);
            if (arena2 == null) {
                throw new IllegalStateException(("Arena for id '" + parentArenaId + "' is not found").toString());
            }
            Arena<?> parentArena = arena2;
            List<Arena<?>> list2 = this.arenaTypes.get(type2);
            if (list2 == null) {
                throw new IllegalStateException(("Arena record type '" + type2.getSimpleName() + "' is not registered").toString());
            }
            List<Arena<?>> extensionArenas = list2;
            for (Arena<?> extArena : extensionArenas) {
                if (!(extArena instanceof ExtArena) || !Intrinsics.areEqual(((ExtArena)extArena).getParent(), parentArena)) continue;
                ExtArena extArena2 = (ExtArena)extArena;
                return extArena2;
            }
            throw new IllegalStateException(("Ext arena with parent '" + parentArena + "' and types of records '" + type2.getSimpleName() + "' is not found").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerTombstone(@NotNull Arena<?> arena2, @NotNull Function3<? super String, ? super String, ? super CallContext, ? extends ARecord> ts) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        Sync sync = Sync.INSTANCE;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> lock$iv = this.arenaTSRegistry;
        boolean $i$f$exec = false;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            Function3<? super String, ? super String, ? super CallContext, ? extends ARecord> function3 = this.arenaTSRegistry.put(arena2, ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> T tombstone(@NotNull Ref<? extends T> ref2, @NotNull CallContext context2) {
        ARecord aRecord;
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Sync sync = Sync.INSTANCE;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> lock$iv = this.arenaTSRegistry;
        boolean $i$f$exec = false;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> map2 = lock$iv;
        synchronized (map2) {
            Object v0;
            block5: {
                void $this$sortedByDescending$iv;
                boolean bl = false;
                Iterable iterable = this.arenaTSRegistry.keySet();
                boolean $i$f$sortedByDescending = false;
                Iterable iterable2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Arena it = (Arena)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPrefix().length());
                        it = (Arena)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPrefix().length()));
                    }
                });
                for (Object t : iterable2) {
                    Arena it = (Arena)t;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getPrefix(), (Object)ref2.getArenaId()) || !it.getSingle() && StringsKt.startsWith$default((String)ref2.getArenaId(), (String)it.getPrefix(), (boolean)false, (int)2, null))) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            Arena arena2 = v0;
            if (arena2 == null) {
                throw new IllegalStateException(("Tombstone for arena " + ref2.getArenaId() + " is not found").toString());
            }
            Arena arena3 = arena2;
            Function3<String, String, CallContext, ARecord> function3 = this.arenaTSRegistry.get(arena3);
            Intrinsics.checkNotNull(function3);
            ARecord aRecord2 = (ARecord)function3.invoke((Object)ref2.getArenaId(), (Object)ref2.getId(), (Object)context2);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl31 : MonitorExitStatement: MONITOREXIT : var6_6
            aRecord = aRecord2;
        }
        Intrinsics.checkNotNull((Object)aRecord, (String)"null cannot be cast to non-null type T of circlet.platform.api.ClientArenaRegistry.tombstone");
        return (T)aRecord;
    }

    public final /* synthetic */ <T extends ARecord> void registerTombstoneSelector(Arena<T> arena2) {
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        boolean $i$f$registerTombstoneSelector = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.registerTombstoneSelector(Reflection.getOrCreateKotlinClass(ARecord.class), arena2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends ARecord> void registerTombstoneSelector(@NotNull KClass<T> type2, @NotNull Arena<T> arena2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Intrinsics.checkNotNullParameter(arena2, (String)"arena");
        Sync sync = Sync.INSTANCE;
        Map<KClass<? extends ARecord>, RefSelector> lock$iv = this.arenaTSSelectors;
        boolean $i$f$exec = false;
        Map<KClass<? extends ARecord>, RefSelector> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            RefSelector refSelector = this.arenaTSSelectors.put(type2, new RefSelector(ArenasKt.tombstoneId(arena2), "__TS__"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RefSelector tombstoneSelector(@NotNull KClass<? extends ARecord> type2) {
        RefSelector refSelector;
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        Sync sync = Sync.INSTANCE;
        Map<KClass<? extends ARecord>, RefSelector> lock$iv = this.arenaTSSelectors;
        boolean $i$f$exec = false;
        Map<KClass<? extends ARecord>, RefSelector> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            refSelector = (RefSelector)MapsKt.getValue(this.arenaTSSelectors, type2);
        }
        return refSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanupTombstoneRegistry() {
        Sync sync = Sync.INSTANCE;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> lock$iv = this.arenaTSRegistry;
        boolean $i$f$exec = false;
        Map<Arena<?>, Function3<String, String, CallContext, ARecord>> map2 = lock$iv;
        synchronized (map2) {
            boolean bl = false;
            this.arenaTSRegistry.clear();
            this.arenaTSSelectors.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public ExtArena<?> extArena(@NotNull ARecord record2, @NotNull KClass<? extends ExtRecord<? extends ARecord>> type2) {
        return ArenaTypesRegistry.DefaultImpls.extArena((ArenaTypesRegistry)this, record2, type2);
    }

    @Override
    @NotNull
    public ExtArena<?> extArena(@NotNull Ref<? extends ARecord> ref2, @NotNull KClass<? extends ExtRecord<? extends ARecord>> type2) {
        return ArenaTypesRegistry.DefaultImpls.extArena((ArenaTypesRegistry)this, ref2, type2);
    }
}

