/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.workspaces;

import circlet.platform.api.ClientSupportFlag;
import circlet.platform.api.oauth.CodeChallenge;
import circlet.platform.api.oauth.OAuthFlowKt;
import circlet.platform.api.oauth.OAuthTokenResponse;
import circlet.platform.api.oauth.OpenSet;
import circlet.platform.api.oauth.XScope;
import circlet.platform.workspaces.WorkspaceConfiguration;
import circlet.platform.workspaces.WorkspaceConfigurationKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.collections.MultiMap;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.Http;
import runtime.net.Uri;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J!\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t0\bj\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lcirclet/platform/workspaces/WorkspaceConfigurationImpl;", "Lcirclet/platform/workspaces/WorkspaceConfiguration;", "server", "", "apiServer", "clientId", "clientSecret", "features", "Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/platform/api/ClientSupportFlag;", "Lcirclet/platform/api/ClientSupportFlags;", "http", "Lruntime/net/Http;", "codeVerifier", "Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;", "requiredScope", "Lcirclet/platform/api/oauth/XScope;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcirclet/platform/api/oauth/OpenSet;Lruntime/net/Http;Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;Lcirclet/platform/api/oauth/XScope;)V", "getApiServer", "()Ljava/lang/String;", "getClientId", "getClientSecret", "codeChallenge", "Lcirclet/platform/api/oauth/CodeChallenge$S256;", "getCodeChallenge", "()Lcirclet/platform/api/oauth/CodeChallenge$S256;", "codeChallenge$delegate", "Lkotlin/Lazy;", "getCodeVerifier", "()Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;", "getFeatures", "()Lcirclet/platform/api/oauth/OpenSet;", "getHttp", "()Lruntime/net/Http;", "getRequiredScope", "()Lcirclet/platform/api/oauth/XScope;", "getServer", "codeFlowURL", "redirectUri", "handleCodeFlowRedirect", "Lcirclet/platform/api/oauth/OAuthTokenResponse;", "uri", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshTokenFlow", "refreshToken", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "platform-app-state"})
@SourceDebugExtension(value={"SMAP\nWorkspaceConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceConfiguration.kt\ncirclet/platform/workspaces/WorkspaceConfigurationImpl\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n*L\n1#1,142:1\n14#2,5:143\n*S KotlinDebug\n*F\n+ 1 WorkspaceConfiguration.kt\ncirclet/platform/workspaces/WorkspaceConfigurationImpl\n*L\n86#1:143,5\n*E\n"})
public final class WorkspaceConfigurationImpl
implements WorkspaceConfiguration {
    @NotNull
    private final String server;
    @NotNull
    private final String apiServer;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final OpenSet<ClientSupportFlag> features;
    @NotNull
    private final Http http;
    @NotNull
    private final WorkspaceConfiguration.CodeVerifier codeVerifier;
    @Nullable
    private final XScope requiredScope;
    @NotNull
    private final Lazy codeChallenge$delegate;

    public WorkspaceConfigurationImpl(@NotNull String server, @NotNull String apiServer, @NotNull String clientId, @NotNull String clientSecret, @NotNull OpenSet<ClientSupportFlag> features2, @NotNull Http http, @NotNull WorkspaceConfiguration.CodeVerifier codeVerifier, @Nullable XScope requiredScope) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)apiServer, (String)"apiServer");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter(features2, (String)"features");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        this.server = server;
        this.apiServer = apiServer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.features = features2;
        this.http = http;
        this.codeVerifier = codeVerifier;
        this.requiredScope = requiredScope;
        KLogger this_$iv = WorkspaceConfigurationKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            boolean bl = false;
            String msgStr$iv = "WorkspaceConfiguration.init()";
            this_$iv.debug(msgStr$iv);
        }
        this.codeChallenge$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CodeChallenge.S256>(this){
            final /* synthetic */ WorkspaceConfigurationImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CodeChallenge.S256 invoke() {
                return CodeChallenge.Companion.s256(this.this$0.getCodeVerifier().getValue());
            }
        }));
    }

    public /* synthetic */ WorkspaceConfigurationImpl(String string2, String string3, String string4, String string5, OpenSet openSet, Http http, WorkspaceConfiguration.CodeVerifier codeVerifier, XScope xScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            openSet = OpenSet.None.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            xScope = null;
        }
        this(string2, string3, string4, string5, openSet, http, codeVerifier, xScope);
    }

    @Override
    @NotNull
    public String getServer() {
        return this.server;
    }

    @Override
    @NotNull
    public String getApiServer() {
        return this.apiServer;
    }

    @Override
    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @NotNull
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @NotNull
    public OpenSet<ClientSupportFlag> getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public Http getHttp() {
        return this.http;
    }

    @Override
    @NotNull
    public WorkspaceConfiguration.CodeVerifier getCodeVerifier() {
        return this.codeVerifier;
    }

    @Override
    @Nullable
    public XScope getRequiredScope() {
        return this.requiredScope;
    }

    private final CodeChallenge.S256 getCodeChallenge() {
        Lazy lazy = this.codeChallenge$delegate;
        return (CodeChallenge.S256)lazy.getValue();
    }

    @Override
    @NotNull
    public String codeFlowURL(@NotNull String redirectUri) {
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        String string2 = this.getServer();
        String string3 = this.getClientId();
        CodeChallenge.S256 s256 = this.getCodeChallenge();
        XScope xScope = this.getRequiredScope();
        if (xScope == null) {
            xScope = XScope.All.INSTANCE;
        }
        XScope xScope2 = xScope;
        return OAuthFlowKt.codeFlowURL$default(string2, string3, redirectUri, null, xScope2, true, s256, 8, null);
    }

    @Override
    @Nullable
    public Object refreshTokenFlow(@NotNull String refreshToken2, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        Http http = this.getHttp();
        String string2 = this.getServer();
        String string3 = this.getClientId();
        String string4 = this.getClientSecret();
        XScope xScope = this.getRequiredScope();
        if (xScope == null) {
            xScope = XScope.All.INSTANCE;
        }
        return OAuthFlowKt.refreshTokenFlow$default(http, string2, string3, string4, refreshToken2, xScope, null, $completion, 32, null);
    }

    @Override
    @Nullable
    public Object handleCodeFlowRedirect(@NotNull String uri, @NotNull String redirectUri, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        String string2 = Uri.INSTANCE.extractQuery(uri);
        if (string2 == null) {
            return new OAuthTokenResponse.Error(uri, "500", "Error parsing redirect uri: " + uri, null, 8, null);
        }
        String query2 = string2;
        MultiMap<String, String> queryParameters = Uri.INSTANCE.parseQuery(query2);
        String string3 = (String)CollectionsKt.firstOrNull((Iterable)queryParameters.get("code"));
        if (string3 == null) {
            return new OAuthTokenResponse.Error(uri, "500", "Error parsing redirect uri, code is missing: " + uri, null, 8, null);
        }
        String code = string3;
        boolean qr = StringsKt.contains$default((CharSequence)uri, (CharSequence)"qr-token", (boolean)false, (int)2, null);
        if (qr) {
            return OAuthFlowKt.qrCodeFlowToken$default(this.getHttp(), this.getServer(), this.getClientId(), this.getClientSecret(), code, true, this.getRequiredScope(), null, $completion, 64, null);
        }
        return OAuthFlowKt.codeFlowToken$default(this.getHttp(), this.getServer(), this.getClientId(), redirectUri, this.getClientSecret(), code, this.getCodeVerifier().getValue(), null, $completion, 64, null);
    }
}

