/*
 * Decompiled with CFR 0.152.
 */
package circlet.rd.api;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u001d"}, d2={"Lcirclet/rd/api/RdWorkspaceResources;", "", "milliCpus", "", "memoryMb", "volumeGb", "(III)V", "cpus", "getCpus", "()I", "memoryGb", "", "getMemoryGb", "()D", "getMemoryMb", "getMilliCpus", "getVolumeGb", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Captions", "Companion", "rd-api"})
@SourceDebugExtension(value={"SMAP\nworkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 workspace.kt\ncirclet/rd/api/RdWorkspaceResources\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
public final class RdWorkspaceResources {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int milliCpus;
    private final int memoryMb;
    private final int volumeGb;
    private final int cpus;
    private final double memoryGb;

    public RdWorkspaceResources(int milliCpus, int memoryMb, int volumeGb) {
        this.milliCpus = milliCpus;
        this.memoryMb = memoryMb;
        this.volumeGb = volumeGb;
        if (!(this.milliCpus > 0)) {
            boolean $i$a$-check-RdWorkspaceResources$42 = false;
            String $i$a$-check-RdWorkspaceResources$42 = "milliCpus must be greater than 0";
            throw new IllegalStateException($i$a$-check-RdWorkspaceResources$42.toString());
        }
        if (!(this.memoryMb > 0)) {
            boolean $i$a$-check-RdWorkspaceResources$52 = false;
            String $i$a$-check-RdWorkspaceResources$52 = "memoryMb must be greater than 0";
            throw new IllegalStateException($i$a$-check-RdWorkspaceResources$52.toString());
        }
        if (!(this.volumeGb > 0)) {
            boolean bl = false;
            String string2 = "volumeGb must be greater than 0";
            throw new IllegalStateException(string2.toString());
        }
        this.cpus = Companion.mCpusToCpus(this.milliCpus);
        this.memoryGb = Companion.memMbToGb(this.memoryMb);
    }

    public final int getMilliCpus() {
        return this.milliCpus;
    }

    public final int getMemoryMb() {
        return this.memoryMb;
    }

    public final int getVolumeGb() {
        return this.volumeGb;
    }

    public final int getCpus() {
        return this.cpus;
    }

    public final double getMemoryGb() {
        return this.memoryGb;
    }

    public final int component1() {
        return this.milliCpus;
    }

    public final int component2() {
        return this.memoryMb;
    }

    public final int component3() {
        return this.volumeGb;
    }

    @NotNull
    public final RdWorkspaceResources copy(int milliCpus, int memoryMb, int volumeGb) {
        return new RdWorkspaceResources(milliCpus, memoryMb, volumeGb);
    }

    public static /* synthetic */ RdWorkspaceResources copy$default(RdWorkspaceResources rdWorkspaceResources, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = rdWorkspaceResources.milliCpus;
        }
        if ((n4 & 2) != 0) {
            n2 = rdWorkspaceResources.memoryMb;
        }
        if ((n4 & 4) != 0) {
            n3 = rdWorkspaceResources.volumeGb;
        }
        return rdWorkspaceResources.copy(n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "RdWorkspaceResources(milliCpus=" + this.milliCpus + ", memoryMb=" + this.memoryMb + ", volumeGb=" + this.volumeGb + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.milliCpus);
        result2 = result2 * 31 + Integer.hashCode(this.memoryMb);
        result2 = result2 * 31 + Integer.hashCode(this.volumeGb);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RdWorkspaceResources)) {
            return false;
        }
        RdWorkspaceResources rdWorkspaceResources = (RdWorkspaceResources)other;
        if (this.milliCpus != rdWorkspaceResources.milliCpus) {
            return false;
        }
        if (this.memoryMb != rdWorkspaceResources.memoryMb) {
            return false;
        }
        return this.volumeGb == rdWorkspaceResources.volumeGb;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcirclet/rd/api/RdWorkspaceResources$Captions;", "", "()V", "Cpu", "", "Memory", "MemoryGb", "Volume", "rd-api"})
    public static final class Captions {
        @NotNull
        public static final Captions INSTANCE = new Captions();
        @NotNull
        public static final String Cpu = "CPUs";
        @NotNull
        public static final String Memory = "MB";
        @NotNull
        public static final String MemoryGb = "GB";
        @NotNull
        public static final String Volume = "GB";

        private Captions() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcirclet/rd/api/RdWorkspaceResources$Companion;", "", "()V", "mCpusToCpus", "", "milliCpus", "memMbToGb", "memMb", "rd-api"})
    public static final class Companion {
        private Companion() {
        }

        public final int mCpusToCpus(int milliCpus) {
            return milliCpus / 1000;
        }

        public final int memMbToGb(int memMb) {
            return MathKt.roundToInt((double)((double)memMb / 1024.0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

