/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.client.api.TodoItemRecord;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.todo.TodoEditorGroup;
import circlet.todo.TodoFilteredTreeModel;
import circlet.todo.TodoItemRecordOverdueInfo;
import circlet.todo.TodoListItemVm;
import circlet.todo.TodoListVmTreeModel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aP\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bH\u0002\u001a*\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00032\n\u0010\u000f\u001a\u00060\u0007j\u0002`\b2\n\u0010\u0010\u001a\u00060\nj\u0002`\u000b\u001a\f\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0013\u001a\f\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0014\u001a\u0012\u0010\u0015\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b*\u00020\u000e\u00a8\u0006\u0016"}, d2={"tryCalcOverdueInfo", "Lcirclet/todo/TodoItemRecordOverdueInfo;", "overdue", "", "overdueByDueTime", "isRemindMeFfEnabled", "dueDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "dueTime", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "deadline", "calcOverdueInfo", "Lcirclet/client/api/TodoItemRecord;", "today", "now", "dump", "", "Lcirclet/todo/TodoFilteredTreeModel;", "Lcirclet/todo/TodoListVmTreeModel;", "fullDueTime", "app-state"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\ncirclet/todo/UtilsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n215#2:105\n216#2:108\n1855#3,2:106\n*S KotlinDebug\n*F\n+ 1 utils.kt\ncirclet/todo/UtilsKt\n*L\n26#1:105\n26#1:108\n28#1:106,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String dump(@Nullable TodoFilteredTreeModel $this$dump) {
        if ($this$dump == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder = sb.append("####dump");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = sb.append("##open");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = sb.append(UtilsKt.dump($this$dump.getOpen()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder4 = sb.append("");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder5 = sb.append("##done");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder6 = sb.append(UtilsKt.dump($this$dump.getDone()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public static final String dump(@Nullable TodoListVmTreeModel $this$dump) {
        StringBuilder sb = new StringBuilder();
        if ($this$dump != null) {
            int groupsSize = $this$dump.getTree().keySet().size();
            StringBuilder stringBuilder = sb.append("groupsSize=" + groupsSize);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            Map<TodoEditorGroup, List<TodoListItemVm>> $this$forEach$iv = $this$dump.getTree();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<TodoEditorGroup, List<TodoListItemVm>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<TodoEditorGroup, List<TodoListItemVm>> element$iv;
                Map.Entry<TodoEditorGroup, List<TodoListItemVm>> it = element$iv = iterator2.next();
                boolean bl = false;
                StringBuilder stringBuilder2 = sb.append(" group=" + it.getKey().getName() + ". itemsSize=" + it.getValue().size());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                Iterable $this$forEach$iv2 = it.getValue();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    TodoListItemVm it2 = (TodoListItemVm)element$iv2;
                    boolean bl2 = false;
                    StringBuilder stringBuilder3 = sb.append("  item=" + it2.getRecord().getContent().display());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                }
            }
        } else {
            StringBuilder stringBuilder = sb.append("null");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Nullable
    public static final KotlinXDateTime fullDueTime(@NotNull TodoItemRecord $this$fullDueTime) {
        Intrinsics.checkNotNullParameter((Object)$this$fullDueTime, (String)"<this>");
        KotlinXDate dd = $this$fullDueTime.getDueDate();
        KotlinXDateTime dt = $this$fullDueTime.getDueTime();
        return dd != null && dt != null ? ADateJvmKt.plusMinutes(ADateJvmKt.plusHours(ADateJvmKt.toDateTimeAtStartOfDay(dd), ADateJvmKt.getHour(dt)), ADateJvmKt.getMinute(dt)) : null;
    }

    @NotNull
    public static final TodoItemRecordOverdueInfo calcOverdueInfo(@NotNull TodoItemRecord $this$calcOverdueInfo, boolean isRemindMeFfEnabled, @NotNull KotlinXDate today, @NotNull KotlinXDateTime now) {
        Intrinsics.checkNotNullParameter((Object)$this$calcOverdueInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)today, (String)"today");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        KotlinXDate dueDate2 = $this$calcOverdueInfo.getDueDate();
        boolean overdue = dueDate2 != null && dueDate2.compareTo(today) < 0;
        boolean internalFfEnabled = isRemindMeFfEnabled;
        KotlinXDateTime dueTime = $this$calcOverdueInfo.getDueTime();
        KotlinXDateTime deadline = internalFfEnabled && dueDate2 != null && dueTime != null ? UtilsKt.fullDueTime($this$calcOverdueInfo) : null;
        boolean overdueByDueTime = internalFfEnabled && deadline != null && deadline.compareTo(now) < 0;
        return UtilsKt.tryCalcOverdueInfo(overdue, overdueByDueTime, internalFfEnabled, dueDate2, dueTime, deadline);
    }

    private static final TodoItemRecordOverdueInfo tryCalcOverdueInfo(boolean overdue, boolean overdueByDueTime, boolean isRemindMeFfEnabled, KotlinXDate dueDate2, KotlinXDateTime dueTime, KotlinXDateTime deadline) {
        if (dueDate2 != null) {
            if (isRemindMeFfEnabled) {
                if (dueTime == null) {
                    if (overdue) {
                        return new TodoItemRecordOverdueInfo.OverdueByDate(dueDate2);
                    }
                } else if (deadline != null && overdueByDueTime) {
                    return new TodoItemRecordOverdueInfo.OverdueByTime(deadline);
                }
            } else if (overdue) {
                return new TodoItemRecordOverdueInfo.OverdueByDate(dueDate2);
            }
        }
        return TodoItemRecordOverdueInfo.NoOverdue.INSTANCE;
    }
}

