/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.auth;

import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirerHttp;
import com.intellij.space.gateway.auth.SpaceGatewayCredentialsAcquirer;
import com.intellij.space.gateway.auth.SpaceGatewayOAuthDatedCredentials;
import com.intellij.space.gateway.auth.UtilKt;
import com.intellij.space.gateway.client.SpaceGatewayApiImplKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/space/gateway/auth/SpaceGatewayCredentialsAcquirer;", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer;", "Lcom/intellij/space/gateway/auth/SpaceGatewayOAuthDatedCredentials;", "server", "", "codeVerifier", "authorizationCodeUrlRaw", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "tokenUrl", "Lcom/intellij/util/Url;", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "code", "Companion", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceGatewayCredentialsAcquirer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceGatewayCredentialsAcquirer.kt\ncom/intellij/space/gateway/auth/SpaceGatewayCredentialsAcquirer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class SpaceGatewayCredentialsAcquirer
implements OAuthCredentialsAcquirer<SpaceGatewayOAuthDatedCredentials> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String codeVerifier;
    @NotNull
    private final String authorizationCodeUrlRaw;
    @NotNull
    private final Url tokenUrl;
    @NotNull
    private static final String CLIENT_SECRET = "gateway-space-integration-secret";

    public SpaceGatewayCredentialsAcquirer(@NotNull String server, @Nullable String codeVerifier, @NotNull String authorizationCodeUrlRaw) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)authorizationCodeUrlRaw, (String)"authorizationCodeUrlRaw");
        this.codeVerifier = codeVerifier;
        this.authorizationCodeUrlRaw = authorizationCodeUrlRaw;
        this.tokenUrl = Urls.newFromEncoded((String)(server + "/oauth/token"));
    }

    public /* synthetic */ SpaceGatewayCredentialsAcquirer(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string4 = "jetbrains-gateway://spaceAuth";
        }
        this(string2, string3, string4);
    }

    @NotNull
    public OAuthCredentialsAcquirer.AcquireCredentialsResult<SpaceGatewayOAuthDatedCredentials> acquireCredentials(@NotNull String code) {
        Map formParameters;
        block0: {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"redirect_uri", (Object)this.authorizationCodeUrlRaw)};
            formParameters = MapsKt.mutableMapOf((Pair[])pairArray);
            String string2 = this.codeVerifier;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            formParameters.put("code_verifier", it);
        }
        return Companion.acquireCredentials(this.tokenUrl, formParameters);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/space/gateway/auth/SpaceGatewayCredentialsAcquirer$Companion;", "", "()V", "CLIENT_SECRET", "", "acquireCredentials", "Lcom/intellij/collaboration/auth/services/OAuthCredentialsAcquirer$AcquireCredentialsResult;", "Lcom/intellij/space/gateway/auth/SpaceGatewayOAuthDatedCredentials;", "endpoint", "Lcom/intellij/util/Url;", "formParameters", "", "intellij.space.gateway"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OAuthCredentialsAcquirer.AcquireCredentialsResult<SpaceGatewayOAuthDatedCredentials> acquireCredentials(@NotNull Url endpoint2, @NotNull Map<String, String> formParameters) {
            Intrinsics.checkNotNullParameter((Object)endpoint2, (String)"endpoint");
            Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
            Base64.Encoder encoder = Base64.getEncoder();
            String string2 = "gateway-space-integration:gateway-space-integration-secret";
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String clientInfo = encoder.encodeToString(byArray);
            HttpRequest request2 = HttpRequest.newBuilder().uri(URI.create(endpoint2.toExternalForm())).header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").header("Authorization", "Basic " + clientInfo).POST(HttpRequest.BodyPublishers.ofString(UtilKt.formDataString(formParameters))).build();
            HttpClient.Builder builder = HttpClient.newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
            HttpClient client2 = SpaceGatewayApiImplKt.setHttpVersion(builder, endpoint2).build();
            HttpResponse<String> response2 = client2.send(request2, HttpResponse.BodyHandlers.ofString());
            Intrinsics.checkNotNull(response2);
            return OAuthCredentialsAcquirerHttp.INSTANCE.convertToAcquireCredentialsResult(response2, (Function2)acquireCredentials.1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

